// Plugin by [IKR] Soul Man (http://ikr.homeip.net).
//
// Adds two commands:
// admin_vote_slay <target>: Starts a vote to slay target.
// admin_vote_stack <target>: Starts a vote to stack target.
//
// Only users who can use the admin_vote_kick <target>, can use these new commands.

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

// These may be edited:
#define SLAY_RATIO 80	/* a number between 0 and 100 */
#define STACK_RATIO 80	/* a number between 0 and 100 */

new STRING_VERSION[MAX_DATA_LENGTH] = "2.50.11";

public admin_vote_slay(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Target[MAX_DATA_LENGTH];
	new TargetName[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new User[MAX_NAME_LENGTH];

	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Target,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	get_username(Target, TargetName, MAX_NAME_LENGTH);

	if (access(ACCESS_VOTE_KICK,"") != 1) {
		selfmessage("You don't have access to this command");	
		return PLUGIN_HANDLED;
	}
	
	if (vote_allowed() != 1) {
		selfmessage("Vote not allowed at this time.");
		return PLUGIN_HANDLED;
	}

	if(check_immunity(Target)==1) {
		snprintf(Text, MAX_TEXT_LENGTH, "Laf. You can't vote slay '%s', you silly bear.", Target);
		say(Text);
		return PLUGIN_HANDLED;
	}

	if ( check_user(Target) > 0 ) {
		say_command(User,Command,Target);

		snprintf(Text, MAX_TEXT_LENGTH, "Kill %s?", TargetName);
		if(getvar("sv_lan")==1) {
			vote(Text, "Yes", "No", "HandleSlayVote", TargetName);
		} else {
			new strAuthID[MAX_AUTHID_LENGTH];
			get_userAuthID(TargetName, strAuthID);
			vote(Text, "Yes", "No", "HandleSlayVote", strAuthID);
		}
	} else {
		selfmessage("Unrecognized user name ");
		selfmessage(Target);
	}

	return PLUGIN_HANDLED;
}

public HandleSlayVote(WinningOption,HLData,VoteCount,UserCount) {
	new strNumber[MAX_NUMBER_LENGTH];
	new TargetDead;
	new TargetIndex;
	new TargetName[MAX_NAME_LENGTH];
	new TargetSessionid;
	new TargetTeam;
	new TargetWonid;
	new Text[MAX_TEXT_LENGTH];

	if(getvar("sv_lan")==1) {
		convert_string(HLData, TargetName, MAX_NUMBER_LENGTH);
	} else {
		new strAuthID[MAX_NUMBER_LENGTH];
		convert_string(HLData, strAuthID, MAX_AUTHID_LENGTH);
		get_username(strAuthID, TargetName, MAX_NAME_LENGTH);
	}
	
	if ( (WinningOption == 1 && VoteCount >= (SLAY_RATIO/100)*UserCount) || (WinningOption == 2 && VoteCount <= (SLAY_RATIO/100)*UserCount) ) {
		if ( check_user(TargetName) > 0 ) { 
			get_userindex(TargetName, TargetIndex);
			if ( playerinfo(TargetIndex, TargetName, MAX_NAME_LENGTH, TargetSessionid, TargetWonid, TargetTeam, TargetDead) == 1 ) {
				if (TargetDead == 1) {
					snprintf(Text, MAX_TEXT_LENGTH, "%s killed due to a vote.", TargetName);
					say(Text);
					message(TargetName, "You have been killed due to a vote.");
					slay(TargetName);
				} else {
					snprintf(Text, MAX_TEXT_LENGTH, "%s would be killed due to a vote if he were alive.", TargetName);
					say(Text);
				}
			}
		}
	} else {
		numtostr((SLAY_RATIO/100)*UserCount, strNumber);
		snprintf(Text, MAX_TEXT_LENGTH, "Not enough votes to kill %s (needed %s).", TargetName, strNumber);
		say(Text);
	}
}

public admin_vote_stack(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Target[MAX_DATA_LENGTH];
	new TargetName[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new User[MAX_NAME_LENGTH];

	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	convert_string(HLData,Target,MAX_DATA_LENGTH);

	get_username(Target, TargetName, MAX_NAME_LENGTH);

	if (access(ACCESS_VOTE_KICK,"") != 1) {
		selfmessage("You don't have access to this command");	
		return PLUGIN_HANDLED;
	}
	
	if (vote_allowed() != 1) {
		selfmessage("Vote not allowed at this time.");
		return PLUGIN_HANDLED;
	}

	if(check_immunity(Target)==1) {
		snprintf(Text, MAX_TEXT_LENGTH, "Laf. You can't vote stack '%s', you silly bear.", Target);
		say(Text);
		return PLUGIN_HANDLED;
	}

	if ( check_user(Target) > 0 ) {
		snprintf(Text, MAX_TEXT_LENGTH, "Nail %s to the ground?", TargetName);

		if(getvar("sv_lan")==1) {
			vote(Text, "Yes", "No", "HandleStackVote", TargetName);
		} else {
			new strAuthID[MAX_AUTHID_LENGTH];
			get_userAuthID(TargetName, strAuthID);
			vote(Text, "Yes", "No", "HandleStackVote", strAuthID);
		}
	} else {
		selfmessage("Unrecognized user name ");
		selfmessage(Target);
	}

	return PLUGIN_HANDLED;
}

public HandleStackVote(WinningOption,HLData,VoteCount,UserCount) {
	new strNumber[MAX_NUMBER_LENGTH];
	new TargetDead;
	new TargetIndex;
	new TargetName[MAX_NAME_LENGTH];
	new TargetSessionid;
	new TargetTeam;
	new TargetWonid;
	new Text[MAX_TEXT_LENGTH];
	new X;
	new Y;
	new Z;

	if(getvar("sv_lan")==1) {
		convert_string(HLData, TargetName, MAX_NUMBER_LENGTH);
	} else {
		new strAuthID[MAX_AUTHID_LENGTH];
		convert_string(HLData, strAuthID, MAX_AUTHID_LENGTH);
		get_username(strAuthID, TargetName, MAX_NAME_LENGTH);
	}
	
	if ( (WinningOption == 1 && VoteCount >= (SLAY_RATIO/100)*UserCount) || (WinningOption == 2 && VoteCount <= (SLAY_RATIO/100)*UserCount) ) {
		if ( check_user(TargetName) > 0 ) {
			get_userindex(TargetName, TargetIndex);
			if ( playerinfo(TargetIndex, TargetName, MAX_NAME_LENGTH, TargetSessionid, TargetWonid, TargetTeam, TargetDead) == 1 ) {
				if (TargetDead == 1) {
					if (get_userorigin(TargetName, X,Y,Z) != 0) {
						if (teleport(TargetName, X,Y,Z - 20) != 0) {
							centersay("Free kill !", 10, 250,250,250);
							snprintf(Text, MAX_TEXT_LENGTH, "%s is stuck due to a vote.", TargetName);
							say(Text);
							message(TargetName, "You are stuck due to a vote");
						} else {
							snprintf(Text, MAX_TEXT_LENGTH, "Stack vote failed. %s is lucky.", TargetName);
							say(Text);
						}
					} else {
						snprintf(Text, MAX_TEXT_LENGTH, "Stack vote failed. %s is lucky.", TargetName);
						say(Text);
					}
				} else {
					snprintf(Text, MAX_TEXT_LENGTH, "%s would be stuck due to a vote if he were alive.", TargetName);
				}
			}
		}
	} else {
		numtostr((SLAY_RATIO/100)*UserCount, strNumber);
		snprintf(Text, MAX_TEXT_LENGTH, "Not enough votes to stack %s (needed %s).", TargetName, strNumber);
		say(Text);
	}
}

public plugin_init() {
	plugin_registerinfo("Vote Plugin by [IKR] Soul Man", "Long live democracy!", STRING_VERSION);
	
	plugin_registercmd("admin_vote_slay", "admin_vote_slay", ACCESS_VOTE_KICK, "admin_vote_slay <target>: Starts a vote to slay target.");
	plugin_registercmd("admin_vote_stack", "admin_vote_stack", ACCESS_VOTE_KICK, "admin_vote_stack <target>: Starts a vote to stack target.");

	return PLUGIN_CONTINUE;
}
