/* This plugin allows you to disable and reenable a player's Voice Communications
 *
 *   NOTE: to restart their microphone after being un-muted, the target must restart HalfLife
 *
 *  Most of the code for this was stolen from Ropey's plugin_retribution... specifically
 *  the admin_execclient code.  The idea for this was also stolen... from ClanMod's client commands.
 *  Basically all I did was to slap it together.  :)  Enjoy!   -Petit
 */

/* $Id: plugin_voicemute.sma,v 1.0 3-Feb-2003 PetitMorte Exp $ */

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_GAG 2048

new STRING_VERSION[MAX_DATA_LENGTH] = "2.50.0";

public admin_voicemute(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new TargetName[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new User[MAX_NAME_LENGTH];
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	
	if(check_user(Data)==0) {
		selfmessage("Unrecognized player: ");
		selfmessage(Data);
		return PLUGIN_HANDLED;
	}
	get_username(Data,TargetName,MAX_NAME_LENGTH);
	say_command(User,Command,TargetName);
	if(check_immunity(TargetName)!=0) {
		snprintf(Text, MAX_TEXT_LENGTH, "Laf. You can't VoiceMute %s, you silly bunt.", TargetName);
		say(Text);
	} else {
		if (execclient(TargetName,"voice_enable 0")==0) {
			selfmessage("Failed.");
		} else {
			selfmessage("Succeeded.");
			messageex(TargetName, "** You have been muted for abusing VoiceComm **", print_center);
			execclient(TargetName, "say I have been MUTED for abusing VoiceComm");
			execclient(TargetName, "speak /sound/hgrunt/silence");

		}
	}
	return PLUGIN_HANDLED;
}

public admin_unvoicemute(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new TargetName[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new User[MAX_NAME_LENGTH];
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	
	if(check_user(Data)==0) {
		selfmessage("Unrecognized player: ");
		selfmessage(Data);
		return PLUGIN_HANDLED;
	}
	get_username(Data,TargetName,MAX_NAME_LENGTH);
	say_command(User,Command,TargetName);
	if(check_immunity(TargetName)!=0) {
		snprintf(Text, MAX_TEXT_LENGTH, "Laf. You can't unVoiceMute %s, you silly bunt.", TargetName);
		say(Text);
	} else {
		if (execclient(TargetName,"voice_enable 1")==0) {
			selfmessage("Failed.");
		} else {
			selfmessage("Succeeded.");
			messageex(TargetName,"** You have been unmuted (restart HL to regain VoiceComm) **", print_center);
			execclient(TargetName, "say I have been unmuted.");
		}
	}
	return PLUGIN_HANDLED;
}

public plugin_init() {
	plugin_registerinfo("Admin VoiceComm Mute Plugin","Shut off the mics of those abusing VoiceComm.",STRING_VERSION);
	
	plugin_registercmd("admin_voicemute","admin_voicemute",ACCESS_GAG,"admin_voicemute <target>: Force target to disable voicecomm.");
	plugin_registercmd("admin_unvoicemute","admin_unvoicemute",ACCESS_GAG,"admin_unvoicemute <target>: Reenable target's voicecomm.");
		
	return PLUGIN_CONTINUE;	
}

