#!/usr/bin/perl -w
#
# Release Date	: 9/8/2001
# Author		: Paul Rosen ([BwC]ScatMan)
# Email			: rosen@purdue.edu
# Website		: http://fullspeed.to/cstrike/
#
#
#	Some portions of the code by (as noted in the code)
# Author		: Jason Morriss (-Pk-Stormtrooper)
# Email			: lifo@liche.net
# Website		: http://www.psychostats.com/


use strict;

##########################################################################
#
#	The following 3 veriables need to be modified to your systems setup.
#
#	when writing directory pathes always use '/', even in windows
#
#	$PSYCHO_OUTPUT_DIRECTORY - path to the output psycostats produces
#	$CSTRIKE_DIRECTORY - path to your server's cstrike directory
#	$ALIAS_FILE - your psychostats alias file
#
##########################################################################


my $PSYCHO_OUTPUT_DIRECTORY = "C:/inetpub/wwwroot/psycho/data/";
my $CSTRIKE_DIRECTORY = "c:/hlserver/cstrike/";
my $ALIAS_FILE = "./aliases.cfg";

##########################################################################
#### Do Not Edit Below this line
##########################################################################
my $INPUT_FILE = $PSYCHO_OUTPUT_DIRECTORY . "stats.dat";
my $OUTPUT_FILE  = $CSTRIKE_DIRECTORY . "stats.dat";

my %Alias;

&loadadvlist('PLAYER:', $ALIAS_FILE, \%Alias, 0, 0, 1);

open(INFILE, $INPUT_FILE);
	my @lines = <INFILE>;
close(INFILE);

open(OUTFILE, ">" . $OUTPUT_FILE)  || die (print "Output file failed!\n\n");

my $countStats = 0;

foreach my $curLine (@lines) {
	if(substr($curLine, 0 , 15) eq "<!--END-HERE-->"){
		$countStats = 0;
	}
	if($countStats == 1){
		if(length($curLine) > 5){
			$curLine =~ s/\&nbsp\;/ /g;
			$curLine =~ s/\&gt\;/\>/g;
			$curLine =~ s/\&lt\;/\</g;
			my($name, $rank, $html, $kills, $deaths, $kdr, $kpm, $skill) = split(/\%/, $curLine);

			print OUTFILE $name . "%" . $rank . "%" . $kills . "%" . $deaths . "%" . $kdr . "%" . $kpm . "%" . $skill . "%" . "\n";

			foreach my $curAlias (keys %Alias) {
				if(%Alias->{$curAlias} eq $name){
					print OUTFILE $curAlias . "%" . $rank . "%" . $kills . "%" . $deaths . "%" . $kdr . "%" . $kpm . "%" . $skill . "%" . "\n";
				}
			}
		}
	}
	if(substr($curLine, 0 , 17) eq "<!--START-HERE-->"){
		$countStats = 1;
	}
}

close(OUTFILE);


exit;


##########################################################################
#
# The following portion of code was taken from psychostats 1.5 by Jason Morriss
#
##########################################################################
sub loadadvlist {
  my ($match, $filename, $list, $lcname, $lcval, $nowhitespace) = @_;
  my $name; 
  my $pattern = '^' . $match . '\s*(.+)$';

  unless (open(FILE, "<$filename")) {
    logerror("Error opening list file: $filename\n",0);
    last;
  }

  while (<FILE>) {
    chomp;
    $_ =~ s/^\s+//;		# remove whitespace from front
    next if (/^#/);		# skip comments
    $_ =~ s/\s+$//;		# remove whitespace from end
    next if (/^$/);		# skip blank lines
    
    if (/$pattern/) {
      $name = ($lcname) ? lc($1) : $1;
      while (<FILE>) {
        if ($nowhitespace) {
          $_ =~ s/^\s+//;		# remove whitespace from front
          $_ =~ s/\s+$//;		# remove whitespace from end
          next if (/^$/);		# skip blank lines
        }
        $_ = lc($_) if $lcval;		# lowercase it

        last if (/^\s*\.\s*$/);		# '.' on line by itself
#        push(@{$list->{$name}}, $_);	#	Original line
		$list->{$_} = $name;			#	replaced for simplicity sake (reduced the complexity of the hash for our uses)
      }
    }
  }
  close(FILE);
}