/***************************************************************************
 * Completed: October 09, 2001, 2:36pm
 *Created By: Sharpsniper
 * Help By: Rosen 
 * $harp$sniper!
 *
 *This plugin is made for setting up your servers stats by using a plugin this requires some computer skill but if you read the readme.txt you should be OK!
 ***************************************************************************/

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

new STRING_VERSION[MAX_DATA_LENGTH] = "2.50.e";
new FILENAME[MAX_DATA_LENGTH] = "stats.dat";

#define PUBLIC_MESSAGE 1;
#define PRIVATE_MESSAGE 2;

new MESSAGE_USER[MAX_NAME_LENGTH];

public plugin_init() {
	plugin_registerinfo("Sharpsniper's PsychoStats Stat Plugin","Gives players their current stats.",STRING_VERSION);
	
	plugin_registercmd("say","get_stats",ACCESS_ALL);
	plugin_registerhelp("say",ACCESS_ALL,"say /stats: Get your current stats, if you are ranked.");
	plugin_registerhelp("say",ACCESS_ALL,"say /stats help: Gives you complete usage on the stats plugin.");
	
	return PLUGIN_CONTINUE;
}

/****************************************************************************\
|****************************************************************************|
\****************************************************************************/
public get_stats(HLCommand,HLData,HLUserName,UserIndex) {
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	strcpy(MESSAGE_USER, User, MAX_NAME_LENGTH);

	strstripquotes(Data);

	new lineCommand1[50];
	new lineCommand2[50];
	new plyrName[50];

	strsplit(Data, " ", lineCommand1, 50 , lineCommand2, 50 , plyrName, 50);

	if (streq(Data, "/stats")==1 || streq(Data, "show my stats")==1) {
		snprintf(Text, MAX_TEXT_LENGTH, "%s :    %s", User, Data);
		say(Text);
		scat_stats(User,  FILENAME);
		return PLUGIN_HANDLED;
	}
	else if (streq(Data, "/stats help")==1) {
		snprintf(Text, MAX_TEXT_LENGTH, "%s :    %s", User, Data);
		say(Text);
		snprintf(Text, MAX_TEXT_LENGTH, "Usage on the /stats command");
		say(Text);
		snprintf(Text, MAX_TEXT_LENGTH, "/stats: returns your current rank and stats");
		say(Text);
		snprintf(Text, MAX_TEXT_LENGTH, "/stats find [string]: returns list of players matching [string]");
		say(Text);
		snprintf(Text, MAX_TEXT_LENGTH, "/stats [rank]: returns the stats on the player with [rank] as their current rank");
		say(Text);
		return PLUGIN_HANDLED;
	}
	else if (streq(Data, "/stats about")==1) {
		snprintf(Text, MAX_TEXT_LENGTH, "%s :    %s", User, Data);
		say(Text);
		snprintf(Text, MAX_TEXT_LENGTH, "Psycho Server Stats, PsychoStats AdminMod Plugin v0.1");
		say(Text);
		snprintf(Text, MAX_TEXT_LENGTH, "Developed by [BwC]ScatMan");
		say(Text);
		return PLUGIN_HANDLED;
	}
	else if (streq(lineCommand1, "/stats")==1 && streq(lineCommand2, "find")==1) {
		snprintf(Text, MAX_TEXT_LENGTH, "%s :    %s", User, Data);
		messageex(MESSAGE_USER, Text, print_chat);
//		say(Text);
		find_stats(plyrName,  FILENAME);
		return PLUGIN_HANDLED;
	}
	else if (streq(lineCommand1, "/stats")==1) {
		snprintf(Text, MAX_TEXT_LENGTH, "%s :    %s", User, Data);
		messageex(MESSAGE_USER, Text, print_chat);
//		say(Text);
		getName_stats(lineCommand2,FILENAME);
		return PLUGIN_HANDLED;
	}

	return PLUGIN_CONTINUE;
}	


public find_stats(UserName[], thefile[])
{
	new bGotLine;
	new iLineNum = 0;
	new strLineBuf[MAX_TEXT_LENGTH];
	new playerFound = 0;
	new OutText[MAX_TEXT_LENGTH];

	if (fileexists(thefile) > 0)
	{
		bGotLine = readfile(FILENAME, strLineBuf, iLineNum, MAX_TEXT_LENGTH);

		if (!bGotLine)
		{
			return makeReadable(thefile);
		}

		while (bGotLine)
		{
			new tmpName[50];
			strsplit(strLineBuf, "%", tmpName, 50);

			if(strcasestr(tmpName, UserName) >= 0){
				new plyrName[50];
				new plyrRank[50];
	
				strsplit(strLineBuf, "%", plyrName, 50, plyrRank, 50);
				snprintf(OutText, MAX_TEXT_LENGTH, "Rank %s: %s", plyrRank, plyrName);
				messageex(MESSAGE_USER, OutText, print_chat);
//				say(OutText);
				playerFound = 1;
			}
			bGotLine = readfile(thefile, strLineBuf, ++iLineNum, MAX_TEXT_LENGTH);
		}

		if(playerFound == 0){
			snprintf(OutText, MAX_TEXT_LENGTH, "No Players Found");
			messageex(MESSAGE_USER, OutText, print_chat);
//			say(OutText);
		}
	}
	else
	{
		snprintf(OutText, MAX_TEXT_LENGTH, "PsychoServer Plugin - Cannot find %s file.", thefile);
		log(OutText);
		return 1;
	}
	return 0;
}

public makeReadable(thefile[])
{
	exec("file_access_read 1");
	return 0;
}

public getName_stats(Rank[], thefile[])
{
	new bGotLine;
	new iLineNum = 0;
	new strLineBuf[MAX_TEXT_LENGTH];
	new playerFound = 0;
	new OutText[MAX_TEXT_LENGTH];


	if (fileexists(thefile) > 0)
	{

		bGotLine = readfile(FILENAME, strLineBuf, iLineNum, MAX_TEXT_LENGTH);

		if (!bGotLine){
			return makeReadable(thefile);
		}

		while (bGotLine && playerFound == 0)
		{
			new tmpName[50];
			new tmpRank[50];
			strsplit(strLineBuf, "%", tmpName, 50, tmpRank, 50);

			if(strcmp(tmpRank, Rank) == 0){
				playerFound = 1;
				output_player(strLineBuf, PRIVATE_MESSAGE);
			}
			bGotLine = readfile(thefile, strLineBuf, ++iLineNum, MAX_TEXT_LENGTH);
		}

		if(playerFound == 0){
			snprintf(OutText, MAX_TEXT_LENGTH, "%s not found on this server.", Rank);
			messageex(MESSAGE_USER, OutText, print_chat);
//			say(OutText);
		}
	}
	else
	{
		snprintf(OutText, MAX_TEXT_LENGTH, "PsychoServer Plugin - Cannot find %s file.", thefile);
		log(OutText);
		return 1;
	}

	return 0;
}

public output_player(fileline[], message_type)
{
	new plyrName[50];
	new plyrRank[50];
	new plyrKills[50];
	new plyrDeaths[50];
	new plyrKdr[50];
	new plyrKpm[50];
	new plyrSkill[50];
	new OutText[MAX_TEXT_LENGTH];

	strsplit(fileline, "%", plyrName, 50, plyrRank, 50, plyrKills, 50, plyrDeaths, 50, plyrKdr, 50, plyrKpm, 50, plyrSkill, MAX_TEXT_LENGTH);
	snprintf(OutText, MAX_TEXT_LENGTH, "Current Stats for Player: %s", plyrName);
	print_text(OutText, message_type);
//	say(OutText);
	snprintf(OutText, MAX_TEXT_LENGTH, "Rank: %s      Skill: %s      KPM: %s", plyrRank, plyrSkill, plyrKpm);
	print_text(OutText, message_type);
//	say(OutText);
	snprintf(OutText, MAX_TEXT_LENGTH, "Kills: %s    Deaths: %s      KDR: %s", plyrKills, plyrDeaths, plyrKdr);
	print_text(OutText, message_type);
//	say(OutText);

	return 0;
}

public print_text(mytext[], message_type){
	if(message_type == PRIVATE_MESSAGE){
		messageex(MESSAGE_USER, mytext, print_chat);
	}
	else if(message_type == PUBLIC_MESSAGE){
		say(mytext);
	}
}


public scat_stats(UserName[], thefile[])
{
	new bGotLine;
	new iLineNum = 0;
	new strLineBuf[MAX_TEXT_LENGTH];
	new playerFound = 0;
	new OutText[MAX_TEXT_LENGTH];


	if (fileexists(thefile) > 0)
	{
		bGotLine = readfile(FILENAME, strLineBuf, iLineNum, MAX_TEXT_LENGTH);

		if (!bGotLine){
			return makeReadable(thefile);
		}

		while (bGotLine && playerFound == 0)
		{
			new tmpName[50];
			strsplit(strLineBuf, "%", tmpName, 50);

			if(strcasecmp(tmpName, UserName) == 0){
				playerFound = 1;

				output_player(strLineBuf, PUBLIC_MESSAGE);
			}
			bGotLine = readfile(thefile, strLineBuf, ++iLineNum, MAX_TEXT_LENGTH);
		}

		if(playerFound == 0){
			snprintf(OutText, MAX_TEXT_LENGTH, "%s is currently not ranked on this server.", UserName);
			say(OutText);
		}

	}
	else
	{
		snprintf(OutText, MAX_TEXT_LENGTH, "PsychoServer Plugin - Cannot find %s file.", thefile);
		log(OutText);
		return 1;
	}

	return 0;
}