// Written by Evgeny Popovich, 17/01/2002
// This plugin adds new command "admin_ss <user>", and makes snapshot on the user's computer.

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_SS 8192

new STRING_VERSION[MAX_DATA_LENGTH] = "2.50.0";

// Command itself
public admin_ss(HLCommand,HLData,HLUserName,UserIndex) {
        new Command[MAX_COMMAND_LENGTH];
        new Data[MAX_DATA_LENGTH];
        new TargetName[MAX_NAME_LENGTH];
        new Text[MAX_TEXT_LENGTH];
        new User[MAX_NAME_LENGTH];

        convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
        convert_string(HLData,Data,MAX_DATA_LENGTH);
        convert_string(HLUserName,User,MAX_NAME_LENGTH);

	// Check user exists
        if (check_user(Data) == 1) {
                get_username(Data,TargetName,MAX_NAME_LENGTH);
		// Check Immunity
                if(check_immunity(TargetName)!=0) {
                        snprintf(Text, MAX_TEXT_LENGTH, "Laf. You can't ss %s, you silly bear.", TargetName);
                        say(Text);
                }
                else {
			// Take SS, so that the message will be seen in the snapshot
                        snprintf(Text, MAX_TEXT_LENGTH, "[ADMIN] SS was taken from %s.",TargetName);
                        say(Text);
                        execclient(TargetName, "snapshot");
                        selfmessage("SS Succeeded for player: ");
                        selfmessage(TargetName);
                }
        }
        else {
                selfmessage("Unrecognized player: ");
                selfmessage(Data);
        }
        return PLUGIN_HANDLED;
}


// Plugin Initialization
public plugin_init() {
        plugin_registerinfo("Takes SS from target","Just for fun.",STRING_VERSION);
        plugin_registercmd("admin_ss","admin_ss",ACCESS_SS,"admin_ss <target>: Takes SS from target.");
        return PLUGIN_CONTINUE;
}
