/***************************************************************************
* Round End Primary Weapon Drop - AdminMod Plugin for use with StatsMe,
*                                   MetaMod, and Counter-Strike 1.5
* Version: 1.2
* HLDS: 1.1.1.0
* CS: 1.5
* MetaMod: 1.12.4
* AdminMod: 2.50.26
* StatsMe: 2.6.4
*
* file: plugin_sm_pwpndropend.sma
* HL mod: Counter-strike
* Original: 29 July 2002
* Developed by: Old and Slow
* email: cgibke@compuserve.com
*
* Purpose:
*	Designed for use with awp_map, where the winning team
*	(who would still have weapons) would spawn shoot the
*	other team at the start of the next round.
*	Designed to level the playing field.
*
*	This plugin will cause all primary weapons to be dropped at
*	the end of the round for all players still alive. This also
*	handles any late comers that arrived after the round started.
*
*	The code forces the switch to weapon slot 1 (primary) so that
*	bozos won't switch to knives or pistols at the end of a round
*	in order to keep their AWP. However, if they drop their AWP,
*	this plugin will also drop their pistol, losing it for next round.
*
*	The drop event is actually the team won/loss event - a RoundEnd
*	event apparently does not allow any more processing. So the
*	weapon Pickup event is processed and forces additional drops
*	until the round officially ends.
*
*	One additional feature is the definition of a "no-kill" period
*	after the round starts - any kills in this period will get the
*	killer slayed. Defaults to 0 seconds (off).
*
*	There is one bug in this - for the one-on-one situation - the
*	round ends during no-kill period, and forces the killer's pistol
*	to be dropped at the start of the next round.
*
*   	v1.1: Weapon Drop and Earlt Kill made independent of each other.
*   	      Added RoundEnd callback to clear drop flag.
*
* Admin commands:
*	admin_priWpnDropEnd 0: disables Weapon Drop feature.
*	admin_priWpnDropEnd 1: enables Weapon Drop feature.
*	admin_priWpnDropEnd:   reports Weapon Drop feature status.
*	admin_earlykilltime:   reports "no-kill" time period from round start.
*	admin_earlykilltime N: sets "no-kill" time period to N seconds.
*
* Description:
*	if enabled:
*		1. forces all players to select primary weapon (slot 1) 
*		2. forces all players to drop selected weapon
*		3. Slays shooter if he kills within "no-kill" time period.
*	if disabled:
*		nothing (what did you expect?)
*
* Required: 
*	StatsMe - http://www.unitedadmins.com	
*	AdminMod - http://www.adminmod.org
*	Metamod - http://www.metamod.org
*	latest HLDS and CS mod
*	
* Suggested use:
*	The feature is normally OFF and should be enabled on a per-map basis.
*	For maps like awp_map, make a config file (awp_map.cfg) in the cstrike
*   	directory, and enter the following lines:
*		admin_command admin_priWpnDropEnd 1
*		mp_freezetime 0
*
*	This cause all primary weapons to be dropped at the end of the round.
*
*	Also add the following to add a "no-kill" time period:
*		admin_earlykilltime 3
*
*	This will slay any player that gets a kill within 3 seconds after the
*   	round begins.
*
***************************************************************************/ 

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_CONSOLE 131071
#define ACCESS_WPNDROP 8192

new STRING_VERSION[MAX_DATA_LENGTH] = "1.2";
new priWpnDropEnd = 0;
new Startslay = 0;
new EarlyKillTime = 0;
new EndNoPickup = 0;


// timer function for kill before [EarlyKillTime] seconds
public earlykill_timer(Timer, Repeat, HLUser, HLParam) {
	Startslay = 0;
	return PLUGIN_CONTINUE;
}


// enable/disable/query the status of the weapon drop feature
public admin_priWpnDropEnd(HLCommand, HLData, HLUserName, UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	
	convert_string(HLCommand, Command, MAX_COMMAND_LENGTH);
	convert_string(HLData,Data, MAX_DATA_LENGTH);
	convert_string(HLUserName, User, MAX_NAME_LENGTH);

	if (strlen(Data) == 0) {
	    snprintf(Text, MAX_TEXT_LENGTH, "Weapon Drop at End: %i",
	    	     priWpnDropEnd);
	    selfmessage(Text);
	} else {
	    new ival = strtonum(Data);
	    if (ival > 0) {
		selfmessage("Weapon Drop at Round End enabled...");
		priWpnDropEnd = 1;
		say_command(User, Command, Data);
	    } else {
		selfmessage("Weapon Drop at Round End disabled...");
		priWpnDropEnd = 0;
		say_command(User, Command, Data);
	    }
	}
	return PLUGIN_HANDLED;
}


// set or report the "no-kill" time period, disable with 0 (zero)
public admin_earlykilltime(HLCommand, HLData, HLUserName, UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];

	convert_string(HLCommand, Command, MAX_COMMAND_LENGTH);
	convert_string(HLData, Data, MAX_DATA_LENGTH);
	convert_string(HLUserName, User, MAX_NAME_LENGTH);

	if (strlen(Data) > 0) {
	    new itime = strtonum(Data);
	    EarlyKillTime = itime;
	    say_command(User, Command, Data);
	}
	snprintf(Text, MAX_TEXT_LENGTH, "Early Kill Time: %i", EarlyKillTime);
	selfmessage(Text);

	return PLUGIN_HANDLED;
}


// start-of-round routine
public sm_pwdropstart (HLCommand, HLData, HLUserName, UserIndex) {
	new event[MAX_DATA_LENGTH], timeS[4], time, dummy[4];
	convert_string(HLData, event, MAX_DATA_LENGTH);
	strsplit(event, " ", dummy, 4, timeS, 4);
	time = strtonum(timeS);

	if (time == getvar("mp_freezetime")) {
	    //Set timer for early kill
	    if (EarlyKillTime > 0) {
	    	new Text[MAX_TEXT_LENGTH];
		Startslay = 1;
		new ftime = getvar("mp_freezetime");
		set_timer("earlykill_timer", EarlyKillTime+ftime, 0);
	    	snprintf(Text, MAX_TEXT_LENGTH, "No Kill Time Period: %i sec",
		    	EarlyKillTime);
	    	selfmessage(Text);
	    }
	    EndNoPickup = 0;    	    	//allow pickup
	}

	return PLUGIN_CONTINUE;
} 


// end-of-round drop logic (team won/loss announce)
public sm_pwdropend (HLCommand, HLData, HLUserName, UserIndex) {
	new target[MAX_NAME_LENGTH];
	new tSession, tWONID, tTeam, tDead;

	new maxplayers = maxplayercount();
	if (priWpnDropEnd > 0) {
	    //Select primary weapon & drop for all players
	    for (new i=1; i<=maxplayers; i++) {
		if (playerinfo(i, target, MAX_NAME_LENGTH,
			       tSession, tWONID, tTeam, tDead) == 1) {
		    if (!tDead) {
			execclient(target, "slot1");
			execclient(target, "+attack");
			execclient(target, "-attack");
			execclient(target, "drop");
		    }
	    	}
	    }
	    EndNoPickup = 1;	//drop any pickedup weapons until round end
	}

	return PLUGIN_CONTINUE;
} 


// inhibit weapon pick-up after won/loss anouncement
public sm_pickupend (HLCommand, HLData, HLUserName, UserIndex) {
	new target[MAX_NAME_LENGTH];
	new tSession, tWONID, tTeam, tDead;

	if (priWpnDropEnd && EndNoPickup) {	//force drop of pick-ups
	    //use receiver & assume alive
	    new event[MAX_DATA_LENGTH], receiver[4], weapon[32];
	    convert_string(HLData, event, MAX_DATA_LENGTH);	
	    strsplit(event, " ", receiver, 4, weapon, 32);
	    new k = strtonum(receiver);
	    if (k > 0) {
		playerinfo(k, target, MAX_NAME_LENGTH, tSession,
		    	   tWONID, tTeam, tDead);
		execclient(target, "slot1");
		execclient(target, "+attack");
		execclient(target, "-attack");
		execclient(target, "drop");
	    }
	}

	return PLUGIN_CONTINUE;
} 


// allow weapon pick-up at end of round
public sm_pickupreset (HLCommand, HLData, HLUserName, UserIndex) {
    	EndNoPickup = 0;

	return PLUGIN_CONTINUE;
} 


// Check kill event for being an "early-kill"
public sm_earlykill(HLCommand, HLData, HLUserName, UserIndex) {
	new Text[MAX_TEXT_LENGTH]; //TEST

	if (EarlyKillTime && Startslay) {   	//kill too early
	    new eng_msg[MAX_DATA_LENGTH], parm0[4], killer[4];
	    new victim[4], hs[4], weapon[32];
	    convert_string(HLData, eng_msg, MAX_DATA_LENGTH);	
	    strsplit(eng_msg, " ", parm0, 4, killer, 4, victim, 4, hs, 4,
	    	     weapon, 32);
	    new kIndex = strtonum(killer);

	    //Make sure killer is not 0 (worldspawn)
	    if (kIndex != 0) {
		new kName[MAX_NAME_LENGTH], kUserID ,kWONID, kTeam, kDead; 
		playerinfo(kIndex, kName, MAX_NAME_LENGTH, kUserID, kWONID,
		    	   kTeam, kDead);
		if (!kDead) {
		    slay(kName);
		    snprintf(Text, MAX_TEXT_LENGTH,
		    	     "ADMIN: %s was slain for killing too soon.",
			     kName);
		    say(Text);
		}
	    }
	}
	return PLUGIN_CONTINUE;
}


// plugin required logic (if you want it to work)
public plugin_init() {
	plugin_registerinfo("Round End Weapon Drop",
		    	    "Forces Primary weapon drop at end of round.",
			    STRING_VERSION);

	//AdminMod
    	plugin_registercmd("admin_priWpnDropEnd", "admin_priWpnDropEnd",
	    ACCESS_WPNDROP,
	    "admin_priWpnDropEnd: Weapon Drop at Round End on/off/query.");
	plugin_registercmd("admin_earlykilltime", "admin_earlykilltime",
	    	ACCESS_WPNDROP,
	    	"admin_earlykilltime: Early Kill Slay Time (seconds).");

	plugin_registercmd("sm_pwdropstart", "sm_pwdropstart", ACCESS_CONSOLE, "");
	plugin_registercmd("sm_pwdropend", "sm_pwdropend", ACCESS_CONSOLE, "");
	plugin_registercmd("sm_pickupend", "sm_pickupend", ACCESS_CONSOLE, "");
	plugin_registercmd("sm_pickupreset","sm_pickupreset",ACCESS_CONSOLE,"");
	plugin_registercmd("sm_earlykill", "sm_earlykill", ACCESS_CONSOLE, "");

	//StatsMe
	exec("sm_reg RoundTime ^"admin_command sm_pwdropstart^" bcd");
	exec("sm_reg ResetHUD ^"admin_command sm_pickupreset^" bcd");
	exec("sm_reg TeamScore ^"admin_command sm_pwdropend^" acd");
	exec("sm_reg WeapPickup ^"admin_command sm_pickupend^" bd");
	exec("sm_reg DeathMsg ^"admin_command sm_earlykill^" ad");

	return PLUGIN_CONTINUE;
}

