/***************************************************************************
 * plugin_sank_consgreet.sma
 * Author: Luke Sankey
 * July 7, 2001 - Began writing
 * July 16, 2001 - First released version?
 * November 15, 2002 - Updated path to consgreet file to follow new
 *  directory structure.  Removed capability for displaying files other than
 *  the consgreet file because it was a security issue.  Also removed code
 *  to reset file_access_read CVAR, also a security issue.
 *
 * This plugin takes the contents of a text file and print it to the user
 * when they connect. The text file can have "macros" that will get replaced
 * with real data as it prints to the client.
 *
 * Here is the list of macros supported and what they mean:
 *
 * %USER%			Client Name
 * %IP%				Client IP address
 * %AUTHID%			Client Auth ID (only works from "admin_console_greet")
 * %MAP%			Current Map
 * %NEXTMAP%		Next Map
 * %PLAYERS%		Number of players
 * %MAXPLAYERS%		Number of max players
 * %TEAM=n%			Number of players on team n where n is a number
 * %MONTH%			Current month	ie. January
 * %DATE%			Current date	ie. 15
 * %DAY%			Current day		ie. Monday
 * %TIME%			Current time	ie. 17:00
 * %YEAR%			Current year	ie. 2001
 * %CVAR=n%			Value of n where n is a CVAR  ex: CVAR=hostname
 * %TIMEINTO%		Time into the current map in minutes
 * %TIMELEFT%		Time left on the current map in minutes
 ***************************************************************************/

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

new STRING_VERSION[MAX_DATA_LENGTH] = "2.50.50";
new FILENAME[MAX_DATA_LENGTH] = "addons\adminmod\config\consgreet.txt";


/****************************************************************************/
/****************************************************************************/
/****************************************************************************/


public plugin_connect(HLUserName, HLIP, UserIndex) 
{
	if (UserIndex >= 1 && UserIndex <= MAX_PLAYERS)
		sank_consgreet(HLUserName, HLIP);

	return PLUGIN_CONTINUE;
}

public plugin_init() 
{
	plugin_registerinfo("Console Greeting", "Prints contents of consgreet.txt to the user's console on connect.", STRING_VERSION);

	plugin_registercmd("admin_console_greet", "admin_console_greet", ACCESS_ALL, "admin_console_greet: Prints console greet information.");

	return PLUGIN_CONTINUE;
}


/****************************************************************************/
/****************************************************************************/
/****************************************************************************/


//////////////////////////////////////////////////////////////////////////////
// In case you weren't looking, or want a new update, this will reprint the
// greet message to the console - server or client. If you want specify a
// filename, then it will use that file instead of the default consgreet file.
// This can be useful for an admin to print out data that would otherwise be
// difficult or impossible to get from the server console without asking a
// player.
//
// Usage: admin_console_greet [filename]
//////////////////////////////////////////////////////////////////////////////
public admin_console_greet(HLCommand, HLData, HLUserName, UserIndex)
{
	new param[MAX_TEXT_LENGTH];

	convert_string(HLData, param, MAX_DATA_LENGTH);

/*	// If they tried to specify a file, then pass it through
	if (strlen(param))
	{
		sank_consgreet(HLUserName, HLData, param);
		return PLUGIN_HANDLED;
	}
*/
	// Otherwise, use the default FILENAME
	sank_consgreet(HLUserName, HLData);

	return PLUGIN_HANDLED;
}


//////////////////////////////////////////////////////////////////////////////
// Returns 0 if the parsing was successful
// Returns non-zero if not successful
//////////////////////////////////////////////////////////////////////////////
sank_consgreet(HLName, HLData, thefile[MAX_TEXT_LENGTH] = "")
{
	// Make all possible variables
	new UserName[MAX_NAME_LENGTH];			// %USER%
	new UserIP[MAX_NAME_LENGTH];			// %IP%
	new UserAuth[MAX_AUTHID_LENGTH];		// %AUTHID%
	new CurrentMap[MAX_DATA_LENGTH];		// %MAP%
	new NextMap[MAX_DATA_LENGTH];			// %NEXTMAP%
	new CurPlayers[MAX_NUMBER_LENGTH];		// %PLAYERS%
	new MaxPlayers[MAX_NUMBER_LENGTH];		// %MAXPLAYERS%
	new TeamCount[4][MAX_NUMBER_LENGTH];	// %TEAM= %
	new CurMonth[MAX_NUMBER_LENGTH];		// %MONTH%
	new CurDate[MAX_NUMBER_LENGTH];			// %DATE%
	new CurDay[MAX_NUMBER_LENGTH];			// %DAY%
	new CurTime[MAX_NUMBER_LENGTH];			// %TIME%
	new CurYear[MAX_NUMBER_LENGTH];			// %YEAR%
	new strVar[MAX_TEXT_LENGTH];			// %CVAR= %
	new TimeInto[MAX_NUMBER_LENGTH];		// %TIMEINTO%
	new TimeLeft[MAX_NUMBER_LENGTH];		// %TIMELEFT%

	// Fill in the variables
	convert_string(HLName, UserName, MAX_NAME_LENGTH);
	convert_string(HLData, UserIP, MAX_NAME_LENGTH);
	if (strlen(UserIP) == 0)
	{
		get_userIP(UserName, UserIP, MAX_NAME_LENGTH);
		get_userAuthID(UserName, UserAuth, MAX_AUTHID_LENGTH);
	}
	else
		strcpy(UserAuth, "N/A", MAX_AUTHID_LENGTH);
	currentmap(CurrentMap, MAX_DATA_LENGTH);
	nextmap(NextMap, MAX_DATA_LENGTH);
	numtostr(playercount(), CurPlayers);
	numtostr(maxplayercount(), MaxPlayers);
	numtostr(getteamcount(0), TeamCount[0]);
	numtostr(getteamcount(1), TeamCount[1]);
	numtostr(getteamcount(2), TeamCount[2]);
	numtostr(getteamcount(3), TeamCount[3]);
	servertime(CurMonth, MAX_NUMBER_LENGTH, "%B");
	servertime(CurDate, MAX_NUMBER_LENGTH, "%d");
	servertime(CurDay, MAX_NUMBER_LENGTH, "%A");
	servertime(CurTime, MAX_NUMBER_LENGTH, "%H:%M");
	servertime(CurYear, MAX_NUMBER_LENGTH, "%Y");
	numtostr(maptime(0)/60, TimeInto);
	numtostr(maptime(1)/60, TimeLeft);


	/************ File should have the following format: **************

	Welcome to my server.
	Your name is %USER%
	My name is %CVAR=hostname%
	There are %PLAYERS% on %MAP% right now.

	******************************************************************/

	new i;
	new iSubs;
	new GotLine;
	new iLineNum = 0;
	new strLineBuf[MAX_TEXT_LENGTH];
	new Text[MAX_TEXT_LENGTH];


	if (strlen(thefile) == 0)
	{
		// No file specified, use default file
		strcpy(thefile, FILENAME, MAX_TEXT_LENGTH);
		if (!fileexists(thefile))
			strcpy(thefile, "consgreet.txt", MAX_TEXT_LENGTH); // backwards compatibility
	}

	if (fileexists(thefile))
	{
		GotLine = readfile(FILENAME, strLineBuf, iLineNum, MAX_TEXT_LENGTH);

		if (GotLine <= 0)
		{
			// See if file access is set correctly
			if (getvar("file_access_read") == 1)
				snprintf(Text, MAX_TEXT_LENGTH, "[plugin_sank_consgreet] Unable to read from %s file.", thefile);
			else
				snprintf(Text, MAX_TEXT_LENGTH, "[plugin_sank_consgreet] CVAR file_access_read is set incorrectly.");

			log(Text);
			return 1;
		}

		// If we came from the console, then print there (without logging)
		if (strcmp(UserName, "Admin") == 0)
		{
			printf("plugin_sank_consgreet^n");
			printf("Get it at http://www.adminmod.org^n^n");
		}
		else
		{
			consgreet("plugin_sank_consgreet");
			consgreet("Get it at http://www.adminmod.org");
		}

		while (GotLine > 0)
		{
			// As long as the line isn't commented out, then process it.
			if ((strncmp(strLineBuf, "#", 1) != 0) && (strncmp(strLineBuf, "//", 2) != 0) )
			{
				iSubs = strcount(strLineBuf, '%') / 2;
				// Look for tokens in this line
				// Loop number-of-token times through the line
				for (i = 0; i < iSubs; i++)
				{
					// Replace %USER% with UserName[]
					strsubst(strLineBuf, "%USER%", UserName, MAX_TEXT_LENGTH);
					// Replace %IP% with UserIP[]
					strsubst(strLineBuf, "%IP%", UserIP, MAX_TEXT_LENGTH);
					// Replace %AUTHID% with UserAuth[]
					strsubst(strLineBuf, "%AUTHID%", UserAuth, MAX_TEXT_LENGTH);
					// Replace %MAP% with CurrentMap[]
					strsubst(strLineBuf, "%MAP%", CurrentMap, MAX_TEXT_LENGTH);
					// Replace %NEXTMAP% with NextMap[]
					strsubst(strLineBuf, "%NEXTMAP%", NextMap, MAX_TEXT_LENGTH);
					// Replace %PLAYERS% with CurPlayers[]
					strsubst(strLineBuf, "%PLAYERS%", CurPlayers, MAX_TEXT_LENGTH);
					// Replace %MAXPLAYERS% with MaxPlayers[]
					strsubst(strLineBuf, "%MAXPLAYERS%", MaxPlayers, MAX_TEXT_LENGTH);
					// Replace %MONTH% with CurMonth[]
					strsubst(strLineBuf, "%MONTH%", CurMonth, MAX_TEXT_LENGTH);
					// Replace %DATE% with CurDate[]
					strsubst(strLineBuf, "%DATE%", CurDate, MAX_TEXT_LENGTH);
					// Replace %DAY% with CurDay[]
					strsubst(strLineBuf, "%DAY%", CurDay, MAX_TEXT_LENGTH);
					// Replace %TIME% with CurTime[]
					strsubst(strLineBuf, "%TIME%", CurTime, MAX_TEXT_LENGTH);
					// Replace %YEAR% with CurYear[]
					strsubst(strLineBuf, "%YEAR%", CurYear, MAX_TEXT_LENGTH);
					// Replace %TIMEINTO% with TimeInto[]
					strsubst(strLineBuf, "%TIMEINTO%", TimeInto, MAX_TEXT_LENGTH);
					// Replace %TIMELEFT% with TimeLeft[]
					strsubst(strLineBuf, "%TIMELEFT%", TimeLeft, MAX_TEXT_LENGTH);
					// Replace %USER% with UserName[]
					strsubst(strLineBuf, "%USER%", UserName, MAX_TEXT_LENGTH);

					new strPos;
					new substText[MAX_TEXT_LENGTH];

					// Replace %TEAM= % with TeamCount[ ]
					strPos = strstr(strLineBuf, "%TEAM=");
					if (strPos > -1)
					{
						// Place full %TEAM= % string in substText
						strncpy(substText, strLineBuf[strPos], 8, MAX_TEXT_LENGTH);

						// Replace token with real info
						strsubst(strLineBuf, substText, TeamCount[strtonum(substText[6])], MAX_TEXT_LENGTH);
					}

					// Replace %CVAR= % with getstrvar()
					strPos = strstr(strLineBuf, "%CVAR=");
					if (strPos > -1)
					{
						// Place full %CVAR= % string in substText
						strcpy(substText, strLineBuf[strPos], MAX_TEXT_LENGTH);
						// Find the second % in substText and terminate string after it
						substText[strchr(substText[1], '%')+2] = 0;

						// Now place the string after = into strVar
						strcpy(strVar, substText[strchr(substText, '=')], MAX_TEXT_LENGTH);
						// Remove all '%' or '=' characters
						strtrim(strVar, "=%");

						// Replace token with real info
						getstrvar(strVar, Text, MAX_TEXT_LENGTH);
						strsubst(strLineBuf, substText, Text, MAX_TEXT_LENGTH);
					}
				} // end FOR loop

				// Now that we have replaced all of the tokens, write the line out
				
				// If we came from the server console, then print there (without logging)
				if (strcmp(UserName, "Admin") == 0)
					printf("%s^n", strLineBuf);
				else
					consgreet(strLineBuf);
			} // end if not commented line

			// Read in the next line from the file
			GotLine = readfile(thefile, strLineBuf, ++iLineNum, MAX_TEXT_LENGTH);
		} // end while loop

	}
	else // file exists returned false, meaning the file didn't exist
	{
		snprintf(Text, MAX_TEXT_LENGTH, "[plugin_sank_consgreet] Cannot find %s file.", thefile);
		log(Text);
		return -1;
	}

	return 0;
}
