// This plugin enables fast changes to specific rule settings like espl or clanbase
// Id: plugin_rules.sma,v 1.4 20.02.2002 by |EEF| IzeBurn

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

new STRING_VERSION[MAX_DATA_LENGTH] = "2.50.09";

public showrules() { 
	new strRule[MAX_NAME_LENGTH];
	new rulefound;
	new len;

	new i = 0;
	rulefound = look_in_dir("rules", "*.cfg", strRule, i);

	while (rulefound == 1 && i < 100) {
		len = strlen(strRule)-3;
		strncpy(strRule, strRule, len, len);
		selfmessage(strRule);
		i++;
		rulefound = look_in_dir("rules", "*.cfg", strRule, i);
	}
}

public admin_rules(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Liga[MAX_NAME_LENGTH]; 

	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	strbreak(Data,Liga,Data, MAX_NAME_LENGTH);
	if(strlen(Liga) < 1) {
		selfmessage("");
		selfmessage("");
		selfmessage("");
		selfmessage("--------------------------------------------------");
		selfmessage("--------------------------------------------------");
		selfmessage("The following rule settings can be choosen:");
		selfmessage("");

		showrules();

		selfmessage("");
		selfmessage("--------------------------------------------------");
		selfmessage("");
		return PLUGIN_HANDLED;
	}

	new Text1[100];
	new Text2[100];
	new Text3[100];
	new Text4[100];

	snprintf(Text1, 100, "rules/%s.cfg", Liga);
	snprintf(Text2, 100, "exec rules/%s.cfg", Liga);
	snprintf(Text3, 100, "Settings are changed to %s settings!", Liga);
	snprintf(Text4, 100, "%s settings are not available!", Liga);

	if(fileexists(Text1)) {
		exec(Text2);
		selfmessage(Text3);
		exec("sv_restartround 5");
		centersay(Text3,7,63,187,239);
		log_command(User,Command,Data);
		selfmessage(Text3);
		return PLUGIN_HANDLED;
	} else {
		selfmessage(Text4);
		log_command(User,Command,Data);
		return PLUGIN_HANDLED;
	}

	log_command(User,Command,Data);
	return PLUGIN_HANDLED;
}

public plugin_init() {
	plugin_registerinfo("Rules PlugIn","This plugin enables fast changes to specific rule settings",STRING_VERSION);
	plugin_registercmd("admin_rules","admin_rules",ACCESS_PAUSE,"admin_rules <liga>: Changes the Server Settings to <liga> rule settings.");	
	return PLUGIN_CONTINUE;
}