/*********************************************************
 * A time announcing plugin - Version 0.8                *
 *********************************************************
 *                                                       *
 * Name: plugin_riny_time                                *
 * Author: Rinde (rinde@fiatnox.de)                      *
 * Released: 07/12/02                                    *
 *                                                       *
 *                                                       *
 * Commands:                                             *
 *                                                       *
 * say "thetime": Display/speak current server's time    *
 *                                                       *
 *                                                       *
 * Changelog:                                            *
 *                                                       *
 * Version 0.8                                           *
 *                                                       *
 *  -  Initial release                                   *
 *                                                       *
 *********************************************************/

/* Includes */
#include <core>
#include <console>
#include <plugin>
#include <adminlib>

/* Global Variables */
new g_Version[]="0.8";
new g_LastSpeak;

/* Function Declarations */
forward HandleSay(HLCommand,HLData,HLUserName,UserIndex);

/* Event Handlers */
public plugin_init() {
    plugin_registerinfo("Server Time/Date Plugin","Speaks the current server time.",g_Version);
    plugin_registercmd("say","HandleSay",ACCESS_ALL);
    plugin_registerhelp("say",ACCESS_ALL,"say thetime: Speaks/displays current server time.");
    return PLUGIN_CONTINUE;
}

/* Command Handlers */
public HandleSay(HLCommand,HLData,HLUserName,UserIndex) {
    new Data[MAX_DATA_LENGTH];
    convert_string(HLData,Data,MAX_DATA_LENGTH);
    strstripquotes(Data);
    if(-1 < strcasestr(Data, "the") < strcasestr(Data, "time")) {
        if(systemtime() - 60 < g_LastSpeak) {
            SpeakTime(0);
        } else {
            SpeakTime(1);
            g_LastSpeak = systemtime();
        }
    }
    return PLUGIN_CONTINUE;
}

/* Support Functions */
SpeakTime(WithSpeech) {
    new Text[MAX_DATA_LENGTH];
    new word1[MAX_TEXT_LENGTH];
    new word2[MAX_TEXT_LENGTH];
    new word3[MAX_TEXT_LENGTH];
    servertime(Text,MAX_TEXT_LENGTH,"[ Time: %H:%M ]");
    say(Text);
    servertime(Text,MAX_DATA_LENGTH,"[ %d.%m. %Y ]");
    say(Text);
    if(WithSpeech == 1) {
        servertime(word1,MAX_TEXT_LENGTH,"%I");
        servertime(word2,MAX_TEXT_LENGTH,"%M");
        servertime(word3,MAX_TEXT_LENGTH,"%p");
        numtoword(strtonum(word1),word1,MAX_TEXT_LENGTH);
        numtoword(strtonum(word2),word2,MAX_TEXT_LENGTH);
        snprintf(Text,MAX_DATA_LENGTH,"speak ^"fvox/bell time_is_now %s %s %s^"",word1,word2,word3);
        speakto_all(Text);
    }
}

new OnesLib[10][] = { "", "one ", "two ", "three ", "four ", "five ", "six ", "seven ", "eight ", "nine " };
new TensLib[10][] = {"", "ten ", "twenty ", "thirty ", "fourty ", "fifty ", "sixty ", "seventy ", "eighty ", "ninety " } ;
new TeensLib[10][] = {"", "eleven ", "twelve ", "thirteen ", "fourteen ", "fifteen ", "sixteen ", "seventeen ", "eighteen ", "nineteen " };
new HundredsLib[10][] = { "", "one hundred ", "two hundred ", "three hundred ", "four hundred ", "five hundred ", "six hundred ", "seven hundred ", "eight hundred ", "nine hundred " };
new GroupNamesLib[5][] = {"", "thousand ", "million ", "billion ", "trillion " };

do_numtoword(iNum,str[],iLevel,iLength) {

   /* If there is more than one group of 3, then take care of the others first. */
   if(iNum >= 1000) do_numtoword(iNum / 1000,str,iLevel + 1,iLength);

   /* Grab the the first 3 digits only */
   iNum %= 1000;

   /* Isolate each digit */
   new _hundreds = iNum / 100;
   new _tens = (iNum / 10) % 10;
   new _ones = iNum % 10;

   /* Take care of the teen numbers */
   if(_tens == 1 && _ones != 0) {
      snprintf(str,iLength,"%s%s%s%s",str,HundredsLib[_hundreds],TeensLib[_ones],GroupNamesLib[iLevel]);
   } else {
      snprintf(str,iLength,"%s%s%s%s%s",str,HundredsLib[_hundreds], TensLib[_tens], OnesLib[_ones],GroupNamesLib[iLevel]);
   }

   if(iLevel==0) str[strlen(str)-1] = 0; /* Gets rid of the trailing space*/
   return 1;
}

numtoword(iNum,str[],iLength) {
   /* Empties the first char of the string */
   str[0] = 0;
   str[iLength-1] = 0;
   if(iNum == 0) {
      snprintf(str,iLength,"zero");
      return 1;
   }
   if(iNum < 0) {
      iNum *= -1;
      snprintf(str,iLength,"negative ");
   }

   return do_numtoword(iNum,str,0,iLength);
}

speakto_all(sSentence[]) {
    new Target[MAX_NAME_LENGTH];
    new i, num = 0;
    new maxplayers = maxplayercount();
    for(i=1; i<=maxplayers; i++) {
        if(playerinfo(i,Target,MAX_NAME_LENGTH) && allowsound(Target)) {
            speakto(Target,sSentence);
            num++;
        }
    }
    return num;
}

new Key[]="am_sound";

public allowsound(User[]){
    new Info[MAX_NUMBER_LENGTH];
    new iInfo;
    new Authid[MAX_AUTHID_LENGTH];
    get_userAuthID(User,Authid,MAX_AUTHID_LENGTH);
    if(strcmp(Authid,"BOT")!=0){
        get_userinfo(User,Key,Info,MAX_NUMBER_LENGTH);
        iInfo=strtonum(Info);
        if(strlen(Info)==0 || iInfo>=1 ){/*damit wird automatisch immer der Sound auf 1 gesetzt,wenn kein setinfo vorhanden, bis 'stop' eingegeben wird*/
            return 1;
        }else{
            return 0;
        }
    }
    return 0;
}