/*********************************************************
 * An IP monitoring plugin - Version 0.8                 *
 *********************************************************
 *                                                       *
 * Name: plugin_rindy_chasecam                           *
 * Author: Rinde (rinde@fiatnox.de)                      *
 * Released: 28/01/03                                    *
 *                                                       *
 *                                                       *
 * Version 0.8                                           *
 *                                                       *
 *  -  Initial release                                   *
 *                                                       *
 *********************************************************/

/* Includes */
#include <plugin>
#include <adminlib>

/* Constants */
#define MAX_IP_LENGTH 22

/* Function Declarations */
forward csay(Text[MAX_TEXT_LENGTH]);

/* Global Variables */
new g_Version[] = "0.8";
new g_LANID[MAX_PLAYERS];
new g_IDs;
new g_Enabled;

/* Event Handlers */
public plugin_init() {
    plugin_registerinfo("Rindes Forcechasecam Plugin","Sets mp_forcechasecam to 2 when players with the same ip are playing",g_Version);
    return PLUGIN_CONTINUE;
}

public plugin_connect(HLUserName,HLIP,UserIndex) {
    new UserName[MAX_NAME_LENGTH];
    new Name[MAX_NAME_LENGTH];
    new UserIP[MAX_IP_LENGTH];
    new IP[MAX_IP_LENGTH];
    new Text[MAX_TEXT_LENGTH];
    new maxplayers = maxplayercount();
    new i;
    convert_string(HLIP,UserIP,MAX_IP_LENGTH);
    if(strrchr(UserIP,':') != -1) UserIP[strrchr(UserIP,':')] = 0;
    for(i=1;i<=maxplayers;i++) {
        if(playerinfo(i,Name,MAX_NAME_LENGTH) == 1 && i != UserIndex) {
            get_userIP(Name,IP,MAX_IP_LENGTH);
            if(strrchr(IP,':') != -1) IP[strrchr(IP,':')] = 0;
            if(strcmp(UserIP,IP) == 0) {
                if(g_LANID[i] == 0) {
                    g_IDs++;
                    g_LANID[i] = g_IDs;
                    g_LANID[UserIndex] = g_IDs;
                } else {
                    g_LANID[UserIndex] = g_LANID[i];
                }
                if(g_Enabled == 0) {
                    g_Enabled = 1;
                    setstrvar("mp_forcechasecam","2");
                    convert_string(HLUserName,UserName,MAX_NAME_LENGTH);
                    snprintf(Text,MAX_TEXT_LENGTH,"%s and %s are playing from the same LAN, mp_forcechasecam thus was set to 2",UserName,Name);
                    csay(Text);
                }
                break;
            }
        }
    }
    return PLUGIN_CONTINUE;
}

public plugin_disconnect(HLUserName,UserIndex) {
    new UserName[MAX_NAME_LENGTH];
    new Text[MAX_TEXT_LENGTH];
    new maxplayers = maxplayercount();
    new i,j,k,l;
    if(g_Enabled == 1 && g_LANID[UserIndex] != 0) {
        for(i=1;i<=maxplayers;i++) {
            if(i == UserIndex) {
                continue;
            } else if(g_LANID[UserIndex] == g_LANID[i]) {
                j++;
                k = i;
            } else if(g_LANID[i] != 0) {
                l++;
            }
        }
        g_LANID[UserIndex] = 0;
        if(j == 1) {
            g_LANID[k] = 0;
            if(l == 0) {
                g_Enabled = 0;
                setstrvar("mp_forcechasecam","0");
                convert_string(HLUserName,UserName,MAX_NAME_LENGTH);
                snprintf(Text,MAX_TEXT_LENGTH,"%s disconnected, mp_forcechasecam thus was set back to 0",UserName);
                csay(Text);
            }
        }
    }
    return PLUGIN_CONTINUE;
}

csay(Text[MAX_TEXT_LENGTH]) {
    new Name[MAX_NAME_LENGTH];
    new maxplayers = maxplayercount();
    new i;
    for(i=1;i<=maxplayers;i++) {
        if(playerinfo(i,Name,MAX_NAME_LENGTH) == 1) {
            messageex(Name,Text,print_pretty);
        }
    }
}