/*********************************************************
 * An advanced retribution plugin - Version 1.1          *
 *********************************************************
 *                                                       *
 * Name: plugin_rindy_advretribution                     *
 * Author: Rinde (rinde@fiatnox.de)                      *
 * Released: 14/11/02                                    *
 *                                                       *
 * IMPORTANT NOTE: This plugin must be listed ABOVE the  *
 *                 standard plugin_retribution in your   *
 *                 plugin-file.                          *
 *                                                       *
 *                                                       *
 * Commands:                                             *
 *                                                       *
 * admin_slap <players>: Like the admin_slap from the    *
 *                       standard plugin, but can handle *
 *                       as many players as you like     *
 *                                                       *
 * admin_slap <players>: Like the admin_slay from the    *
 *                       standard plugin, but can handle *
 *                       as many players as you like     *
 *                                                       *
 * admin_slapteam <#>: Slaps all members of team #,      *
 *                     where # must be a number from 1-4 *
 *                                                       *
 *                                                       *
 * Changelog:                                            *
 *                                                       *
 * Version 1.1                                           *
 *                                                       *
 *  - admin_slap and admin_slay now working              *
 *                                                       *
 * Version 1.0                                           *
 *                                                       *
 *  - Initial release                                    *
 *                                                       *
 *********************************************************/

/* Includes */
#include <plugin>
#include <adminlib>

/* Constants */
#define ACCESS_SLAP 128
#define ACCESS_SLAY 128

/* Global Variables */
new g_Version[]="1.1";

/* Function Declarations */
forward admin_slap(HLCommand,HLData,HLUserName,UserIndex);
forward admin_slapteam(HLCommand,HLData,HLUserName,UserIndex);
forward admin_slay(HLCommand,HLData,HLUserName,UserIndex);

/* Event Handlers */
public plugin_init() {
  plugin_registerinfo("Rinde's Retribution Plugin Addon","Allows to slay/slap multiple players",g_Version);
  plugin_registercmd("admin_slap","AdminSlap",ACCESS_SLAP,"admin_slap <players>: Slaps players. Include as many players as you like.");
  plugin_registercmd("admin_slapteam","AdminSlapTeam",ACCESS_SLAP,"admin_slapteam <#>: Slaps all players of team #.");
  plugin_registercmd("admin_slay","AdminSlay",ACCESS_SLAY,"admin_slay <players>: Slays players. Include as many players as you like.");
  return PLUGIN_CONTINUE;
}

/* Command Handlers */
public AdminSlap(HLCommand,HLData,HLUserName,UserIndex) {
    new Data[MAX_DATA_LENGTH];
    new Target[MAX_NAME_LENGTH];
    convert_string(HLData,Data,MAX_DATA_LENGTH);
    strstripquotes(Data);
    while(strtrim(Data," ",2) > 0)
    if(strcount(Data,' ') > 0) {
        while(strlen(Data) > 0) {
            strgsep(Data," ","^"",Target,MAX_NAME_LENGTH,Data,MAX_DATA_LENGTH);
            plugin_exec("admin_slap",Target);
        }
        return PLUGIN_HANDLED;
    }
    return PLUGIN_CONTINUE;
}

public AdminSlapTeam(HLCommand,HLData,HLUserName,UserIndex) {
    new Command[MAX_COMMAND_LENGTH];
    new Data[5];
    new User[MAX_NAME_LENGTH];
    new maxplayers = maxplayercount();
    new SlapTeam;
    new Team;
    new i;
    convert_string(HLData,Data,MAX_DATA_LENGTH);
    strstripquotes(Data);
    while(strtrim(Data," ",2) > 0)
    if(strlen(Data) == 0 || strlen(Data) != strspn(Data,"1234")) {
        selfmessage("Wrong syntax");
        selfmessage("You must enter the team number (1 - 4).");
    } else {
        SlapTeam = strtonum(Data);
        for(i=1;i<=maxplayers;i++) {
            if(playerinfo(i,User,MAX_NAME_LENGTH,_,_,Team) == 1 && Team == SlapTeam && i != UserIndex && check_immunity(User) == 0) {
                slap(User);
            }
        }
        convert_string(HLUserName,User,MAX_NAME_LENGTH);
        convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
        say_command(User,Command,Data);
    }
    return PLUGIN_HANDLED;
}


public AdminSlay(HLCommand,HLData,HLUserName,UserIndex) {
    new Data[MAX_DATA_LENGTH];
    new Target[MAX_NAME_LENGTH];
    convert_string(HLData,Data,MAX_DATA_LENGTH);
    strstripquotes(Data);
    while(strtrim(Data," ",2) > 0)
    if(strcount(Data,' ') > 0) {
        while(strlen(Data) > 0) {
            strgsep(Data," ","^"",Target,MAX_NAME_LENGTH,Data,MAX_DATA_LENGTH);
            plugin_exec("admin_slay",Target);
        }
        return PLUGIN_HANDLED;
    }
    return PLUGIN_CONTINUE;
}