/********************************************************************************************************
* Created By: Will (aka Footy)                                                                          *
*																																																				*
* Date: 23/12/04                                                                                        *
*																																																				*
* Commands:	admin_record <say/say_team/admin_> <on/off> turns recording on or off for 																					*
*						admin_record_data <user> <number> returns the last <number> things that <user> said					*
*						admin_record_user <user>/admins <on/off> turns recording on or off for <user> or admins			*
*																										 with g_Level access (change below)									*
*																																																				*
* Versions: 1.0.0 - initial release																																			*
*						1.0.1 - fixed: numerous scripting errors																										*
*						1.0.2 - fixed: when you used command admin_record <user> <number> it showed everything that *
*													 <user> say/say_team instead of the <number> it should show.									*
*						1.1.0 - added: new command admin_record_user <user>/admins <on/off> replaces admin_record		*
*													 <user>/admins <on/off>.																											*
*										added: new command admin_record_data <user> <number> replaces admin_record <user>   *
*													 <number>.																																		*
*										changed: rewrote most of the code for easier understanding and editting.						*
*										fixed: admin_record_data <user> <number> didn't work when <user> wasn't on the			*
*													 server.																																			*
*						1.2.0 - added: now records admin_ commands as well																					*
*																																																				*
* Credits: Sir Drink a lot, from OzForums, great guy, helped me figure out most of my problems and			*
*					 helped me correct some of them.																															*
*																																																				*
* Help: If you spot any errors, or need any help, or want something added, email me at:									*
*				william@lesberries.co.uk																																				*
*********************************************************************************************************/


#include <core>
#include <string>
#include <admin>
#include <adminlib>

#define MAX_LOG_LENGTH MAX_COMMAND_LENGTH + MAX_DATA_LENGTH + MAX_AUTHID_LENGTH + MAX_NAME_LENGTH + 24

new VERSION_STRING[] = "1.2.0";

// you can change the path of the file if you like. note, must be relative to your <mod> directory
new g_File[] = "addons/adminmod/config/record.txt";

new g_Record[3];

// change this to 1 if you dont want to record what admins say.
new g_Admin = 0;

// default admin level that doesn't get recorded if g_Admin = 1, change if you want.
new g_Level = 256; // Ban level

new Players[MAX_PLAYERS];

new g_Other = 0;

//------------------------------------------------------------------------------------
public plugin_init() {
	// change this to 0 if you dont want to record whay users say.
	g_Record[0] = 1;

	// change this to 0 if you dont want to record whay users say_team.
	g_Record[1] = 1;

	// change this to 0 if you dont want to record what commands are used.
	g_Record[2] = 1;

	plugin_registerinfo("Say/Say_Team Recorder","Records what users say/say_team with easy commands to tell admins.",VERSION_STRING);
	plugin_registercmd("admin_record","admin_record",ACCESS_BAN,"admin_record <on/off>: turns recording on or off.");
	plugin_registercmd("admin_record_data","admin_record_data",ACCESS_KICK,"admin_record_data <user> <number>: retrieves the last <number> things said by <user>");
	plugin_registercmd("admin_record_user","admin_record_user",ACCESS_BAN,"admin_record_user <user>/admins <on/off>: turns <user> or admin recording on or off.");

	return PLUGIN_CONTINUE;
}
//------------------------------------------------------------------------------------
public admin_record(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new toggle[1];
	new i;
	new itog;

	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	strbreak(Data,Data,toggle,MAX_DATA_LENGTH);

	if (strcmp(Data,"say")==0) {
		i = 0;
		g_Other = 0;
	} else if (strcmp(Data,"say_team")==0) {
		i = 1;
		g_Other = 0;
	} else if (strncmp(Data,"admin_",6)==0) {
		i = 2;
		g_Other = 0;
	} else {
		g_Other = 1;
	}
	itog = check_param(toggle);
	if (g_Record[i] == itog) {
		snprintf(Text,MAX_TEXT_LENGTH,"This option is already %d. 1=On, 0=Off",itog);
		selfmessage(Text);
	} else {
		g_Record[i] = itog;
		snprintf(Text,MAX_TEXT_LENGTH,"This option is now %d. 1=On, 0=Off",itog);
		selfmessage(Text);
	}

	log_command(User,Command,Data);

	return PLUGIN_HANDLED;
}
//------------------------------------------------------------------------------------
public admin_record_data(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Name[MAX_NAME_LENGTH];
	new Number[MAX_DATA_LENGTH];
	new Target[MAX_NAME_LENGTH];
	new Before[24];
	new After[MAX_DATA_LENGTH];
	new String[321];
	new Int;
	new i;
	new num_lines;

	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	strbreak(Data,Name,Number,MAX_DATA_LENGTH);
	if(strlen(Name) && strlen(Number)) {
		Int = strtonum(Number);
		if (fileexists(g_File)) {
			num_lines = filesize(g_File,fsize_unit:lines);
			for (i=num_lines;i>0;i--) {
				readfile(g_File,String,i,MAX_LOG_LENGTH);
				strsplit(String,"-",Before,24,After,MAX_DATA_LENGTH);
				strsplit(After,"<",Target,MAX_NAME_LENGTH,After,MAX_DATA_LENGTH);
				if (Int > 0) {
					if (strcasestr(Target,Name)>=0) {
						Int--;
						selfmessage(String);
					} else {
						selfmessage("No more results available");
						break;
					}
				}
			}
		}

		log_command(User,Command,Data);
	} else {
		selfmessage("Invalid Data: Usage admin_record_data <user> <number of post to retrieve>");
	}

	return PLUGIN_HANDLED;
}
//------------------------------------------------------------------------------------
public admin_record_user(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Name[MAX_NAME_LENGTH];
	new real_name[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new toggle[MAX_DATA_LENGTH];
	new Index;

	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	strbreak(Data,Name,toggle,MAX_DATA_LENGTH);

	if(check_user(Name)) {
		get_username(Name,real_name,MAX_NAME_LENGTH);
		get_userindex(Name,Index);
		if(check_param(toggle)) {
			if(Players[Index]) {
				snprintf(Text,MAX_TEXT_LENGTH,"%s is already being recorded",real_name);
				selfmessage(Text);
			} else {
				Players[Index] = 1;
				snprintf(Text,MAX_TEXT_LENGTH,"%s is now being recorded",real_name);
				selfmessage(Text);
			}
		} else {
			if(!Players[Index]) {
				snprintf(Text,MAX_TEXT_LENGTH,"%s is not being recorded already",real_name);
				selfmessage(Text);
			} else {
				Players[Index] = 0;
				snprintf(Text,MAX_TEXT_LENGTH,"%s is now not being recorded",real_name);
				selfmessage(Text);
			}
		}

		log_command(User,Command,Data);
	} else if(strcmp(Name,"admins")==0) {
		if(check_param(toggle)) {
			if(g_Admin) {
				selfmessage("Admins are already being recorded");
			} else {
				g_Admin = 1;
				selfmessage("Admins are now being recorded");
			}
		} else {
			if(!g_Admin) {
				selfmessage("Admins are not being recorded already");
			} else {
				g_Admin = 0;
				selfmessage("Admins are now being recorded");
			}
		}

		log_command(User,Command,Data);
	} else {
		selfmessage("Invalid Data: Usage admin_record_user <name>/admins <on/off>");
	}

	return PLUGIN_HANDLED;
}
//------------------------------------------------------------------------------------
public plugin_command(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new Date[19];
	new UserID[MAX_AUTHID_LENGTH];
	new i;

	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	if (strcmp(Command,"say")==0) {
		i = 0;
		g_Other = 0;
	} else if (strcmp(Command,"say_team")==0) {
		i = 1;
		g_Other = 0;
	} else if (strncmp(Command,"admin_",6)==0) {
		i = 2;
		g_Other = 0;
	} else {
		g_Other = 1;
	}
	if (!g_Other) {
		if (g_Record[i]) {
			if (Players[UserIndex]) {
				get_userAuthID(User,UserID,MAX_AUTHID_LENGTH);
				servertime(Date,19,"L %d/%m/%y %H:%M:%S");
				snprintf(Text,MAX_LOG_LENGTH,"%s-%s<%s>(%s)%s",Date,User,UserID,Command,Data);
				if (!g_Admin) { // if recording admins is on
					writefile(g_File,Text,-1);
				} else {        // admin recording is off
					if (!check_auth(g_Level)) { // if user doesn't have g_Level admin (defined at top)
						writefile(g_File,Text,-1);
					}
				}
			}
		}
	}

	return PLUGIN_CONTINUE;
}
//------------------------------------------------------------------------------------
public plugin_connect(HLUserName,HLIP,UserIndex) {

	Players[UserIndex] = 1;

}
//------------------------------------------------------------------------------------
public plugin_disconnect(HLUserName,UserIndex) {

	Players[UserIndex] = 0;

}
