/**********************************************************
 Protect Tag by redeyez (redeyez@mindspring.com)

 Protect Clan Tags and/or Player names to certain AuthID

 History:
 version 1.2 - Implemented the Command option.
		   Added more (rather verbose) Debug comments.
		   Removed some junk.
 version 1.1 - Fixed a cuple of bugs.
		   Add Command option in Tags.txt file
		   Not implemented yet.
 version 1.0 - First release of Protect Tag Plugin.

**********************************************************/

/* Should be compatible to steam now [WING] Black Knight */

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_PROTECTTAG 8192
#define MAX_TAGS 100

new STRING_VERSION[MAX_DATA_LENGTH] = "1.2";

new TagTimer[MAX_PLAYERS];   

new FileStatus = 0; /* Check if file exists flag */
new TotalTags = 0;
new ClanTag[MAX_TAGS][MAX_TEXT_LENGTH];
new scommand[MAX_TAGS];
new TagType[MAX_TAGS];
new PlayerAuthID[MAX_TAGS][MAX_TEXT_LENGTH];
new DebugUser[MAX_NAME_LENGTH];
new DebugFlag = 0;

public tag_debug (HLCommand, HLData, HLUserName, UserIndex)
{
	convert_string(HLUserName, DebugUser, MAX_NAME_LENGTH);

	if (DebugFlag)
	{
		printf ("[PROTECT TAG] Debug Off^n");
		messageex(DebugUser,"[PROTECT TAG] Debug Off",print_console);
		DebugFlag = 0;
	}
	else
	{
		printf ("[PROTECT TAG] Debug On^n");
		messageex(DebugUser,"[PROTECT TAG] Debug On",print_console);
		DebugFlag = 1;
	}
	return PLUGIN_HANDLED;
}

public load_tag_file()
{
	new gotLine;
	new lineNum = 0;
	new lineStr[MAX_TEXT_LENGTH];
	new Text[MAX_TEXT_LENGTH];

	TotalTags = 0;

	FileStatus = fileexists("TAGS.TXT");
	if ( FileStatus > 0 )
	{
		printf("[TAG PROTECT]Reading Tags.^n");
		do
		{
			gotLine = readfile("TAGS.TXT",lineStr, lineNum, MAX_TEXT_LENGTH);
			if (gotLine) 
		      {
				if (DebugFlag)
				{
					printf ("Got tag %s^n",lineStr);
					printf ("Got Line # %s^n",TotalTags+1);
				}
				lineNum++;	
				if ((strncmp(lineStr, "#", 1) == 0) || (strncmp(lineStr, "//", 2) == 0))
				{
					/* Ignoreing comment. */
				}
				else 
				{
					strsplit(lineStr, ";", TagType[TotalTags], MAX_DATA_LENGTH , scommand[TotalTags], MAX_DATA_LENGTH , ClanTag[TotalTags], MAX_DATA_LENGTH, PlayerAuthID[TotalTags], MAX_DATA_LENGTH);
					TagType[TotalTags] = strtonum(TagType[TotalTags]);
					scommand[TotalTags] = strtonum(scommand[TotalTags]);
					if (DebugFlag)
					{
						printf("TAG: %s AUTHID: %s COMMAND: %i TAGTYPE: %i^n",ClanTag[TotalTags],PlayerAuthID[TotalTags],scommand[TotalTags],TagType[TotalTags]);
					}
					TotalTags++;
				}
			}
			if ( TotalTags > MAX_TAGS )
			{
				return PLUGIN_CONTINUE;
			}
		} while(gotLine);
		TotalTags--;
		snprintf(Text, MAX_TEXT_LENGTH, "[PROTECT TAG] TAGS.TXT file found: %i Tags",TotalTags);
		printf ("%s.^n",Text);
		if (DebugFlag)
		{
			messageex(DebugUser,Text,print_console);
		}
	}
	else
	{
		printf ("[PROTECT TAG] Cannot find TAGS.TXT file.^n");
		if (DebugFlag)
		{
			messageex(DebugUser,"[PROTECT TAG] Cannot find TAGS.TXT file.",print_console);
		}
	}
	return PLUGIN_HANDLED;
}

public  TagTrigger(Timer,WaitCount,RepeatCount,User) {
	new MyAuthID[MAX_AUTHID_LENGTH];
	new UserIndex;
	new MyName[MAX_NAME_LENGTH];
	new searchIndex = 0;
	new Text[MAX_TEXT_LENGTH];
	new NameFound = 0;
	new TagFound = 0;
	new TagCommand = 0;
	
	convert_string(User, MyName, MAX_NAME_LENGTH);
	get_userindex(MyName, UserIndex);
	get_userAuthID(MyName, MyAuthID);

	/* Only continue if player has fully connected; WONID of 0 means they haven't */
	if ( strlen(MyAuthID) != 0 )
	{
		if (DebugFlag)
		{
			messageex(MyName,"[PROTECT TAG] AUTHENTICATING CLAN TAG...",print_console);
			printf ("%s",Text);
		}

		for ( searchIndex=1; searchIndex<=TotalTags; searchIndex++ )
		{
			if (TagType[searchIndex] == 0 )
			{
				if ( (strcasestr(MyName,ClanTag[searchIndex]) != -1) )
				{
					if (DebugFlag)
					{
						messageex(MyName,"^n[PROTECT TAG] TAG MATCH",print_console);
						snprintf(Text, MAX_TEXT_LENGTH, "^nsearchIndex: %i ClanTag: %s YourName: %s",searchIndex, ClanTag[searchIndex], MyName);
						messageex(MyName, Text, print_console);
					}
			
					if (streq(MyAuthID,PlayerAuthID[searchIndex]))
					{
						TagFound = 1;
						if (DebugFlag)
						{
							messageex(MyName,"AUTHENICATED",print_console);
							printf ("%s.^n",Text);
						}
						searchIndex=TotalTags+1;
					}
					else
					{
						TagFound = 2;
						if ( scommand[searchIndex] > TagCommand )
						{
							TagCommand = scommand[searchIndex];
						}
					}
				}
			}
		}
		if (DebugFlag)
		{
			if ( TagFound == 2 )
			{
				messageex(MyName, "FAILED TO AUTHENICATE",print_console);
				printf ("%s^n",Text);
			}
			
			if ( TagFound == 0 )
			{
				messageex(MyName, "DONE",print_console);
				printf ("%s^n",Text);
			}

			messageex(MyName,"[PROTECT TAG] AUTHENTICATING NAME...",print_console);
			printf ("%s",Text);
		}

		for ( searchIndex=1; searchIndex<=TotalTags; searchIndex++ )
		{
			if (TagType[searchIndex] == 1 )
			{
				if ( (strcasestr(MyName,ClanTag[searchIndex]) != -1) )
				{
					if (DebugFlag)
					{
						messageex(MyName,"^n[PROTECT TAG] NAME MATCH",print_console);
						snprintf(Text, MAX_TEXT_LENGTH, "^nsearchIndex: %i ClanTag: %s YourName: %s",searchIndex, ClanTag[searchIndex], MyName);
						messageex(MyName, Text, print_console);
					}
			
					if (streq(MyAuthID,PlayerAuthID[searchIndex]))
					{
						NameFound = 1;
						if (DebugFlag)
						{
							messageex(MyName,"AUTHENICATED",print_console);
							printf ("%s^n",Text);
						}
						searchIndex=TotalTags+1;
					}
					else
					{
						NameFound = 2;
						if ( scommand[searchIndex] > TagCommand )
						{
							TagCommand = scommand[searchIndex];
						}
					}
				}			
			}
		}
		if (DebugFlag)
		{
			if ( NameFound == 2 )
			{
				messageex(MyName, "FAILED TO AUTHENICATE",print_console);
				printf ("%s^n",Text);
			}

			if ( NameFound == 0 )
			{
				messageex(MyName, "DONE",print_console);
				printf ("%s^n",Text);
			}
		}

		if ( (TagFound == 2) || (NameFound == 2) )
		{
			if ( TagCommand != 1 && TagCommand != 2 )
			{
				execclient(MyName, "name IMPOSTER");
			}
			if ( TagCommand == 1 )
			{
				kick(MyName);
			}
			if ( TagCommand == 2 )
			{
				ban(MyName,0);
			}
		}
		kill_timer(TagTimer[UserIndex]);
	}
	else
	{
		/* Repeat later when the player has hopefully finished connecting */
		if ( TagTimer[UserIndex] != 0 ) kill_timer(TagTimer[UserIndex]);
		TagTimer[UserIndex] = set_timer("TagTrigger",30,0,MyName);
	}
}




public plugin_connect(HLUserName, HLIP, UserIndex)
{
	new MyUserName[MAX_NAME_LENGTH];

	convert_string(HLUserName, MyUserName, MAX_NAME_LENGTH);

	if ( (UserIndex >= 1) && (UserIndex <= MAX_PLAYERS))
	{
		if ( TagTimer[UserIndex] != 0 ) kill_timer(TagTimer[UserIndex]);
		TagTimer[UserIndex] = set_timer("TagTrigger",30,0,MyUserName);

	}
	
	return PLUGIN_CONTINUE;
}	

public plugin_disconnect(HLUserName, UserIndex) {
	if ( UserIndex >= 1 && UserIndex <= MAX_PLAYERS )
	{
		if ( TagTimer[UserIndex]  = 0 ) kill_timer(TagTimer[UserIndex]); 
	}

	return PLUGIN_CONTINUE;
}
	

public plugin_info(HLOldName,HLNewName,UserIndex)
{
	new Text[MAX_TEXT_LENGTH];
	new MyAuthID[MAX_AUTHID_LENGTH];
	new NewName[MAX_NAME_LENGTH];
	new OldName[MAX_NAME_LENGTH];
	new NameFound = 0;
	new searchIndex = 0;
	new TagFound = 0;
	new TagCommand = 0;

	convert_string(HLNewName, NewName, MAX_NAME_LENGTH);
	convert_string(HLOldName, OldName, MAX_NAME_LENGTH);

	get_userAuthID(OldName, MyAuthID);
	
	/* Only bother if the name has changed. */
	if(streq(OldName,NewName)==0)
	{
		if (DebugFlag)
		{
			messageex(OldName,"[PROTECT TAG] YOUR NAME HAS CHANGED",print_console);
		}

		if ( (strcasestr(NewName,"IMPOSTER") != -1) )
		{
			return PLUGIN_CONTINUE;
		}

		if (DebugFlag)
		{
			messageex(OldName,"[PROTECT TAG] AUTHENTICATING CLAN TAG...",print_console);
			printf ("%s",Text);	
		}

		for ( searchIndex=1; searchIndex<=TotalTags; searchIndex++ )
		{


			if (TagType[searchIndex] == 0 )
			{
				if ( (strcasestr(NewName,ClanTag[searchIndex]) != -1) )
				{
					if (DebugFlag)
					{
						messageex(OldName,"^n[PROTECT TAG] TAG MATCH",print_console);
						snprintf(Text, MAX_TEXT_LENGTH, "^nsearchIndex: %i ClanTag: %s YourName: %s",searchIndex, ClanTag[searchIndex], NewName);
						messageex(OldName, Text, print_chat);
					}
			
					if (streq(MyAuthID,PlayerAuthID[searchIndex]))
					{
						TagFound = 1;
						if (DebugFlag)
						{
							messageex(OldName,"AUTHENICATED",print_console);
							printf ("%s.^n",Text);
						}
						searchIndex=TotalTags+1;
					}
					else
					{
						TagFound = 2;
						if ( scommand[searchIndex] > TagCommand )
						{
							TagCommand = scommand[searchIndex];
						}
					}
				}
			}
		}

		if (DebugFlag)
		{
			if ( TagFound == 2 )
			{
				messageex(OldName, "FAILED TO AUTHENICATE",print_console);
				printf ("%s^n",Text);
			}
	
			if ( TagFound == 0 )
			{
				messageex(OldName, "DONE",print_console);
				printf ("%s^n",Text);
			}

			messageex(OldName,"[PROTECT TAG] AUTHENTICATING NAME...",print_console);
			printf ("%s",Text);
		}
		for ( searchIndex=1; searchIndex<=TotalTags; searchIndex++ )
		{
			if (TagType[searchIndex] == 1 )
			{
				if ( (strcasestr(NewName,ClanTag[searchIndex]) != -1) )
				{
					if (DebugFlag)
					{
						messageex(OldName,"^n[PROTECT TAG] NAME MATCH",print_console);
						snprintf(Text, MAX_TEXT_LENGTH, "^nsearchIndex: %i ClanTag: %s YourName: %s",searchIndex, ClanTag[searchIndex], NewName);
						messageex(OldName, Text, print_console);
					}
			
					if (streq(MyAuthID,PlayerAuthID[searchIndex]))
					{
						NameFound = 1;
						if (DebugFlag)
						{
							messageex(OldName,"AUTHENICATED",print_console);
							printf ("%s^n",Text);
						}
						searchIndex=TotalTags+1;
					}
					else
					{
						NameFound = 2;
						if ( scommand[searchIndex] > TagCommand )
						{
							TagCommand = scommand[searchIndex];
						}
					}
				}			
			}
		}

		if (DebugFlag)
		{
			if ( NameFound == 2 )
			{
				messageex(OldName, "FAILED TO AUTHENICATE",print_console);
				printf ("%s^n",Text);
			}
	
			if ( NameFound == 0 )
			{
				messageex(OldName, "DONE",print_console);
				printf ("%s^n",Text);
			}
		}

		if ( (TagFound == 2) || (NameFound == 2) )
		{
			if ( TagCommand != 1 && TagCommand != 2 )
			{
				execclient(OldName, "name IMPOSTER");
			}
			if ( TagCommand == 1 )
			{
				kick(OldName);
			}
			if ( TagCommand == 2 )
			{
				ban(OldName,0);
			}
			return PLUGIN_HANDLED;
		}
	}
	return PLUGIN_CONTINUE;
}
		

public plugin_init()
{
	plugin_registerinfo("redeyez Protect Clan Tags Plugin", "Protect Clan Tags.", STRING_VERSION);
	plugin_registercmd("admin_loadtags", "load_tag_file", ACCESS_PROTECTTAG);
	plugin_registercmd("admin_tagdebug", "tag_debug",ACCESS_PROTECTTAG);	
	load_tag_file();
	return PLUGIN_CONTINUE;
}



	
