/* This plugin is for having private conversations. 
 * Cobbled together between Scoutn, Bud-froggy, and yensid */

/* $Id: plugin_private.sma,v 1.2 2001/13/07 yensid $ */

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_PRIVATE 2048
#define ACCESS_PRIVATEROOM 1

#define NO_PRIVACY 0
#define MAX_ROOMS 99999

new PrivateUsers[MAX_PLAYERS] = {NO_PRIVACY,...};
new PrivateRoomFlag[MAX_PLAYERS] = {NO_PRIVACY,...};

new STRING_VERSION[MAX_DATA_LENGTH] = "2.50.0";

public admin_private(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new iIndex;
	new TargetName[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new User[MAX_NAME_LENGTH];
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	if (PrivateUsers[UserIndex] != NO_PRIVACY) {
		selfmessage("You are already in a private conversation.");
		selfmessage("Use admin_unprivate to end that one - run it on yourself if necessary - first.");
		return PLUGIN_HANDLED;
	}
	if (check_user(Data) == 1) {
		get_username(Data,TargetName,MAX_NAME_LENGTH);
		get_userindex(TargetName, iIndex);
		if (PrivateUsers[iIndex] != NO_PRIVACY) {
			snprintf(Text, MAX_TEXT_LENGTH, "%s is already in a private conversation.", TargetName);
			selfmessage(Text);
			selfmessage("Use admin_unprivate to end that one first.");
			return PLUGIN_HANDLED;
		}
		log_command(User,Command,TargetName);
		PrivateUsers[iIndex] = UserIndex;
		PrivateUsers[UserIndex] = iIndex;
		snprintf(Text, MAX_TEXT_LENGTH, "You are entering a private conversation with %s.", User);
		messageex(TargetName, Text, print_chat);
		messageex(TargetName, "Use your say_team key - usually 'U' - to chat.", print_chat);
		snprintf(Text, MAX_TEXT_LENGTH, "You are entering a private conversation with %s.", TargetName);
		messageex(User, Text, print_chat);
	} else {
		selfmessage("Unrecognized player: ");
		selfmessage(Data);
	}
	return PLUGIN_HANDLED;
}

public admin_privateroom(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new iIndex;
	new TargetName[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Target[MAX_NAME_LENGTH];
	new Room[MAX_NAME_LENGTH];
	new iRoom;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	
	strbreak(Data, Room, Target, MAX_NAME_LENGTH);
	iRoom = strtonum(Room);
	if (iRoom <= 0 || iRoom >= MAX_ROOMS) {
		selfmessage( "Invalid room number.");
		return PLUGIN_HANDLED;
	}
	if (strlen(Target) == 0) {
		strcpy(Target, User, MAX_NAME_LENGTH);
	}
	if (check_user(Target) == 1) {
		new i;
		new maxplayers = maxplayercount();
		new UserID;
		new WONID;
		new Msg[MAX_TEXT_LENGTH];
		new Name[MAX_NAME_LENGTH];
		get_username(Target,TargetName,MAX_NAME_LENGTH);
		if (streq(User, TargetName)!=1) {
			if (check_auth(ACCESS_PRIVATE)!=1) {
				selfmessage("You are not authorized to run this command on other players.");
				return PLUGIN_HANDLED;
			}
		}		
		log_command(User,Command,TargetName);
		get_userindex(TargetName, iIndex);
		PrivateRoomFlag[iIndex] = iRoom;
		snprintf(Text, MAX_TEXT_LENGTH, "You are entering private chat room #%s.", Room);
		messageex(TargetName, Text, print_chat);
		messageex(TargetName, "Use your say_team key - usually 'U' - to chat.", print_chat);
		for(i=1; i<=maxplayers; i++) {
			if(playerinfo(i,Name,MAX_NAME_LENGTH,UserID,WONID)!=0) {
				if(PrivateRoomFlag[i] == PrivateRoomFlag[iIndex]) {
					snprintf(Msg, MAX_TEXT_LENGTH, "(Room %i): %s has entered the chat room.", PrivateRoomFlag[iIndex], TargetName);
					messageex(Name, Msg, print_chat);
				}
			}
		}
	} else {
		selfmessage("Unrecognized player: ");
		selfmessage(Target);
	}
	return PLUGIN_HANDLED;
}

public admin_unprivate(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new iIndex;
	new TargetName[MAX_NAME_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	if ( check_user(Data) == 1) {
		get_username(Data,TargetName,MAX_NAME_LENGTH);
		get_userindex(TargetName, iIndex);
		if (PrivateUsers[iIndex] != NO_PRIVACY) {
			log_command(User,Command,TargetName);
			PrivateUsers[iIndex] = NO_PRIVACY;
			PrivateUsers[UserIndex] = NO_PRIVACY;
			snprintf(Text, MAX_TEXT_LENGTH, "You have left a private conversation with %s.", User);
			messageex(TargetName, Text, print_chat);
			snprintf(Text, MAX_TEXT_LENGTH, "You have left a private conversation with %s.", TargetName);
			messageex(User, Text, print_chat);
		} else {
			snprintf(Text, MAX_TEXT_LENGTH, "%s is not in a private conversation.", TargetName);
			selfmessage(Text);
		}
	} else {
		selfmessage("Unrecognized player: ");
		selfmessage(Data);
	}
	return PLUGIN_HANDLED;
}

public admin_unprivateroom(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new iIndex;
	new TargetName[MAX_NAME_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Msg[MAX_TEXT_LENGTH];
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	if (strlen (Data) == 0) {
		strcpy (Data, User, MAX_NAME_LENGTH);
	}	
	if ( check_user(Data) == 1) {
		get_username(Data,TargetName,MAX_NAME_LENGTH);
		if (streq(User, TargetName)!=1) {
			if (check_auth(ACCESS_PRIVATE)!=1) {
				selfmessage("You are not authorized to run this command on other players.");
				return PLUGIN_HANDLED;
			}
		}		
		get_userindex(TargetName, iIndex);
		if (PrivateRoomFlag[iIndex] != NO_PRIVACY) {
			new i;
			new maxplayers = maxplayercount();
			new UserID;
			new WONID;
			new Name[MAX_NAME_LENGTH];
			log_command(User,Command,TargetName);
			for(i=1; i<=maxplayers; i++) {
				if(playerinfo(i,Name,MAX_NAME_LENGTH,UserID,WONID)!=0) {
					if(PrivateRoomFlag[i] == PrivateRoomFlag[iIndex]) {
						snprintf(Msg, MAX_TEXT_LENGTH, "(Room %i): %s is leaving the chat room.", PrivateRoomFlag[iIndex], TargetName);
						messageex(Name, Msg, print_chat);
					}
				}
			}
			PrivateRoomFlag[iIndex] = NO_PRIVACY;
		} else {
			snprintf(Msg, MAX_TEXT_LENGTH, "%s is not in a private chat room.", TargetName);
			selfmessage(Msg);
		}
	} else {
		selfmessage("Unrecognized player: ");
		selfmessage(Data);
	}
	return PLUGIN_HANDLED;
}

public HandleSay(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new UserName[MAX_NAME_LENGTH];
	new TargetName[MAX_NAME_LENGTH];
	new User[MAX_NAME_LENGTH];
	new UserID;
	new TargetID;
	new WONID;
	new TargetWONID;
	new Dead;
	new TargetDead;
	new Msg[MAX_TEXT_LENGTH];
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	if (PrivateUsers[UserIndex] != NO_PRIVACY) {
		if (playerinfo(PrivateUsers[UserIndex],TargetName,MAX_NAME_LENGTH,TargetID,TargetWONID) != 0) {
			snprintf(Msg, MAX_TEXT_LENGTH, "%s (private): %s", User, Data);
			messageex(TargetName, Msg, print_chat);
			messageex(User, Msg, print_chat);
			return PLUGIN_HANDLED;
		}
	}
	if (PrivateRoomFlag[UserIndex] != NO_PRIVACY) {
		if(playerinfo(UserIndex,UserName,MAX_NAME_LENGTH,UserID,WONID, Dead)!=0) {
			new i;
			new maxplayers = maxplayercount();
			for(i=1; i<=maxplayers; i++) {
				if(playerinfo(i,TargetName,MAX_NAME_LENGTH,TargetID,TargetWONID, TargetDead)!=0) {
					if(PrivateRoomFlag[i] == PrivateRoomFlag[UserIndex]) {
						if ((Dead==1)&&(TargetDead!=1)) {
							if ((check_auth(ACCESS_PRIVATE)==1)||(access(ACCESS_PRIVATE, TargetName)==1)) {
								snprintf(Msg, MAX_TEXT_LENGTH, "%s (Room %i): %s", User, PrivateRoomFlag[UserIndex], Data);
								messageex(TargetName, Msg, print_chat);
							}
						} else {
							snprintf(Msg, MAX_TEXT_LENGTH, "%s (Room %i): %s", User, PrivateRoomFlag[UserIndex], Data);
							messageex(TargetName, Msg, print_chat);
						}
					}
				}
			}
		}
		return PLUGIN_HANDLED;
	}
	return PLUGIN_CONTINUE;
}

public plugin_connect(HLUserName, HLIP, UserIndex) {
	if (UserIndex >= 1 && UserIndex <= MAX_PLAYERS) {
		PrivateUsers[UserIndex] = NO_PRIVACY;
		PrivateRoomFlag[UserIndex] = NO_PRIVACY;
	}
	return PLUGIN_CONTINUE;
}

public plugin_disconnect(HLUserName, UserIndex) {
	if (UserIndex >= 1 && UserIndex <= MAX_PLAYERS)	{
		PrivateUsers[UserIndex] = NO_PRIVACY;
		PrivateRoomFlag[UserIndex] = NO_PRIVACY;
	}
	return PLUGIN_CONTINUE;
}

public plugin_init() {
	plugin_registerinfo("Admin Private Conversation Plugin","Command for entering a private conversation",STRING_VERSION);
	plugin_registercmd("admin_private","admin_private",ACCESS_PRIVATE,"admin_private <target>: Enter private conversation with target.");
	plugin_registercmd("admin_unprivate","admin_unprivate",ACCESS_PRIVATE,"admin_unprivate <target>: Leave private conversation with target.");
	plugin_registercmd("admin_privateroom","admin_privateroom",ACCESS_PRIVATEROOM,"admin_privateroom <room#> [<target>]: Enter private chat room <room#>.  Include <target> to put another player in <room#>.");
	plugin_registercmd("admin_unprivateroom","admin_unprivateroom",ACCESS_PRIVATEROOM,"admin_unprivateroom [<target>]: Leave any private chat room.  Include <target> to remove another player.");
	plugin_registercmd("say_team","HandleSay",ACCESS_ALL);
		
	return PLUGIN_CONTINUE;	
}
