/*
  This plugin was originally written by Bryan Clay.

  It has been rewritten by [TCSUK]Meddler (Paulo Rodrigues) to allow
  multiple coordinates per map and a few other bits and pieces. Best 
  of all you dont need to recompile to add new map coordinates. Use it 
  as a more sophisticated version of admin_bury

  admin_vote_prison <target> is essentially the same as the original
                             and initiates a vote to put a player in prison
  admin_prison <target> puts a player in prison
  admin_prison_all Puts all the players in prison
  admin_prison_write <description> Saves the current coordinates to a file
                                   along with a descripion

  All of the commands use a file called <mapname>.xyz where <mapname> is
  the current map. This is the file written to using admin_prison_write
  When a player is put in prison, the prison location is selected by cycling 
  through all the locations in xyz file

  file_access_read 1  is required to allow you to use the prison functions
  file_access_write 1 is required to allow you to write your configuration files.

  When you want to create a configuration file for your map just go into 
  spectator mode and when you have a good spot open the console and type 
  admin_prison_write some descriptive text  

  Visit the TCSUK Clan at http://tcsuk.alivewww.co.uk
*/

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_VOTE_PRISON 128
#define VOTE_PRISON_RATIO 51

new STRING_VERSION[MAX_DATA_LENGTH] = "3.0";
new prisoncycle = 1;

// Write out your current coordinates to prison.dat

public admin_prison_write(HLCommand,HLData,HLUser,UserIndex) {
    new Command[MAX_COMMAND_LENGTH];
    new Data[MAX_DATA_LENGTH];
    new User[MAX_NAME_LENGTH];
    new Text[MAX_TEXT_LENGTH];
    new filename[MAX_TEXT_LENGTH];

    convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    convert_string(HLData,Data,MAX_DATA_LENGTH);
    convert_string(HLUser,User,MAX_NAME_LENGTH);

    new x = 0;
    new y = 0;
    new z = 0;
    new map[MAX_DATA_LENGTH];

    currentmap(map,MAX_DATA_LENGTH);
    get_userorigin(User,x,y,z);
    snprintf(Text,MAX_TEXT_LENGTH,"%s:%d:%d:%d:%s",map,x,y,z,Data);
    selfmessage(Text);
    snprintf(filename,MAX_TEXT_LENGTH,"%s.xyz",map);
    writefile(filename,Text);    

    return PLUGIN_HANDLED;
}

public admin_vote_prison(HLCommand,HLData,HLUser,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new strAuthID[MAX_AUTHID_LENGTH];
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUser,User,MAX_NAME_LENGTH);
	if (check_user(Data) == 1) {
		new real_user[MAX_NAME_LENGTH];
		get_username(Data,real_user,MAX_NAME_LENGTH);
		if(check_immunity(real_user)!=0) {
			snprintf(Text, MAX_TEXT_LENGTH, "Laf. You cant put %s in prison.", real_user);
			//message(Text);
			snprintf(Text,MAX_TEXT_LENGTH,"%s tried to put %s in prison",User,real_user);
			plugin_exec("admin_clanchat",Text);
		} else {
			snprintf(Text, MAX_TEXT_LENGTH, "Put %s in prison?", real_user);
			if(getvar("sv_lan")==1) {
				vote(Text,"Lock him up!","Hes innocent","HandlePrisonVote",real_user);
			} else {
				get_userAuthID(real_user,strAuthID);
				vote(Text,"Lock him up!","Hes innocent","HandlePrisonVote",strAuthID);
			}
		}
	} else {
		selfmessage("Unrecognized user name ");
		selfmessage(Data);
	}
	return PLUGIN_HANDLED;
}

public HandlePrisonVote(WinningOption,HLUser,VoteCount,UserCount) {
	new strNumber[MAX_NUMBER_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new Ratio = VOTE_PRISON_RATIO;
	new VoteTarget[MAX_NAME_LENGTH];
	new host[MAX_NAME_LENGTH];
	getstrvar("hostname",host,MAX_TEXT_LENGTH);
	convert_string(HLUser,VoteTarget,MAX_NAME_LENGTH);
	if (WinningOption == 1) {
		if (VoteCount >= Ratio*UserCount/100) {
                   lock_up(VoteTarget);
		} else {
			numtostr(Ratio*UserCount/100,strNumber);
			snprintf(Text, MAX_TEXT_LENGTH, "Prison vote succeded but not enough for conviction (needed %s)",strNumber);
			say(Text);
		}
	} else {
		say("Prison vote failed.");
	}
}

public admin_prison(HLCommand,HLData,HLUser,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
 
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUser,User,MAX_NAME_LENGTH);
	if (check_user(Data) == 1) {
		new real_user[MAX_NAME_LENGTH];
		get_username(Data,real_user,MAX_NAME_LENGTH);
		if(check_immunity(real_user)!=0) {
			snprintf(Text, MAX_TEXT_LENGTH, "Laf. You cant put %s in prison.", real_user);
			//message(Text);
			snprintf(Text,MAX_TEXT_LENGTH,"%s tried to put %s in prison",User,real_user);
			plugin_exec("admin_clanchat", Text);
		} else {
                        lock_up(real_user);
		}
	} else {
		selfmessage("Unrecognized user name ");
		selfmessage(Data);
	}
	return PLUGIN_HANDLED;


}

public admin_prison_all(HLCommand,HLData,HLUser,UserIndex) {
    new username[200];
    new i=0;        
    new m = 0;

    m = maxplayercount();
    for(i=1; i<=m; i=i+1) {                
        username[0] = NULL_CHAR;
        playerinfo(i, username, 200);
        if(check_user(username)==1) { 
             lock_up(username);
        }
    }

}

public lock_up(VoteTarget[]){
	new Current[MAX_DATA_LENGTH];
	new Text[MAX_TEXT_LENGTH];
        new x;
        new y;
        new z;
        new filename[MAX_TEXT_LENGTH];


	currentmap(Current,MAX_DATA_LENGTH);
        snprintf(filename,MAX_TEXT_LENGTH,"%s.xyz",Current);

        if ( fileexists(filename) ) {
            new line[MAX_DATA_LENGTH];
            strcpy(line,"",MAX_DATA_LENGTH);
            new linecount = 0;
            new vlinecount = 0;
            new tmp[MAX_DATA_LENGTH];

            while ( readfile(filename,line,linecount,MAX_DATA_LENGTH) ) {
               linecount = linecount + 1;
               if ( strlen(line) > 0 ) {
                  vlinecount = vlinecount + 1;
               
                  if ( prisoncycle == vlinecount ) {
                     selfmessage(line);
                     new storedmap[MAX_DATA_LENGTH];
                 
                     strtok(line,":",storedmap,MAX_DATA_LENGTH);
                     strtok("",":",tmp,MAX_DATA_LENGTH);
                     x = strtonum(tmp);
                     strtok("",":",tmp,MAX_DATA_LENGTH);
                     y = strtonum(tmp);
                     strtok("",":",tmp,MAX_DATA_LENGTH);
                     z = strtonum(tmp);
                     strtokrest(tmp,MAX_DATA_LENGTH);                    
                  }
               }
            }
            prisoncycle = prisoncycle +1 ;
            if ( prisoncycle > vlinecount ) prisoncycle = 1;
            if ( strlen(tmp) <1 ) {
               snprintf(Text, MAX_TEXT_LENGTH, "%s is now inprisoned, watch him at %d %d,%d", VoteTarget,x,y,z);
            } else {
               snprintf(Text, MAX_TEXT_LENGTH, "%s is now inprisoned, watch him %s", VoteTarget,tmp);
            }
            say(Text);
            messageex(VoteTarget,"Welcome to your cell",print_center);
            teleport(VoteTarget,x,y,z);
            execclient(VoteTarget,"snapshot");
        } else {
            selfmessage("There are no prison details for this map");
        }
}

public plugin_init() {
	plugin_registerinfo("Prison Vote Plugin","Commands to to send a player to prison.",STRING_VERSION);  
	plugin_registercmd("admin_vote_prison","admin_vote_prison",ACCESS_VOTE_PRISON,"admin_vote_prison <name|uniqueid> : Opens a vote to imprison a player");
	plugin_registercmd("admin_prison","admin_prison",ACCESS_VOTE_PRISON,"admin_vote_prison <name|uniqueid> : Imprison a player");
	plugin_registercmd("admin_prison_write","admin_prison_write",ACCESS_VOTE_PRISON,"admin_prison_write : write the prison coordinates to the prison.dat file");
	plugin_registercmd("admin_prison_all","admin_prison_all",ACCESS_VOTE_PRISON,"admin_prison_all : put everyone in prison");
	return PLUGIN_CONTINUE;
}
