/* 
 * Allows in-game toggling of sv_alltalk svar
 * Simulates LAN experiences, by allowing everyone, DEAD, ALIVE, CT and T
 * to communicate over the Voice-Chat System.
 *
 * I copied coding from plugin_ultimate_democracy.sma and plugin_milkman_camper,
 * so thanks to those who made them, respectively
 *
 */

/* $Id: plugin_am_alltalk.c, v1.0, 6/01/02 by Paegus $ */

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>
#define ACCESS_RESTRICT 8192

new STRING_VERSION[MAX_DATA_LENGTH] = "2.50.0";

/* Enable Public AllTalk Voting? Overriden by vault data...*/
new ENABLE_AT_VOTE=1;

/* Required Player Ratio */
#define AT_VOTE_RATIO 51

/* Enable AllTalk AutoVote? */
#define AUTO_AT_VOTE 0

/* Seconds into MAP to start AllTalk Vote, if AutoVote is enabled */
#define AUTO_AT_TIME 300

/* Allow AllTalk Status Report */
#define ENABLE_AT_STATUS 1

/* Change this to the number secconds a NON-admin will have to wait to Re-Vote somthing. Like to */
/* vote_alltalk again you wait ?? secconds. This stops Vote-Spams. Thanks to Wraith for the idea */
new RVfreq=180;

/**************************************/
/***** END OF SWITCHES FOR ADMINS *****/
/**************************************/

new vote_ATAllowed=1;
@ATVoteTimer() {vote_ATAllowed=1;}

public AllTalkON() {
	setstrvar("sv_alltalk","1");
	plugin_exec("admin_chat","SVar sv_alltalk 1");
}
public AllTalkOff() {
	setstrvar("sv_alltalk","0");
	plugin_exec("admin_chat","SVar sv_alltalk 0"); 
}

public ATVote() {
	new strDummy[10];
	vote("Voice Comm:", "Team-Specific", "Universal", "HandleATVote",strDummy);
}

public HandleATVote(WinningOption,HLData,VoteCount,UserCount) {
	if (ENABLE_AT_VOTE==1) {
		new Text[MAX_TEXT_LENGTH];
		new strNumber[MAX_NUMBER_LENGTH];
		new Ratio = AT_VOTE_RATIO;
		new strData[MAX_DATA_LENGTH];
		new i;
		new maxplayers = maxplayercount();
		new Target[MAX_NAME_LENGTH];
		convert_string(HLData, strData,MAX_DATA_LENGTH);

		if (VoteCount >= Ratio*UserCount/100) {	
			if (WinningOption==1) {
				if (getvar("sv_alltalk") == 0) {
					snprintf(Text, MAX_TEXT_LENGTH, "Vote over...^nTeam-Specific voice chat shall remain.");
				} else {
					snprintf(Text, MAX_TEXT_LENGTH, "Vote successful...^nTeam-Specific voice chat Enabled!");
					AllTalkOff();
				}
			} else {
				if (getvar("sv_alltalk") == 0) {
					snprintf(Text, MAX_TEXT_LENGTH, "GLOBAL VOICE CHAT!^nEveryone Can Hear Everyone.^nNo Cheating NOW...");
					AllTalkON();
				} else {
					snprintf(Text, MAX_TEXT_LENGTH, "Vote over...^nGlobal voice chat will remain enabled.");
				}
			}
		} else {
			numtostr(Ratio*UserCount/100,strNumber);
			if (getvar("sv_alltalk") == 0) {
				snprintf(Text, MAX_TEXT_LENGTH, "Team-Specific voice chat shall remain...^nNot enough votes for change (needed %s)", strNumber);
			} else {
				snprintf(Text, MAX_TEXT_LENGTH, "Global voice chat shall remain...^nNot enough votes for change (needed %s)", strNumber);
			}
		}
		centersay(Text,18,63,187,239);
		for(i=1; i<=maxplayers; i++) {
			strinit(Target);
			if(playerinfo(i,Target,MAX_NAME_LENGTH)==1) {
				messageex(Target,Text,print_console);
			}
		}
	}
}

public admin_vote_alltalk(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	say_command(User,Command,Data);

	if (streq(Data, "off")==1) {
		selfmessage( "Public AllTalk voting has been disabled");
		ENABLE_AT_VOTE=0;

		new NumString[MAX_TEXT_LENGTH];
		numtostr(ENABLE_AT_VOTE,NumString);
		set_vaultdata("alltalk_voting",NumString);
		
		return PLUGIN_HANDLED;
	}
	if (streq(Data, "on")==1) {
		selfmessage( "Public AllTalk voting has been enabled");
		ENABLE_AT_VOTE=1;
		
		new NumString[MAX_TEXT_LENGTH];
		numtostr(ENABLE_AT_VOTE,NumString);
		set_vaultdata("alltalk_voting",NumString);
		
		return PLUGIN_HANDLED;
	}
	
	if (vote_allowed()!=1) {
		selfmessage( "Vote not allowed at this time.");
		return PLUGIN_HANDLED;
	}

	vote_ATAllowed=0;
	set_timer("@ATVoteTimer",RVfreq,1);
	ATVote();

	return PLUGIN_HANDLED;
}

public admin_alltalk(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new maxplayers = maxplayercount();
	new Target[MAX_NAME_LENGTH];
	new i;
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	if (getvar("sv_alltalk") == 0) {
		snprintf(Text, MAX_TEXT_LENGTH, "ADMIN has set Global Voice Chat ON");
		centersay(Text,10,0,255,0);
		for(i=1; i<=maxplayers; i++) {
			strinit(Target);
			if(playerinfo(i,Target,MAX_NAME_LENGTH)==1) {
				messageex(Target,Text,print_console);
			}
		}
		AllTalkON();
	} else {
		snprintf(Text, MAX_TEXT_LENGTH, "ADMIN has DISABLED Global Voice Chat!");
		centersay(Text,10,0,255,0);
		for(i=1; i<=maxplayers; i++) {
			strinit(Target);
			if(playerinfo(i,Target,MAX_NAME_LENGTH)==1) {
				messageex(Target,Text,print_console);
			}
		}
		AllTalkOff();
	}
	return PLUGIN_HANDLED;
}

public HandleSay(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	strstripquotes(Data);
		
	if (strcasestr(Data, "vote_alltalk")!=-1) {
		if (ENABLE_AT_VOTE==0) {
			say("Admin has disabled public use of vote_alltalk.");
		} else {
			if (vote_ATAllowed != 1){
				say("A vote has just been completed, sorry if you didn't like the results.");
			} else {
				if (vote_allowed()!=1) {
					say("Vote not allowed at this time.");
				} else {
					vote_ATAllowed=0;
					set_timer("@ATVoteTimer",RVfreq,1);
					ATVote();
				}
			}
		}
	}

#if ENABLE_AT_STATUS==1
	if ((strmatch(Data, "vox", 3))     ||
		(strmatch(Data, "voice", 5))   ||
		(strmatch(Data, "alltalk", 7))) {
		if (getvar("sv_alltalk") == 0) {
			snprintf(Text, MAX_TEXT_LENGTH, "Voice Communication is Team-Specific.^nTeam A cannot hear Team B.^nThe Living cannot hear the Dead!");
		} else {
			snprintf(Text, MAX_TEXT_LENGTH, "Voice Communication is Universal^nEveryone can hear everyone,^nreguardless of Team or Mortality.");
		}
		centersay(Text,10,10,255,10);
	}
#endif

}

@ATVote() {
	if (vote_allowed()==1) {
		ATVote();
		say("[AutoVoteAllTalk] Vote Started");
	} else {
		set_timer("@ATVote",30,1);
		say("[AutoVoteAllTalk] Vote not allowed at this time");
		say("Server will retry in 30 secconds");
	}
}

public plugin_init() {
	plugin_registerinfo("Global Voice Comm","Allows Global Voice Chat via sv_alltalk status",STRING_VERSION);
	plugin_registercmd("say","HandleSay",ACCESS_ALL);
	plugin_registercmd("admin_alltalk","admin_alltalk",ACCESS_RESTRICT,"admin_alltalk : toggles global voice chat on and off.");
	plugin_registercmd("admin_vote_alltalk","admin_vote_alltalk",ACCESS_RESTRICT,"admin_vote_alltalk : Starts a vote to enable global voice chat.");
	plugin_registerhelp("say",ACCESS_ALL,"say vote_alltalk: Will start global voice chat vote.");

#if ENABLE_AT_STATUS==1
	plugin_registerhelp("say",ACCESS_ALL,"say voice/vox/alltalk: Shows Voice Chat Status.");
#endif

	/* Get "Public alltalk voting?" from Vault or assign Default value.*/
	new StrValue[MAX_TEXT_LENGTH];
	if(!get_vaultdata("alltalk_voting", StrValue,10))
		set_vaultdata("alltalk_voting","1");
	get_vaultdata("alltalk_voting",StrValue,10);
	ENABLE_AT_VOTE=strtonum(StrValue);

#if AUTO_AT_VOTE==1
		set_timer("@ATVote",AUTO_AT_TIME,1);
#endif

	return PLUGIN_CONTINUE;
}