/*
* Bud-froggy Productions -- July 22nd, 2001
* Team Kill Detection
*
* Detects team kills and attacks
*
* Place in logd_kill
*/


#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_CONSOLE 131072
#define ACCESS_FORGIVE 256

new STRING_VERSION[MAX_DATA_LENGTH] = "v0.01";

#define CLEAN_SLATE 0
#define TK_LIMIT 3
new TkCount[MAX_PLAYERS] = {CLEAN_SLATE,...};

new LastTker = 0;
new LastTked = 0;
new BeLastTker = 0;
new BeLastTked = 0;

/******************************
	Helper Functions
*******************************/
Announce() {
	say("[LOGD-TK] Team Killing is an offense on this server.");
	say("[LOGD-TK] Team Killers can however be forgiven if the killed says !forgivetk.");
}


tkPunish(iID) {
	new Message[ MAX_TEXT_LENGTH ];
	new Name[ MAX_NAME_LENGTH ];


	if( !playerinfo( iID, Name, MAX_NAME_LENGTH ) )
		return 0;

	TkCount[ iID ] = TkCount[ iID ] + 1;

	if(TkCount[iID] < 0)	{
		log("[LOGD] Error: tkpunish -> TkCount was inferior to 0.");
		return 0;
	}

	if( TkCount[iID] < TK_LIMIT ) {
		for(new i=1;i<=19;i++) {
			slap(Name);
		}
		snprintf( Message, MAX_TEXT_LENGTH, "%s^nTK Warning %i of %i", Name, TkCount[iID], TK_LIMIT );
		typesay( Message, 10, 255, 255, 255 );
	}
	else if( TkCount[iID] == TK_LIMIT ) {
		slay(Name);
		snprintf( Message, MAX_TEXT_LENGTH, "%s^nViolated %i TK Warning", Name, TK_LIMIT );
		typesay( Message, 10, 255, 255, 255 );
	}
	else {
		ban(Name,30); 	//30 minute ban
		snprintf( Message, MAX_TEXT_LENGTH, "%s^nExceded %i TK Warning", Name, TK_LIMIT );
		typesay( Message, 10, 255, 255, 255 );
	}

	Announce();  //public statement about forgiving
	return 1;
}


/*****************************
	Admin Functions
******************************/



public logd_teamkill(HLCommand,HLData,HLUserName,UserIndex)
{
	new iIDA;
	new iIDV;
	new iUserID;
	new iWONID;
	new iTeamA;
	new iTeamV;

	new sIDA[3];
	new sIDV[3];
	new Data[MAX_NAME_LENGTH];


	convert_string(HLData,Data,MAX_DATA_LENGTH);
	strsplit(Data, " ", sIDA, 3, sIDV, 3 );

	iIDA = strtonum( sIDA );
	iIDV = strtonum( sIDV );

	if(playerinfo(iIDA, Data, MAX_NAME_LENGTH, iUserID, iWONID, iTeamA))	{
		if(playerinfo(iIDV, Data, MAX_NAME_LENGTH, iUserID, iWONID, iTeamV))	{
			if(iTeamV != iTeamA)
				return PLUGIN_HANDLED;
			else {
				tkPunish(iIDA);
				BeLastTker = LastTker;
				BeLastTked = LastTked;
				LastTker = iIDA;
				LastTked = iIDV;
			}
		}
	}

	return PLUGIN_HANDLED;
}


forgiveMostRecent() {
	new NameV[MAX_NAME_LENGTH];
	new NameP[MAX_NAME_LENGTH];
	new Message[MAX_DATA_LENGTH];

	//these checks are to make sure we don't touch any numbers
	//if the player doesn't exist (aka this tk was already forgiven)
	if( LastTked == 0 || LastTker == 0 ) {
		return 0;
	}

	if( !playerinfo(LastTker,NameP,MAX_NAME_LENGTH) ) {
		return 0;
	}
	if( !playerinfo(LastTked,NameV,MAX_NAME_LENGTH) ) {
		return 0;
	}

	TkCount[ LastTker ] = TkCount[ LastTker ] - 1;

	snprintf(Message,MAX_DATA_LENGTH,"[LOGD-TK] %s has forgiven %s.", NameV, NameP);
	say(Message);

	LastTked = BeLastTked;
	LastTker = BeLastTker;
	BeLastTked = 0;
	BeLastTker = 0;

	return 1;
}
forgiveLeastRecent() {
	new NameV[MAX_NAME_LENGTH];
	new NameP[MAX_NAME_LENGTH];
	new Message[MAX_DATA_LENGTH];

	//these checks are to make sure we don't touch any numbers
	//if the player doesn't exist (aka this tk was already forgiven)
	if( BeLastTked == 0 || BeLastTker == 0 ) {
		//snprintf(Message,MAX_DATA_LENGTH, "[Logd-tk]LeastRecent doesn't exist <%i> <%i>", BeLastTker, BeLastTked );
		//log(Message);
		return 0;
	}
	if( !playerinfo(BeLastTker,NameP,MAX_NAME_LENGTH) ) {
		return 0;
	}
	if( !playerinfo(BeLastTked,NameV,MAX_NAME_LENGTH) ) {
		return 0;
	}

	TkCount[ BeLastTker ] = TkCount[ BeLastTker ] - 1;

	snprintf(Message,MAX_DATA_LENGTH,"[LOGD-TK] %s has forgiven %s.", NameV, NameP);
	say(Message);

	BeLastTked = 0;
	BeLastTker = 0;

	return 1;
}

public admin_forgivetk(HLCommand,HLData,HLUserName,UserIndex) {
	new Data[MAX_DATA_LENGTH];
	convert_string(HLData, Data, MAX_DATA_LENGTH);

	if( strcmp( Data, "new" ) == 0 ) {
		forgiveMostRecent();
	} else if( strcmp( Data, "old" ) == 0 ) {
		forgiveLeastRecent();
	}
	return PLUGIN_HANDLED;
}

public HandleSay(HLCommand,HLData,HLUserName,UserIndex)
{
	new Data[MAX_DATA_LENGTH];

	convert_string(HLData, Data, MAX_DATA_LENGTH);
	strstripquotes(Data);

	if( Data[0] != '!' ) //quick check to save time since its not a full string compare
		return PLUGIN_CONTINUE;
	else if(strcmp(Data,"!forgivetk") == 0) {
		if(UserIndex == LastTked) {
			forgiveMostRecent();
		}
		else if(UserIndex == BeLastTked) {
			forgiveLeastRecent();
		}
	}
	return PLUGIN_CONTINUE;
}


public plugin_connect(HLUserName, HLIP, UserIndex)
{
	if (UserIndex >= 1 && UserIndex <= MAX_PLAYERS) {
		TkCount[UserIndex] = CLEAN_SLATE;
	}
	return PLUGIN_CONTINUE;
}

public plugin_disconnect(HLUserName, UserIndex)
{
	if (UserIndex >= 1 && UserIndex <= MAX_PLAYERS) {
		TkCount[UserIndex] = CLEAN_SLATE;
	}
	return PLUGIN_CONTINUE;
}


public plugin_init()
{
	plugin_registerinfo("Team Killing Detection",".",STRING_VERSION);
	plugin_registercmd("logd_teamkill", "logd_teamkill", ACCESS_CONSOLE, "");
	plugin_registercmd("admin_forgivetk", "admin_forgivetk", ACCESS_FORGIVE, "admin_forgivetk <new|old> : forgives most recent or least recent TK (only usable by admins)");
	plugin_registercmd("say","HandleSay",ACCESS_ALL);
	plugin_registerhelp("say",ACCESS_ALL,"say !forgivetk: Forgives your Team Killer.");

	exec( "logd_reg 57 admin_command logd_teamkill" );
	return PLUGIN_CONTINUE;
}