/*colored text messages!
b2: 
Changelog: 
- bombspawned: UserIndex instead of UserName is used!
- bombtimer: g_curbombtimer=999 is checked in bomb(...) function.
*/

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

new STRING_VERSION[MAX_DATA_LENGTH] = "AM_2.50.59_11.02.04_v.7.0_b2_c";

#define ACCESS_CONSOLE 131072
#define CLEAN_SLATE 0
#pragma dynamic 8192

//////////////////////////////////////////////////////////////////
//  	STATUS OF FEATURES (Don't change anything below)	//
//////////////////////////////////////////////////////////////////
/*features enabled*/

enum operation { 
    enable, 
    disable, 
    toggle 
}; 

/*single feature enable/disable = ID*/
#define MAX_FEATURES	26
#define HEADSHOT	(1<<0)
#define KILLS_IN_TIME	(1<<1)
#define KILLSTREAK	(1<<2)
#define FIRSTBLOOD	(1<<3)
#define LEAD		(1<<4)
#define TEAMATTACK	(1<<5)
#define KNIFEKILL	(1<<6)
#define GRENADEKILL	(1<<7)
#define ROUNDCOUNTER	(1<<8)
#define BOMBSPAWNED	(1<<9)
#define BOMBGET		(1<<10)
#define BOMBDROP	(1<<11)
#define BOMBPLANT	(1<<12)
#define STARTDEFUSE	(1<<13)
#define BOMBDEFUSED	(1<<14)
#define BOMBDETONATE	(1<<15)
#define BOMBTIMER	(1<<16)
#define TOUCHHOSTAGE	(1<<17)
#define RESCUEHOSTAGE	(1<<18)
#define KILLEDHOSTAGE	(1<<19)
#define SUICIDE		(1<<20)
#define LASTSCOUT	(1<<21)
#define BECAMEVIP	(1<<22)
#define KILLEDVIP	(1<<23)
#define ESCAPEVIP	(1<<24)
#define SCOREBOARD	(1<<25)

new g_Commands[MAX_FEATURES][]={
	"headshot",		//Line: 1076 -> Injure (948)
	"killsintime",		//Line: 1103 -> Kill (909)
	"killstreak",		//Line: 1133 -> Kill (909)
	"firstblood",		//Line: 1154 -> Kill (909)
	"takenlead",		//Line: 1165 -> Kill (909), World (1050)
	"teamattack",		//Line: 1235 -> Injure (948)
	"knifekill",		//Line: 1254 -> Kill (909)
	"grenadekill",		//Line: 1254 -> Kill (909)
	"roundcounter",		//Line: 1273 -> World (1050)
	"bombspawned",		//Line: 1297 -> Playeraction (987)
	"bombget",		//Line: 1297 -> Playeraction (987)
	"bombdrop",		//Line: 1297 -> Playeraction (987)
	"bombplant",		//Line: 1297 -> Playeraction (987)
	"startdefuse",		//Line: 1297 -> Playeraction (987)
	"bombdefused",		//Line: 1297 -> Playeraction (987)
	"bombdetonate",		//Line: 1297 -> Playeraction (987)
	"bombtimer",		//Line: 1297 -> Playeraction (987)
	"touchhostage",		//Line: 1433 -> Playeraction (987)
	"reschostage",		//Line: 1433 -> Playeraction (987)
	"killedhostage",	//Line: 1433 -> Playeraction (987)
	"suicide",		//Line: 1464 -> Suicide (897)
	"lastscout",		//Line: 1480 -> Kill (909)
	"becamevip",		//Line: 1531 -> Playeraction (987)
	"killedvip",		//Line: 1531 -> Playeraction (987)
	"escapevip",		//Line: 1531 -> Playeraction (987)		
	"scoreboard"		//Line: 1559 -> Teamaction (1030)
};
new g_SubCommands[MAX_FEATURES][]={
	"sound_1,sound_2,sound_3,msg_1,msg_2,msg_3", 
	"sound_1,sound_2,sound_3,msg_1,msg_2,msg_3,timer,frag_1,frag_2,frag_3", 
	"sound_1,sound_2,sound_3,msg_1,msg_2,msg_3,frag_1,frag_2,frag_3",
	"sound,msg", 
	"sound_taken,msg_taken,sound_lost,msg_lost,sound_tied,msg_tied", 
	"sound,msg,timer", 
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg",
	"sound,msg,menu"
};

new g_SubVault[MAX_FEATURES][]={
	"IMP_SOUND_0,IMP_SOUND_1,IMP_SOUND_2,IMP_MSG_0,IMP_MSG_1,IMP_MSG_2", 
	"IMP_SOUND_3,IMP_SOUND_4,IMP_SOUND_5,IMP_MSG_3,IMP_MSG_4,IMP_MSG_5,IMP_KILLS_TIMER,IMP_KILLS_IN_TIME_1,IMP_KILLS_IN_TIME_2,IMP_KILLS_IN_TIME_3",
	"IMP_SOUND_6,IMP_SOUND_7,IMP_SOUND_8,IMP_MSG_6,IMP_MSG_7,IMP_MSG_8,IMP_KILLSTREAK_1,IMP_KILLSTREAK_2,IMP_KILLSTREAK_3",
	"IMP_SOUND_9,IMP_MSG_9", 
	"IMP_SOUND_10,IMP_MSG_10,IMP_SOUND_11,IMP_MSG_11,IMP_SOUND_12,IMP_MSG_12", 
	"IMP_SOUND_13,IMP_MSG_13,IMP_TA_TIMER", 
	"IMP_SOUND_14,IMP_MSG_14",
	"IMP_SOUND_15,IMP_MSG_15",
	"IMP_SOUND_16,IMP_MSG_16",
	"IMP_SOUND_17,IMP_MSG_17",
	"IMP_SOUND_18,IMP_MSG_18",
	"IMP_SOUND_19,IMP_MSG_19",
	"IMP_SOUND_20,IMP_MSG_20",
	"IMP_SOUND_21,IMP_MSG_21",
	"IMP_SOUND_22,IMP_MSG_22",
	"IMP_SOUND_23,IMP_MSG_23",
	"IMP_SOUND_24,IMP_MSG_24",
	"IMP_SOUND_25,IMP_MSG_25",
	"IMP_SOUND_26,IMP_MSG_26",
	"IMP_SOUND_27,IMP_MSG_27",
	"IMP_SOUND_28,IMP_MSG_28",
	"IMP_SOUND_29,IMP_MSG_29",
	"IMP_SOUND_30,IMP_MSG_30",
	"IMP_SOUND_31,IMP_MSG_31",
	"IMP_SOUND_32,IMP_MSG_32",
	"IMP_SOUND_33,IMP_MSG_33,IMP_SCOREBOARD_MENU"
};

/*sound of feature enabled*/
new g_Sounds;
/*text message of feature enabled*/
new g_Messages;

////////////////////////////////
// SOUND AND MESSAGE SETTINGS //
////////////////////////////////
// = SID //
#define ALL_SOUNDS 		34
#define S_HEADSHOT1		0
#define S_HEADSHOT2		1
#define S_HEADSHOT3		2
#define S_DOUBLEKILL		3
#define S_MULTIKILL		4
#define S_MONSTERKILL		5
#define	S_KILLINGSPREE		6
#define S_DOMINATING		7
#define S_GODLIKE		8
#define S_FIRSTBLOOD		9
#define S_TAKENLEAD		10
#define S_LOSTLEAD		11
#define	S_TIEDLEAD		12
#define S_TEAMATTACK		13
#define S_KNIFEKILL		14
#define S_GRENADEKILL		15
#define	S_ROUNDCOUNTER		16
#define	S_BOMBSPAWNED		17
#define	S_BOMBGET		18
#define	S_BOMBDROP		19
#define	S_BOMBPLANT		20
#define S_STARTDEFUSE		21
#define S_BOMBDEFUSED		22
#define S_BOMBDETONATE		23
#define S_BOMBTIMER		24
#define S_TOUCHHOSTAGE		25
#define S_RESCUEHOSTAGE		26
#define S_KILLEDHOSTAGE		27
#define S_PLAYERSUICIDE		28
#define S_LASTSCOUT		29
#define S_BECAMEVIP		30
#define S_KILLEDVIP		31
#define S_ESCAPEVIP		32
#define S_SCOREBOARD		33

///////////////////////////////////////////////////////
// STORING SOUNDS AND MESSAGES LOADED FROM VAULT.INI //
///////////////////////////////////////////////////////
new g_Imp_Sounds[ALL_SOUNDS][MAX_TEXT_LENGTH];
new g_TextMsg[ALL_SOUNDS][MAX_TEXT_LENGTH];
/*END ADRESSES OF EACH SID FOR EACH FEATURE*/
new g_Features_SID[MAX_FEATURES][4]={
	S_HEADSHOT3,S_MONSTERKILL,S_GODLIKE,S_FIRSTBLOOD,S_TIEDLEAD,
	S_TEAMATTACK,S_KNIFEKILL,S_GRENADEKILL,S_ROUNDCOUNTER,S_BOMBSPAWNED,
	S_BOMBGET,S_BOMBDROP,S_BOMBPLANT,S_STARTDEFUSE,S_BOMBDEFUSED,
	S_BOMBDETONATE,S_BOMBTIMER,S_TOUCHHOSTAGE,S_RESCUEHOSTAGE,S_KILLEDHOSTAGE,
	S_PLAYERSUICIDE,S_LASTSCOUT,S_BECAMEVIP,S_KILLEDVIP,S_ESCAPEVIP,
	S_SCOREBOARD
};
	

/////////////////////////
// KEY FOR ALLOWSOUNDS //
/////////////////////////

new Key[]="am_sound";

/*clean kill-arrays*/
#define CLEAN_SLATE	0

/*message id = MSGID*/
#define DIS_ALL_A	1
#define DIS_TARGET_A	2
#define DIS_ALL		3
#define DIS_TARGET	4
/*message type*/
#define TSAY		1
#define CSAY		2
#define P_TSAY		3
#define P_CSAY		4
#define P_MSAY		5

/*teams*/
#define ALL 	-1
#define TARGET	0
#define T	1
#define CT	2
#define SPEC	3

////////////////////////////////////////
// ROUND COUNTER (Big THX an SR71GOKU)//
////////////////////////////////////////
static OnesLib[10][] = { 
	"", "one ", "two ", "three ", "four ", "five ", "six ", "seven ", "eight ", "nine " 
};
static TensLib[10][] = {
	"", "ten ", "twenty ", "thirty ", "fourty ", "fifty ", "sixty ", "seventy ", "eighty ", "ninety " 
};
static TeensLib[10][] = {
	"", "eleven ", "twelve ", "thirteen ", "fourteen ", "fifteen ", "sixteen ", "seventeen "
	, "eighteen ", "nineteen " 
};
static HundredsLib[10][] = { 
	"", "one hundred ", "two hundred ", "three hundred ", "four hundred ", "five hundred ", 
	"six hundred ", "seven hundred ", "eight hundred ", "nine hundred " 
};
static GroupNamesLib[5][] = {
	"", "thousand ", "million ", "billion ", "trillion " 
};

//////////////////////////////////////////////////////////////////////////////////////////
// 		    		OTHER STATIC SETTINGS 			 		//
//////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////
#define PREFERRED_DISPLAY	DIS_ALL		// WHICH MSG_ID IS USED AS DEFAULT
#define PREFERRED_TYPE_ALL	TSAY		// WHICH MSG_TYPE_ALL IS USED AS DEFAULT
#define PREFERRED_TYPE_PRIVATE	P_TSAY		// WHICH MSG_TYPE_PRIVATE IS USED AS DEFAULT
/////////////////////////////////////////////

////////////////////////////////////////////////////
//HEADSHOT WEAPON DAMAGE ( > than max body damage)//
////////////////////////////////////////////////////
#define MAX_WEAPONS	24
#define MIN_HS_DAMAGE	36 //MP5 and TMP atm.
//PISTOLS
#define DEAGLE		80
#define GLOCK		40
#define USP		40
#define ELITE		40
#define FIVESEVEN	40
#define P228		40
//SHOTGUNS (IMPOSSIBLE TO FIGURE OUT THE REAL HS DAMAGE!)
#define M3		200
#define XM1014		200
//SMGS
#define MP5		36
#define P90		40
#define TMP		36
#define MAC		38
#define UMP45		45
//RIFLES
#define GALLIL		45
#define DEFENDER	45
#define AUG		50
#define SG552		50
#define AWP		155
#define M4A1		50
#define AK47		50
#define SCOUT		95
#define SG550		80
#define G3SG1		80
//MG
#define M249		50
	
new g_WeaponName[MAX_WEAPONS][MAX_NAME_LENGTH]	={	
		"usp","glock18","deagle","mp5navy","gallil","defender","m4a1",
		"ak47","awp","aug","sg552","scout","m249",
		"p90","p228","tmp","mac10","ump45","fiveseven",
		"elite","m3","xm1014","sg550","g3sg1"
};
						
new g_WeaponDamage[MAX_WEAPONS][MAX_NUMBER_LENGTH]={	
		USP,GLOCK,DEAGLE,MP5,GALLIL,DEFENDER,M4A1,
		AK47,AWP,AUG,SG552,SCOUT,M249,
		P90,P228,TMP,MAC,UMP45,FIVESEVEN,
		ELITE,M3,XM1014,SG550,G3SG1
};

///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////
// 		PLUGIN-VARIABLES 		 //
///////////////////////////////////////////////////

//////////////////////////////////
//Values loaded at plugin_init()//
//////////////////////////////////
//from vault.ini

new g_status_plugin=1;
/////////////////////////////////
//KILLS IN TIME (No. of frags) //
/////////////////////////////////
new g_kstimer;
new g_DOUBLEKILL	=2;
new g_MULTIKILL		=3;
new g_MONSTERKILL	=4;

/////////////////////////////
//KILLSTREAK (No. of frags)//
/////////////////////////////
new g_KILLINGSPREE	=3;
new g_DOMINATING	=4;
new g_GODLIKE		=5;

new g_menuenabled;
new g_tatimer;

//from server settings
new g_bombtimer;
new g_maxplayers;

//////////////////////////////////////////
// Values set during gameplay by plugin //
//////////////////////////////////////////
new g_rounds;
new g_firstblood;
new g_leader;
new g_curbombtimer;
new g_teamattack;
new g_lastCT;
new g_lastT;
new g_BombPlanter[MAX_NAME_LENGTH];
new g_KillsInTime[MAX_PLAYERS];
new g_KillsTimer[MAX_PLAYERS];
new g_Killstreak[MAX_PLAYERS];
new g_KillsRound[MAX_PLAYERS];
new g_HSinRound[MAX_PLAYERS];

///////////////////////////////////////////////////////

public plugin_init(){
	new Text[MAX_TEXT_LENGTH];
	new sValue[MAX_TEXT_LENGTH];
	new value;
	new error;
	
	getstrvar( "admin_vault_file", sValue, MAX_TEXT_LENGTH );
	if(strlen(sValue)==0){
		log("[IMPRESSIVE] FATAL ERROR: admin_vault_file not set in adminmod.cfg!");
		error++;
	}	
	if(!error){
		plugin_registerinfo("Impressive-Script","The ultimative Logd-Script: Announces headshots with sound and many more.",STRING_VERSION);
		plugin_registercmd("imp_feature", "imp_feature", ACCESS_BAN, "imp_feature <feature> <sound/msg/both> <on/off/toogle>: activate/deactivate sound or/and message of feature.");
		plugin_registercmd("imp_set", "imp_set", ACCESS_BAN, "imp_set <feature> <subcommand> <value>: set needed values for some features");
		plugin_registercmd("imp_plugin","imp_plugin",ACCESS_BAN, "imp_plugin <on/off>: de/activates the plugin.");
		/*ERROR CHECKS*/
		value = getvar("mp_logdetail");
		if(value!=3){
			snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] CRITICAL ERROR. mp_logdetail is not set to ^"3^" in server.cfg! ^"headshots^" can not be detected!");
			log(Text);
		}
		
		load_vault_settings();
		
		g_bombtimer = getvar("mp_c4timer");
		g_maxplayers = maxplayercount();
		/*REGISTER LOGD FUNCTIONS*/
		plugin_registercmd("im_connect", "logd_handler", ACCESS_CONSOLE, "");
		exec( "logd_reg 51 admin_command im_connect" );
		plugin_registercmd("im_disconnect", "logd_handler", ACCESS_CONSOLE, "");
		exec( "logd_reg 52 admin_command im_disconnect" );
		plugin_registercmd("im_suicide", "logd_handler", ACCESS_CONSOLE, "");
		exec( "logd_reg 53 admin_command im_suicide" );
		plugin_registercmd("im_kill", "logd_handler", ACCESS_CONSOLE, "");
		exec( "logd_reg 57 admin_command im_kill" );
		plugin_registercmd("im_injure", "logd_handler", ACCESS_CONSOLE, "");
		exec( "logd_reg 58 admin_command im_injure" );
		plugin_registercmd("im_playeraction", "logd_handler", ACCESS_CONSOLE, "");
		exec( "logd_reg 60 admin_command im_playeraction" ); 
		plugin_registercmd("im_teamaction", "logd_handler", ACCESS_CONSOLE, "");
		exec( "logd_reg 61 admin_command im_teamaction" );
		plugin_registercmd("im_world", "logd_handler", ACCESS_CONSOLE, "");
		exec( "logd_reg 62 admin_command im_world");
	}else{
		plugin_registerinfo("Impressive-Script","Plugin disabled! Please take a look in logfiles for more informations!",STRING_VERSION);
		snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] %i fatal errors. Plugin is disabled!",error);
		log(Text);
	}	
	return PLUGIN_CONTINUE;
}

load_vault_settings(){
	new Text[MAX_TEXT_LENGTH];
	new sValue[MAX_TEXT_LENGTH];
	new i;
	get_vaultnumdata("IMP_SOUNDS",g_Sounds);
	get_vaultnumdata("IMP_MESSAGES",g_Messages);
	
	get_vaultnumdata("IMP_PLUGIN",g_status_plugin);
	if(!g_status_plugin){
		log("[IMPRESSIVE] PLUGIN IS DISABLED! ^"IMP_PLUGIN^" is not set in vault.ini!");
	}
	get_vaultnumdata("IMP_KILLS_TIMER",g_kstimer);
	if(!g_kstimer){
		log("[IMPRESSIVE] ^"killsintime^": ^"IMP_KILLS_TIMER^" is not set in vault.ini!");
	}else{
		snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] ^"killsintime^": check-timer is set to %i sec!",g_kstimer);
		log(Text);
	}
	get_vaultnumdata("IMP_KILLS_IN_TIME_1",g_DOUBLEKILL);
	if(!g_DOUBLEKILL){
		log("[IMPRESSIVE] ^"killsintime^": ^"IMP_KILLS_IN_TIME_1^" is not set in vault.ini!");
	}else{
		snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] ^"killsintime^": %i frags are set to for first sound/msg!",g_DOUBLEKILL);
		log(Text);
	}
	get_vaultnumdata("IMP_KILLS_IN_TIME_2",g_MULTIKILL);
	if(!g_MULTIKILL){
		log("[IMPRESSIVE] ^"killsintime^": ^"IMP_KILLS_IN_TIME_2^" is not set in vault.ini!");
	}else{
		snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] ^"killsintime^": %i frags are set to for second sound/msg!",g_MULTIKILL);
		log(Text);
	}
	get_vaultnumdata("IMP_KILLS_IN_TIME_3",g_MONSTERKILL);
	if(!g_MONSTERKILL){
		log("[IMPRESSIVE] ^"killsintime^": ^"IMP_KILLS_IN_TIME_3^" is not set in vault.ini!");
	}else{
		snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] ^"killsintime^": %i frags are set to for third sound/msg!",g_MONSTERKILL);
		log(Text);
	}
	get_vaultnumdata("IMP_KILLSTREAK_1",g_KILLINGSPREE);
	if(!g_KILLINGSPREE){
		log("[IMPRESSIVE] ^"killstreak^": ^"IMP_KILLSTREAK_1^" is not set in vault.ini!");
	}else{
		snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] ^"killstreak^": %i frags are set to for first sound/msg!",g_KILLINGSPREE);
		log(Text);
	}
	get_vaultnumdata("IMP_KILLSTREAK_2",g_DOMINATING);
	if(!g_DOMINATING){
		log("[IMPRESSIVE] ^"killstreak^": ^"IMP_KILLSTREAK_2^" is not set in vault.ini!");
	}else{
		snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] ^"killstreak^": %i frags are set to for second sound/msg!",g_DOMINATING);
		log(Text);
	}
	get_vaultnumdata("IMP_KILLSTREAK_3",g_GODLIKE);
	if(!g_GODLIKE){
		log("[IMPRESSIVE] ^"killstreak^": ^"IMP_KILLSTREAK_3^" is not set in vault.ini!");
	}else{
		snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] ^"killstreak^": %i frags are set to for third sound/msg!",g_GODLIKE);
		log(Text);
	}
	get_vaultnumdata("IMP_TA_TIMER",g_tatimer);
	if(!g_tatimer){
		log("[IMPRESSIVE] ^"teamattack^": ^"IMP_TA_WAIT^" is not set in vault.ini!");
	}else{
		snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] ^"teamattack^": TA-check-timer is set to %i sec starting after round start!",g_tatimer);
		log(Text);
	}
	get_vaultnumdata("IMP_SCOREBOARD_MENU",g_menuenabled);
	if(g_menuenabled){
		getstrvar( "amv_enable_beta", sValue, MAX_TEXT_LENGTH );
		if(strstrx(sValue,"menu1")!=-1){
			log("[IMPRESSIVE] ^"scoreboard^": menu-scoreboard is enabled !");
		}else{
			g_menuenabled=0;
			log("[IMPRESSIVE] ^"scoreboard^": can't enable menu-scoreboard! ^"amv_enable_beta 'menu1'^" not set in adminmod.cfg!");
		}
	}
	/*LOAD SOUNDS AND MESSAGES*/
	for(i=0;i<ALL_SOUNDS;i++){
		strinit(sValue);
		snprintf(sValue,MAX_NAME_LENGTH,"IMP_SOUND_%i",i);
		get_vaultdata(sValue,g_Imp_Sounds[i],MAX_TEXT_LENGTH);
		if(!strlen(g_Imp_Sounds[i])){
			snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] No sound set! (IMP_SOUND_%i is empty!)",i);
			log(Text);
		}else{
			if(!fileexists(g_Imp_Sounds[i])){
				snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] Wave file ^"%s^" not found on server!",g_Imp_Sounds[i]);
				log(Text);
			}
		}
		strinit(sValue);
		snprintf(sValue,MAX_NAME_LENGTH,"IMP_MSG_%i",i);
		get_vaultdata(sValue,g_TextMsg[i],MAX_TEXT_LENGTH);
		if(!strlen(g_TextMsg[i])){
			snprintf(Text,MAX_TEXT_LENGTH,"[IMPRESSIVE] No message set! (IMP_MSG_%i is empty!)",i);
			log(Text);
		}	
	}
}
	
public imp_plugin(HLCommand,HLData,HLUserName,UserIndex) { 
	new Data[MAX_DATA_LENGTH];
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	g_status_plugin=check_param(Data);
	if(g_status_plugin){
		selfmessage("[IMPRESSIVE] Plugin is enabled!");
	}else{
		selfmessage("[IMPRESSIVE] Plugin is disabled!");
	}
	set_vaultnumdata("IMP_PLUGIN",g_status_plugin);
	return PLUGIN_HANDLED;
}

public imp_set(HLCommand,HLData,HLUserName,UserIndex) { 
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	execclient(User,"clear");
	strstripquotes(Data);
	set_timer("dis_set",1,0,Data);
	return PLUGIN_HANDLED; 
} 

public dis_set(Timer,Repeat,HLName,HLParam) {
	new Data[MAX_DATA_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new sCmd[MAX_COMMAND_LENGTH];
	new sSubCmd[MAX_COMMAND_LENGTH];
	new sValue[MAX_TEXT_LENGTH];
	
	new sSubCmdFound[MAX_COMMAND_LENGTH];
	new sSubVaultFound[MAX_COMMAND_LENGTH];
	new sSubVaultValueFound[MAX_TEXT_LENGTH];
	
	new ifeature;
	new iDelim;
	new i;
	
	convert_string(HLParam,Data,MAX_DATA_LENGTH);
	strsep(Data," ",sCmd,MAX_COMMAND_LENGTH,sSubCmd,MAX_COMMAND_LENGTH,sValue,MAX_TEXT_LENGTH);
	ifeature=get_feature(sCmd);
	if(!ifeature){
		show_all_subcommands();
		return PLUGIN_HANDLED;
	}
	if(strlen(g_SubCommands[ifeature])==0){
		show_all_subcommands();
		return PLUGIN_HANDLED;
	}
	
	if(strstrx(g_SubCommands[ifeature],sSubCmd)!=-1 && strlen(sValue)!=0){
		selfmessage("=================================");
		selfmessage("[IMPRESSIVE] SETTINGS-CENTER:");
		snprintf(Text,MAX_TEXT_LENGTH,"FEATURE: %s",g_Commands[ifeature]);
		selfmessage(Text);
		selfmessage("=================================");
		selfmessage("SUBCOMMANDS:^t^t^t^tVALUE");
		iDelim=strcount(g_SubCommands[ifeature],',');
		if(iDelim==0){
			get_vaultdata(g_SubVault[ifeature],sSubVaultValueFound,MAX_TEXT_LENGTH);
			set_vaultdata(g_SubVault[ifeature],sValue);
			snprintf(Text,MAX_TEXT_LENGTH,"* %s:^t^t^t^tchanged %s to %s",g_SubCommands[ifeature],sSubVaultValueFound,sValue);
			selfmessage(Text);
		}else{
			for(i=0;i<=iDelim;i++){
				extract_subvault(ifeature,i,sSubCmdFound,sSubVaultFound,sSubVaultValueFound);
				if(strcmp(sSubCmd,sSubCmdFound)==0){
					set_vaultdata(sSubVaultFound,sValue);
					snprintf(Text,MAX_TEXT_LENGTH,"* %s:^t^t^t^tchanged %s to %s",sSubCmdFound,sSubVaultValueFound,sValue);
					selfmessage(Text);
					break;
				}
			}
		}
		load_vault_settings();
	}else{
		show_subcommands(ifeature);
	}	
	return PLUGIN_HANDLED;	
}

show_subcommands(ifeature){
	new Text[MAX_TEXT_LENGTH];
	new sSubCmd[MAX_TEXT_LENGTH];
	new Dummy[MAX_COMMAND_LENGTH];
	new sSubValue[MAX_TEXT_LENGTH];
	new iDelimCmd;
	new i;
	selfmessage("=================================");
	selfmessage("[IMPRESSIVE] SETTINGS-CENTER:");
	snprintf(Text,MAX_TEXT_LENGTH,"FEATURE: %s",g_Commands[ifeature]);
	selfmessage(Text);
	selfmessage("=================================");
	selfmessage("SUBCOMMANDS^t^t^t^tVALUE");
	
	iDelimCmd=strcount(g_SubCommands[ifeature],',');
	if(iDelimCmd==0){
		get_vaultdata(g_SubVault[ifeature],sSubValue,MAX_TEXT_LENGTH);
		snprintf(Text,MAX_TEXT_LENGTH,"* %s ->^t^t^t^t^t^t%s",g_SubCommands[ifeature],sSubValue);
		selfmessage(Text);
	}else{
		for(i=0;i<=iDelimCmd;i++){
			strinit(sSubCmd);
			strinit(sSubValue);
			extract_subvault(ifeature,i,sSubCmd,Dummy,sSubValue);
			snprintf(Text,MAX_TEXT_LENGTH,"* %s ->^t^t^t^t^t^t%s",sSubCmd,sSubValue);
			selfmessage(Text);
		}
	}
	selfmessage("==========(c) by Sir Drink a lot==========");
}

extract_subvault(ifeature,iReturn,sSubCmd[],sSubVault[],sSubValue[]){
	new sDummyCmd[MAX_TEXT_LENGTH];
	new sDummyVault[MAX_TEXT_LENGTH];
	new sSubCmdFound[MAX_COMMAND_LENGTH];
	new sSubCmdVault[MAX_COMMAND_LENGTH];
	new sVaultValue[MAX_TEXT_LENGTH];
	new i;
	strcpy(sDummyCmd,g_SubCommands[ifeature],MAX_TEXT_LENGTH);
	strcpy(sDummyVault,g_SubVault[ifeature],MAX_TEXT_LENGTH);
	for(i=0;i<=iReturn;i++){
		strinit(sSubCmdFound);
		strinit(sSubCmdVault);
		strsep(sDummyCmd,",",sSubCmdFound,MAX_COMMAND_LENGTH,sDummyCmd,MAX_TEXT_LENGTH);
		strsep(sDummyVault,",",sSubCmdVault,MAX_COMMAND_LENGTH,sDummyVault,MAX_TEXT_LENGTH);
	}
	get_vaultdata(sSubCmdVault,sVaultValue,MAX_TEXT_LENGTH);
	strcpy(sSubCmd,sSubCmdFound,MAX_COMMAND_LENGTH);
	strcpy(sSubVault,sSubCmdVault,MAX_COMMAND_LENGTH);
	strcpy(sSubValue,sVaultValue,MAX_TEXT_LENGTH);
}

show_all_subcommands(){
	new Text[MAX_TEXT_LENGTH];
	new SubCmd[MAX_TEXT_LENGTH];
	new i;
	selfmessage("=================================");
	selfmessage("[IMPRESSIVE] SETTINGS-CENTER:");
	selfmessage("=================================");
	selfmessage(" FEATURE:^t^t^t^t^tSUBCOMMANDS:");
	for(i=0;i<MAX_FEATURES;i++){
		if(strlen(g_SubCommands[i])==0){
			strcpy(SubCmd,"none",MAX_TEXT_LENGTH);
		}else{
			strcpy(SubCmd,g_SubCommands[i],MAX_TEXT_LENGTH);
		}
		snprintf(Text,MAX_TEXT_LENGTH," *%s: %s",g_Commands[i],SubCmd);
		selfmessage(Text);
	}	
	selfmessage("==========(c) by Sir Drink a lot==========");
}	
	
	
public imp_feature(HLCommand,HLData,HLUserName,UserIndex) { 
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	execclient(User,"clear");
	strstripquotes(Data);
	set_timer("dis_feature",1,0,Data);
	return PLUGIN_HANDLED; 
} 

public dis_feature(Timer,Repeat,HLName,HLParam) {
	new Data[MAX_DATA_LENGTH];
	new sToken1[MAX_COMMAND_LENGTH];
	new sToken2[MAX_DATA_LENGTH];
	new bSound = 0, bMessage = 0; 
	new operation:Operation; 
	new feature;
	new ID;
	convert_string(HLParam,Data,MAX_DATA_LENGTH);
	strsep(Data," ",sToken1,MAX_COMMAND_LENGTH,sToken2,MAX_DATA_LENGTH);
	/*HL-CONSOLE ALWAYS ADDS A SPACE AT THE END, IF YOU COPY/PASTE COMMANDS. LET'S REMOVE IT*/
	strtrim(sToken1," ",1);
	if(!strlen(sToken1)) { 
		show_config_all(); 
		return PLUGIN_HANDLED; 
	}
	ID = get_feature(sToken1);
	if(!(feature = 1<<ID)) { 
		snprintf(Data,MAX_DATA_LENGTH,"[IMPRESSIVE] Feature ^"%s^" not found",sToken1);
		selfmessage(Data);
		return PLUGIN_HANDLED; 
	}
	strinit(sToken1);
	strinit(Data);
	strsep(sToken2," ",sToken1,MAX_COMMAND_LENGTH,Data,MAX_DATA_LENGTH);
	strtrim(sToken1," ",1);	
	if(!strlen(sToken1)) { 
		selfmessage("=================================");
		selfmessage("[IMPRESSIVE] FEATURE-CENTER:");
		selfmessage("=================================");
		show_config(feature,ID,1,0); 
		show_config(feature,ID,0,1);
		selfmessage("==========(c) by Sir Drink a lot==========");
		return PLUGIN_HANDLED; 
	}
	strtrim(sToken1," ",1);
	if(!strcmp(sToken1,"sound")) { 
		bSound = 1;
	} else if(!strcmp(sToken1,"msg")) { 
		bMessage = 1; 
	} else if(!strcmp(sToken1,"both")) { 
		bMessage = bSound = 1; 
	}else {
		snprintf(Data,MAX_DATA_LENGTH,"[IMPRESSIVE] ^"%s^" invalid! Only ^"sound/msg/all/set^" allowed!",sToken1);
		selfmessage(Data);
		return PLUGIN_HANDLED; 
	}
	
	if(!strlen(Data)) {
		selfmessage("=================================");
		selfmessage("[IMPRESSIVE] FEATURE-CENTER:");
		selfmessage("=================================");
		if(bSound){
			show_config(feature,ID,1,0);
		}
		if(bMessage){
			show_config(feature,ID,0,1);
		}
		selfmessage("==========(c) by Sir Drink a lot==========");
		return PLUGIN_HANDLED; 
	}
	strtrim(Data," ",1);
	if(!strcmp(Data,"on")) { 
		Operation = enable; 
	} else if(!strcmp(Data,"off")) { 
		Operation = disable; 
	} else if(!strcmp(Data,"toggle")) { 
		Operation = toggle; 
	} else { 
		// Fehlermeldung & return 
		selfmessage("[IMPRESSIVE] Only ^"on/off/toogle^" allowed!");
		return PLUGIN_HANDLED; 
	} 
	if(bSound==1){
		do_operation(g_Sounds, Operation, feature, bSound);
		set_vaultnumdata("IMP_SOUNDS",g_Sounds);
		show_config_all();
	}
	if(bMessage==1){
		do_operation(g_Messages, Operation, feature, bMessage); 
		set_vaultnumdata("IMP_MESSAGES",g_Messages);
		show_config_all();
	}
	return PLUGIN_CONTINUE;
}
	
do_operation(&variable, operation:Operation, feature, apply) { 
	if(!apply) { 
		return; 
	} 
	switch(Operation) { 
		case enable: variable |= feature; 
		case disable: variable &= ~feature; 
		case toggle: variable ^= feature;
	}
}

get_feature(str[]) { 
	new i; 
	for(i=0;i<MAX_FEATURES;i++) { 
		if(strstrx(str,g_Commands[i])!=-1) { 
			return i; 
		} 
	} 
	return 0; 
}
show_config_all() { 
	new i; 
	new lastfeature = 1<<(MAX_FEATURES-1);
	new ID;
	selfmessage("=================================");
	selfmessage("[IMPRESSIVE] FEATURE-CENTER:");
	selfmessage("=================================");
	selfmessage(" SOUND:^t^t^t^t^tMESSAGE:^t^t^t^t^tFEATURE:");
	selfmessage("=================================");
	for(i = 1; i <= lastfeature; i<<=1) {
		show_config(i,ID); 
		ID++;
	} 
	selfmessage("==========(c) by Sir Drink a lot==========");
}
show_config(feature, ID, bSound = 1, bMessage = 1) { 
	new Text[MAX_TEXT_LENGTH];
	new i;
	new start;
	if(bSound && bMessage){
		if((g_Sounds & feature)&&(g_Messages & feature)){
			snprintf(Text,MAX_TEXT_LENGTH,"* ACTIVATED     -- ACTIVATED      ^t^t-> %s",g_Commands[ID]);
		}else if((g_Sounds & feature)){
			snprintf(Text,MAX_TEXT_LENGTH,"* ACTIVATED     -- DEACTIVATED  ^t^t-> %s",g_Commands[ID]);
		}else if((g_Messages & feature)){
			snprintf(Text,MAX_TEXT_LENGTH,"* DEACTIVATED -- ACTIVATED      ^t^t-> %s",g_Commands[ID]);
		}else{
			snprintf(Text,MAX_TEXT_LENGTH,"* DEACTIVATED -- DEACTIVATED   ^t^t-> %s",g_Commands[ID]);
		}
		selfmessage(Text);
	}else{
		if(bSound){
			if((g_Sounds & feature)) { 
				snprintf(Text,MAX_TEXT_LENGTH,"* %s: SOUND is ACTIVATED!",g_Commands[ID]);
			}else{
				snprintf(Text,MAX_TEXT_LENGTH,"* %s: SOUND is DEACTIVATED!",g_Commands[ID]);
			}
			selfmessage(Text);
			if(ID==0){
				start=0;
			}else{
				start=g_Features_SID[ID-1][0]+1;
			}
			for(i=start;i<=g_Features_SID[ID][0];i++){
				snprintf(Text,MAX_TEXT_LENGTH,"* - IMP_SOUND_%i: %s",i,g_Imp_Sounds[i]);
				selfmessage(Text);
				strinit(Text);
			}
		}
		if(bMessage){
			if((g_Messages & feature)) { 
				snprintf(Text,MAX_TEXT_LENGTH,"* %s: MESSAGE is ACTIVATED!",g_Commands[ID]);	
			}else{
				snprintf(Text,MAX_TEXT_LENGTH,"* %s: MESSAGE is DEACTIVATED!",g_Commands[ID]);
			}
			selfmessage(Text);
			if(ID==0){
				start=0;
			}else{
				start=g_Features_SID[ID-1][0]+1;
			}
			for(i=start;i<=g_Features_SID[ID][0];i++){
				snprintf(Text,MAX_TEXT_LENGTH,"* - IMP_MSG_%i: %s",i,g_TextMsg[i]);
				selfmessage(Text);
				strinit(Text);
			}
		}
	}
	
}

///////////////////////
/// LOGD - HANDLING ///
///////////////////////
public logd_handler(HLCommand,HLData,HLUserName,UserIndex){
	if(g_status_plugin){
		new Command[MAX_COMMAND_LENGTH];
		new Data[MAX_DATA_LENGTH];
		
		convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
		convert_string(HLData,Data,MAX_DATA_LENGTH);
		switch(Command[3]){
			case 'c': connect(Data);
			case 'd': disconnect(Data);
			case 's': suicide(Data);
			case 'k': kill(Data);
			case 'i': injure(Data);
			case 'p': playeraction(Data);
			case 't': teamaction(Data);
			case 'w': worldaction(Data);
		}
	}
	return PLUGIN_CONTINUE;
}

connect(Data[]){
	new UserIndex;
	UserIndex=strtonum(Data);
	reset_playerarray(UserIndex);
	check_lead();
}

disconnect(Data[]){
	new UserIndex;
	UserIndex=strtonum(Data);
	reset_playerarray(UserIndex);
	check_lead();
}

suicide(Data[]){
	new Weapon[MAX_NAME_LENGTH];
	new sUserIndex[3];
	new UserIndex;
	strbreak(Data,sUserIndex,Weapon,MAX_DATA_LENGTH);
	UserIndex=strtonum(sUserIndex);
	g_Killstreak[UserIndex]=CLEAN_SLATE;
	g_KillsRound[UserIndex]-=1;
	check_lead();
	player_suicide(UserIndex);
}

kill(Data[]){
	new Attacker[MAX_NAME_LENGTH];
	new Victim[MAX_NAME_LENGTH];
	new Weapon[MAX_NAME_LENGTH];
	new sAttacker[3];
	new sVictim[3];
	new iAID;
	new iVID;
	new iTeamA;
	new iTeamV;
		
	strsplit(Data," ",sAttacker,3,sVictim,3,Weapon,MAX_NAME_LENGTH);
	iAID=strtonum(sAttacker);
	iVID=strtonum(sVictim);
	check_lead();
	if(playerinfo(iAID,Attacker,MAX_NAME_LENGTH,_,_,iTeamA)){
		if(playerinfo(iVID,Victim,MAX_NAME_LENGTH,_,_,iTeamV)){
			if(iTeamA!=iTeamV){
				g_Killstreak[iAID]+=1;
				g_KillsInTime[iAID]+=1;
				g_KillsRound[iAID]+=1;
				lastscout();
				killsintime(Attacker,iAID);
				weaponkill(Attacker,Victim,Weapon);
				killstreak(Attacker,iAID);
				if(!g_firstblood){
					g_firstblood=1;
					firstblood(Attacker);
				}
				
			}else{
				g_KillsRound[iAID]-=1;
				g_Killstreak[iAID]-=1;
			}
			g_Killstreak[iVID]=CLEAN_SLATE;
		}
	}
}

injure(Data[]){
	new Dummy[MAX_DATA_LENGTH];
	new sAttacker[3];
	new sVictim[3];
	new Weapon[MAX_NAME_LENGTH];
	new Attacker[MAX_NAME_LENGTH];
	new Victim[MAX_NAME_LENGTH];
	new iAID;
	new iVID;
	new iTeamA;
	new iTeamV;
	new sDamage[4];
	new sHealth[4];
	new iDamage;
	new iHealth;
	
	strsep(Data," ",sAttacker,3,sVictim,3,Weapon,MAX_NAME_LENGTH,Dummy,MAX_DATA_LENGTH);
	strsplit(Dummy,"#",sDamage,4,sDamage,4,sHealth,4,sHealth,4);
	
	iAID=strtonum(sAttacker);
	iVID=strtonum(sVictim);
	iDamage=strtonum(sDamage);
	iHealth=strtonum(sHealth);

	if(playerinfo(iAID,Attacker,MAX_NAME_LENGTH,_,_,iTeamA)){
		if(playerinfo(iVID,Victim,MAX_NAME_LENGTH,_,_,iTeamV)){
			if(iTeamA==iTeamV){
				teamattack(Attacker);
			}else{
				if(iHealth<=0){
					if(iDamage>=MIN_HS_DAMAGE){
						headshot(Attacker,Weapon,iDamage,iAID);
					}
				}
			}
		}
	}
}

playeraction(Data[]){
	new sID[3];
	new Player[MAX_NAME_LENGTH];
	new Action[MAX_DATA_LENGTH];
	new CurMap[MAX_NAME_LENGTH];
	new iID;
	
	strbreak(Data,sID,Action,MAX_DATA_LENGTH);
	
	iID=strtonum(sID);
	
	if(playerinfo(iID,Player,MAX_NAME_LENGTH)){
		currentmap(CurMap,MAX_NAME_LENGTH);
		if(strncmp(CurMap,"de_",3)==0){
			if(strcmp(Action, "Spawned_With_The_Bomb") == 0) {
				bomb(Player,BOMBSPAWNED);
			}else if(strcmp(Action, "Got_The_Bomb") == 0) {
				bomb(Player,BOMBGET);
			}else if(strcmp(Action, "Dropped_The_Bomb") == 0) {
				bomb(Player,BOMBDROP);
			}else if(strcmp(Action, "Planted_The_Bomb") == 0) {
				bomb(Player,BOMBPLANT);
			}else if(strncmp(Action, "Begin_",6) == 0) {
				bomb(Player,STARTDEFUSE);
			}else if(strcmp(Action, "Defused_The_Bomb") == 0) {
				bomb(Player,BOMBDEFUSED);
			}
		}else if(strncmp(CurMap,"cs_",3)==0){
			switch(Action[0]){
				case 'T': hostage(Player,TOUCHHOSTAGE);
				case 'R': hostage(Player,RESCUEHOSTAGE);
				case 'K': hostage(Player,KILLEDHOSTAGE);
			}
		}else if(strncmp(CurMap,"as_",3)==0){
			switch(Action[0]){
				case 'B': player_vip(Player,BECAMEVIP);
				case 'V': player_vip(Player,KILLEDVIP);
				case 'E': player_vip(Player,ESCAPEVIP);
			}
		}
	}
}

teamaction(Data[]){
	new Data1[MAX_DATA_LENGTH];                                
        new Data2[MAX_DATA_LENGTH];  
	new Action[MAX_NAME_LENGTH];
	new dummy[10];
        new CTS[6];
        new TS[6];
        new iCTS;
        new iTS;        
        strbreak(Data,Data1,Data2,MAX_DATA_LENGTH);
	strsplit(Data2, "# " ,Action,MAX_DATA_LENGTH,dummy,10,CTS,MAX_NUMBER_LENGTH,dummy,10,TS,MAX_NUMBER_LENGTH);
	if(strcmp(Action,"Target_Bombed")==0){
		bomb("",BOMBDETONATE);
	}
	iCTS=strtonum(CTS);
	iTS=strtonum(TS);
	scoreboard(iCTS,iTS);
        return PLUGIN_CONTINUE;
}

worldaction(Data[]){
	if(Data[8]=='R' || Data[0]=='G'){
		new i;
		g_leader=0;
		g_rounds=0;
		for(i=0;i<=g_maxplayers;i++){
			reset_playerarray(i);
		}
	}else if(Data[6]=='S') {
		g_firstblood=0;
		reset_playerarray(ALL);
		roundcounter();
		check_lead();
		g_teamattack=1;
		g_curbombtimer=0;
		set_timer("teamattack_rs",g_tatimer,0);
	}else if(Data[6]=='E'){
		g_curbombtimer=999;
	}	
}

//////////////////////////////////
// IMPRESSIVE FEATURE FUNCTIONS //
//////////////////////////////////
////////////
/*HEADSHOT*/
////////////
headshot(Player[],Weapon[],iDamage,UserIndex){
	if((g_Messages & HEADSHOT) || (g_Sounds & HEADSHOT)){
		new a;
		new i;
		new Text[MAX_TEXT_LENGTH];
		for(i=0;i<MAX_WEAPONS;i++){
			if (strcmp(Weapon,g_WeaponName[i])==0 && iDamage >= g_WeaponDamage[i][0]){
				snprintf(Text,MAX_TEXT_LENGTH,"%s: Headshot with %s (%i HP)",Player,Weapon,iDamage);
				display_all_a(Text,ALL,print_chat);
				a= random(3);
				if(a==0){
					a=S_HEADSHOT1;
				}else if(a==1){
					a=S_HEADSHOT2;
				}else{
					a=S_HEADSHOT3;
				}
				g_HSinRound[UserIndex]+=1;
				prepare_message(Player,a,HEADSHOT);
				sound_all_a(ALL,a,HEADSHOT);
			}
		}
	}
}
/////////////////
/*KILLS IN TIME*/
/////////////////
killsintime(Player[],UserIndex){
	if((g_Messages & KILLS_IN_TIME) || (g_Sounds & KILLS_IN_TIME)){
		if(g_KillsTimer[UserIndex]==0){
			set_timer("count_kills_in_time",g_kstimer,0,Player);
		}
	}
}

public count_kills_in_time(Timer,Repeat,HLName,HLParam) {
  	new Player[MAX_NAME_LENGTH];
	new UserIndex;
  	convert_string(HLParam,Player,MAX_NAME_LENGTH);
	get_userindex(Player,UserIndex);
	if(g_KillsInTime[UserIndex]==g_DOUBLEKILL){
		prepare_message(Player,S_DOUBLEKILL,KILLS_IN_TIME);
		sound_all_a(ALL,S_DOUBLEKILL,KILLS_IN_TIME);
	}else if(g_KillsInTime[UserIndex]==g_MULTIKILL){
		prepare_message(Player,S_MULTIKILL,KILLS_IN_TIME);
		sound_all_a(ALL,S_MULTIKILL,KILLS_IN_TIME);
	}else if(g_KillsInTime[UserIndex]>=g_MONSTERKILL){
		prepare_message(Player,S_MONSTERKILL,KILLS_IN_TIME);
		sound_all_a(ALL,S_MONSTERKILL,KILLS_IN_TIME);
	}
	g_KillsTimer[UserIndex]=CLEAN_SLATE;
	g_KillsInTime[UserIndex]=CLEAN_SLATE;
	return PLUGIN_CONTINUE;
}
//////////////
/*KILLSTREAK*/
//////////////
killstreak(Player[],UserIndex){
	if((g_Messages & KILLSTREAK) || (g_Sounds & KILLSTREAK)){
		if(g_Killstreak[UserIndex] == g_KILLINGSPREE){
			prepare_message(Player,S_KILLINGSPREE,KILLSTREAK);
			sound_all_a(ALL,S_KILLINGSPREE,KILLSTREAK);
			
		}else if(g_Killstreak[UserIndex] == g_DOMINATING){
			prepare_message(Player,S_DOMINATING,KILLSTREAK);
			sound_all_a(ALL,S_DOMINATING,KILLSTREAK);
			
		}else if(g_Killstreak[UserIndex] >= g_GODLIKE){
			prepare_message(Player,S_GODLIKE,KILLSTREAK);
			sound_all_a(ALL,S_GODLIKE,KILLSTREAK);
			
		}
	}
	
}
//////////////
/*FIRSTBLOOD*/
//////////////
firstblood(Player[]){
	if((g_Messages & FIRSTBLOOD) || (g_Sounds & FIRSTBLOOD)){
		prepare_message(Player,S_FIRSTBLOOD,FIRSTBLOOD);
		sound_all_a(ALL,S_FIRSTBLOOD,FIRSTBLOOD);
		
	}
	
}
//////////////////////////////////
/*TAKENLEAD, LOSTLEAD, TIEDLEAD */
//////////////////////////////////
check_lead(){
	if((g_Messages & LEAD) || (g_Sounds & LEAD)){
		new Target[MAX_NAME_LENGTH];
		new frags;
		new maxfrags;
		new leader;
		new i;
		new iDead;
		/*FIND THE LEADER*/
		for(i=1;i<=g_maxplayers;i++){
			if(playerinfo(i,Target,MAX_NAME_LENGTH)){
				get_userFrags( Target, frags );
				if(frags>maxfrags){
					maxfrags=frags;
					leader=i;
				}else if(frags==maxfrags){
					leader=0;
				}
			}
		}
		if(maxfrags!=0){
			if(leader!=0){
				if(g_leader!=leader){
					/*New Leader: display message to all, play sound to player*/
					if(playerinfo(leader,Target,MAX_NAME_LENGTH)){
						prepare_message(Target,S_TAKENLEAD,LEAD);
						sound_target_a(Target,S_TAKENLEAD,LEAD);
					}
					/*Old Leader: display message and play sound to old leader*/
					if(g_leader!=0){
						if(playerinfo(g_leader,Target,MAX_NAME_LENGTH)){
							prepare_message(Target,S_LOSTLEAD,LEAD,DIS_TARGET_A,TARGET,PREFERRED_TYPE_PRIVATE);
							sound_target_a(Target,S_LOSTLEAD,LEAD);
						}
					}
					g_leader=leader;
					
				}
			}else{
				/*Old Leader: display message to all and play sound to old leader*/
				if(g_leader!=0){
					if(playerinfo(g_leader,Target,MAX_NAME_LENGTH)){
						prepare_message(Target,S_LOSTLEAD,LEAD);
						sound_target_a(Target,S_LOSTLEAD,LEAD);
					}
				}
				
				/*All tied for lead: display message and play sound to all who are tied for the lead*/
				for(i=1;i<=g_maxplayers;i++){
					if(g_leader!=i){ /*EXCEPT THE OLD LEADER*/
						if(playerinfo(i,Target,MAX_NAME_LENGTH,_,_,_,iDead)){
							/*Don't play, if player is dead, else repeat every time*/
							if(!iDead){
								get_userFrags( Target, frags );
								if(frags==maxfrags){
									prepare_message(Target,S_TIEDLEAD,LEAD,DIS_TARGET_A,TARGET,PREFERRED_TYPE_PRIVATE);
									sound_target_a(Target,S_TIEDLEAD,LEAD);
								}
							}
						}
					}
				}
				g_leader=0;
			}
		}
	}
}
///////////////
/*TEAM ATTACK*/
///////////////
teamattack(Player[]){
	if((g_Messages & TEAMATTACK) || (g_Sounds & TEAMATTACK)){
		prepare_message(Player,S_TEAMATTACK,TEAMATTACK,DIS_TARGET,ALL,P_MSAY);
		sound_target_a(Player,S_TEAMATTACK,TEAMATTACK);
		if(g_teamattack){
			slay(Player);
		}		
		
	}
	
}

public teamattack_rs(Timer,Repeat,HLName,HLParam) {
	g_teamattack=0;
}

////////////////////////////////////////////////////
/*KILLS WITH SPECIAL WEPAONS (e.g. knife or grenade)*/
////////////////////////////////////////////////////
weaponkill(Player[],Victim[],Weapon[]){
	if(strcmp(Weapon,"knife")==0){
		if((g_Messages & KNIFEKILL) || (g_Sounds & KNIFEKILL)){
			prepare_message(Player,S_KNIFEKILL,KNIFEKILL,PREFERRED_DISPLAY,ALL,PREFERRED_TYPE_ALL,Victim);
			sound_all_a(ALL,S_KNIFEKILL,KNIFEKILL);
			
		}
	}else if(strcmp(Weapon,"grenade")==0){
		if((g_Messages & GRENADEKILL) || (g_Sounds & GRENADEKILL)){
			prepare_message(Player,S_GRENADEKILL,GRENADEKILL,PREFERRED_DISPLAY,ALL,PREFERRED_TYPE_ALL,Victim);
			sound_all_a(ALL,S_GRENADEKILL,GRENADEKILL);
			
		}
	}
	
}
/////////////////
/*ROUND COUNTER*/
/////////////////
roundcounter(){
	if((g_Messages & ROUNDCOUNTER) || (g_Sounds & ROUNDCOUNTER)){
		new Text[MAX_TEXT_LENGTH];
		new strRounds[MAX_NUMBER_LENGTH];
		g_rounds++;
		numtoword(g_rounds,strRounds,MAX_NUMBER_LENGTH);
		snprintf(Text,MAX_DATA_LENGTH,"round %s",strRounds);
		set_timer("speak_round",2,0,Text);
		numtostr(g_rounds,strRounds);
		prepare_message(strRounds,S_ROUNDCOUNTER,ROUNDCOUNTER);
		sound_all_a(ALL,S_ROUNDCOUNTER,ROUNDCOUNTER);
	}
	
}

public speak_round(Timer,Repeat,HLName,HLParam) {
	new Output[MAX_DATA_LENGTH];
	convert_string(HLParam,Output,MAX_DATA_LENGTH);
	speak_all_a(ALL,Output,ROUNDCOUNTER);
}

////////////////////////////////////////////////////////////
/* BOMB EVENTS (everything, which can happen at de_ maps) */
////////////////////////////////////////////////////////////
bomb(Target[],ID){
	switch(ID){
		case BOMBSPAWNED:{
			if((g_Messages & BOMBSPAWNED) || (g_Sounds & BOMBSPAWNED)){
				prepare_message(Target,S_BOMBSPAWNED,BOMBSPAWNED,DIS_ALL_A,T,PREFERRED_TYPE_PRIVATE);
				sound_target_a(Target,S_BOMBSPAWNED,BOMBSPAWNED);
				glow(Target,250,10,10);
				new iUser;
				get_userindex(Target,iUser);
				numtostr(iUser,Target);
				set_timer("glow_off",10,0,Target);				
			}
		}
		case BOMBGET:{
			if((g_Messages & BOMBGET) || (g_Sounds & BOMBGET)){
				prepare_message(Target,S_BOMBGET,BOMBGET,DIS_ALL_A,T,PREFERRED_TYPE_PRIVATE);
				sound_target_a(Target,S_BOMBGET,BOMBGET);
				
			}
		}
		case BOMBDROP:{
			if((g_Messages & BOMBDROP) || (g_Sounds & BOMBDROP)){
				prepare_message(Target,S_BOMBDROP,BOMBDROP,DIS_ALL_A,T,PREFERRED_TYPE_PRIVATE);
				sound_target_a(Target,S_BOMBDROP,BOMBDROP);
				
			}
		}
		case BOMBPLANT:{
			strinit(g_BombPlanter);
			strcpy(g_BombPlanter,Target,MAX_NAME_LENGTH);
			if((g_Messages & BOMBPLANT) || (g_Sounds & BOMBPLANT)){
				prepare_message(Target,S_BOMBPLANT,BOMBPLANT);
				sound_all_a(ALL,S_BOMBPLANT,BOMBPLANT);
				
			}
			if(g_curbombtimer!=999){
				if((g_Messages & BOMBTIMER) || (g_Sounds & BOMBTIMER)){
					new wait;
					if(g_bombtimer>=30){
						wait=g_bombtimer-30;
						g_curbombtimer=30;
					}else if(20 <= g_bombtimer < 30){
						wait=g_bombtimer-20;
						g_curbombtimer=20;
					}
					set_timer("bombtimer",wait,0);
				}
			}
		}
		case STARTDEFUSE:{
			if((g_Messages & STARTDEFUSE) || (g_Sounds & STARTDEFUSE)){
				prepare_message(Target,S_STARTDEFUSE,STARTDEFUSE,DIS_ALL_A,CT,PREFERRED_TYPE_PRIVATE);
				sound_target_a(Target,S_STARTDEFUSE,STARTDEFUSE);
				
			}
		}
		case BOMBDEFUSED:{
			if((g_Messages & BOMBDEFUSED) || (g_Sounds & BOMBDEFUSED)){
				prepare_message(Target,S_BOMBDEFUSED,BOMBDEFUSED);
				sound_all_a(ALL,S_BOMBDEFUSED,BOMBDEFUSED);
				
			}
		}
		case BOMBDETONATE:{
			if((g_Messages & BOMBDETONATE) || (g_Sounds & BOMBDETONATE)){
				prepare_message(g_BombPlanter,S_BOMBDETONATE,BOMBDETONATE);
				sound_all_a(ALL,S_BOMBDETONATE,BOMBDETONATE);
				
			}
		}
	}
	
}

public glow_off(Timer,Repeat,HLName,HLParam) {
	new Target[MAX_NAME_LENGTH];
	new strUser[3];
	new iUser;
  	convert_string(HLParam,strUser,MAX_NAME_LENGTH);
  	iUser=strtonum(strUser);
  	if(playerinfo(iUser,Target,MAX_NAME_LENGTH)){
  		glow(Target,0,0,0);
  	}
}

public bombtimer(Timer,Repeat,HLName,HLParam) {
	if(g_curbombtimer!=999){
		new Text[MAX_TEXT_LENGTH];
		new C4Timer[MAX_NUMBER_LENGTH];
		new wait;
		numtoword(g_curbombtimer,C4Timer,MAX_NUMBER_LENGTH);
		if(g_curbombtimer>5){
			snprintf(Text,MAX_TEXT_LENGTH,"detonation in %s seconds",C4Timer);
			prepare_message(Text,S_BOMBTIMER,BOMBTIMER);
			speak_all_a(ALL,Text,BOMBTIMER);
			sound_all_a(ALL,S_BOMBTIMER,BOMBTIMER);
		}else if(g_curbombtimer!=0){
			snprintf(Text,MAX_TEXT_LENGTH,"%s",C4Timer);
			prepare_message(Text,S_BOMBTIMER,BOMBTIMER);
			speak_all_a(ALL,Text,BOMBTIMER);
			sound_all_a(ALL,S_BOMBTIMER,BOMBTIMER);
		}
		switch(g_curbombtimer){
			case 30:{ 
				g_curbombtimer=20;
				wait=10;
			}
			case 20:{ 
				g_curbombtimer=10;
				wait=10;
			}
			case 10:{
				g_curbombtimer=5;
				wait=4;
			}
			case 5: {
				g_curbombtimer=4;
				wait=1;
			}
			case 4: {
				g_curbombtimer=3;
				wait=1;
			}
			case 3: {
				g_curbombtimer=2;
				wait=1;
			}
			case 2: {
				g_curbombtimer=1;
				wait=1;
			}
			case 1: {
				g_curbombtimer=0;
				wait=1;
			}			
		}
		set_timer("bombtimer",wait,0);
	}
	return PLUGIN_CONTINUE;
}

///////////////////////////////////////////////////////////////
/* HOSTAGE EVENTS (everything, which can happen at cs_ maps) */
///////////////////////////////////////////////////////////////

hostage(Target[],ID){
	switch(ID){
		case TOUCHHOSTAGE:{
			if((g_Messages & TOUCHHOSTAGE) || (g_Sounds & TOUCHHOSTAGE)){
				prepare_message(Target,S_TOUCHHOSTAGE,TOUCHHOSTAGE,DIS_ALL_A,CT,PREFERRED_TYPE_PRIVATE);
				sound_all_a(CT,S_TOUCHHOSTAGE,TOUCHHOSTAGE);
				
			}
		}
		case RESCUEHOSTAGE:{
			if((g_Messages & RESCUEHOSTAGE) || (g_Sounds & RESCUEHOSTAGE)){
				prepare_message(Target,S_RESCUEHOSTAGE,RESCUEHOSTAGE,DIS_ALL_A,CT,PREFERRED_TYPE_PRIVATE);
				sound_all_a(ALL,S_RESCUEHOSTAGE,RESCUEHOSTAGE);
				
			}
		}
		case KILLEDHOSTAGE:{
			if((g_Messages & KILLEDHOSTAGE) || (g_Sounds & KILLEDHOSTAGE)){
				prepare_message(Target,S_KILLEDHOSTAGE,KILLEDHOSTAGE);
				sound_all_a(ALL,S_KILLEDHOSTAGE,KILLEDHOSTAGE);
				
			}
		}
	}
	
}

////////////////////
/* PLAYER SUICIDE */
////////////////////
player_suicide(UserIndex){
	if((g_Messages & SUICIDE) || (g_Sounds & SUICIDE)){
		new Player[MAX_NAME_LENGTH];
		if(get_playername(UserIndex,Player)){
			prepare_message(Player,S_PLAYERSUICIDE,SUICIDE);
			sound_all_a(ALL,S_PLAYERSUICIDE,SUICIDE);
			
		}
	}
	
}

////////////////
/* LAST SCOUT */
////////////////

lastscout(){
	if((g_Messages & LASTSCOUT) || (g_Sounds & LASTSCOUT)){
		new Target[MAX_NAME_LENGTH];
		new iTeam;
		new iDead;
		new i;
		new lastT;
		new lastCT;
		new iT;
		new iCT;
		
		for(i=1;i<=g_maxplayers;i++){
			if(playerinfo(i,Target,MAX_NAME_LENGTH,_,_,iTeam,iDead)){
				if(!iDead){
					if(iTeam==T){
						iT++;
						lastT=i;
					}else if(iTeam==CT){
						iCT++;
						lastCT=i;
					}
					if(iT >= 2 && iCT >= 2){
						iT=0;
						iCT=0;
						break;
					}
				}
				
			}
		}
		if(iT==1 && iCT>0 && g_lastT==0){
			if(playerinfo(lastT,Target,MAX_NAME_LENGTH)){
				prepare_message(Target,S_LASTSCOUT,LASTSCOUT,DIS_ALL_A,T,PREFERRED_TYPE_PRIVATE);
				sound_all_a(T,S_LASTSCOUT,LASTSCOUT);
				g_lastT=1;
			}
		}
		if(iCT==1 && iT>0 && g_lastCT==0){
			if(playerinfo(lastCT,Target,MAX_NAME_LENGTH)){
				prepare_message(Target,S_LASTSCOUT,LASTSCOUT,DIS_ALL_A,CT,PREFERRED_TYPE_PRIVATE);
				sound_all_a(CT,S_LASTSCOUT,LASTSCOUT);
				g_lastCT=1;
			}
		}
	}	
}

///////////////////////////////////////////////////////////
/* VIP EVENTS (everything, which can happen at as_ maps) */
///////////////////////////////////////////////////////////

player_vip(Target[],ID){
	switch(ID){
		case BECAMEVIP:{
			if((g_Messages & BECAMEVIP) || (g_Sounds & BECAMEVIP)){
				prepare_message(Target,S_BECAMEVIP,BECAMEVIP,DIS_TARGET_A,CT,PREFERRED_TYPE_PRIVATE);
				sound_target_a(Target,S_BECAMEVIP,BECAMEVIP);
				
			}
		}
		case KILLEDVIP:{
			if((g_Messages & KILLEDVIP) || (g_Sounds & KILLEDVIP)){
				prepare_message(Target,S_KILLEDVIP,KILLEDVIP);
				sound_all_a(ALL,S_KILLEDVIP,KILLEDVIP);
				
			}
		}
		case ESCAPEVIP:{
			if((g_Messages & ESCAPEVIP) || (g_Sounds & ESCAPEVIP)){
				prepare_message(Target,S_ESCAPEVIP,ESCAPEVIP);
				sound_all_a(ALL,S_ESCAPEVIP,ESCAPEVIP);
			}
		}
	}
}

////////////////
/* SCOREBOARD */
////////////////
scoreboard(iCT,iT){
	if((g_Messages & SCOREBOARD) || (g_Sounds & SCOREBOARD)){
		new Text[512];
		new Target[MAX_NAME_LENGTH];
		new Player[5][3];
		new Frags[5][4];
		new iFrags;
		new i;
		new j;
		new k;
		new x;
		
		
		/*FIND THE 5 Best Players*/
		for(i=1;i<=g_maxplayers;i++){
			if(playerinfo(i,Target,MAX_NAME_LENGTH)){
				if(g_KillsRound[i]!=0){
					/*Check Frag Array*/
					for(j=0;j<5;j++){
						if(g_KillsRound[i]>Frags[j][0]){
							if(j<5){
								/*shift stored values -1*/
								for(k=4;k>j;k--){
									Frags[k]=Frags[k-1];
									Player[k]=Player[k-1];
								}
								Frags[j][0]=g_KillsRound[i];
								Player[j][0]=i;
								x++;
								break;
							}else{
								Frags[j][0]=g_KillsRound[i];
								Player[j][0]=i;
								x++;
								break;
							}
						}
					}
				}
			}
		}
		if(g_menuenabled){
			snprintf(Text,MAX_TEXT_LENGTH,"\wCT: \y%i -- \rT: \y%i^nBest in round:",iCT,iT);
			for(i=0;i<3;i++){
				if(Player[i][0]!=0){
					if(playerinfo(Player[i][0],Target,MAX_NAME_LENGTH)){
						snprintf(Text,MAX_TEXT_LENGTH,"%s^n\y%s -- %i (%i)",Text,Target,Frags[i],g_HSinRound[Player[i][0]]);
					}
				}
			}
			if(g_leader!=0){
				if(playerinfo(g_leader,Target,MAX_NAME_LENGTH)){
					get_userFrags(Target,iFrags);
					snprintf(Text,MAX_TEXT_LENGTH,"%s^n^n\yBest of map:^n\w%s -- %i",Text,Target,iFrags);
				}
			}
			display_all_a(Text,ALL,P_MSAY);
		}else{
			snprintf(Text,MAX_TEXT_LENGTH,"CT: %i -- T: %i^nBest in round:",iCT,iT);
			if(Player[0][0]!=0){
				if(playerinfo(Player[0][0],Target,MAX_NAME_LENGTH)){
					snprintf(Text,MAX_TEXT_LENGTH,"%s^n%s -- %i (%i)",Text,Target,Frags[0],g_HSinRound[Player[0][0]]);
				}
			}
			if(g_leader!=0){
				if(playerinfo(g_leader,Target,MAX_NAME_LENGTH)){
					get_userFrags(Target,iFrags);
					snprintf(Text,MAX_TEXT_LENGTH,"%s^nBest of map:^n%s -- %i",Text,Target,iFrags);
				}
			}
			display_all_a(Text,ALL,PREFERRED_TYPE_PRIVATE);
		}
	}
}

//////////////////////
// HELPER FUNCTIONS //
//////////////////////
prepare_message(Part1[],SID,ID,MSGID=PREFERRED_DISPLAY,TEAM=ALL,TYPE=PREFERRED_TYPE_ALL,Part2[]=""){
	if((g_Messages & ID)){
		new Text[MAX_TEXT_LENGTH];
		snprintf(Text,MAX_TEXT_LENGTH,g_TextMsg[SID],Part1,Part2);
		if(MSGID==DIS_ALL_A){
			display_all_a(Text,TEAM,TYPE);
		}else if (MSGID==DIS_TARGET_A){
			display_target_a(Text,Part1,TYPE);
		}else if (MSGID==DIS_ALL){
			display_all(Text,TYPE);
		}else if (MSGID==DIS_TARGET){
			display_target(Text,Part1,TYPE);
		}
	}
}
reset_playerarray(UserIndex){
	if(UserIndex!=-1){
		g_KillsInTime[UserIndex]=CLEAN_SLATE;
		g_KillsTimer[UserIndex]=CLEAN_SLATE;
		g_Killstreak[UserIndex]=CLEAN_SLATE;
		g_HSinRound[UserIndex]=CLEAN_SLATE;
		g_KillsRound[UserIndex]=CLEAN_SLATE;
	}else{
		new i;
		for(i=1;i<=g_maxplayers;i++){
			g_KillsInTime[i]=CLEAN_SLATE;
			g_KillsTimer[i]=CLEAN_SLATE;
			g_KillsRound[i]=CLEAN_SLATE;
			g_HSinRound[i]=CLEAN_SLATE;
		}
	}
}

stock get_playername(UserIndex,PlayerName[]){
	if(playerinfo(UserIndex,PlayerName,MAX_NAME_LENGTH)){
		return 1;
	}
	return 0;
}

stock do_numtoword(iNum,str[],iLevel,iLength) {
	
	/* If there is more than one group of 3, then take care of the others first. */
	if(iNum >= 1000) do_numtoword(iNum / 1000,str,iLevel + 1,iLength);
	
	/* Grab the the first 3 digits only */
	iNum %= 1000;	
	
	/* Isolate each digit */
	new _hundreds = iNum / 100;
	new _tens = (iNum / 10) % 10;
	new _ones = iNum % 10;
	
	/* Take care of the teen numbers */
	if(_tens == 1 && _ones != 0) {
		snprintf(str,iLength,"%s%s%s%s",str,HundredsLib[_hundreds],TeensLib[_ones],GroupNamesLib[iLevel]);
	} else {
		snprintf(str,iLength,"%s%s%s%s%s",str,HundredsLib[_hundreds], TensLib[_tens], OnesLib[_ones],GroupNamesLib[iLevel]);
	}
	
	if(iLevel==0) str[strlen(str)-1] = 0; /* Gets rid of the trailing space*/
	return 1;
}

stock numtoword(iNum,str[],iLength) {
	/* Empties the first char of the string */
	str[0] = 0;
	str[iLength-1] = 0;
	if(iNum == 0) {
		snprintf(str,iLength,"zero");
		return 1;
	}
	if(iNum < 0) {
		iNum *= -1;
		snprintf(str,iLength,"negative ");
	}
	
	return do_numtoword(iNum,str,0,iLength); 
}	

//////////////////////////////
// SOUND AND MESSAGE OUTPUT //
//////////////////////////////

allowsound(User[]){
	new Info[MAX_NUMBER_LENGTH];
	new iInfo;
	new Authid[MAX_AUTHID_LENGTH];
	get_userAuthID(User,Authid,MAX_AUTHID_LENGTH);
	if(strcmp(Authid,"BOT")!=0){
		get_userinfo(User,Key,Info,MAX_NUMBER_LENGTH);
		iInfo=strtonum(Info);
		if(strlen(Info)==0 || iInfo > 0){/*damit wird automatisch immer der Sound auf 1 gesetzt,wenn kein setinfo vorhanden, bis 'stop' eingegeben wird*/
			return 1;
		}
	}
	return 0;
}
/*MESSAGE OUTPUT*/
/*CHECK FOR ALLOWSOUND*/
stock display_all_a(Text[],iTeam,iType){
	new Target[MAX_NAME_LENGTH];
	new iTeamB;
	new i;
	for(i=1;i<=g_maxplayers;i++){
		if(playerinfo(i,Target,MAX_NAME_LENGTH,_,_,iTeamB)){
			if(allowsound(Target)){
				if(iTeam!=-1){
					if(iTeam==iTeamB){
						if(iType!=P_MSAY){
							messageex(Target,Text,print_type:iType);
						}else{
							if(g_menuenabled){
								menu(Target,Text,1023,8);
							}else{
								messageex(Target,Text,print_tty);
							}
						}
					}
				}else{
					if(iType!=P_MSAY){
						messageex(Target,Text,print_type:iType);
					}else{
						if(g_menuenabled){
							menu(Target,Text,1023,8);
						}else{
							messageex(Target,Text,print_tty);
						}
					}
				}
			}
		}
	}
}

stock display_target_a(Text[],Target[],iType){
	if(allowsound(Target)){
		if(iType!=P_MSAY){
			messageex(Target,Text,print_type:iType);
		}else{
			if(g_menuenabled){
				menu(Target,Text,1023,8);
			}else{
				messageex(Target,Text,print_tty);
			}
		}
	}
}

/*NO CHECK FOR ALLOWSOUND*/
stock display_all(Text[],iType){
	if(iType==TSAY){
		typesay(Text,12,random(250),random(250),random(250));
	}else{
		centersay(Text,12,random(250),random(250),random(250));
	}
}

stock display_target(Text[],Target[],iType){
	if(iType!=P_MSAY){
		messageex(Target,Text,print_type:iType);
	}else{
		if(g_menuenabled){
			menu(Target,Text,1023,8);
		}else{
			messageex(Target,Text,print_tty);
		}
	}
}

/*SOUND OUTPUT*/
/*CHECK FOR ALLOWSOUND*/
stock sound_all_a(iTeam,SID,ID){
	if((g_Sounds & ID)){
		new Target[MAX_NAME_LENGTH];
		new iTeamB;
		new i;
		for(i=1;i<=g_maxplayers;i++){
			if(playerinfo(i,Target,MAX_NAME_LENGTH,_,_,iTeamB)){
				if(allowsound(Target)){
					if(iTeam!=-1){
						if(iTeam==iTeamB){
							playsound(Target,g_Imp_Sounds[SID]);
						}
					}else{
						playsound(Target,g_Imp_Sounds[SID]);
					}
				}
			}
		}
	}
}

stock sound_target_a(Target[],SID,ID){
	if((g_Sounds & ID)){
		if(allowsound(Target)){
			playsound(Target,g_Imp_Sounds[SID]);
		}
	}
}

/*NO CHECK FOR ALLOWSOUND*/
stock sound_target(Target[],SID,ID){
	if((g_Sounds & ID)){
		playsound(Target,g_Imp_Sounds[SID]);
	}
}

/*HL-SPEECH OUTPUT*/
stock speak_all_a(iTeam,Output[],ID){
	if((g_Sounds & ID)){
		new Target[MAX_NAME_LENGTH];
		new iTeamB;
		new i;
		for(i=1;i<=g_maxplayers;i++){
			if(playerinfo(i,Target,MAX_NAME_LENGTH,_,_,iTeamB)){
				if(allowsound(Target)){
					if(iTeam!=-1){
						if(iTeam==iTeamB){
							speakto(Target,Output);
						}
					}else{
						speakto(Target,Output);
					}
				}
			}
		}
	}
}

stock speak_target_a(Target[],Output[],ID){
	if((g_Sounds & ID)){
		if(allowsound(Target)){
			speakto(Target,Output);
		}
	}
}