/*************************************************************************************************
* 							  				*********
**  		Sir Drink a lots Impressive-Plugin              v 6.5			********
***                                                         				******** 
****  		INFO:  									*******
*****		---HEADSHOT-ANZEIGE:---							*******
***** 		Dieses Plugin zeigt die Headshots an und spielt 			******
*****  		einen zuflligen Sound ab. Die Auswahl liegt bei 3 Sounds		**** 
******	 	fr den Headshot. (Standardmig sind es die headshot.wav,		***
******* 	impressive.wav und perfect.wav)						***
*******		Die Pfadangabe und die Datei werden in der vault.ini			***
******* 	gespeichert. IMP_SOUND_1, IMP_SOUND_2 und IMP_SOUND_3 sind  		***
******* 	dafr vorgesehen.							***
*******  							  			***
*******  	---TEAMSCORE-ANZEIGE:---			  			***
******* 	Ausserdem zeigt es am Ende der Runde die Teamscore und 			***
*******		den besten Spieler mit der Anzahl seiner Frags und			***
*******		seiner Headshots an. Wenn man amv_enable_beta "menu1"			***
*******  	in der adminmod.cfg aktiviert hat, wird eine ausfhrlichere		***
*******  	Score-Anzeige dargestellt.			  			***
*******  							  			***
*******  	---KILLSTREAK-ANZEIGE:---			  			***
*******  	Ich habe es jetzt noch um ein eigenes "killstreak" ergnzt,		***
*******  	soll heien, dass es jetzt einen "Doublekill", "Multikill" 		***
*******  	und "Monsterkill" anzeigt und eine entsprechende Wave-Datei  		***
*******  	abspielt. Dafr sind in der vault.ini IMP_SOUND_4, IMP_SOUND_5		***
*******  	und IMP_SOUND_6 vorgesehen. (Standardmig sind die Sounds		***
*******  	doublekill.wav, multikill.wav und monsterkill.wav eingetragen.)		***
*******  	Damit diese Sounds aber ertnen, mssen die Frags in einer gewissen	***
*******  	Zeit absolviert werden. Standardmig sind 3 Sekunden eingestellt.	***
*******  							  			***
*******  	Fr Spieler, die insgesamt 4 Frags, 5 Frags oder mehr in der 		***
*******  	gesamten Rundenzeit, aber diese nicht innerhalb	der Zeitbegrenzung,	***
*******  	erreicht haben, wird "Killingspree", "Dominating" bzw. "Godlike"	***					  			***
*******  	angezeigt und standardmig die Sounds killingspree.wav, 		***
*******  	dominating.wav bzw.goodlike.wav abgespielt. Dafr sind in der 		***
*******  	vault.ini IMP_SOUND_7, IMP_SOUND_8 und IMP_SOUND_9 reserviert.		***
*******								  			***
*******  	---FIRST-BLOOD-ANZEIGE:---			  			***
*******		Der erste Spieler, der ein Frag in der Runde macht, wird angekndigt.	***
*******		(IMP_SOUND_10)					  			***
*******								  			***
*******  	---MAP-FHRUNGS-ANZEIGE:---			  			***
*******		'Taken the Lead', 'tied for the lead' and 'lost the lead'		***
*******		sind IMP_SOUND_11 - 13 festgelegt.		  			***
*******								  			***
*******  	---TEAMATTACK-WARNUNG:---			  			***
*******		Anzeige an den TA mit entsprechendem Sound. (IMP_SOUND_14)		***
*******								  			***
*******  	---GRENADEKILL UND KNIFEKILL-ANZEIGE:---	  			***
*******  	Jeder Messer und Grantenkill wird entsprechend angezeigt und		***
*******  	mit Sound untermalt. (IMP_SOUND_15 u. 16)	  			***
*******  							  			***
*******  	---SPAWNED WITH THE BOMB-ANZEIGE:---		  			***
*******  	Den Teammitgliedern wird mitgeteilt, wer die Bombe hat und		***
*******  	dem BTrger mit entsprechendem Sound untermalt. Ausserdem glht er fr	***
*******		5 Sekunden. (IMP_SOUND_17)			  			***
*******  							  			***
*******  	---PREPARE TO FIGHT-ANZEIGE:---			  			***
*******  	Rundenanzahl wird angekndigt.						***
*******		(IMP_SOUND_18 und mit der HL-Sprachausgabe)				***
*******  							  			***
*******  	---PLANT BOMB:---			  				***
*******  	Bombenleger wird allen angekndigt. (IMP_SOUND_19)			***
*******  							  			***
*******  	---DROP BOMB:---			  				***
*******  	Spieler, der die Bombe verliert, wird dem Team angekndigt.		***
*******  	(IMP_SOUND_20)						  		***
*******  							  			***
*******  	---GET BOMB:---			  					***
*******  	Spieler, der die Bombe aufnimmt, wird dem Team wird angekndigt.	***
*******		(IMP_SOUND_21)								***
*******  							  			***
*******  	---TOUCHED HOSTAGE:---		  					***
*******  	Spieler, der die Hostages berhrt wird dem Team wird angekndigt.	***
*******		(IMP_SOUND_22)								***
*******  							  			***
*******  	---BOMB-TIMER:---		  					***
*******  	Nach dem Legen der Bombe, wird die Zeit bis zur Explosion angekndigt.	***
*******		(IMP_SOUND_23 und mit der HL-Sprachausgabe)				***
*******  							  			***
*******  	---BENTIGT WIRD PLUGIN_SDAL_ALLOWSOUNDS!!!:---	  			***
*******  	Desweiteren gibt es die Option fr jeden Spieler auf dem Server		***
*******  	die Sounds fr sich zu deaktivieren.		  			***
*******  	Dafr muss er nur EINMAL "stopsounds" oder "stop" im Chat eingeben.	***
*******  	Dann ist es fr die gesamte Mapzeit fr ihn deaktiviert.		***
*******  	Mit "playsounds" bzw. "play" kann er es wieder aktivieren.		***
*******  							  			***
*******  	---Befehle innerhalb des Spiels in der Console:---  			***
*******  							  			***
*******  	INSTALLATION/EINSTELLUNGEN:			  			***
*******  	Als Grundbefehl dient immer admin_impressive.	  			***
*******  	Danach muss eine CommandNummer eingegeben werden.  			***
*******  	Bei CommandNummer 0 muss ein zustzlicher Befehl plus Parameter 	***
*******  	eingegeben werden, um gewisse Sachen generell an- bzw. auszuschalten.	***
*******								  			***
*******  	Command		Befehl		Parameter	wird zu vault.ini	***
*******		-Nummer						Eintrag			***
*******		----------------------------------------------------------------------	***
*******  	0		plugin		0=aus/1=ein	IMP_PLUGIN 0/1		***
*******  	0		dk		0=aus/1=ein	IMP_DISPLAY_KILL 0/1	***
*******  	0		ds		0=aus/1=ein	IMP_DISPLAY_SCORE 0/1	***
*******		0		ls		0=aus/1=ein	IMP_LEADSOUNDS 0/1	***
*******		0		fb		0=aus/1=ein	IMP_FIRSTBLOOD 0/1	***
*******  	0		hs		0=aus/1=ein	IMP_HEADSHOT 0/1	***
*******  	0		ks		0=aus/1=ein	IMP_KILLSTREAK 0/1	***
*******  	0		kst		0-XX		IMP_KILLSTREAKTIME 0/XX	***
*******  	0		kk		0=aus/1=ein	IMP_KNIFEKILL 0/1	***
*******  	0		gk		0=aus/1=ein	IMP_GRENADEKILL 0/1	***
*******  	0		bs		0=aus/1=ein	IMP_BOMBSPAWNED 0/1	***
*******  	0		bp		0=aus/1=ein	IMP_BOMBPLANT 0/1	***
*******  	0		bd		0=aus/1=ein	IMP_BOMBDROP 0/1	***
*******  	0		bg		0=aus/1=ein	IMP_BOMBGET 0/1		***
*******  	0		bt		0=aus/1=ein	IMP_BOMBTIMER 0/1	***
*******  	0		sbd		0=aus/1=ein	IMP_STARTDEFUSE 0/1	***
*******  	0		fbd		0=aus/1=ein	IMP_BOMBDEFUSED 0/1	***
*******  	0		db		0=aus/1=ein	IMP_BOMBDET 0/1		***
*******  	0		th		0=aus/1=ein	IMP_TOUCHHOSTAGE 0/1	***
*******  	0		rc		0=aus/1=ein	IMP_ROUNDCOUNTER 0/1	***
*******  	0		ta		0=aus/1=ein	IMP_TEAMATTACK 0/1	***
*******  							  			***
*******  	SOUND-PFADANGABEN:				  			***
*******  	Das speichern der Pfadangabe und des Dateinamens in der vault.ini	***
*******  	soll eben die Mglichkeit bieten, jederzeit die Sounds auszuwechseln, 	***
*******  	in dem man eben andere Pfade und Dateinamen dort hineinschreibt.	***
*******  							  			***
*******  	Bei CommandNummer 1-x muss danach eine Pfadangabe und die Wave-Datei	***
*******  	folgen. (Dabei ist auf richtige Zeichensetzung zu achten!!!)		***
*******  	Die unten abgebildete Tabelle hat als Speicherort der Sounds den Ordner	***
*******  	MOD/sound/impressive. Folgende Wave-Dateien habe ich bei mir festgelegt.***
*******  							  			***
*******  	Com.	wird in	    PFADANGABE (Beispiel)		FEATURE		***
*******		-Nr	vault.ini							***
*******		----------------------------------------------------------------------	***
*******  	1	IMP_SOUND_1 sound/impressive/headshot.wav	HEADSHOT	***
*******  	2	IMP_SOUND_2 sound/impressive/impressive.wav	HEADSHOT	***
*******  	3	IMP_SOUND_3 sound/impressive/perfect.wav	HEADSHOT	***
*******		4	IMP_SOUND_4 sound/impressive/doublekill.wav	KILLSTREAK	***
*******		5	IMP_SOUND_5 sound/impressive/multikill.wav	KILLSTREAK	***
*******  	6	IMP_SOUND_6 sound/impressive/monsterkill.wav	KILLSTREAK	***
*******  	7	IMP_SOUND_7 sound/impressive/killingspree.wav	KILLSTREAK	***
*******  	8	IMP_SOUND_8 sound/impressive/dominating.wav	KILLSTREAK	***
*******  	9	IMP_SOUND_9 sound/impressive/godlike.wav	KILLSTREAK	***
*******  	10	IMP_SOUND_10 sound/impressive/firstblood.wav	FIRSTBLOOD	***
*******  	11	IMP_SOUND_11 sound/impressive/takenlead.wav	FHRUNG		***
*******  	12	IMP_SOUND_12 sound/impressive/lostlead.wav	FHRUNG		***
*******  	13	IMP_SOUND_13 sound/impressive/tiedlead.wav	FHRUNG		***
*******  	14	IMP_SOUND_14 sound/impressive/PayAttention.wav	TEAMATTACK	***
*******  	15	IMP_SOUND_15 sound/impressive/humiliation.wav	KNIFEKILL	***
*******  	16	IMP_SOUND_16 sound/impressive/humiliation.wav	GRENADEKILL	***
*******  	17	IMP_SOUND_17 sound/impressive/prepare.wav	PREPARE TO FIGHT***
*******  	18	IMP_SOUND_18 sound/impressive/becomeone.wav	BOMBSPAWNDED	***
*******  	19	IMP_SOUND_19 sound/impressive/execellent.wav	PLANT BOMB	***
*******  	20	IMP_SOUND_20 sound/impressive/doh.wav		DROP BOMB	***
*******  	21	IMP_SOUND_21 sound/impressive/becomeone.wav	GET BOMB	***
*******  	22	IMP_SOUND_22 sound/impressive/ticking.wav	BOMBTIMER	***
*******  	23	IMP_SOUND_23 sound/impressive/feelgood.wav	BOMBEXPLOSION	***
*******  	24	IMP_SOUND_24 sound/impressive/force2.wav	BEGINNDEFUSE	***
*******  	25	IMP_SOUND_25 sound/impressive/feelgood.wav	DEFUSEDBOMB	***
*******  	26	IMP_SOUND_26 sound/impressive/excellent.wav	TOUCHED HOSSI	***
*******  							  			***
********  	Thanks to Warhead,Biohazard,[Cola]-Whiskey, [WING] BlackKnight and the	**
*********  	www.admin-mod.de forumusers for help and the idea.			*
*********  	ALSO GREAT THANKS TO NETKOWALSKI FOR THE NEW CODE and			*
*********	Big THX an SR71GOKU for the Round-Counter-Code.				*
*********	Thx to [MOK] Appel for the newest bug report!				*
*********										*
*********	History:								*
*********	6.5: 									*
*********	- Sound fr Bombtimer und Hostage waren vertauscht.			*
*********	- Bombtimer wurde nicht aktiviert, wenn nicht auch "Bomb Planted"	*
*********	  aktiviert war.							*
*********	- hinzugefgt: Begin_Bomb_Defuse, Defused_Bomb and Bomb Detonation	*
*********	6.4: 									*
*********	- Gallil und Defender Damage geaddet					*
*********	- show_stats() auch von allowsound(User[]) abhngig.			*
*********	- show_stats(): nur Spieler mit mehr als einem Kill werden angezeigt.	*
*********	- allowsounds() setinfo Abfrage verbessert.				*
*********	6.3:									*
*********	- Bugfix: Weapondamage							*
*********	6.2: 									*
*********	- Das Abschalten von displaykill (dk) betrifft jetzt nur noch 		*
*********	  die Feature Headshot, Killstreak, Firstblood und Fhrungsanzeige	*
*********	  Die Anzeigen der anderen Feature sind aktiv, wenn das gesamte Feature *
*********	  auch gewnscht und aktiviert ist.					*
*********	6.1: 									*
*********	- Neustrukturierung der Befehle. Man kann nur noch ganze Feature	*
*********	  an/bzw. ausschalten. Nicht einzelne Teile des Features.		*
*********	- Neue Befehls- und Vault.ini Verwaltung. 				*
*********	- Neue Feature: Bomb_Plant, Bomb_Drop, Bomb_Get, Touched_Hostage,	*
*********	  Bombtimer.								*
*********	- Die Sounds sollten fr dieses Plugin jetzt im MOD unter		*
*********	  sound/impressive abgelegt weden. Kann man aber anhand des		*
*********	  vault.ini Eintrages selber festlegen.					*
*********	6.0:									*
*********	- Knifekill, Bombkill, Rundenanzahl uns Spawned with a bomb hinzugefgt.*
*********	- Code-Verbesserungen							*
*********	5.7:									*
*********	- erweiterte Score-Anzeige, wenn amv_enable_beta "menu1" aktiviert ist	*
*********	5.6.1:									*
*********	- eigenstndiges Plugin geschrieben, was am_sound bei dem Client setzt. *
*********	  (plugin_sdal_allowsounds)						*
*********	- An Bots wird nichts mehr gesendet.					*
*********	5.6:									*
*********	- berprfung der Serverconfiguration erweitert				*
*********	- Plugin Konfiguration erweitert (soundsbest1,2,3), um Sounds zu	*
*********	  aktivieren/deaktivieren.						*
*********	- Sound-Prioritt auf die Quake-Sounds festgelegt			*
*********	5.5:									*
*********	- internes Scoreboard in der Console fr Debug-Zwecke			*
*********	- Selbstmord wird erkannt.						*
*********	- 2-Dimensionale Arrays fr die Sounds und Textanzeigen 		*
*********	- Waffendamage ber #define nderbar					*
*********	- ber setinfo vom Spieler definierbar, ob er Sounds hren mchte	*
********	5.4:									*
*********	- Quake-Sounds hinzugefgt, um die Fhrungen zu signalisieren		*
*********	5.3:									*
*********	- Unreal-Tournament Sounds mit Zeitbegrenzung und Ohne. Killstreak	*
*********	5.0:									*
*********	- integriertes Killstreak						*
*********	< 5:									*
*********	- nur Headshotsound Analyse mit Ausgabe von Sounds und Anzeige		*
*********	- erstes Killstreak							*
*****************************************************************************************/ 


#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

new STRING_VERSION[MAX_DATA_LENGTH] = "AM_2.50.59_11.02.04_v.6.5";

#define ACCESS_CONSOLE 131072
#define CLEAN_SLATE 0
#pragma dynamic 8192


new Key[]="am_sound";

/*13.04.03 erweiterte Scoreanzeige*/
new menuenabled;

//////////////////////////////////////////
/////// SOUND UND TEXT-VERWALTUNG ////////
//////////////////////////////////////////
/*Legt die momentane Anzahl der Sounds und Textmeldungen in diesem Plugin fest und speichert sie im 2-Dim-Array*/
#define ALL_SOUNDS 	26
#define HEADSHOT1	0
#define HEADSHOT2	1
#define HEADSHOT3	2
#define DOUBLEKILL	3
#define MULTIKILL	4
#define MONSTERKILL	5
#define	KILLINGSPREE	6
#define DOMINATING	7
#define GODLIKE		8
#define FIRSTBLOOD	9
#define TAKENLEAD	10
#define LOSTLEAD	11
#define	TIEDLEAD	12
#define PAYATTENTION	13
#define KNIFEKILL	14
#define GRENKILL	15
#define	PREPAREFIGHT	16
#define	BOMBSPAWNED	17
#define	PLANTBOMB	18
#define	DROPBOMB	19
#define	GOTBOMB		20
#define BOMBTIMER	21
#define BOMBDETONATION	22
#define BOMBDEFUSE	23
#define DEFUSEDBOMB	24
#define TOUCHEDHOSTAGE	25
new IMP_SOUND[ALL_SOUNDS][MAX_TEXT_LENGTH];

/*Textmeldungen*/
new TextMessage[ALL_SOUNDS][]={{"%s made^na headshot!"},{"%s made^nan impressive headshot"},{"%s made^na perfekt headshot!"},
				{"%s made^na doublekill!"},{"%s made^na multikill"},{"%s made^na monsterkill"},
				{"%s:^nKILLINGSPREE!"},{"%s:^nDOMINATING"},{"%s:^nGODLIKE"},{"%s:^nFIRST BLOOD"},{"%s has^ntaken the lead!"},
				{"%s has^nlost the lead!"},{"You are tied^nfor the lead!"},{"STOP SHOOTING YOUR TEAMMATE"},{"%s killed^n%s with a knife!"},
				{"%s killed^n%s with a grenade!"},{"--PREPARE TO FIGHT--^n        ROUND %i"},{"%s^nspawned with the bomb"},
				{"%s^nplanted the bomb"},{"%s^ndropped the bomb"},{"%s^ngot the bomb"},{""},{"Terrorists win!"},
				{"%s^nbegins to defuse the bomb!"},{"%s^ndefused the bomb!"},{"%s^ntouched a hostage"}};

/*17.04.03 Um Zahlen korrekt mit HL-Speech als String auszusprechen*/
static OnesLib[10][] = { "", "one ", "two ", "three ", "four ", "five ", "six ", "seven ", "eight ", "nine " };
static TensLib[10][] = {"", "ten ", "twenty ", "thirty ", "fourty ", "fifty ", "sixty ", "seventy ", "eighty ", "ninety " } ;
static TeensLib[10][] = {"", "eleven ", "twelve ", "thirteen ", "fourteen ", "fifteen ", "sixteen ", "seventeen ", "eighteen ", "nineteen " };
static HundredsLib[10][] = { "", "one hundred ", "two hundred ", "three hundred ", "four hundred ", "five hundred ", "six hundred ", "seven hundred ", "eight hundred ", "nine hundred " };
static GroupNamesLib[5][] = {"", "thousand ", "million ", "billion ", "trillion " };

//////////////////////////////////
/////// WAFFEN-VERWALTUNG ////////
//////////////////////////////////
/*Ausgetestete Damage-Werte der Waffen. Ausgehend vom maximaler Bodydamage. 
Jeder hhere Damage-Wert muss also ein Headshot sein. Werte sind aufgerundet, um wirklich sicher zu sein, 
dass es sich um einen Headshot handelt. Naja, sind eben Annherungswerte.*/
#define MAX_WEAPONS	24
/*Pistolen*/
#define DEAGLE		80
#define GLOCK		40
#define USP		40
#define ELITE		40
#define FIVESEVEN	40
#define P228		40
/*Shotguns, unmglich mit Annherung genau den Headshot zu definieren.*/
#define M3		200
#define XM1014		200
/*SMG*/
#define MP5		36
#define P90		40
#define TMP		36
#define MAC		40
#define UMP40		45
/*Rifles*/
#define GALLIL		45
#define DEFENDER	45
#define AUG		50
#define SG552		50
#define AWP		155
#define M4A1		50
#define AK47		50
#define SCOUT		95
#define SG550		80
#define G3SG1		80
/*MG*/
#define M249		50

/*15.04.03 Weapon Arrays und Weapon Damage*/	
new g_WeaponName[MAX_WEAPONS][MAX_NAME_LENGTH]	=	{{"usp"},{"glock18"},{"deagle"},{"mp5navy"},{"gallil"},{"defender"},{"m4a1"},
							{"ak47"},{"awp"},{"aug"},{"sg552"},
							{"scout"},{"m249"},{"p90"},{"p228"},{"tmp"},{"mac10"},{"ump40"},{"fiveseven"},
							{"elite"},{"m3"},{"xm1014"},{"sg550"},{"g3sg1"}};
						
new g_WeaponDamage[MAX_WEAPONS][MAX_NUMBER_LENGTH]= 	{{USP},{GLOCK},{DEAGLE},{MP5},{GALLIL},{DEFENDER},{M4A1},
							{AK47},{AWP},{AUG},{SG552},{SCOUT},{M249},
							{P90},{P228},{TMP},{MAC},{UMP40},{FIVESEVEN},{ELITE},{M3},{XM1014},{SG550},
							{G3SG1}};

//////////////////////////////////////////////////////
/////// BEFEHLS- UND INSTALLATIONS-VERWALTUNG ////////
//////////////////////////////////////////////////////
/*Befehlsverwaltung fr admin_impressive*/
#define MAX_COMMANDS 	21
#define STATUS_PLUGIN		0
#define STATUS_DK		1
#define STATUS_DS		2
#define STATUS_LS		3
#define	STATUS_FB		4
#define STATUS_HS		5
#define STATUS_KS		6
#define STATUS_KST		7
#define STATUS_KK		8
#define STATUS_GK		9
#define STATUS_BS		10
#define STATUS_BP		11
#define STATUS_BD		12
#define STATUS_BG		13
#define STATUS_BT		14
#define STATUS_SBD		15
#define STATUS_FBD		16
#define STATUS_DB		17
#define STATUS_TH		18
#define STATUS_RC		19
#define STATUS_TA		20


new CommandName[MAX_COMMANDS][]={{"plugin"},{"dk"},{"ds"},{"ls"},{"fb"},{"hs"},{"ks"},{"kst"},
				{"kk"},{"gk"},{"bs"},{"bp"},{"bd"},{"bg"},{"bt"},{"sbd"},{"fbd"},{"db"},{"th"},{"rc"},{"ta"}};
				
new VaultCommandData[MAX_COMMANDS][]={{"IMP_PLUGIN"},{"IMP_DISPLAY_KILL"}, {"IMP_DISPLAY_SCORE"},{"IMP_LEADSOUNDS"},
				{"IMP_FIRSTBLOOD"},{"IMP_HEADSHOT"},{"IMP_KILLSTREAK"},{"IMP_KILLSTREAKTIME"},{"IMP_KNIFEKILL"},
				{"IMP_GRENADEKILL"},{"IMP_BOMBSPAWNED"},{"IMP_BOMBPLANT"},{"IMP_BOMBDROP"},
				{"IMP_BOMBGET"},{"IMP_BOMBTIMER"},{"IMP_STARTDEFUSE"},{"IMP_BOMBDEFUSED"},{"IMP_BOMBDET"},
				{"IMP_TOUCHHOSTAGE"},{"IMP_ROUNDCOUNTER"},{"IMP_TEAMATTACK"}};
				
new CommandText[MAX_COMMANDS][]={{"plugin: Das gesamte Plugin ist %s."},{"dk:^t Die Anzeige der Kills und Headshots ist %s."},
		{"ds:^t TeamScore- und Bester-Spieler-Anzeige ist %s."},{"ls:^t Fuehrungs-Sounds sind generell %s."},
		{"fb:^t 'First Blood' ist %s."},{"hs:^t Die Headshotsounds sind %s."},{"ks:^t Das Killstreak ist %s."},{"kst:^t Die Killzeit wurde auf %s Sekunden gesetzt."},
		{"kk:^t Knife Kill ist %s."},{"gk:^t Grenade Kill ist %s."},{"bs:^t Bomb Spawned ist %s."},{"bp:^t Bomb_Planted ist %s."},
		{"bd:^t Bomb-Dropped ist %s."},{"bg:^t Got-Bomb ist %s."},{"bt:^t Bomb-Timer ist %s"},
		{"sbd:^t Start Bomb defusing ist %s."},{"fbd:^t Bomb defused ist %s."},{"db:^t Bomb Detonation ist %s."},
		{"th:^t Touched-Hostage ist %s."},{"rc:^t Round-Counter ist %s."},{"ta:^t Team-Attack ist %s"}};

/*Alle Einstellungen des Plugins werden hier gespeichert*/
new STATUS_COMMAND[MAX_COMMANDS][1];
new killtime=3;

///////////////////////////////////////////////
/////// Die Frag- und Score Verwaltung ////////
///////////////////////////////////////////////

/*ZHLER*/
new FragCount[MAX_PLAYERS] = {CLEAN_SLATE,...}; 	/*dient zum Zhlen aller Kills*/
new KillCount[MAX_PLAYERS] = {CLEAN_SLATE,...}; 	/*dient zum Zhlen der Kills im Zeitlimit*/
new TimerIndex[MAX_PLAYERS] = {CLEAN_SLATE,...}; 	/*merkt sich den TimerIndex des Spielers, um die Zeit zu berwachen*/
new HeadCount[MAX_PLAYERS] = {CLEAN_SLATE,...};		/*dient zum Zhlen der Headshots*/
new KillCountAll[MAX_PLAYERS] = {CLEAN_SLATE,...}; 	/*dient zum Zhlen der gesamten Frags ber die gesamte Mapzeit*/

new ctscore [MAX_NUMBER_LENGTH];			/*speichert die Teamscore CT*/
new terrscore[MAX_NUMBER_LENGTH];			/*speichert die Teamscore T*/
new round=0;						/*speichert die Rundenzahl*/
new c4timer;						/*C4-Countdown*/

new SpielerID = 0;					/*speichert den UserIndex des besten Spielers der Runde*/
new SpielerIDBest =0;					/*speichert den UserIndex des besten Spielers der gesamten Mapzeit.*/
new MostFrags =0;					/*speichert die Anzahl der meisten Frags der gesamten Mapzeit.*/
new MostFrags2 =0;					/*wird nur benutzt, wenn der allerbeste Spieler den Server verlsst*/
new priority =0;					/*alle Sounds an den Spieler werden mit Prioritt 1 ausgefhrt.*/

////////////////////////////////////////////
/////// INITIALISIERUNG DES PLUGINS ////////
////////////////////////////////////////////

public plugin_init(){
	plugin_registerinfo("Impressive-Script","The ultimative Logd-Script: Announces headshots with sound and many more.",STRING_VERSION);
	plugin_registercmd("admin_impressive", "admin_impressive", ACCESS_BAN, "admin_impressive <CommandNo> <Foldername/Filename or Command> <0/1>:read manual");
	plugin_registercmd("say","HandleSay",ACCESS_ALL);
	
	/*HINZUGEFGT AM:09.09.02 :Server-Configuration wird berprft---Ergnzt am: 29.09.02*/
	new Text[MAX_TEXT_LENGTH];
	new Menuactiv[MAX_TEXT_LENGTH];
	new mp_logdetail;
	new error;
	new VaultIni[MAX_TEXT_LENGTH];
	getstrvar( "admin_vault_file", VaultIni, MAX_TEXT_LENGTH );
	mp_logdetail = getvar("mp_logdetail");
	if(mp_logdetail==0){
		error++;
		snprintf(Text,MAX_TEXT_LENGTH,"[Impressive Plugin] FATAL ERROR: mp_logdetail ist auf %i gesetzt => LogD NICHT funktionsfaehig",mp_logdetail);
		log(Text);
	}else{
		plugin_registercmd("im_connect", "im_connect", ACCESS_CONSOLE, "");
		plugin_registercmd("im_disconnect", "im_disconnect", ACCESS_CONSOLE, "");
		plugin_registercmd("im_suicide", "im_suicide", ACCESS_CONSOLE, "");
		plugin_registercmd("im_kill", "im_kill", ACCESS_CONSOLE, "");
		plugin_registercmd("im_injure", "im_injure", ACCESS_CONSOLE, "");
		plugin_registercmd("im_playeraction", "im_playeraction", ACCESS_CONSOLE, "");
		plugin_registercmd("im_showintheend", "im_showintheend", ACCESS_CONSOLE, "");
		plugin_registercmd("im_resetscore", "im_resetscore", ACCESS_CONSOLE, "");
		exec( "logd_reg 51 admin_command im_connect" );
		exec( "logd_reg 52 admin_command im_disconnect" );
		exec( "logd_reg 53 admin_command im_suicide" );
		exec( "logd_reg 57 admin_command im_kill" );
		exec( "logd_reg 58 admin_command im_injure" );
		exec( "logd_reg 60 admin_command im_playeraction" ); 
		exec( "logd_reg 61 admin_command im_showintheend" );
		exec( "logd_reg 62 admin_command im_resetscore");
		snprintf(Text,MAX_TEXT_LENGTH,"[Impressive Plugin] LogD-Funktionen aktiviert");
		log(Text);
	}
	if(mp_logdetail <3){
		error++;
		snprintf(Text,MAX_TEXT_LENGTH,"[Impressive Plugin] mp_logdetail nicht auf 3 => Keine Headshot-Sounds moeglich.",mp_logdetail);
		log(Text);
	}
	if(!getvar("allow_client_exec")){
		error++;
		snprintf(Text,MAX_TEXT_LENGTH,"[Impressive Plugin] allow_exec_client nicht gesetzt => Client darf keine Sounds abspielen");
		log(Text);
	}
	getstrvar( "amv_enable_beta", Menuactiv, MAX_TEXT_LENGTH );
	if(strstrx(Menuactiv,"menu1")!=-1){
		menuenabled=1;
		log("[Impressive Plugin] Erweiterte Scoreanzeige nutzbar!");
	}else{
		menuenabled=0;
		log("[Impressive Plugin] Erweiterte Scoreanzeige nicht nutzbar!(amv_enable_beta 'menu1' fehlt)");
	}
	/*Alle Daten werden aus der vault.ini eingelesen, wenn sie nicht existieren, werden sie gesetzt und/oder Fehlermeldung*/
	if(!fileexists(VaultIni)){
		error++;
		snprintf(Text,MAX_TEXT_LENGTH,"[Impressive Plugin] FATAL ERROR: 'admin_vault_file' nicht gesetzt oder gefunden!");
		log(Text);
	}else{
		new i;
		for(i=0;i<MAX_COMMANDS;i++){
			get_vaultnumdata(VaultCommandData[i],STATUS_COMMAND[i][0]);
			if(i==STATUS_KST){
				killtime=STATUS_COMMAND[i][0];
			}
			if(strlen(STATUS_COMMAND[i])==0){
				error++;
				snprintf(Text,MAX_TEXT_LENGTH,"[Impressive Plugin] vault.ini: %s nicht gesetzt!",VaultCommandData[i]);
			}else{
				snprintf(Text,MAX_TEXT_LENGTH,"[Impressive Plugin] Status: %s -- %i ",VaultCommandData[i],STATUS_COMMAND[i][0]);
			}
			log(Text);
		}
		
		new Vault[MAX_NAME_LENGTH];	
		for(i=1;i<=ALL_SOUNDS;i++){
			snprintf(Vault,MAX_NAME_LENGTH,"IMP_SOUND_%i",i);
			get_vaultdata(Vault,IMP_SOUND[i-1],MAX_TEXT_LENGTH);
			if(!fileexists(IMP_SOUND[i-1])){
				error++;
				snprintf(Text,MAX_TEXT_LENGTH,"[Impressive Plugin] Wave Datei %s wurde nicht gefunden!",IMP_SOUND[i-1]);
				log(Text);
			}	
		}
	}
	if(error>=1){
		snprintf(Text,MAX_TEXT_LENGTH,"[Impressive Plugin] Es sind %i Fehler aufgetreten =>Impressive Plugin nicht voll funktionsfaehig.",error);
		log(Text);
	}else{
		snprintf(Text,MAX_TEXT_LENGTH,"[Impressive Plugin] Impressive Plugin erfolgreich initialisiert!(Wenn Log-File vorhanden!)");
		log(Text);
	}
	return PLUGIN_CONTINUE;
}

////////////////////////////////////
/////// ADMINMOD-FUNKTIONEN ////////
////////////////////////////////////

/*GENDERT AM:09-09-02, Verwaltung des Plugins*/
public admin_impressive(HLCommand,HLData,HLUserName,UserIndex) {
	new Data[MAX_DATA_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new Number[MAX_NUMBER_LENGTH];
	new Commandname[MAX_TEXT_LENGTH];
	new CommandParam[MAX_NUMBER_LENGTH];
	new Vaultini[MAX_DATA_LENGTH];
	new Value[MAX_TEXT_LENGTH];
	new Value1[12];
	new iNumber;
	new i;
	new iCommandParam;
	
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	
	strbreak(Data,Number,Commandname,MAX_TEXT_LENGTH);
	strbreak(Commandname,Commandname,CommandParam,MAX_TEXT_LENGTH);
	iNumber=strtonum(Number);
	if(iNumber>ALL_SOUNDS){
		selfmessage("Die Befehlsnummer existiert nicht!!");
		return PLUGIN_HANDLED;
	}
	selfmessage("=================== IMPRESSIVE-PLUGIN ==========================");
	selfmessage("* PLUGIN-SETTINGS: admin_impressive 0 'Befehl' 'Wert'");
	selfmessage("* SOUND-SETTINGS: admin_impressive 1-x 'Pfadangabe/sound.wav'");
	selfmessage("================================================================");
	if(iNumber==0){
		if(strlen(Commandname)!=0){
			for(i=0; i<MAX_COMMANDS;i++){
				if(strcmp(Commandname,CommandName[i])==0){
					iCommandParam = strtonum(CommandParam);
					if(i!=STATUS_KST && iCommandParam >1){
						iCommandParam = 1;
					}
					if(i==STATUS_KST){ // bei killtime Sonderbehandlung, sollten weitere Flle auftreten -> switch/case Statement
						if(iCommandParam>9){
							iCommandParam = 9;
						}
						killtime = iCommandParam;
					}
					set_vaultnumdata(VaultCommandData[i],iCommandParam);
					break; 
				} 
			}
		}
		selfmessage("BEFEHL:	 STATUS:");
		for(i=0;i<MAX_COMMANDS;i++){
			get_vaultnumdata(VaultCommandData[i],STATUS_COMMAND[i][0]);
			if(i==STATUS_KST){
				killtime=STATUS_COMMAND[i][0];
				snprintf(Value1,15,"%i",killtime);
			}else{
				if(STATUS_COMMAND[i][0]!=0){
					snprintf(Value1,12,"AKTIVIERT");
				}else{
					snprintf(Value1,12,"DEAKTIVIERT");
				}
			}
			snprintf(Value,MAX_TEXT_LENGTH,CommandText[i],Value1);
			snprintf(Text,MAX_TEXT_LENGTH,"* %s",Value);
			selfmessage(Text);
		}
	}else{
		snprintf(Vaultini,MAX_DATA_LENGTH,"IMP_SOUND_%i",iNumber);
		if(strlen(Commandname)==0){
			set_vaultdata(Vaultini,"");
			snprintf(Text,MAX_TEXT_LENGTH,"IMP_SOUND_%i wurde DEAKTIVIERT",iNumber);
		}else{
			if(fileexists(Commandname)){
				set_vaultdata(Vaultini,Commandname);
				snprintf(Text,MAX_TEXT_LENGTH,"IMP_SOUND_%i wurde auf %s gesetzt",iNumber,Commandname);
			}else{
				snprintf(Text,MAX_TEXT_LENGTH,"[Impressive Plugin] Datei %s konnte auf dem Server nicht gefunden werden.",Commandname);
			}
		}
		selfmessage(Text);
		selfmessage("");
		selfmessage("VAULT.INI:        PFADANGABE:");
		for(i=1;i<=ALL_SOUNDS;i++){
			if(i==1){
				selfmessage("* HEADSHOT-SOUNDS:");
			}else if(i==4){
				selfmessage("* FRAGS-IN-TIME-SOUNDS:");
			}else if(i==7){
				selfmessage("* FRAGS-BY-NUMBER-SOUNDS:");
			}else if(i==10){
				selfmessage("* FIRSTBLOOD-SOUND:");
			}else if(i==11){
				selfmessage("* LEAD-SOUNDS:(Taken,Lost,Tied)");
			}else if(i==14){
				selfmessage("* TEAM-ATTACK-SOUND:");
			}else if(i==15){
				selfmessage("* KNIFEKILL-SOUND:");
			}else if(i==16){
				selfmessage("* GRENADEKILL-SOUND:");
			}else if(i==17){
				selfmessage("* ROUND-COUNTER-SOUND:");
			}else if(i==18){
				selfmessage("* BOMB-SOUNDS (Spawn,Plant,Drop,Get,Bomb-Timer,Detonate,Begin_Defuse,Bomb_Defused):");
			}else if(i==26){
				selfmessage("* TOUCH-HOSTAGE-SOUND:");
			}
			snprintf(Vaultini,MAX_DATA_LENGTH,"IMP_SOUND_%i",i);
			get_vaultdata(Vaultini,Commandname,MAX_TEXT_LENGTH);
			snprintf(Text,MAX_TEXT_LENGTH,"* IMP_SOUND_%i %s",i,Commandname);
			strcpy(IMP_SOUND[i-1],Commandname,MAX_TEXT_LENGTH);
			selfmessage(Text);
			strinit(Commandname);
		}
	}
	selfmessage("================== (c) by Sir Drink a lot ========================");
	return PLUGIN_HANDLED;
}

/*16.04.03: Bei der Chat-Eingabe 'score' wird die Score-Anzeige aktiviert.*/
/*29.01.03: plugin_sdal_allowsounds reagiert jetzt auf die chateingaben 'stop' und 'play'*/
public HandleSay(HLCommand,HLData,HLUserName,UserIndex){
	if(STATUS_COMMAND[STATUS_DS][0]!=0 && STATUS_COMMAND[STATUS_PLUGIN][0]!=0){
		new Data[MAX_DATA_LENGTH];
		new User[MAX_NAME_LENGTH];
		convert_string(HLData,Data,MAX_DATA_LENGTH);
		convert_string(HLUserName,User,MAX_DATA_LENGTH);
		strstripquotes(Data);
		if (strcasecmp(Data, "score")==0){
			show_stats(User);
		}
	}
        return PLUGIN_CONTINUE;
}

/* Nullung der SpielerIndex-Arrays und Neuberechnung des besten Spielers*/
public plugin_connect(HLUserName,HLIP, UserIndex){
	if (UserIndex >= 1 && UserIndex <= MAX_PLAYERS) {
		reset_playerarray(UserIndex);
		
	}	
	return PLUGIN_CONTINUE;
}

public plugin_disconnect(HLUserName,UserIndex){
	new loop;
	new maxplayers=maxplayercount();
	new Name[MAX_NAME_LENGTH];
	new a;
	new dummy;
	if (UserIndex >= 1 && UserIndex <= MAX_PLAYERS) {
		reset_playerarray(UserIndex);
		/*MenuID[UserIndex]=0;*/
		if(SpielerID == UserIndex){
			SpielerID =0;
		}
		/*Wenn der allerbeste Spieler den Server verlsst, muss ein neue beste Score und evt. Spieler gefunden werden!!*/
		if(SpielerIDBest==UserIndex){
			for(loop=1;loop <=maxplayers;loop++){
				if(loop!=UserIndex){
					if(KillCountAll[loop]>=MostFrags2){
						MostFrags2=KillCountAll[loop];
					}
				}
			}
			/*ERGNZT AM:10-09-02, berprft, ob es nur einen neuen besten Spieler gibt*/
			for(loop=1;loop<=maxplayers;loop++){
				if(KillCountAll[loop]==MostFrags2){
					a++;/*Dient als Identifizierung, ob es nur einen besten Spieler gibt!*/
					SpielerIDBest=loop;
				}
			}
			if(a==1){
				if(STATUS_COMMAND[STATUS_LS][0]!=0){
					if(playerinfo(SpielerIDBest,Name,MAX_NAME_LENGTH,dummy,dummy,dummy,dummy)){
						soundplayer(TextMessage[TAKENLEAD],IMP_SOUND[TAKENLEAD],Name,TAKENLEAD);
					}
				}
			}else{
				SpielerIDBest=0;
			}	
			MostFrags=MostFrags2;
			MostFrags2=0;
		}
	}
	return PLUGIN_CONTINUE;
}

//////////////////////////////////////////////
/////// LOGD-FUNKTIONEN NACH EVENT-NR ////////
//////////////////////////////////////////////

/*29.01.03: Eigenes Plugin fr die Enter-Meldung geschrieben: plugin_sdal_allowsounds*/
/*18.11.02: Array-Nullung auch nochmal hier eingefgt.*/
public im_connect(HLCommand,HLUserIndex){
	new UserIndex;
	new strUserIndex[MAX_NAME_LENGTH];
	convert_string(HLUserIndex, strUserIndex, MAX_NAME_LENGTH);
	UserIndex=strtonum(strUserIndex);
	reset_playerarray(UserIndex);
	return PLUGIN_CONTINUE;
}

/*13.04.03 Nochmal die Logd Disconnect Funktion zur Sicherheit*/
public im_disconnect(HLCommand,HLUserIndex){
	new UserIndex;
	new strUserIndex[MAX_NAME_LENGTH];
	convert_string(HLUserIndex, strUserIndex, MAX_NAME_LENGTH);
	UserIndex=strtonum(strUserIndex);
	reset_playerarray(UserIndex);
	return PLUGIN_CONTINUE;
}

/*ERSTELLT AM:10-09-02, Selbstmorde erkennen und evt. neuen bester Spieler erkennen*/
public im_suicide(HLCommand,HLData){
	new Data[MAX_DATA_LENGTH];
	new UserIndex[MAX_NUMBER_LENGTH];
	new Weapon[MAX_NAME_LENGTH];
	new Name[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new iUserIndex;
	new dummy;
	new WONID;
	new loop;
	new maxplayers=maxplayercount();
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	
	strsplit(Data," ",UserIndex,MAX_NUMBER_LENGTH,Weapon,MAX_NAME_LENGTH);

	iUserIndex=strtonum(UserIndex);
	/*Selbstmord mit 'worldspawn' gibt keinen Fragabzug*/
	if(strcmp(Weapon,"world")==0 || strcmp(Weapon,"grenade")==0){
		if(playerinfo(iUserIndex,Name,MAX_NAME_LENGTH,dummy,dummy,WONID,dummy)){
			snprintf(Text,MAX_TEXT_LENGTH,"%s beging Selbstmord",Name,Weapon);
			if(STATUS_COMMAND[STATUS_TA][0]==1){
				soundall(Text,IMP_SOUND[PAYATTENTION],Name,PAYATTENTION);
			}
			KillCountAll[iUserIndex]-= 1;
			if(SpielerIDBest == iUserIndex){
				MostFrags--;
				for(loop=1;loop<=maxplayers;loop++){
				/*Darf nicht mit Fhrenden selber vergeleichen :-) */
					if((KillCountAll[loop]==MostFrags) && (iUserIndex != loop)){
						if(STATUS_COMMAND[STATUS_LS][0]!=0){
							soundplayer(TextMessage[LOSTLEAD],IMP_SOUND[LOSTLEAD],Name,LOSTLEAD);
						}
						SpielerIDBest=0;
						break;
					}
				}
                        }
		}
	}
	return PLUGIN_CONTINUE;
}

public im_kill( HLCommand,HLData,HLUserName,UserIndex ){
	new Data[MAX_DATA_LENGTH];
	new Attacker[MAX_NAME_LENGTH];
	new Victim[MAX_NAME_LENGTH]; 
	new Weapon[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new iIDA;
	new iIDV;
	new iTeamA;
        new iTeamV;
	new dummy1;
	new loop;
	new maxplayers=maxplayercount();

	convert_string( HLData, Data, MAX_DATA_LENGTH ); 

	strsplit(Data," ",Attacker,MAX_NAME_LENGTH,Victim,MAX_NAME_LENGTH,Weapon,MAX_NAME_LENGTH); 

	iIDV 	=strtonum(Victim);
	iIDA 	=strtonum(Attacker);
	
	/*Frags werden gezhlt.*/
	if(playerinfo(iIDA, Attacker, MAX_NAME_LENGTH,dummy1,dummy1, iTeamA,dummy1)){
                if(playerinfo(iIDV, Victim, MAX_NAME_LENGTH,dummy1,dummy1,iTeamV,dummy1)){
                        if(iTeamV != iTeamA){
				KillCount[iIDA] +=1;
				FragCount[iIDA] +=1;
				KillCountAll[iIDA] +=1;
				/*First Blood Analyse*/
				if(STATUS_COMMAND[STATUS_FB][0]!=0){
					if(SpielerID == 0){
						snprintf(Text,MAX_TEXT_LENGTH,TextMessage[FIRSTBLOOD],Attacker);
						soundall(Text,IMP_SOUND[FIRSTBLOOD],Attacker,FIRSTBLOOD);
					}
				}
				/*wenn die zeitunabhngigen Killstreak-Sounds erlaubt sind*/
				if(STATUS_COMMAND[STATUS_KS][0]!=0){
					imp_killstreak(Attacker,iIDA);
				}
				/*wenn die Zeitabhngigen Killstreak-Sounds erlaubt sind*/
				if(STATUS_COMMAND[STATUS_KST][0]!=0){
					if(TimerIndex[iIDA]==0){
						TimerIndex[iIDA]=set_timer("imp_killstreaktime",killtime,0,Attacker);
					}
				}
				/*wenn die Maplead-Sounds erlaubt sind*/
				if(STATUS_COMMAND[STATUS_LS][0]!=0){
					imp_MapLeader(Attacker,iIDA);
				}
				/*15.04.03: Messer oder Grenade Analyse*/
				if(strcmp(Weapon,"knife")==0 && STATUS_COMMAND[STATUS_KK][0]!=0 ){
					snprintf(Text,MAX_TEXT_LENGTH,TextMessage[KNIFEKILL],Attacker,Victim);
					soundall(Text,IMP_SOUND[KNIFEKILL],Attacker,KNIFEKILL);
				}else if (strcmp(Weapon,"grenade")==0 && STATUS_COMMAND[STATUS_GK][0]!=0){
					snprintf(Text,MAX_TEXT_LENGTH,TextMessage[GRENKILL],Attacker,Victim);
					soundall(Text,IMP_SOUND[GRENKILL],Attacker,GRENKILL);
				}
                        }else{
                        	KillCount[iIDA] -=1;
				FragCount[iIDA] -=1;
				KillCountAll[iIDA] -=1;
				/*GENDERT AM:10-09-02, Vergleich jetzt mit MostFrags anstatt mit KillCountAll[iIDA]*/
				/*Wenn der Fhrende einen TK gemacht hat und nun nicht mehr der Fhrenden ist*/
				if(SpielerIDBest == iIDA){
					MostFrags--;
					for(loop=1;loop<=maxplayers;loop++){
					/*Darf nicht mit Fhrenden selber vergeleichen :-) */
						if(((KillCountAll[loop]==MostFrags) && (iIDA != loop))){
							if(STATUS_COMMAND[STATUS_LS][0]!=0){
								soundplayer(TextMessage[LOSTLEAD],IMP_SOUND[LOSTLEAD],Attacker,LOSTLEAD);
							}
							SpielerIDBest=0;
							break;
						}
					}
				}
			}		
                }
        }
	/*Best Player-Analyse fr die Runde*/
	if(FragCount[iIDA] > FragCount[SpielerID]){
		SpielerID = iIDA;
	}
	return PLUGIN_CONTINUE;
}

public im_injure( HLCommand,HLData,HLUserName,UserIndex ){
	new Attacker[MAX_NAME_LENGTH];
	new Victim[MAX_NAME_LENGTH]; 
	new Weapon[MAX_NAME_LENGTH];
	new Damage[MAX_NUMBER_LENGTH];
	new Rest_Health[MAX_NUMBER_LENGTH];
	new dummy[MAX_NAME_LENGTH];
	new Rest[MAX_DATA_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new iIDD;
	new iDH;
	new iIDA;
	new iIDV;
	new dummy1;
	new iTeamA;
        new iTeamV;
	new i;
			
	convert_string( HLData, Data, MAX_DATA_LENGTH ); 
	
	strsep(Data," ",Attacker,MAX_NAME_LENGTH,Victim,MAX_NAME_LENGTH,Weapon,MAX_NAME_LENGTH,Rest,MAX_DATA_LENGTH); 
	strsplit(Rest," ",Damage,MAX_NUMBER_LENGTH,dummy,MAX_NAME_LENGTH,Rest_Health,MAX_NUMBER_LENGTH,dummy,MAX_NAME_LENGTH);
	strsplit(Damage,"#",dummy,MAX_NAME_LENGTH,Damage,MAX_NUMBER_LENGTH);
	strsplit(Rest_Health,"#",dummy,MAX_NAME_LENGTH,Rest_Health,MAX_NUMBER_LENGTH);
	
	iIDD 	=strtonum(Damage);
	iDH 	=strtonum(Rest_Health);
	iIDA 	=strtonum(Attacker);
	iIDV 	=strtonum(Victim);
	
	/*Um einen Sound abzugeben, wenn man den Teamkollegen trifft*/
	if(STATUS_COMMAND[STATUS_TA][0]!=0){
		if(playerinfo(iIDA, Attacker, MAX_NAME_LENGTH,dummy1,dummy1, iTeamA,dummy1)){
	                if(playerinfo(iIDV, Victim, MAX_NAME_LENGTH,dummy1,dummy1,iTeamV,dummy1)){
				/*GENDERT AM:10-09-02, nderung, damit nicht auch bei Selbstdamage die Warnung kommt!*/
	                        if(iTeamV == iTeamA && iIDA != iIDV){
					soundplayer(TextMessage[PAYATTENTION],IMP_SOUND[PAYATTENTION],Attacker,PAYATTENTION);				
				}
			}
		}
	}
	/*Headshot-Analyse*/
	if(STATUS_COMMAND[STATUS_HS][0]!=0){
		if( iDH <=0 ){
			for(i=0;i<MAX_WEAPONS;i++){
				if (strcmp(Weapon,g_WeaponName[i])==0 && iIDD >= g_WeaponDamage[i][0]){
					imp_HeadSounds(Attacker,iIDA);
					break;
				}
			}
		}
	}
	return PLUGIN_CONTINUE;
}

/*15.04.03: Spawned with the bomb hinzugefgt*/
public im_playeraction(HLCommand,HLData,HLUserName,UserIndex){
	if(STATUS_COMMAND[STATUS_PLUGIN][0]!=0){
		new Data[MAX_DATA_LENGTH];
		new Name[MAX_NAME_LENGTH];
		new Player[MAX_NAME_LENGTH];
		new Text[MAX_TEXT_LENGTH];
		new Authid[MAX_AUTHID_LENGTH];
		new sAID[3];
		new iAID;
		new dummy;
		new iTeam1;
		new iTeam2;
		new i;
		new maxplayers=maxplayercount();
			
		convert_string(HLData, Data, MAX_DATA_LENGTH); 
		strbreak(Data, sAID, Data, MAX_DATA_LENGTH);
			
		iAID=strtonum(sAID);
		playerinfo(iAID,Name,MAX_NAME_LENGTH,dummy,dummy,iTeam1,dummy);
		
		
		if(strcmp(Data, "Spawned_With_The_Bomb") == 0) {
			if(STATUS_COMMAND[STATUS_BS][0]!=0){
				snprintf(Text,MAX_TEXT_LENGTH,TextMessage[BOMBSPAWNED],Name);
				soundplayer(Text,IMP_SOUND[BOMBSPAWNED],Name,BOMBSPAWNED);
				glow(Name,250,10,10);
				set_timer("glow_off",10,0,Name);
				/*Text-Ausgabe ans ganze Team*/
				for(i=1;i<=maxplayers;i++){
					playerinfo(i,Player,MAX_NAME_LENGTH,dummy,dummy,iTeam2,dummy,Authid);
					if(iTeam1==iTeam2){
						if(strcmp(Authid,"BOT")!=0){
							soundplayer(Text,"0",Player,BOMBSPAWNED);
						}
					}
				}
			}
		}else if(strcmp(Data, "Planted_The_Bomb") == 0) {
			if(STATUS_COMMAND[STATUS_BP][0]!=0){	
				snprintf(Text,MAX_TEXT_LENGTH,TextMessage[PLANTBOMB],Name);
				soundall(Text,IMP_SOUND[PLANTBOMB],Name,PLANTBOMB);
			}
			new c4timerorig;
			new wait;
			c4timerorig=getvar("mp_c4timer");
			if(c4timerorig>=30){
				wait=c4timerorig-30;
				c4timer=30;
			}else if(c4timerorig>=20 && c4timerorig<30){
				wait=c4timerorig-20;
				c4timer=20;
			}
			set_timer("imp_bombtimer",wait,0);
		}else if(strcmp(Data, "Dropped_The_Bomb") == 0) {
			if(STATUS_COMMAND[STATUS_BD][0]!=0){	
				snprintf(Text,MAX_TEXT_LENGTH,TextMessage[DROPBOMB],Name);
				soundplayer(Text,IMP_SOUND[DROPBOMB],Name,DROPBOMB);
				for(i=1;i<=maxplayers;i++){
					playerinfo(i,Player,MAX_NAME_LENGTH,dummy,dummy,iTeam2,dummy,Authid);
					if(iTeam1==iTeam2){
						if(strcmp(Authid,"BOT")!=0){
							soundplayer(Text,IMP_SOUND[DROPBOMB],Player,DROPBOMB);
						}
					}
				}
			}
		}else if(strcmp(Data, "Got_The_Bomb") == 0) {
			if(STATUS_COMMAND[STATUS_BG][0]!=0){
				snprintf(Text,MAX_TEXT_LENGTH,TextMessage[GOTBOMB],Name);
				soundplayer(Text,IMP_SOUND[GOTBOMB],Name,GOTBOMB);
				for(i=1;i<=maxplayers;i++){
					playerinfo(i,Player,MAX_NAME_LENGTH,dummy,dummy,iTeam2,dummy,Authid);
					if(iTeam1==iTeam2){
						if(strcmp(Authid,"BOT")!=0){
							soundplayer(Text,"0",Player,GOTBOMB);
						}
					}
				}
			}
		}else if(strcmp(Data, "Touched_A_Hostage") == 0) {
			if(STATUS_COMMAND[STATUS_TH][0]!=0){
				snprintf(Text,MAX_TEXT_LENGTH,TextMessage[TOUCHEDHOSTAGE],Name);
				soundall(Text,IMP_SOUND[TOUCHEDHOSTAGE],Name,TOUCHEDHOSTAGE);
			}
		}else if(strncmp(Data, "Begin_",6) == 0) {
			if(STATUS_COMMAND[STATUS_SBD][0]!=0){
				soundplayer("Good Luck!",IMP_SOUND[BOMBDEFUSE],Name,PAYATTENTION);
				for(i=1;i<=maxplayers;i++){
					playerinfo(i,Player,MAX_NAME_LENGTH,dummy,dummy,iTeam2,dummy,Authid);
					if(iTeam1==iTeam2){
						if(strcmp(Authid,"BOT")!=0){
							snprintf(Text,MAX_TEXT_LENGTH,TextMessage[BOMBDEFUSE],Name);
							soundplayer(Text,"0",Player,BOMBDEFUSE);
						}
					}
				}
			}
		}else if(strcmp(Data, "Defused_The_Bomb") == 0) {
			if(STATUS_COMMAND[STATUS_FBD][0]!=0){
				snprintf(Text,MAX_TEXT_LENGTH,TextMessage[DEFUSEDBOMB],Name);
				soundall(Text,IMP_SOUND[DEFUSEDBOMB],Name,DEFUSEDBOMB);
			}
		}
		
		
	}			
	return PLUGIN_CONTINUE;
}

public im_showintheend(HLCommand,HLData,HLUserName,UserIndex){
	if(STATUS_COMMAND[STATUS_DS][0]!=0 && STATUS_COMMAND[STATUS_PLUGIN][0]!=0){
		new Data1[MAX_DATA_LENGTH];                                
	        new Data2[MAX_DATA_LENGTH];  
	        new Params[MAX_DATA_LENGTH];
		new dummy[MAX_DATA_LENGTH];
	        new Name[MAX_NAME_LENGTH];
		new Text[MAX_TEXT_LENGTH];
		new dummy1;
		new i;
		new maxplayers=maxplayercount();
		new Authid[MAX_AUTHID_LENGTH];
		
		convert_string(HLData,Params,MAX_DATA_LENGTH);
	                    
	        strbreak(Params,Data1,Data2,MAX_DATA_LENGTH);
		strsplit(Data2, "# " ,dummy,MAX_DATA_LENGTH,dummy,MAX_DATA_LENGTH,ctscore,MAX_NUMBER_LENGTH,dummy,MAX_DATA_LENGTH,terrscore,MAX_NUMBER_LENGTH);
		
	        if(strmatch(Data1, "CT", strlen("CT")) || strmatch(Data1, "TERRORIST", strlen("TERRORIST"))){
			if(menuenabled==1 && vote_allowed()==1){
				for(i=1;i<=maxplayers;i++){
					if(playerinfo(i,Name,MAX_NAME_LENGTH,dummy1,dummy1,dummy1,dummy1,Authid)){
						if(strcmp(Authid,"BOT")!=0){
							if(allowsound(Name)){
								show_stats(Name);
							}
						}
					}
				}
			}else{
				if(SpielerID!=0){
					if(playerinfo(SpielerID,Name,MAX_NAME_LENGTH,dummy1,dummy1,dummy1,dummy1)){
						snprintf(Text,MAX_TEXT_LENGTH,"T:%s-CT:%s Best in round:^n%s^nwith %i Frags and %i Hs",terrscore,ctscore,Name,FragCount[SpielerID],HeadCount[SpielerID]);
					}
				}else{
					snprintf(Text,MAX_TEXT_LENGTH,"T:%s - CT:%s^nNo best player available for this round!",terrscore,ctscore);
				}
				typesay(Text,12,47,74,206);
			}
			SpielerID=0;
			c4timer=999;
		}
	}
        return PLUGIN_CONTINUE;
}

public im_resetscore(HLCommand,HLData,HLUserName,UserIndex,Param){
	new loop;
	new Data[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new Dummy[MAX_NAME_LENGTH];
	new Number[MAX_NUMBER_LENGTH];
	convert_string(HLData,Data,MAX_NAME_LENGTH);
	/*Bitweiser Vergleich (ab 0):Restart_'R'ound -> 8 = R, ERGNZT AM:10.09.02, 'G'ame_Commencing = 0*/
	if(Data[8]=='R' || Data[0]=='G'){
		for( loop = 0; loop < MAX_PLAYERS; loop ++) {
			KillCountAll[loop]=CLEAN_SLATE;
		}
		SpielerIDBest=0;
		MostFrags=0;
		round = 0;
		c4timer=999;
	}else if(Data[6]=='S') {
		for( loop = 0; loop < MAX_PLAYERS; loop ++) {
			KillCount[loop] = CLEAN_SLATE;
			TimerIndex[loop]=CLEAN_SLATE;
			FragCount[loop]=CLEAN_SLATE;
			HeadCount[loop]=CLEAN_SLATE;
		}
		SpielerID=0;
		round++;
		c4timer=999;
		if(STATUS_COMMAND[STATUS_PLUGIN][0]!=0){
			if(STATUS_COMMAND[STATUS_RC][0]!=0){
				snprintf(Text,MAX_TEXT_LENGTH,TextMessage[PREPAREFIGHT],round);
				soundall(Text,IMP_SOUND[PREPAREFIGHT],Dummy,PREPAREFIGHT);
				numtoword(round,Number,MAX_NUMBER_LENGTH);
				snprintf(Text,MAX_TEXT_LENGTH,"round %s",Number);
				speak_number(Text);
			}
		}
	}
	return PLUGIN_CONTINUE;
}

/////////////////////////////////
/////// HILFS-FUNKTIONEN ////////
/////////////////////////////////

/*------------------------------*/
/*---- ALLES WAS MIT SOUND -----*/
/*---- UND DISPLAY ZU TUN  -----*/
/*----          HAT        -----*/
/*--------------------------------*/

/*Check, ob Client die Sounds hren will*/
public allowsound(User[]){
	new Info[MAX_NUMBER_LENGTH];
	new iInfo;
	new Authid[MAX_AUTHID_LENGTH];
	get_userAuthID(User,Authid,MAX_AUTHID_LENGTH);
	if(strcmp(Authid,"BOT")!=0){
		get_userinfo(User,Key,Info,MAX_NUMBER_LENGTH);
		iInfo=strtonum(Info);
		if(strlen(Info)==0 || iInfo > 0){/*damit wird automatisch immer der Sound auf 1 gesetzt,wenn kein setinfo vorhanden, bis 'stop' eingegeben wird*/
			return 1;
		}
	}
	return 0;
}
/*Sound- und Textausgabe, wenn es an alle Spieler auf dem Server gehen soll*/
soundall(Text[],Sound[],Attacker[],ID){
	if(STATUS_COMMAND[STATUS_PLUGIN][0]==0){
		return PLUGIN_CONTINUE;
	}
	new Name[MAX_NAME_LENGTH];
	new maxplayers = maxplayercount();
	new Authid[MAX_AUTHID_LENGTH];
	
	if(strcmp(Sound,"0")!=0){
		for( new i = 1; i <= maxplayers; i++ ){
			if( playerinfo(i, Name, MAX_NAME_LENGTH,_,_,_,_,Authid) ){
				//if its not a bot
				if(strcmp(Authid,"BOT")!=0){
				/*wenn der Spieler es erlaubt*/
					if(allowsound(Name)){
						if(priority==0){ 
							playsound(Name,Sound);
						}else{
							if(strcmp(Attacker,Name)!=0){
								playsound(Name,Sound);
							}
						}
					}
				}
			}
		}
	}
	if(STATUS_COMMAND[STATUS_DK][0]!=0 || ID>=PAYATTENTION){
		typesay(Text,12,random(255),random(255),random(255));
	}
	return PLUGIN_CONTINUE;
}
  
/*15.04.03: soundplayer(...) als Hilfsfunktion eingefgt*/
soundplayer(Text[],Sound[],Attacker[],ID){
	if(STATUS_COMMAND[STATUS_PLUGIN][0]==0){
		return PLUGIN_CONTINUE;
	}
	
	
	new Authid[MAX_AUTHID_LENGTH];
	priority=1;
	get_userAuthID(Attacker,Authid,MAX_AUTHID_LENGTH);
	if(strcmp(Authid,"BOT")!=0){
		if(allowsound(Attacker)){
			if(strcmp(Sound,"0")!=0){
				playsound(Attacker,Sound);
			}
			if(STATUS_COMMAND[STATUS_DK][0]!=0 && strlen(Text)!=0){
				messageex(Attacker,Text,print_tty);
			}
		}else if(ID==PAYATTENTION && strlen(Text)!=0){
			messageex(Attacker,Text,print_tty);
		}
	}
	priority=0;
	return PLUGIN_CONTINUE;
}

/*17.04.03: Um die Zahl + Text auszusprechen. Big THX an SR71GOKU*/
speak_number(Speak[]) {
	new Output[MAX_TEXT_LENGTH];
	new maxplayers=maxplayercount();
	new Target[MAX_NAME_LENGTH];
	new SessionID,WONID,Team,Dead;
	new Authid[MAX_AUTHID_LENGTH];
	new i;
	
	snprintf(Output,MAX_TEXT_LENGTH,"vox/%s",Speak);
	for(i=1; i<=maxplayers; i++) {
		strinit(Target);
		if(playerinfo(i,Target,MAX_NAME_LENGTH,SessionID,WONID,Team,Dead,Authid)==1) {
			if(strcmp(Authid,"BOT")!=0 && allowsound(Target)==1 ){
				speakto(Target,Output);
			}
		}
	}
	return PLUGIN_CONTINUE;
}

/*--------------------------------*/
/*---- DIE FRAG UND HEADSHOT -----*/
/*----       ANALAYSEN	     -----*/
/*--------------------------------*/

/*Die Headshot-Sounds-Analyse*/
imp_HeadSounds(Attacker[],iIDA){
	new Text[MAX_TEXT_LENGTH];
	new a;
	/*Headshots werden gezhlt*/
	HeadCount[iIDA]+=1;
	/*Zuflliger Headshotsound wird ausgewhlt*/
	a= random(3);
	snprintf(Text,MAX_TEXT_LENGTH,TextMessage[a],Attacker);
	soundall(Text,IMP_SOUND[a],Attacker,a);
}

/*19.04.03: Die MapLead-Analyse, Firstblood entfernt*/
imp_MapLeader( Attacker[],iIDA ){
	new Text[MAX_TEXT_LENGTH];
	new Victim[MAX_NAME_LENGTH];
	new dummy1;
	/*"Taken the lead", "Lost the lead" und "tied for the lead"-Gesamte Mapzeit-Analyse*/
	/*Der beste Spieler der gesamten Mapzeit wird ermittelt*/
	
	/*Gleichstand an Frags und kein bester Spieler mehr vorhanden*/
	if(KillCountAll[iIDA] == MostFrags){
		if(SpielerIDBest != iIDA){ /*Den Fhrenden ausschlieen*/
			soundplayer(TextMessage[TIEDLEAD],IMP_SOUND[TIEDLEAD],Attacker,TIEDLEAD);
			/*Wenn es einen Fhrenden gab, ist er es nun nicht mehr, da Gleichstand eingetreten.*/
			if(SpielerIDBest!=0){
				playerinfo(SpielerIDBest,Victim,MAX_NAME_LENGTH,dummy1,dummy1,dummy1,dummy1);
				snprintf(Text,MAX_TEXT_LENGTH,TextMessage[LOSTLEAD],Attacker,LOSTLEAD);
				soundall(Text,"0",Victim,LOSTLEAD);
				soundplayer(Text,IMP_SOUND[LOSTLEAD],Victim,LOSTLEAD);
			}
			SpielerIDBest = 0;
		}	
	}
	/*Wenn es einen besten Spieler gibt*/
	if(KillCountAll[iIDA] > MostFrags){
		if(  SpielerIDBest != iIDA ){ /*Damit es dem Fhrenden nicht dauernd gesagt wird*/
				snprintf(Text,MAX_TEXT_LENGTH,TextMessage[TAKENLEAD],Attacker,TAKENLEAD);
				soundall(Text,"0",Attacker,TAKENLEAD);
				soundplayer(Text,IMP_SOUND[TAKENLEAD],Attacker,TAKENLEAD);
		}
		SpielerIDBest = iIDA;
		MostFrags = KillCountAll[iIDA];		
	}
	return PLUGIN_CONTINUE;
}

/*Die zeitunabhngigen UT-Sounds-Analayse*/
imp_killstreak( Attacker[],iIDA ){
	new Text[MAX_TEXT_LENGTH];
	/*Kill-Anzahl in der Runde-Analyse*/
	if(FragCount[iIDA] == 4){
			snprintf(Text,MAX_TEXT_LENGTH,TextMessage[KILLINGSPREE],Attacker);
			soundall(Text,IMP_SOUND[KILLINGSPREE],Attacker,KILLINGSPREE);
	}else if(FragCount[iIDA] == 5){
			snprintf(Text,MAX_TEXT_LENGTH,TextMessage[DOMINATING],Attacker);
			soundall(Text,IMP_SOUND[DOMINATING],Attacker,DOMINATING);
	}else if(FragCount[iIDA] >= 6){
			snprintf(Text,MAX_TEXT_LENGTH,TextMessage[GODLIKE],Attacker);
			soundall(Text,IMP_SOUND[GODLIKE],Attacker,GODLIKE);
	}
}
	
/*Die zeitabhngigen UT-Sounds*/
public imp_killstreaktime(Timer,Repeat,HLName,HLParam) {
  	new Attacker[MAX_NAME_LENGTH];
	new iIDA;
	new Text[MAX_TEXT_LENGTH];
  	convert_string(HLParam,Attacker,MAX_NAME_LENGTH);
	get_userindex(Attacker,iIDA);
	if( KillCount[iIDA]==2){
		snprintf(Text,MAX_TEXT_LENGTH,TextMessage[DOUBLEKILL],Attacker);
		soundall(Text,IMP_SOUND[DOUBLEKILL],Attacker,DOUBLEKILL);
	}else if(KillCount[iIDA]==3){
		snprintf(Text,MAX_TEXT_LENGTH,TextMessage[MULTIKILL],Attacker);
		soundall(Text,IMP_SOUND[MULTIKILL],Attacker,MULTIKILL);
	}else if(KillCount[iIDA]>=4 ){
		snprintf(Text,MAX_TEXT_LENGTH,TextMessage[MONSTERKILL],Attacker);
		soundall(Text,IMP_SOUND[MONSTERKILL],Attacker,MONSTERKILL);
	}
	KillCount[iIDA]=CLEAN_SLATE;
	TimerIndex[iIDA]=CLEAN_SLATE;
	return PLUGIN_CONTINUE;
}

/*-----------------------------------*/
/*---- SONSTIGE HILFSFUNKTIONEN -----*/
/*-----------------------------------*/

/*Bombentrger glht bei Bomb_Spawned. Aufruf in Funktion im_playeraction*/
public glow_off(Timer,Repeat,HLName,HLParam) {
	new Player[MAX_NAME_LENGTH];
  	convert_string(HLParam,Player,MAX_NAME_LENGTH);
  	glow(Player,0,0,0);
  	return PLUGIN_CONTINUE;
}

/*Zurcksetzen der Spieler-Arrays. Aufgerufen in plugin_connect,plugin_disconnect,im_connect und im_disconnect*/
reset_playerarray(UserIndex){
	KillCount[UserIndex] = CLEAN_SLATE;
	TimerIndex[UserIndex]=CLEAN_SLATE;
	FragCount[UserIndex]=CLEAN_SLATE;
	HeadCount[UserIndex]=CLEAN_SLATE;
	KillCountAll[UserIndex]=CLEAN_SLATE;
}

/*13.04.04 Men fr die erweiterte Stats-Anzeige. Aufgerufen in der AM-Funktion HandleSay(...)*/
show_stats(User[]){
	new Text[512];
	new loop;
	new loop2;
	new maxplayers=maxplayercount();
	new Name[MAX_NAME_LENGTH];
	new Dead[MAX_NAME_LENGTH];
	new x;
	new iDead;
	
	snprintf(Text,512,"Teamscore: \yCT:%s -- \rT:%s\w RUNDE:%i^n^n",ctscore,terrscore,round);
	snprintf(Text,512,"%s\yDie Besten Spieler dieser Runde:\w",Text);
	if(FragCount[SpielerID]>1){
		for(loop=FragCount[SpielerID];loop>1;loop--){
			if(x==3){
				break;
			}
			for(loop2=1;loop2<=maxplayers;loop2++){
				if(x==3){
					break;
				}
				if(playerinfo(loop2,Name,MAX_NAME_LENGTH,_,_,_,iDead)){
					if(FragCount[loop2]==loop){
						x++;
						if(iDead==1){
							strcpy(Dead,"TOT",MAX_NAME_LENGTH);
						}else{
							strcpy(Dead,"",MAX_NAME_LENGTH);
						}
						snprintf(Text,512,"%s^n%i (%i) ---- %s (%s)",Text,FragCount[loop2],HeadCount[loop2],Name,Dead);
					}
				}
			}
		}
	}else{
		snprintf(Text,512,"%s^nKein bester Spieler vorhanden.",Text);
	}
	snprintf(Text,512,"%s\y^n^nBester Spieler auf der gesamten Map:\w",Text);
	if(SpielerIDBest!=0){
		playerinfo(SpielerIDBest,Name,MAX_NAME_LENGTH);
	}else{
		strcpy(Name,"Niemand",MAX_NAME_LENGTH);
	}
	snprintf(Text,512,"%s^n%s ^nMeisten Frags: %i Frags",Text,Name,MostFrags);
	menu(User,Text,1023,8);
	return PLUGIN_HANDLED;
}

/*17.04.03: Zahlen in String umwandeln, um es mit HL-Speech auszuwerten. Big THX an SR71GOKU*/
stock do_numtoword(iNum,str[],iLevel,iLength) {
	
	/* If there is more than one group of 3, then take care of the others first. */
	if(iNum >= 1000) do_numtoword(iNum / 1000,str,iLevel + 1,iLength);
	
	/* Grab the the first 3 digits only */
	iNum %= 1000;	
	
	/* Isolate each digit */
	new _hundreds = iNum / 100;
	new _tens = (iNum / 10) % 10;
	new _ones = iNum % 10;
	
	/* Take care of the teen numbers */
	if(_tens == 1 && _ones != 0) {
		snprintf(str,iLength,"%s%s%s%s",str,HundredsLib[_hundreds],TeensLib[_ones],GroupNamesLib[iLevel]);
	} else {
		snprintf(str,iLength,"%s%s%s%s%s",str,HundredsLib[_hundreds], TensLib[_tens], OnesLib[_ones],GroupNamesLib[iLevel]);
	}
	
	if(iLevel==0) str[strlen(str)-1] = 0; /* Gets rid of the trailing space*/
	return 1;
}

stock numtoword(iNum,str[],iLength) {
	/* Empties the first char of the string */
	str[0] = 0;
	str[iLength-1] = 0;
	if(iNum == 0) {
		snprintf(str,iLength,"zero");
		return 1;
	}
	if(iNum < 0) {
		iNum *= -1;
		snprintf(str,iLength,"negative ");
	}
	
	return do_numtoword(iNum,str,0,iLength); 
}

/*19.04.03: Der Bombtimer*/

public imp_bombtimer(Timer,Repeat,HLName,HLParam) {
	if(c4timer!=999){
		new Text[MAX_TEXT_LENGTH];
		new C4Timer[MAX_NUMBER_LENGTH];
		new wait;
		new Dummy[MAX_NAME_LENGTH];
		if(STATUS_COMMAND[STATUS_BT][0]!=0){
			numtoword(c4timer,C4Timer,MAX_NUMBER_LENGTH);
			if(c4timer>5){
				snprintf(Text,MAX_TEXT_LENGTH,"detonation in %s seconds",C4Timer);
				speak_number(Text);
				soundall(Text,IMP_SOUND[BOMBTIMER],Dummy,BOMBTIMER);
			}else if(c4timer!=0){
				snprintf(Text,MAX_TEXT_LENGTH,"%s",C4Timer);
				speak_number(Text);
				soundall(Text,IMP_SOUND[BOMBTIMER],Dummy,BOMBTIMER);
			}
		}
		switch(c4timer){
			case 30:{ 
				c4timer=20;
				wait=10;
			}
			case 20:{ 
				c4timer=10;
				wait=10;
			}
			case 10:{
				c4timer=5;
				wait=4;
			}
			case 5: {
				c4timer=4;
				wait=1;
			}
			case 4: {
				c4timer=3;
				wait=1;
			}
			case 3: {
				c4timer=2;
				wait=1;
			}
			case 2: {
				c4timer=1;
				wait=1;
			}
			case 1: {
				c4timer=0;
				wait=1;
			}	
			case 0: {
				if(STATUS_COMMAND[STATUS_DB][0]!=0){
					soundall(TextMessage[BOMBDETONATION],IMP_SOUND[BOMBDETONATION],Dummy,BOMBDETONATION);
				}
				return PLUGIN_CONTINUE;
			}			
		}
		set_timer("imp_bombtimer",wait,0);
	}
	return PLUGIN_CONTINUE;
}