/*	This plugin allows users to search thru the maps on your server.
	You will need to create a file called "tmaps.txt" and place it in your
	Mod directory.  This file should contain a list of all the maps you
	have available to play.  The easiest way to create this file is with the DOS
	command "dir *.bsp /b >tmaps.txt"  Do that in your maps directory to
	generate the file, then move it to your mod directory.
*/

/* $Id: plugin_listmaps.sma,v 1.0 05/04/01 PetitMorte(?) $ */

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

new STRING_VERSION[MAX_DATA_LENGTH] = "2.50.0";

public admin_listallmaps(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new From;
	convert_string(HLCommand,Command,MAX_NAME_LENGTH);
	convert_string(HLData,Data,MAX_NAME_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	/* how many maps are in list? */
	new TotalMaps = filesize("tmaps.txt", lines);

	/* Make sure From is acceptable. If it isn't, make it so. */
	if (strlen(Data)==0) {
		From = 1;
	}
	From = strtonum(Data);

	if( From >= TotalMaps ) {
		From = TotalMaps - 9;
	}
	if( From < 1 ) {
		From = 1;
	}

	new From10 = (From + 9);
	if (From10 > TotalMaps) {
		From10 = TotalMaps;
	}
	snprintf(Text, MAX_TEXT_LENGTH, "Listing maps %i - %i of %i.", From, From10, TotalMaps);
	selfmessage(Text);
	new i = From;
	new sLine[100];
	while (i <= From10) {
		readfile("tmaps.txt", sLine, i, 100);
		selfmessage(sLine);
		i++;
	}
	return PLUGIN_HANDLED;
}


public admin_searchmaps(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	convert_string(HLCommand,Command,MAX_NAME_LENGTH);
	convert_string(HLData,Data,MAX_NAME_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	/* how many maps are in list? */
	new TotalMaps = filesize("tmaps.txt", lines);

	if (strlen(Data)==0){
		snprintf(Text, MAX_TEXT_LENGTH, "We've got %i maps to choose from.  Use admin_listallmaps for a list.", TotalMaps);
		selfmessage(Text);
	} else if (strlen(Data)==1){
		new i = 1;
		new sLine[100];
		while (i <= TotalMaps) {
			readfile("tmaps.txt", sLine, i, 100);
			if (strncasecmp(sLine, Data, 1) == 0) {
				selfmessage(sLine);
			}
			i++;
		}
	} else {
		new i = 1;
		new sLine[100];
		while (i <= TotalMaps) {
			readfile("tmaps.txt", sLine, i, 100);
			if (strcasestr(sLine, Data) != -1) {
				selfmessage(sLine);
			}
			i++;
		}
	}
	return PLUGIN_HANDLED;
}

public plugin_init() {
	plugin_registerinfo("List All Maps Plugin","Allows user to list maps on server.",STRING_VERSION);
	plugin_registercmd("admin_listallmaps","admin_listallmaps",ACCESS_ALL,"admin_listallmaps <number>: Lists available maps on the server in groups of 10");
	plugin_registercmd("admin_searchmaps","admin_searchmaps",ACCESS_ALL,"admin_serachmaps <target>: Lists available maps with target in their name");

	return PLUGIN_CONTINUE;	
}

