/*  Contains all of the Frontline Force specific commands for AdminMod. 
    If you have any questions about the commands or usage, please refer to the 
    readme or contact me at SR71Goku@hotmail.com or ICQ: 146538715                       
*/

/*$Id: plugin_flf_common.sma,v 1.0 4/20/2002 SR71Goku Exp $*/


#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

new STRING_VERSION[MAX_DATA_LENGTH] = "2.51.00";

#define ACCESS_DELAYROUND 4
#define ACCESS_FADETOBLACK 32
#define ACCESS_FLASHLIGHT 32
#define ACCESS_FOOTSTEPS 8192
#define ACCESS_GRENADES 8192
#define ACCESS_KILLERHEALTH 2
#define ACCESS_SPECTS 32
#define ACCESS_TEAMCHANGE 8192
#define ACCESS_WAVESPAWN 8192


public admin_allowkickvote(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_allow_kickvote");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_allow_kickvote","0");
    	} else {
       	execute_command(User,Command,"mp_allow_kickvote","1");
	}
	return PLUGIN_HANDLED;
}

public admin_allowicons(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_allowicons");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_allowicons","0");
    	} else {
       	execute_command(User,Command,"mp_allowicons","1");
	}
	return PLUGIN_HANDLED;
}

public admin_allowspects(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_allowspects");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_allowspects","0");
    	} else {
       	execute_command(User,Command,"mp_allowspects","1");
	}
	return PLUGIN_HANDLED;
}
	
public admin_autoidlekick(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_autoidlekick");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_autoidlekick","0");
    	} else {
       	execute_command(User,Command,"mp_autoidlekick","1");
	}
	return PLUGIN_HANDLED;
}

public admin_autobalance(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_autoteambalance");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_autoteambalance","0");
    	} else {
       	execute_command(User,Command,"mp_autoteambalance","1");
	}
	return PLUGIN_HANDLED;
}

public admin_delayround(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
		
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	execute_command(User,Command,"mp_delayround",Data);
	return PLUGIN_HANDLED;
}

public admin_fadetoblack(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_fadetoblack");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_fadetoblack","0");
    	} else {
       	execute_command(User,Command,"mp_fadetoblack","1");
	}
	return PLUGIN_HANDLED;
}

public admin_flashlight(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_flashlight");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_flashlight","0");
    	} else {
       	execute_command(User,Command,"mp_flashlight","1");
	}
	return PLUGIN_HANDLED;
}

public admin_footsteps(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_footsteps");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_footsteps","0");
    	} else {
       	execute_command(User,Command,"mp_footsteps","1");
	}
	return PLUGIN_HANDLED;
}

public admin_forcebalance(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_forcebalance");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_forcebalance","0");
    	} else {
       	execute_command(User,Command,"mp_forcebalance","1");
	}
	return PLUGIN_HANDLED;
}

public admin_friendlyfire(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_friendlyfire");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_friendlyfire","0");
    	} else {
       	execute_command(User,Command,"mp_friendlyfire","1");
	}
	return PLUGIN_HANDLED;
}

public admin_grenades(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_grenades");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_grenades","0");
    	} else {
       	execute_command(User,Command,"mp_grenades","1");
	}
	return PLUGIN_HANDLED;
}

public admin_grenadespam(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_grenadespam");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_grenadespam","0");
    	} else {
       	execute_command(User,Command,"mp_grenadespam","1");
	}
	return PLUGIN_HANDLED;
}

public admin_killerhealth(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_killerhealth");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_killerhealth","0");
    	} else {
       	execute_command(User,Command,"mp_killerhealth","1");
	}
	return PLUGIN_HANDLED;
}

public admin_roundlimit(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
		
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	execute_command(User,Command,"mp_roundlimit",Data);
	return PLUGIN_HANDLED;
}

public admin_spectchat(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
    	convert_string(HLData,Data,MAX_DATA_LENGTH);
    	convert_string(HLUserName,User,MAX_NAME_LENGTH);
    	Toggle = getvar("mp_spectchat");
    	if(Toggle == 1) {
        	execute_command(User,Command,"mp_spectchat","0");
    	} else {
       	execute_command(User,Command,"mp_spectchat","1");
	}
	return PLUGIN_HANDLED;
}

public admin_startmatch(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
		
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	execute_command(User,Command,"sv_startmatch",Data);
	return PLUGIN_HANDLED;
}

public admin_teamchange(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Toggle;
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	Toggle = getvar("mp_teamchange");
	if(Toggle == 1) {
		execute_command(User,Command,"mp_teamchange","0");
	} else {
		execute_command(User,Command,"mp_teamchange","1");
	}
	return PLUGIN_HANDLED;
}

public admin_wavespawn(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	if( (strtonum(Data) < 0) || (strtonum(Data) > 3) ) {
		selfmessage("Value must be between 0 and 3");
	} else {
		execute_command(User,Command,"mp_wavespawn",Data);
	}
	return PLUGIN_HANDLED;
}

public plugin_init(){
	plugin_registerinfo("Frontline Force specific commands","Plugin provides all of the Frontline Force specific cvars.",STRING_VERSION);
	
	plugin_registercmd("admin_allowkickvote","admin_allowkickvote",ACCESS_KICK,"admin_allowkickvote : Toggles  the ability for players to vote people off of the server.");
	plugin_registercmd("admin_allowicons","admin_allowicons",ACCESS_FRIENDLY_FIRE,"admin_allowicons : Toggles ability of players to toggle the display of team icons.");
	plugin_registercmd("admin_allowspects","admin_allowspects",ACCESS_SPECTS,"admin_allowspects : Toggles ability for players to be spectators.");
	plugin_registercmd("admin_autoidlekick","admin_autoidlekick",ACCESS_KICK,"admin_autoidlekick : Toggles the auto kicking of idle players.");
	plugin_registercmd("admin_autobalance","admin_autobalance",ACCESS_TEAMCHANGE,"admin_autobalance : Toggles auto team balancing on and off.");
	plugin_registercmd("admin_delayround","admin_delayround",ACCESS_DELAYROUND,"admin_delayround <time> : Sets the ammount of time before the official round starts.");
	plugin_registercmd("admin_fadetoblack","admin_fadetoblack",ACCESS_FADETOBLACK,"admin_fadetoblack: Toggles fade-to-black on and off.");
	plugin_registercmd("admin_flashlight","admin_flashlight",ACCESS_FLASHLIGHT,"admin_flashlight: Toggles the use of the flashlight on and off.");
	plugin_registercmd("admin_footsteps","admin_footsteps",ACCESS_FOOTSTEPS,"admin_footsteps: Toggles footsteps on and off.");
	plugin_registercmd("admin_forcebalance","admin_forcebalance",ACCESS_TEAMCHANGE,"admin_forcebalance : Toggles forced team balance on and off.");
	plugin_registercmd("admin_friendlyfire","admin_friendlyfire",ACCESS_FRIENDLY_FIRE,"admin_friendlyfire : Toggles friendly fire on and off.");
	plugin_registercmd("admin_grenades","admin_grenades",ACCESS_GRENADES,"admin_grenades : Toggles the use of grenades on and off.");
	plugin_registercmd("admin_grenadespam","admin_grenadespam",ACCESS_GRENADES,"admin_grenadespam : Toggles the ability to grenade spam from spawn on and off.");
	plugin_registercmd("admin_killerhealth","admin_killerhealth",ACCESS_KILLERHEALTH,"admin_killerhealth : Toggles the showing of your killer's health when you die on and off.");
	plugin_registercmd("admin_roundlimit","admin_roundlimit",ACCESS_TIMELIMIT,"admin_roundlimit <data> : Set the number of wins till the round ends.");
	plugin_registercmd("admin_spectchat","admin_spectchat",ACCESS_SPECTS,"admin_spectchat : Toggles ability for spectators to speak on and off.");
	plugin_registercmd("admin_startmatch","admin_startmatch",ACCESS_TIMELIMIT,"admin_startmatch <data> : ^"Restarts^" the map without making other players reload hte map.");
	plugin_registercmd("admin_teamchange","admin_teamchange",ACCESS_TEAMCHANGE,"admin_teamchange : Toggles ability of players to switch teams after warm-up time.");
	plugin_registercmd("admin_wavespawn","admin_wavespawn",ACCESS_WAVESPAWN,"admin_wavespawn <data> : Sets the mode for players to spawn.  Can be 0-3.");
	
	return PLUGIN_CONTINUE;
}
