//
//
//         This plugin must be the FIRST or at least before the base 
//     or adminmod default plugins in your PLUGIN.INI or it wont work.
//
//
/***********************************************************************
 * plugin_ejl_adminhierarchy.sma     release version 4.0  October 26/2002
 *  By:  Eric Lidman	Alias: Ludwig van
 *  Upgrade: http://lidmanmusic.com/cs/plugins.html        
 *
 *
 * This plugin performs much the same function as the cvar 
 *  admin_highlander, except it is more flexible. It allows a group of
 *  top admins to have their complete access (as specified in users.ini,
 *  but no more) to admin commands, while admins not in the group will
 *  only have limited access.
 *
 * Adminhierarchy should be useful for servers with many admins. Only
 *  admins in the top rank who are on at the time will have control over
 *  the more "global" commands on the server -- commands which directly 
 *  affect more than one player such as admin_gravity or admin_map.
 *  This way admins can argue about what the gravity will be, but only 
 *  the top admins can do anything about it -- until they leave, then the 
 *  next highest admin in the ranks takes control. It is aimed at keeping
 *  order on the server.
 * 
 * This plugin also gives partial immunity to all admins. No one can
 *  admin_ban, admin_kick, or admin_vote_kick any admin. Admins without
 *  immunity in their access can still be slapped, slayed etc. This is
 *  just a precaution to keep lower admins from gaining power by 
 *  kicking/banning higher admins.
 *
 * Commands:
 *
 *  admin_signin    --- tells the server you are on and ready to take your
 *                      place in the admin hierarchy, low or high. This is 
 *                      not required if you are using the default scheme 
 *                      of having the server automatically sign you in.
 *  admin_resign    --- used by a higher admin to let the next lower admin
 *                      be the top admin while the higher admin is still
 *                      connected. This is for all your either humble or 
 *                      lazy higher admins out there who dont want to be 
 *                      the higher admin for the moment.  
 *  admin_topadmin  --- use this to find out who the current top admin is.
 *  admin_adminstatus  --- Lists admins who are currently playing in rank 
 *                         order and reports if they are signed in or not.
 *                         A regular player looking at this will only see
 *                         admins who have their access (admin_password)
 *                         active, although the admins dont need to be 
 *                         signed in. Admins with thier access active from 
 *                         the users.ini looking at this will see all 
 *                         admins connected even if the othe admin do not
 *                         have their admin access in the users.ini active.
 *  admin_cloak_owner      --- Makes the number 1 admin invisible to the 
 *                             other admins. He wont be reported at all 
 *                             and will not be signed in automatically
 *                             even if auto-signin is the current mode.
 *                             If you decide to sign in, however, you will
 *                             be exposed. But thats not the point of this.
 *                             This allows for the server owner to watch
 *                             stealthily over his admins while playing
 *                             under a fake name. The command toggles on 
 *                             and off stealth mode and sets it in the 
 *                             vault.ini as the default until it is 
 *                             changed again. Only the server owner 
 *                             can set this mode on or off. Make sure as
 *                             the server owner that you are the number 
 *                             1 admin listed in the adminhierarchy.txt.
 *                             Admin access RCON also required. Also, if
 *                             you are running any plugins which announce
 *                             admin's entrances, you will want to modify
 *                             them in such a way that they dont announce
 *                             you, or disable them altogether. Of course
 *                             you would only need to do this if you want 
 *                             to use the cloak owner mode. Obviosly an 
 *                             annouced entrance could blow your cover.
 * admin_signin_default    --- Toggles auto-signin mode on and off and 
 *                             sets it in the vault.ini as the default
 *                             until it is changed again. Only the server
 *                             owner can set this mode on or off. Make 
 *                             sure as the server owner that you are the
 *                             number 1 admin in the adminhierarchy.txt.
 *                             Admin access RCON also required.
 * admin_ah_reload         --- Reloads the adminhierarchy.txt file so that
 *                             changes made to it midway through a game
 *                             can be effective immediately without having
 *                             to wait for a map change. Only the server
 *                             owner is allowed to use this command. Make 
 *                             sure as the server owner that you are the
 *                             number 1 admin in the adminhierarchy.txt.
 *                             Admin access RCON also required. 
 * admin_ah_report         --- Toggles the use of messeges telling when
 *                             admins sign in, resign, connect, or
 *                             diconnect and sets it in the vault.ini as
 *                             the default until it is changed again.
 *                             This cuts down on chat use by the plugin
 *                             and the bombarding of players with admin
 *                             information if thats the way you like it. 
 *                             The commands, admin_adminstatus and
 *                             admin_topadmin still work. Only the server
 *                             owner can set this mode on or off. Make 
 *                             sure as the server owner that you are the
 *                             number 1 admin in the adminhierarchy.txt.
 *                             Admin access RCON also required. 
 *
 * By default, this plugin tries to automatically sign in admins on
 *  their connect. If it misses there, everytime this admin says
 *  anything, he gets signed in -- unless he resigns. Also by default
 *  owner cloaking is off and use of messenging (admin_ah_report) is
 *  on. It is possible in cloak mode for a server owner to allow himself
 *  to be kicked (but not banned) by one of his admins. This is useful if
 *  you want to observe them extensively and not raise thier suspicions
 *  as they kick you. Then of course you can tell them later that they
 *  kicked you. (Then fire them. lol) By default in cloak mode you cant
 *  be kicked, but there is a switch below you can set to be in allow
 *  kick mode. If you change it, you need to recompile the plugin. The
 *  switch looks like this: #define AllowOwnerKick 0 // 0=no 1=yes
 * 
 * This plugin uses WONIDs for admin identification so it WILL NOT WORK
 *  for LAN games. Actually, it might work for a lan server if you use
 *  your unique id, as long as it doesnt change. I dont have enough
 *  experience to say. WONIDs for your admins MUST be entered into the 
 *  adminhierarchy.txt file and that file must be in your mod directory.
 *  I am not certain, but I think SteamIDs may also be used. We'll see.
 *  I actually dont even know what a SteamID looks like. But since I am
 *  using the new AUTHID scheme in this plugin, it seems like it should
 *  work.  
 *
 * Make sure admin_highlander is set to 0 -- not 1 in your adminmod.cfg
 *  Also change these values in your adminmod.cfg to 1:
 *    allow_client_exec 1
 *    file_access_read 1
 *    file_access_write 1  
 * 
 * How to set up adminhierarchy.txt:
 *
 *  At the beginning of each map, this file is read by the server to see
 *   how it should treat the admins. The format of the file is one admin 
 *   for each line. Rank numbers are not given, it just goes in order top
 *   to bottom. First there is a number 1 or 2 to identify admin type
 *   (then a space), next is the admin's wonid (then a space), next is
 *   optional -- the admin's name just so it is easier for you to see who
 *   is who in the order. The name is not important to the plugin. Type 1 
 *   admins are those who are not limited by this plugin. They can be on
 *   the server all at the same time and all issue "global" commands.
 *   Type 2 admins are the reason for this plugin in the first place. If 
 *   an admin ranking higher than them is on, all the lower ranking type 2
 *   admins will have their power limited by this plugin. All type 1
 *   admins should be listed first, then type 2 in rank order.  
 * 
 *    example of adminhierarchy.txt contents:
 *
 *    1 123454   mynamecuzimtheowner
 *    1 527373   anothername
 *    1 43498    anotherhighadmin
 *    2 8994422  thehiestlowadmin
 *    2 33743    anyoldadmin
 *    2 748433   howiecarr
 *    2 1277344  yetanotheradmin
 *
 *   The file adminhierarchy.txt included in the .zip file is an actual 
 *   working one from my own server provided to be a further example.
 *   You need to change all the info in it to match your admins info of
 *   course if you use it.
 *
 * Known issues: Adminmod has difficulty detecting the first player/admin
 *  or more connecting to the server after a startup or mapchange. As a 
 *  result, the plugin might not detect if a higher admin is on since it
 *  relies on adminmod's connect routine to register an admin present.
 *  My plugin tries to correct for this by allowing an admin to check 
 *  himself in just by chatting, saying anything. Further, when an admin
 *  attempts to use a "global" command, he will be re-registered in the
 *  plugin. So a higher admin will never have his commands denied, even
 *  if he wasnt detected at connect. The only possible error the plugin 
 *  can make is letting a lower admin execute global commands while a
 *  higher admin is on -- which can be remedied by time (eventually the 
 *  higher admin will be picked up) or by the higher admin asserting his
 *  authority by using a "global" command. 
 *
 * Changes/fixes from earlier versions:
 *  8/25/02 Added restricted/enabled indicator to admin_adminstatus.
 *   Added admin_ah_reload / Removed the outdated admin_unresign  
 *  8/02/02 Cloak owner mode bug fixed and now works as it should.
 *  6/29/02 Compliant with adminmod 2.51 (earlier versions not supported)  
 *   Modified reporting of top admins. Included an auto-response to 
 *   players who ask who the top admin is through the chat. Added 
 *   cloaking for server operators. Added a command to list admins who
 *   are connected and report if they are signed in. Auto-sign in mode
 *   can be turned off and that mode set as default from the game via 
 *   the vault.ini data and therefore no re-compiling of the plugin is 
 *   necessary to make that change anymore.  
 *  5/23/02 Added the admin_signin / admin_resign commands with
 *   echo of sign in and announcement of who top admin is.  
 *  5/16/02 Completely re-written to use a text file with admins info
 *   instead of having admins info written write into the .sma thus
 *   making it more user friendly. Also, there is now no limit now to
 *   the numbers of admins you can have (well 200 admins, but that can
 *   change in a few keystrokes if necessary). 
 *  4/30/02 fixed to work with the new adminmod 2.50.26 small compiler.
 *
 **********************************************************************/

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define AllowOwnerKick 0 // 0=no 1=yes  'yes' lets owner be kicked in cloak mode

#define log_info 0 // 0=off 1=on  log adminherarchy activity in AHD.log

new STRING_VERSION[MAX_DATA_LENGTH] = "2.51";

new AdminOn[200];
new AdminResign[200];
new AdminType[200];
new AdminInfo[200][MAX_AUTHID_LENGTH];
new AdminName[200][MAX_NAME_LENGTH];
new TotalAdmins;
new bool:bAutoSignIn = true;
new bool:bCloakOwner = false;
new bool:bReportS = true;

public plugin_init() 
{
	plugin_registerinfo("plugin_ejl_adminhierarchy", "A more flexible admin_highlader system", STRING_VERSION);
	plugin_registercmd("admin_signin", "admin_signin", ACCESS_MAP, "admin_signin  :  Tells the server he is here and in the pool of possible top admins.");	
	plugin_registercmd("admin_resign", "admin_resign", ACCESS_MAP, "admin_resign  :  Lets the next lowest admin be the high admin instead.");
	plugin_registercmd("admin_topadmin", "admin_topadmin", ACCESS_ALL, "admin_topadmin  :  Find out who is the top admin currently playing.");
	plugin_registercmd("admin_adminstatus", "admin_adminstatus", ACCESS_ALL, "admin_adminstatus  :  Find out what admins are currently playing and if they are signed in.");
	plugin_registercmd("admin_signin_default", "admin_signin_deflt", ACCESS_RCON, "admin_signin_default : Toggles the signin mode and sets it as the default.");
	plugin_registercmd("admin_ah_report", "admin_ah_report", ACCESS_RCON, "admin_ah_report : Toggles the reporting of signin, signout, and topadmin on and off. Sets as default.");
	plugin_registercmd("admin_ah_reload", "admin_ah_reload", ACCESS_RCON, "admin_ah_reload : Reloads Adminhierarchy.txt in the middle of a round.");
	plugin_registercmd("admin_cloak_owner", "admin_cloak_own", ACCESS_RCON, "admin_cloak_owner : Toggles server owner cloak mode and sets it as the default.");
	plugin_registercmd("say", "HandleSay", ACCESS_ALL);

// global commands for top admins only
//
	plugin_registercmd("admin_map","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_denymap","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_fraglimit","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_cancelvote","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_prematch","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_teamplay","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_balance","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_pause","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_unpause","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_reload","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_pass","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_nopass","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_gravity","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_matrix","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_friendlyfire","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_restartround","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_timelimit","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_slayteam","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_hostname","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_cfg","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_servercfg","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_timebombs","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_fun","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_disco","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_t","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_ct","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_stack","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_lineup","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_awp","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_pistols","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_enableallweapons","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_enableweapon","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_enablemenu","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_enableequipment","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_restrictallweapons","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_restrictweapon","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_restrictmenu","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_restrictequipment","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_rcon","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_execall","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_execclient","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_execteam","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_scotty_on","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_scotty_off","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_scotty_unlimited","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_scotty_crazy","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_scotty_insane","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_votes","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_knives","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_droppem","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("stopmapvote","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("stopkickvote","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_buytime","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_c4timer","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_flashlight","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_freeztime","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_startmoney","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_roundtime","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_tkpunish","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_hostagepenalty","AdminHierarchy",ACCESS_ALL,"");
	plugin_registercmd("admin_abort_vote","AdminHierarchy",ACCESS_ALL,"");

// protect the admins without giving them full immunity
//
	plugin_registercmd("admin_ban","CantBanMe",ACCESS_ALL,"");
	plugin_registercmd("admin_banip","CantBanMe",ACCESS_ALL,"");
	plugin_registercmd("admin_kick","CantBanMe",ACCESS_ALL,"");
	plugin_registercmd("admin_vote_kick","CantBanMe",ACCESS_ALL,"");

	new VaultData;
	new signin_mode;	
	if(get_vaultnumdata("EJL_ADMINH_MODE", VaultData) != 0){
		signin_mode = VaultData;
	} else {
		signin_mode = 1;
		set_vaultnumdata("EJL_ADMINH_MODE", 1);
	}
	if(signin_mode == 1){
		bAutoSignIn = true;
	}	
	if(signin_mode == 2){
		bAutoSignIn = false;
	}

	new cloak_owner;
	if(get_vaultnumdata("EJL_ADMINH_CLOAK", VaultData) != 0){
		cloak_owner = VaultData;
	} else {
		cloak_owner = 1;
		set_vaultnumdata("EJL_ADMINH_CLOAK", 1);
	}
	if(cloak_owner == 1){
		bCloakOwner = false;
	}	
	if(cloak_owner == 2){
		bCloakOwner = true;
	}

	new ah_report;
	if(get_vaultnumdata("EJL_ADMINH_REPORT", VaultData) != 0){
		ah_report = VaultData;
	} else {
		ah_report = 1;
		set_vaultnumdata("EJL_ADMINH_REPORT", 1);
	}
	if(ah_report == 1){
		bReportS = true;
	}	
	if(ah_report == 2){
		bReportS = false;
	}

	new iAdmin;
	new sAdminData[100];
	new sAdminType[10];
	new sAdminName[MAX_NAME_LENGTH];
	new sAdminAuthID[MAX_AUTHID_LENGTH];
	TotalAdmins = filesize("adminhierarchy.txt", lines);
	for (iAdmin = 1; iAdmin <= TotalAdmins; iAdmin++) {
		if ((iAdmin < 1) || (iAdmin > 1000)) {
			break;
		}
		readfile("adminhierarchy.txt", sAdminData, iAdmin, 100);
		strsplit(sAdminData, " ", sAdminType, 10, sAdminAuthID, MAX_AUTHID_LENGTH, sAdminName, MAX_NAME_LENGTH);
		AdminType[iAdmin] = strtonum(sAdminType);
		strcpy(AdminInfo[iAdmin], sAdminAuthID, MAX_AUTHID_LENGTH);
		strcpy(AdminName[iAdmin], sAdminName, MAX_NAME_LENGTH);
	}
	return PLUGIN_CONTINUE;
}

// We use this to correct for adminmod if it fails to detect an admin's connect
// Everytime someone chats, this routine checks for the presence of admins.

public HandleSay(HLCommand, HLData, HLUserName, UserIndex){

	if(bAutoSignIn == true){
		new i;
		new UserName[MAX_NAME_LENGTH];
		new AUTHID[MAX_AUTHID_LENGTH];
		new cloak;
	
		convert_string(HLUserName, UserName, MAX_NAME_LENGTH);
		get_userAuthID(UserName,AUTHID);

		if(bCloakOwner == true){
			cloak = 2;
		}else{
			cloak = 1;
		}

		for (i = cloak; i <= TotalAdmins; i++) {
			if ((i < 1) || (i > 1000)) {
				break;
			}	
			if(strcmp(AUTHID, AdminInfo[i]) == 0){
				if(AdminResign[i] == 0){
					AdminOn[i] = 1;
				}
			}
		}
	}

	new Speech[MAX_DATA_LENGTH];
	new dummy1;
	new dummy2;
	new dummy3;
	new dummy4;
	convert_string(HLData, Speech, MAX_DATA_LENGTH);
	strstripquotes(Speech);

	if ((strcasestr(Speech, "admin") != -1) && ((strcasestr(Speech, "top") != -1) || (strcasestr(Speech, "who") != -1) || (strcasestr(Speech, "status") != -1) || (strcasestr(Speech, "high") != -1)) ){
		admin_topadmin(dummy1,dummy2,dummy3,dummy4);
	}
	return PLUGIN_CONTINUE;
}	

//  Here is where admins are supposed to be "signed in", on thier connect
//

public plugin_connect(HLUserName,HLIP,UserIndex) {

	new i;
	new UserName[MAX_NAME_LENGTH];
	new AUTHID[MAX_AUTHID_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new FoundHi;
	new HiAUTHID[MAX_AUTHID_LENGTH];
	new HiName[MAX_NAME_LENGTH];
	new iMaxPlayers = maxplayercount();
	new Name[MAX_NAME_LENGTH];
	new SessionID;
	new WONID;
	new Authid[MAX_AUTHID_LENGTH];
	new Team, Dead;
	new AdminDC;
	new cloak;

	convert_string(HLUserName, UserName, MAX_NAME_LENGTH);
	get_userAuthID(UserName,AUTHID);

	if(bCloakOwner == true){
		cloak = 2;
	}else{
		cloak = 1;
	}

	for (i = cloak; i <= TotalAdmins; i++) {
		if ((i < 1) || (i > 1000)) {
			break;
		}	
		if(strcmp(AUTHID, AdminInfo[i]) == 0){
			if(bAutoSignIn == true){
				AdminDC =1;
				AdminOn[i] = 1;
			}
			AdminResign[i] = 0;
		}
		if(AdminOn[i] == 1){
			if(FoundHi == 0){
				strcpy(HiAUTHID,AdminInfo[i],MAX_AUTHID_LENGTH);
				FoundHi =1;
			}
		}
	}
	for (i = 1; i <= iMaxPlayers; i++) {
     		if (playerinfo(i,Name,MAX_NAME_LENGTH,SessionID,WONID,Team,Dead,Authid) !=0) {
        		if(strcmp(Authid, HiAUTHID) == 0){
				strcpy(HiName,Name,MAX_NAME_LENGTH);
			}
		}
	}
	if(FoundHi==0){
		strcpy(HiName, "... uh, there is none.", MAX_NAME_LENGTH);
	}
	i=1;
	FoundHi = 0;
	if (AdminDC==1){
		if(bReportS == true){
			if(strcmp(UserName, HiName) == 0){
				snprintf(Text, MAX_TEXT_LENGTH, "%s has signed in and is now top admin.", UserName);
			}else{
				snprintf(Text, MAX_TEXT_LENGTH, "%s signs in but top admin is still %s", UserName, HiName);
			}	
			say(Text);
		}
	}
	AdminDC=0;

	return PLUGIN_CONTINUE;
}

//  Here is when admins are "signed out" with thier disconnect
//

public plugin_disconnect(HLUserName, UserIndex) {

	new Text[MAX_TEXT_LENGTH];
	new FoundHi;
	new HiAUTHID[MAX_AUTHID_LENGTH];
	new HiName[MAX_NAME_LENGTH];
	new FoundHix;
	new HiAUTHIDx[MAX_AUTHID_LENGTH];
	new HiNamex[MAX_NAME_LENGTH];
	new iMaxPlayers = maxplayercount();
	new Name[MAX_NAME_LENGTH];
	new SessionID;
	new WONID;
	new Authid[MAX_AUTHID_LENGTH];
	new Team, Dead;
	new i;
	new cloak;
	new AdminDC;
	new AUTHID[MAX_AUTHID_LENGTH];
	new UserName[MAX_NAME_LENGTH];
	convert_string(HLUserName, UserName, MAX_NAME_LENGTH);
	get_userAuthID(UserName,AUTHID);

	if(bCloakOwner == true){
		cloak = 2;
	}else{
		cloak = 1;
	}

	for (i = cloak; i <= TotalAdmins; i++) {
		if ((i < 1) || (i > 1000)) {
			break;
		}
		if(AdminOn[i] == 1){
			if(FoundHix == 0){
				strcpy(HiAUTHIDx,AdminInfo[i], MAX_AUTHID_LENGTH);
				FoundHix =1;
			}
		}
		if(strcmp(AUTHID, AdminInfo[i]) == 0){
			AdminDC =1;
			AdminOn[i] = 0;
			AdminResign[i] = 0;
		}
		if(AdminOn[i] == 1){
			if(FoundHi == 0){
				strcpy(HiAUTHID,AdminInfo[i], MAX_AUTHID_LENGTH);
				FoundHi =1;
			}
		}
	}
	for (i = 1; i <= iMaxPlayers; i++) {
     		if (playerinfo(i,Name,MAX_NAME_LENGTH,SessionID,WONID,Team,Dead,Authid) !=0) {
      		if(strcmp(Authid, HiAUTHID) == 0){
				strcpy(HiName,Name,MAX_NAME_LENGTH);
			}
      		if(strcmp(Authid, HiAUTHIDx) == 0){
				strcpy(HiNamex,Name,MAX_NAME_LENGTH);
			}

		}
	}
	if(FoundHi==0){
		strcpy(HiName, "... uh, there is none.", MAX_NAME_LENGTH);
	}
	if (AdminDC==1){
		if(bReportS == true){
			if(strcmp(UserName, HiNamex) == 0){
				snprintf(Text, MAX_TEXT_LENGTH, "%s has left. The top admin is now %s", UserName, HiName);	
				say(Text);
			}
		}
	}
	FoundHi = 0;
	FoundHix = 0;
	AdminDC=0;
	return PLUGIN_CONTINUE;
}

//  Here is the main part of the plugin where we determin if an admin is
//  eligable to issue any "global" commands.

public AdminHierarchy(HLCommand, HLData, HLName, UserIndex){

	new i;
	new cloak;
	new COMauthid[MAX_AUTHID_LENGTH];
	new UserName[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new DenyAdmin;
	new AllowCommand;
	new FoundHi;
	new HiAUTHID[MAX_AUTHID_LENGTH];
	new HiName[MAX_NAME_LENGTH];
	new iMaxPlayers = maxplayercount();
	new Name[MAX_NAME_LENGTH];
	new SessionID;
	new Authid[MAX_AUTHID_LENGTH];
	new Team, Dead;
	new WONID;

#if log_info == 1
	new AHD; // admin hierarchy diagnostic
	new Command[MAX_COMMAND_LENGTH];
	convert_string(HLCommand, Command, MAX_COMMAND_LENGTH);
	new CurTime[MAX_NUMBER_LENGTH];
	new CurDate[MAX_NUMBER_LENGTH];
	servertime(CurDate, MAX_NUMBER_LENGTH, "%d");
	servertime(CurTime, MAX_NUMBER_LENGTH, "%H:%M");
#endif

	convert_string(HLName, UserName, MAX_NAME_LENGTH);
	get_userAuthID(UserName,COMauthid);

	if(bCloakOwner == true){
		cloak = 2;
	}else{
		cloak = 1;
	}

	if(bAutoSignIn == true){
		for (i = cloak; i <= TotalAdmins; i++) {
			if ((i < 1) || (i > 1000)) {
				break;
			}	
			if(strcmp(COMauthid, AdminInfo[i]) == 0){
				AdminOn[i] = 1;
				AdminResign[i] = 0;
			}
		}
	}

	for (i = 1; i <= TotalAdmins; i++) {
		if ((i < 1) || (i > 1000)) {
			break;
		}
		if(AdminOn[i] == 1){
			if(FoundHi == 0){
				strcpy(HiAUTHID,AdminInfo[i], MAX_AUTHID_LENGTH);
				FoundHi =1;
			}
			if((AdminType[i] == 1) && (strcmp(AdminInfo[i],COMauthid) == 0)){
				AllowCommand = 1;
				DenyAdmin = 1;
#if log_info == 1
				AHD=100;
#endif
			}
		} 
		if(DenyAdmin == 0){
			if(AdminOn[i] == 1){
				DenyAdmin = 1;				
				if(strcmp(AdminInfo[i], COMauthid) == 0) {	
					AllowCommand = 1;
#if log_info == 1
					AHD=i;
#endif
				}
			}
		}
	}

	if(AllowCommand == 1){
		AllowCommand = 0;
		DenyAdmin = 0;
#if log_info == 1
		snprintf(Text, MAX_TEXT_LENGTH, "%s %s <AHD>  CMD SUCCEED  %s %s %i %i%i%i%i%i%i %i%i%i%i%i%i %i%i%i%i%i%i %i%i%i%i%i%i   %i%i%i%i%i%i %i%i%i%i%i%i %i%i%i%i%i%i", CurDate, CurTime, UserName, Command, AHD, 
		AdminOn[1],AdminOn[2],AdminOn[3],AdminOn[4],AdminOn[5],AdminOn[6],AdminOn[7],AdminOn[8],AdminOn[9],AdminOn[10],
		AdminOn[11],AdminOn[12],AdminOn[13],AdminOn[14],AdminOn[15],AdminOn[16],AdminOn[17],AdminOn[18],AdminOn[19],AdminOn[20],AdminOn[21],AdminOn[22],AdminOn[23],AdminOn[24],
		AdminResign[1],AdminResign[2],AdminResign[3],AdminResign[4],AdminResign[5],AdminResign[6],AdminResign[7],AdminResign[8],AdminResign[9],AdminResign[10],
		AdminResign[11],AdminResign[12],AdminResign[13],AdminResign[14],AdminResign[15],AdminResign[16],AdminResign[17],AdminResign[18]);
		log(Text);
		writefile("AHD.log",Text);
		FoundHi=0;
		AHD=0; 
#endif
		return PLUGIN_CONTINUE;
	}
	if(DenyAdmin == 0){
		execclient(UserName, "speak ^"access denied you slime bag^""); 
		selfmessage("You are not admin here, so you cant do that ... MMMM'kay ...");
		selfmessage(" or maybe you forgot to sign in ... MMMM'kay ... The command:   admin_signin");
#if log_info == 1
		snprintf(Text, MAX_TEXT_LENGTH, "%s %s <AHD>  CMD FAILED NA  %s %s %i %i%i%i%i%i%i %i%i%i%i%i%i %i%i%i%i%i%i %i%i%i%i%i%i   %i%i%i%i%i%i %i%i%i%i%i%i %i%i%i%i%i%i", CurDate, CurTime, UserName, Command, AHD,
		AdminOn[1],AdminOn[2],AdminOn[3],AdminOn[4],AdminOn[5],AdminOn[6],AdminOn[7],AdminOn[8],AdminOn[9],AdminOn[10],
		AdminOn[11],AdminOn[12],AdminOn[13],AdminOn[14],AdminOn[15],AdminOn[16],AdminOn[17],AdminOn[18],AdminOn[19],AdminOn[20],AdminOn[21],AdminOn[22],AdminOn[23],AdminOn[24],
		AdminResign[1],AdminResign[2],AdminResign[3],AdminResign[4],AdminResign[5],AdminResign[6],AdminResign[7],AdminResign[8],AdminResign[9],AdminResign[10],
		AdminResign[11],AdminResign[12],AdminResign[13],AdminResign[14],AdminResign[15],AdminResign[16],AdminResign[17],AdminResign[18]);
		writefile("AHD.log", Text);
		log(Text);
		FoundHi=0;
		AHD=0; 
#endif
		return PLUGIN_HANDLED;
	}
	AllowCommand = 0;
	DenyAdmin = 0;
	execclient(UserName, "speak ^"access denied^"");
	for (i = 1; i <= iMaxPlayers; i++) {
     		if (playerinfo(i,Name,MAX_NAME_LENGTH,SessionID,WONID,Team,Dead,Authid) !=0) {
        		if(strcmp(Authid, HiAUTHID) == 0){
				strcpy(HiName,Name,MAX_NAME_LENGTH);
			}
		}
	}
	FoundHi = 0;
	snprintf(Text, MAX_TEXT_LENGTH, "%s is the current top admin here, ask him.", HiName);	
	selfmessage(Text);

#if log_info == 1
	snprintf(Text, MAX_TEXT_LENGTH, "%s %s <AHD>  CMD FAILED HO  %s %s %i %i%i%i%i%i%i %i%i%i%i%i%i %i%i%i%i%i%i %i%i%i%i%i%i   %i%i%i%i%i%i %i%i%i%i%i%i %i%i%i%i%i%i", CurDate, CurTime, UserName, Command, AHD,
	AdminOn[1],AdminOn[2],AdminOn[3],AdminOn[4],AdminOn[5],AdminOn[6],AdminOn[7],AdminOn[8],AdminOn[9],AdminOn[10],
	AdminOn[11],AdminOn[12],AdminOn[13],AdminOn[14],AdminOn[15],AdminOn[16],AdminOn[17],AdminOn[18],AdminOn[19],AdminOn[20],AdminOn[21],AdminOn[22],AdminOn[23],AdminOn[24],
	AdminResign[1],AdminResign[2],AdminResign[3],AdminResign[4],AdminResign[5],AdminResign[6],AdminResign[7],AdminResign[8],AdminResign[9],AdminResign[10],
	AdminResign[11],AdminResign[12],AdminResign[13],AdminResign[14],AdminResign[15],AdminResign[16],AdminResign[17],AdminResign[18]);
	log(Text);
	writefile("AHD.log",Text);
	AHD=0; 
#endif
	return PLUGIN_HANDLED;
}

public CantBanMe(HLCommand, HLData, HLName, UserIndex){
	new i;
	new authid[MAX_AUTHID_LENGTH];
	new DenyRequest;
	new UserName[MAX_NAME_LENGTH];
	new Name[MAX_NAME_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new Command[MAX_COMMAND_LENGTH];
	new Text[MAX_TEXT_LENGTH];

	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLName,UserName,MAX_DATA_LENGTH);
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);

	if (check_user(Data)==1){
		get_username(Data,Name,MAX_NAME_LENGTH);
		get_userAuthID(Data,authid);
	}
	for (i = 1; i <= TotalAdmins -1; i++) {
		if ((i < 1) || (i > 1000)) {
			break;
		}	
		if(strcmp(authid, AdminInfo[i]) == 0){
			DenyRequest = 1;
#if AllowOwnerKick == 1
			if((strcasestr(Command, "kick") != -1) && (strcmp(authid, AdminInfo[1]) == 0) && (bCloakOwner == true)){
				DenyRequest = 0;
			}
#endif
		}
	}		
	if(DenyRequest == 1){
		snprintf(Text, MAX_TEXT_LENGTH, "Sorry,  %s cannot be banned or kicked from here.", Name);
		selfmessage(Text);
        	execclient(UserName, "speak ^"access denied _comma administration has safe status^"");
		DenyRequest = 0;
		return PLUGIN_HANDLED;
	}
	return PLUGIN_CONTINUE;
}

public admin_resign(HLCommand, HLData, HLUserName, UserIndex){

	new i;
	new UserName[MAX_NAME_LENGTH];
	new AUTHID[MAX_AUTHID_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new FoundHi;
	new HiAUTHID[MAX_AUTHID_LENGTH];
	new HiName[MAX_NAME_LENGTH];
	new FoundHix;
	new HiAUTHIDx[MAX_AUTHID_LENGTH];
	new HiNamex[MAX_NAME_LENGTH];
	new iMaxPlayers = maxplayercount();
	new Name[MAX_NAME_LENGTH];
	new SessionID;
	new WONID;
	new Authid[MAX_AUTHID_LENGTH];
	new Team, Dead;

	convert_string(HLUserName, UserName, MAX_NAME_LENGTH);
	get_userAuthID(UserName,AUTHID);

	for (i = 1; i <= TotalAdmins; i++) {
		if ((i < 1) || (i > 1000)) {
			break;
		}
		if(AdminOn[i] == 1){
			if(FoundHix == 0){
				strcpy(HiAUTHIDx,AdminInfo[i], MAX_AUTHID_LENGTH);
				FoundHix =1;
			}
		}	
		if(strcmp(AUTHID, AdminInfo[i]) == 0){
			AdminOn[i] = 0;
			AdminResign[i] = 1;
		}
		if(AdminOn[i] == 1){
			if(FoundHi == 0){
				strcpy(HiAUTHID,AdminInfo[i], MAX_AUTHID_LENGTH);
				FoundHi =1;
			}
		}
	}
	for (i = 1; i <= iMaxPlayers; i++) {
     		if (playerinfo(i,Name,MAX_NAME_LENGTH,SessionID,WONID,Team,Dead,Authid) !=0) {
        		if(strcmp(Authid, HiAUTHID) == 0){
				strcpy(HiName,Name,MAX_NAME_LENGTH);
			}
        		if(strcmp(Authid, HiAUTHIDx) == 0){
				strcpy(HiNamex,Name,MAX_NAME_LENGTH);
			}
		}
	}
	if(FoundHi==0){
		strcpy(HiName, "... uh, there is none.", MAX_NAME_LENGTH);
	}
	if(strcmp(UserName, HiNamex) == 0){
		snprintf(Text, MAX_TEXT_LENGTH, "%s resigned. Top admin is now %s", UserName, HiName);	
	}else{
		snprintf(Text, MAX_TEXT_LENGTH, "%s resigned. Top admin was always %s", UserName, HiName);
	}
	if(bReportS == true){
		say(Text);
		selfmessage(Text);
	}else{
		selfmessage(Text);
		selfmessage("This was not publicly reported");
	}
	FoundHi = 0;
	FoundHix = 0;
	return PLUGIN_HANDLED;
}

public admin_signin(HLCommand, HLData, HLUserName, UserIndex){

	new i;
	new UserName[MAX_NAME_LENGTH];
	new AUTHID[MAX_AUTHID_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new FoundHi;
	new HiAUTHID[MAX_AUTHID_LENGTH];
	new HiName[MAX_NAME_LENGTH];
	new iMaxPlayers = maxplayercount();
	new Name[MAX_NAME_LENGTH];
	new SessionID;
	new WONID;
	new Authid[MAX_AUTHID_LENGTH];
	new Team, Dead;

	convert_string(HLUserName, UserName, MAX_NAME_LENGTH);
	get_userAuthID(UserName,AUTHID);

	for (i = 1; i <= TotalAdmins; i++) {
		if ((i < 1) || (i > 1000)) {
			break;
		}	
		if(strcmp(AUTHID, AdminInfo[i]) == 0){
			AdminOn[i] = 1;
			AdminResign[i] = 0;
			if((strcmp(AUTHID, AdminInfo[1]) == 0) && (bCloakOwner == true)){
				messageex(UserName, "<Private Message> You are no longer cloaked.", print_console);
				messageex(UserName, "<Private Message> You are no longer cloaked.", print_chat);
				AdminOn[1] = 1;
				bCloakOwner = false;
			}
		}
		if(AdminOn[i] == 1){
			if(FoundHi == 0){
				strcpy(HiAUTHID,AdminInfo[i],MAX_AUTHID_LENGTH);
				FoundHi =1;
			}
		}
	}
	for (i = 1; i <= iMaxPlayers; i++) {
     		if (playerinfo(i,Name,MAX_NAME_LENGTH,SessionID,WONID,Team,Dead,Authid) !=0) {
        		if(strcmp(Authid, HiAUTHID) == 0){
				strcpy(HiName,Name,MAX_NAME_LENGTH);
			}
		}
	}
	if(FoundHi==0){
		strcpy(HiName, "... uh, there is none.", MAX_NAME_LENGTH);
	}
	i=1;
	FoundHi = 0;
	snprintf(Text, MAX_TEXT_LENGTH, "%s signed in. The top admin is %s", UserName, HiName);
	if(bReportS == true){
		say(Text);
		selfmessage(Text);
	}else{
		selfmessage(Text);
		selfmessage("This was not publicly reported");
	}
	return PLUGIN_HANDLED;
}

public admin_topadmin(HLCommand, HLData, HLUserName, UserIndex){

	new i;
	new Text[MAX_TEXT_LENGTH];
	new FoundHi;
	new HiAUTHID[MAX_AUTHID_LENGTH];
	new HiName[MAX_NAME_LENGTH];
	new iMaxPlayers = maxplayercount();
	new Name[MAX_NAME_LENGTH];
	new SessionID;
	new WONID;
	new Authid[MAX_AUTHID_LENGTH];
	new Team, Dead;
	new cloak;

	if(bCloakOwner == true){
		cloak = 2;
	}else{
		cloak = 1;
	}

	for (i = cloak; i <= TotalAdmins; i++) {
		if ((i < 1) || (i > 1000)) {
			break;
		}	
		if(AdminOn[i] == 1){
			if(FoundHi == 0){
				strcpy(HiAUTHID,AdminInfo[i],MAX_AUTHID_LENGTH);
				FoundHi =1;
			}
		}
	}
	for (i = 1; i <= iMaxPlayers; i++) {
     		if (playerinfo(i,Name,MAX_NAME_LENGTH,SessionID,WONID,Team,Dead,Authid) !=0) {
        		if(strcmp(Authid, HiAUTHID) == 0){
				strcpy(HiName,Name,MAX_NAME_LENGTH);
			}
		}
	}
	if(FoundHi==0){
		strcpy(HiName, "... uh, there is none.", MAX_NAME_LENGTH);
	}
	i=1;
	FoundHi = 0;
	snprintf(Text, MAX_TEXT_LENGTH, "Current top admin: %s    More: admin_adminstatus", HiName);	
	say(Text);
	selfmessage(Text);
	return PLUGIN_HANDLED;
}

public admin_adminstatus(HLCommand, HLData, HLUserName, UserIndex){

	new i;
	new j;
	new FoundHi;
	new HiAUTHID[MAX_AUTHID_LENGTH];
	new HiName[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new iMaxPlayers = maxplayercount();
	new Name[MAX_NAME_LENGTH];
	new SessionID;
	new WONID;
	new Authid[MAX_AUTHID_LENGTH];
	new Team, Dead;
	new AdminCurName[MAX_NAME_LENGTH];
	new YesNo[4];
	new PowStat[10];
	new SomeoneHere = 0;
	new cloak;

	if(bCloakOwner == true){
		cloak = 2;
	}else{
		cloak = 1;
	}

	FoundHi = 0;
	selfmessage("");
	selfmessage("Rank / Signed In / Full Power / Constant Name / Current Name");

	for (i = cloak; i <= TotalAdmins; i++) {		
		if ((i < 1) || (i > 1000)) {
			break;
		}
		for (j = 1; j <= iMaxPlayers; j++) {
			if ((j < 1) || (j > 1000)) {
				break;
			}
			if (playerinfo(j,Name,MAX_NAME_LENGTH,SessionID,WONID,Team,Dead,Authid) !=0) {
     				if(strcmp(Authid, AdminInfo[i]) == 0){
					if (check_auth(ACCESS_MAP)==1) {
						strcpy(AdminCurName, Name, MAX_NAME_LENGTH);
						if(AdminOn[i] == 1){
							strcpy(YesNo, "Yes", 4);
						}else{
							strcpy(YesNo, "No ", 4);
						}
						if((AdminType[i] == 1) && (AdminOn[i] == 1)){
							strcpy(PowStat, "-Enabled-", 10);
							FoundHi = 1;
						}else{
							if((AdminOn[i] == 1) && (FoundHi == 0)){
								strcpy(PowStat, "-Enabled-", 10);
								FoundHi = 1;
							}else{
								strcpy(PowStat, "Resticted", 10);
							}
						} 
						SomeoneHere = 1;
						if(i < 10){
							snprintf(Text, MAX_TEXT_LENGTH, "0%i     %s       %s    %s        %s", i, YesNo, PowStat, AdminName[i], AdminCurName);
						}else{
							snprintf(Text, MAX_TEXT_LENGTH, "%i     %s       %s    %s        %s", i, YesNo, PowStat, AdminName[i], AdminCurName);
						}
						selfmessage(Text);
					}else{
						if(access(ACCESS_MAP,Name)!=0) {
							strcpy(AdminCurName, Name, MAX_NAME_LENGTH);
							if(AdminOn[i] == 1){
								strcpy(YesNo, "Yes", 4);
							}else{
								strcpy(YesNo, "No ", 4);
							}
							if((AdminType[i] == 1) && (AdminOn[i] == 1)){
								strcpy(PowStat, "-Enabled-", 10);
								FoundHi = 1;
							}else{
								if((AdminOn[i] == 1) && (FoundHi == 0)){
									strcpy(PowStat, "-Enabled-", 10);
									FoundHi = 1;
								}else{
									strcpy(PowStat, "Resticted", 10);
								}
							} 
							SomeoneHere = 1;
							if(i < 10){
								snprintf(Text, MAX_TEXT_LENGTH, "0%i     %s       %s    %s        %s", i, YesNo, PowStat, AdminName[i], AdminCurName);
							}else{
								snprintf(Text, MAX_TEXT_LENGTH, "%i     %s       %s    %s        %s", i, YesNo, PowStat, AdminName[i], AdminCurName);
							}
							selfmessage(Text);
						}
					}
				}
			}
		}
	}
	FoundHi = 0;
	if(SomeoneHere==0){
		selfmessage("Hmmm.... I guess there are no admins on. Whether they are signed in or not.");
	}else{
		for (i = 1; i <= TotalAdmins; i++) {
			if ((i < 1) || (i > 1000)) {
				break;
			}	
			if(AdminOn[i] == 1){
				if(FoundHi == 0){
					strcpy(HiAUTHID,AdminInfo[i],MAX_AUTHID_LENGTH);
					FoundHi =1;
				}
			}
		}
		for (i = 1; i <= iMaxPlayers; i++) {
     			if (playerinfo(i,Name,MAX_NAME_LENGTH,SessionID,WONID,Team,Dead,Authid) !=0) {
        			if(strcmp(Authid, HiAUTHID) == 0){
					strcpy(HiName,Name,MAX_NAME_LENGTH);
				}
			}
		}
		if(FoundHi==0){
			strcpy(HiName, "... uh, none. Nobody signed in.", MAX_NAME_LENGTH);
		}
		i=1;
		FoundHi = 0;
		snprintf(Text, MAX_TEXT_LENGTH, "The current top admin is %s", HiName);	
		selfmessage(Text);
	}
	selfmessage("");				
	SomeoneHere = 0;
	
	return PLUGIN_HANDLED;
}

public admin_signin_deflt(HLCommand, HLData, HLUserName, UserIndex){

	new Command[MAX_COMMAND_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new AUTHID[MAX_AUTHID_LENGTH];
	convert_string(HLData,Data,MAX_DATA_LENGTH);
 	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	get_userAuthID(User, AUTHID);

	if(strcmp(AdminInfo[1], AUTHID) == 0){
	
		log_command(User,Command,Data);

		if(bAutoSignIn == true){
			bAutoSignIn = false;
			set_vaultnumdata("EJL_ADMINH_MODE", 2);
			selfmessage("Admins are no longer automaically signed in.  This has been set as the default.");
		}else{
			bAutoSignIn = true;
			set_vaultnumdata("EJL_ADMINH_MODE", 1);
			selfmessage("Admins will be signed in automatically.  This has been set as the default.");
		}
	}else{
		selfmessage("You do not have access to this command because you are not listed as the 1st admin.");
	}
	return PLUGIN_HANDLED;
}

public admin_ah_report(HLCommand, HLData, HLUserName, UserIndex){

	new Command[MAX_COMMAND_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new AUTHID[MAX_AUTHID_LENGTH];
	convert_string(HLData,Data,MAX_DATA_LENGTH);
 	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	get_userAuthID(User, AUTHID);

	if(strcmp(AdminInfo[1], AUTHID) == 0){
	
		log_command(User,Command,Data);

		if(bReportS == true){
			bReportS = false;
			set_vaultnumdata("EJL_ADMINH_REPORT", 2);
			selfmessage("Admins' sign in and sign out are no longer reported in chat -- now set as default.");
		}else{
			bReportS = true;
			set_vaultnumdata("EJL_ADMINH_REPORT", 1);
			selfmessage("Admins' sign in and sign out are now reported in chat -- now set as default.");
		}
	}else{
		selfmessage("You do not have access to this command because you are not listed as the 1st admin.");
	}
	return PLUGIN_HANDLED;
}

public admin_cloak_own(HLCommand, HLData, HLUserName, UserIndex){

	new Command[MAX_COMMAND_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new AUTHID[MAX_AUTHID_LENGTH];
	convert_string(HLData,Data,MAX_DATA_LENGTH);
 	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	get_userAuthID(User, AUTHID);

	if(strcmp(AdminInfo[1], AUTHID) == 0){
	
		log_command(User,Command,Data);

		if(bCloakOwner == true){
			bCloakOwner = false;
			set_vaultnumdata("EJL_ADMINH_CLOAK", 1);
			selfmessage("You are NOT cloaked now.   This has been set as the default.");
		}else{
			bCloakOwner = true;
			AdminOn[1] = 0;
			set_vaultnumdata("EJL_ADMINH_CLOAK", 2);
			selfmessage("You are now CLOAKED.  This has been set as the default.");
		}
	}else{
		selfmessage("You do not have access to this command because you are not listed as the 1st admin.");
	}
	return PLUGIN_HANDLED;
}

public admin_ah_reload(HLCommand, HLData, HLUserName, UserIndex){

	new Command[MAX_COMMAND_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new iAdmin;
	new sAdminData[100];
	new sAdminType[10];
	new sAdminName[MAX_NAME_LENGTH];
	new sAdminAuthID[MAX_AUTHID_LENGTH];
	convert_string(HLData,Data,MAX_DATA_LENGTH);
 	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	log_command(User,Command,Data);
	TotalAdmins = filesize("adminhierarchy.txt", lines);
	for (iAdmin = 1; iAdmin <= TotalAdmins; iAdmin++) {
		if ((iAdmin < 1) || (iAdmin > 1000)) {
			break;
		}
		readfile("adminhierarchy.txt", sAdminData, iAdmin, 100);
		strsplit(sAdminData, " ", sAdminType, 10, sAdminAuthID, MAX_AUTHID_LENGTH, sAdminName, MAX_NAME_LENGTH);
		AdminType[iAdmin] = strtonum(sAdminType);
		strcpy(AdminInfo[iAdmin], sAdminAuthID, MAX_AUTHID_LENGTH);
		strcpy(AdminName[iAdmin], sAdminName, MAX_NAME_LENGTH);
	}
	selfmessage("Reloaded: Adminhierachy.txt.   Any changes made are now in effect.");		
	return PLUGIN_HANDLED;
}
