/***************************************************************************************************************
* Version 1.9a  *****		*****   [01-22-2001]   *****	*****   [HDK]DragonReborn   *
****************************************************************************************************************
* Credits
* ------------
* Original Creator is Karel from the adminmod team.  Yensid also played a part in the code in AM version conversion 2.10 - 2.50
* Please give them most the credit, my version here is based off an earlier version then what they recently released.
* Under my version numbers, I started at 1.2b.  I have not looked at their recent changes, so don't ask me about them.
****************************************************************************************************************
* This plugin let's you declare two clan tags, check that everyone has them,
* and kick anyone that doesn't.  Then it puts a password on the server, and 
* restarts the round in 10 secs and sets all ogl match rule settings. It then 
* starts a timer that displays the timeleft every minute or with the admin_matchtime 
* command. The timer can be turned off with the admin_matchtimer on/off command.  
* Remember the clan tags ARE case sensetive. 
*
*
* NEED HELP??? --> [HDK]DragonReborn --- mascarod@hotmail.com
*
_____________________________________________________________________________________________________________
* Installation:|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
* ---------------
* 
* Installation is very easy.  It would be best to compile the sma file with the computer you plan
* to run the server on.  Before doign so, however, edit the servername variable in the 'normal .cfg' file
* Otherwise your server will be given the default name 'CS 1.3 || AdminMod' when admin_endmatch is used.
* The only values to change in the sma would be the default map time for each match half and the status of score reporting at each round end.
* These can be found inside the box of ### characters.  Everything else is set in the two CFG files.
* 
* After compiling this file...put the amx file in the dlls folder and edit the plugin.ini file to
* include this line:    addons/adminmod/scripts/plugin_dragon_clanmatch.amx
*
*Once you have compiled it, put it in the dlls folder of the server and added that line to the plugin.ini file, 
* the final thing to be sure of is that your match.cfg and normal.cfg files are in the cstrike folder.
*	(ex. C:\SIERRA\Half-Life\cstrike  or  C:\SIERRA\Counter-Strike\cstrike)
* If you would rather not change names of your files to match or normal.cfg from ogl.cfg or whatever,
* ...then in those files just put 'exec ogl.cfg' or whatever you plan to use
*
* -----
* LogD
* -----
* -If you really want the score part of this plugin to work, make sure LogD[ version 1.00+] works before
* trying this.  Otherwise, this plugin does not require LogD at all.
*
* -Start your server and try the commands.  If you did not restart the server, at least do a map change so that
* everything loads.
*
_____________________________________________________________________________________________________________
* Change Log:|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
*
* New to version 1.9a / 01-23-2002
* ----------------------------------------------
*	-Deleted admin_alltalk command declaration that displayed a minor error when the plugin loaded. 
*	  Admin_alltalk is no longer used so the code was not necessary.
*
* New to version 1.9 / 01-22-2002
* ----------------------------------------------
*	-Changed format of server settings
*		-Removed all customizatoins from the sma file so that re-compiling is not necessary for each change
*		-Specify match settings in the "match.cfg" file, allows for use of plugin with any tourny ladder settings(ex. ogl.cfg or sta.cfg)
*		-Specify normal game play settings in the "normal.cfg" file(could use server.cfg here if all normal play settings are in there)
*		-Normal game play SERVER_NAME changing has been moved to normal.cfg to allow easy editing w/o recompiling
*	-Removed admin_alltalk because the beta server required for it is outdated
*	-Fixed bug with switchteams not working
*
* New to version 1.8 / 01-05-2002
* ----------------------------------------------
*	-Put in notes for original creators(finally found out who they were)
*	-Fixed some spelling errors in this help section
*	-No other new features or commands
*
* New to version 1.7 / 12-09-2001
* ---------------------------------------------
*	-It is really compatible with LogD 1.00 now
*	-Fixed minor issues with logging so that Pyschostats doesn't give errors
*
* New to version 1.6 / 11-03-2001
* ---------------------------------------------
*
*	-No new commands or functions
*	-Revised plugin to work with new version of LogD[1.00] and dropped support for old LogD versions < 1.00
*
* New to version 1.5 / 10-15-2001
* ---------------------------------------------
*
*	-Changed file name to plugin_dragon_clanmatch
*		-Relieves version number from file name and adds author name to distinguish between others versions
*	-Fixed timer not turning off automatically sometimes
*	-Added centersays to admin_alltalk to announce activation or deactivation of alltalk
*
* New to version 1.4 / 10-07-2001
* ---------------------------------------------
*
*	-Added admin_alltalk: turns voice chat on/off for all players to talk to all other players
*			*** (requires beta HL server[beta "a" version] from www.counter-strike.net ) ***
*	-Final team scores report for each timed match when the timer shuts off *** (requires LogD) ***
*	-Added admin_scores: turns team score reporting on/off for every round *** (requires LogD) ***
*	-Take a screen shot of the scoreboard anytime by saying "ss" in chat
*	-Server variable changes run local, rather than from client using admin, to reduce the execution lag
*	-Added the ability to easily change the matchtime variable while on server: admin_matchtimer <minutes>
*		-If left blank, the default 25 minutes will be used
*	-Added the ability of clients to type "matchtime", "time", or "match time" in chat to get the current
*	 time elapsed on the match timer
*	-Command usage is now logged to HL Logs(admin_clanmatch, matchtimer, and endmatch only)
*	-Optimized more code
*		-Put in code to remove timers used for the matchtimer, so when the matchtimer is disabled the
*		 server resources are not being used when the match timer is not actually running.
*	-Enabling of matchtimer now sets mp_timelimit to 0 so that when the timer is used without the whole
*	 server being set to match play, the map won't change in the middle of match time
*	-When timer or match is deactivated, mp_timelimit set back to what it was before activation
*	-Fixed errors in text information section
*	-Fixed some timing of CSAYs
*	-Fixed selfmessage text to show the default or specified matchtime when entered into console
* 
* New to version 1.3 / 
* -----------------------------
*
*	-Admin_clanmatch no longer starts the timer automatically, only sets the server settings for match play
*	-ServerName and MatchTime set as global variables to allow easier setting for personal preferences
*		-Look for section of code near the top labeled with: #############
*	-Fixed the 10 seconds of play lost due to the restartround at the start of the timer
*	-Added 10 second countdown to the timer before automatic shut-off
*	-Optimized code
*		-Removed un-needed code and restructured other segments
*	-Improved visual messages
*		-Added some centersays and changed some colors
*	-Updated for latest OGL settings
*	-New layout for readme section
* 
* New to version 1.2b / [HDK]DragonReborn starts revisions
* ---------------------------------------------------------------------------------------
*
*	-Added Admin_switchteams
*	-Added Admin_endmatch
*		-Removes server password, returns server name to desired name, and returns server settings
*	-Removed all compilation errors
*	Note: All settings set to OGL.org defined RULES. 
*	      You CAN change any of the settings for your own needs.
*
*	******* ALSO: With the additions by [HDK]DragonReborn,
*		users will need admin_hostname and admin_nopass access for those to work.
*		Plugin will still work without it however, it will just have limited features.
*
_____________________________________________________________________________________________________________
* Commands:|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
*	Admin_clanmatch (clan tag 1) (clan tag 2) (serverpassword)
*		-Kicks players that don't have clantag1 or clantag2, puts the password on the server,
*		 and restarts the round to clear scores.
*			-Changes server name to (ClanTag1) vs. (ClanTag2)   
*			-Changes mp_timelimit to 0 so that the map will not change after the first 25 minutes
*			 so that the teams can switch sides and play the 2nd half of the match, just
*			 use admin_matchtimer to stop the first timer and start again after teams
*			 have switched sides.
*
*	Admin_matchtimer <minutes>
*		-Toggles the clan match timer (on/off).
*		-Sets match time to specified minutes(default=25). 
*		-Restart round on each start of the timer
*		-Starts matchtimer with 10 second countdown, ends with 10 second countdown
*		-Deactivation returns mp_timelimit back to default(below)
*
*	Admin_matchtime 
*		-Public Command displays timer time elapsed.
* 
*	Admin_endmatch 
*		-Removes the server password	
*		-Changes server name back to the ServerName specified in the admin_endmatch code section
*		-Returns server to desired preferences for time settings and stuff for non clan match game play
*		-Deactivation returns mp_timelimit back to default(below)
*		-Disables any active timer
*
*	Admin_switchteams
*		-Switches the teams of all players on the server except those admins with access immunity
*			-uses admin_t and admin_ct commands
*			-useful for the mid-clanmatch time when each side must switch teams at the same time
*			-Works for normal game play also, does not require the use of timers
*
*	Admin_scores <#> (1=on/0=off) *** (requires LogD running)
*		-Turns team score reporting on/off for every round
*		-Works for normal game play also, does not require the use of timers
*
*	say "ss"
*		-Takes screen shot of the current scoreboard
*		-Works for normal game play also, does not require the use of timers
*
*	say "matchtime", "time", or "match time"
*		-Displays the current elapsed match time if the timer is active(uses admin_matchtime)
*	
********************************************************************************************************************************************************/

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_CLANMATCH 4096
#define ACCESS_TIMER 4096
#define ACCESS_MATCHTIME 0
#define ACCESS_CONSOLE 131072

new Status = 0;
new LogDenabled = 0;
new Request = 0;
new Counter = 1;
new ElapsedM = 0;            
new ElapsedS = 0;
new CTScore[MAX_DATA_LENGTH];
new TScore[MAX_DATA_LENGTH];
new LastTime;
new MatchTime;
new DraTimer;
new CTimer;
new z = 0;
new STRING_VERSION[MAX_DATA_LENGTH] = "v1.9a";

/*#############################################################################*/
new MTimeDefault = 25;	//default timelimit (minutes per map[half of match] for clan matches)
new Report = 0;		//defaults score reporting to off at each map start, change to 1 to activate at each map start
/*		*** Don't edit any other code below. ***
#############################################################################*/


public admin_clanmatch(HLCommand,HLData,HLUserName,UserIndex)
{
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new ClanTag1[MAX_NAME_LENGTH];
	new ClanTag2[MAX_NAME_LENGTH];
	new TempServerName[MAX_NAME_LENGTH];
	new Password[MAX_DATA_LENGTH];
	new maxplayers = maxplayercount();
	new Target[MAX_NAME_LENGTH];
	new i = 0;
	new Variable[MAX_TEXT_LENGTH];
	new SessionID;
	new WONID;
	new Team;
	new Text[MAX_TEXT_LENGTH];

	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	strbreak(Data, ClanTag1, Data, MAX_NAME_LENGTH);
	if (strlen(ClanTag1) == 0) {
		selfmessage("Clantag 1 missing");
		return PLUGIN_HANDLED;
	}
	strbreak(Data, ClanTag2, Data, MAX_NAME_LENGTH);
	if (strlen(ClanTag2) == 0) {
		selfmessage("Clantag 2 missing");
		return PLUGIN_HANDLED;
	}
	strbreak(Data, Password, Data, MAX_NAME_LENGTH);
	if (strlen(Password) == 0) {
		selfmessage("Password was not specified, server password not set");
	}else {
		execute_command(User,"SV_Password","sv_password",Password);
		snprintf(Text, MAX_TEXT_LENGTH, "Server password has been set to ^"%s^".", Password);
		centersay(Text,10,255,0,0);
		say(Text);
	}

	for(i=1; i<=maxplayers; i++) {
		if(playerinfo(i,Target,MAX_NAME_LENGTH,SessionID,WONID,Team)==1) {
			if (strstr(Target, ClanTag1) == -1 && strstr(Target, ClanTag2) == -1) {
				if(check_immunity(Target)==0 && i != UserIndex) {
					message(Target, "A match is about to start ... thanks for leaving this quickly. Please don't rejoin right now, thanks.");
					kick(Target);
				}
			}
		}
	}

	exec("exec match.cfg");
	
	TempServerName="^"";
	strcat(TempServerName,ClanTag1, MAX_NAME_LENGTH);
	strcat(TempServerName," vs. ", MAX_NAME_LENGTH);
	strcat(TempServerName,ClanTag2, MAX_NAME_LENGTH);
	strcat(TempServerName,"^"",MAX_NAME_LENGTH);
	
	snprintf(Variable,MAX_TEXT_LENGTH,"hostname %s",TempServerName);
	exec(Variable);
	
	log_command(User, Command, Data);
	return PLUGIN_HANDLED;
}

public admin_matchtimer(HLCommand,HLData,HLUserName)
{                        
	new i;
	new maxplayers = maxplayercount();
	new User[MAX_NAME_LENGTH];
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new Team;
	new WONID;
	new SessionID;
	new Target[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new Text2[MAX_TEXT_LENGTH];

	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

        if (Status == 0) {
		Status = 1;
		ElapsedM = 0;
		ElapsedS = 0;
			
		exec("mp_timelimit 0");

		if (strlen(Data) == 0) {
			MatchTime = 25;
			selfmessage("[ MatchTime not given, using default of 25 minutes. ]");
		}else {
			MatchTime = strtonum(Data);
			snprintf(Text,MAX_TEXT_LENGTH,"[ MatchTime given as %i minutes. ]",MatchTime);
			selfmessage(Text);
		}
		
		exec("sv_restartround 10");
		centersay("Match Starts at Round Reset in 10 seconds.",10,255,0,0);
		z=10;
		CTimer = set_timer("countdown", 1, 10);
		say("[ Clan Match Timer Started ]");
		snprintf(Text,MAX_TEXT_LENGTH,"Match is LIVE after restart and runs for %i minutes.",MatchTime);
		centersay(Text,10,0,255,0);
		Counter=systemtime() + 10;
		DraTimer = set_timer("refreshtime", 10, (MatchTime * 6 + 1));
		refreshtime();
			
		for(i=1; i<=maxplayers; i++) {
			strinit(Target);
			if(playerinfo(i,Target,MAX_NAME_LENGTH,SessionID,WONID,Team)==1) {
				execclient(Target, "speak ^"fvox/fuzz activated^"");		
				return PLUGIN_HANDLED;
			}
		}
		numtostr(MatchTime,Data);
		log_command(User,Command,Data);
	}else {
		Status = 0;
		snprintf(Text,MAX_TEXT_LENGTH,"mp_timelimit %i",MTimeDefault);
		exec(Text);

		kill_timer(CTimer);
		kill_timer(DraTimer);
		refreshtime();
		snprintf(Text, MAX_TEXT_LENGTH, "[ Clan Match Timer Stopped at: %i minute(s) %i second(s) ]", ElapsedM, ElapsedS);
		say(Text);
		say("");
		say("******************************************************************");
		snprintf(Text, MAX_TEXT_LENGTH, "If you would like a screenshot taken of the current scores, say: ss",20,0,255,0);
		say(Text);
		if (LogDenabled == 1) {
			snprintf(Text2, MAX_TEXT_LENGTH, "Final Score for this section of match is %s and %s^n", CTScore, TScore);
			say(Text2);
			strcat(Text2,Text,MAX_TEXT_LENGTH);
			centersay(Text2,20,0,255,0);
			
		}else {
			centersay(Text,20,0,255,0);
		}
		say("******************************************************************");
		Counter = 1;

		for(i=1; i<=maxplayers; i++) {
			strinit(Target);
			if(playerinfo(i,Target,MAX_NAME_LENGTH,SessionID,WONID,Team)==1) {
				execclient(Target, "speak ^"fvox/fuzz deactivated^"");
			}
		}
		
		numtostr(ElapsedM,Data);
		log_command(User, Command, Data);
	}
	return PLUGIN_HANDLED;
}

public admin_endmatch(HLCommand,HLUserName,HLData)
{
	new User[MAX_NAME_LENGTH];
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new Variable[MAX_TEXT_LENGTH];
	
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	
	plugin_exec("admin_nopass","");
	exec("exec normal.cfg");
        
        if (Counter == 1) {
		say("[ Clan Match Ended ]");
	} else {
		
		snprintf(Variable,MAX_TEXT_LENGTH,"%i",MatchTime);
		plugin_exec("admin_matchtimer","Variable");
	}
	snprintf(Variable,MAX_TEXT_LENGTH,"mp_timelimit %i",MTimeDefault);
	exec(Variable);

	log_command(User, Command, Data);
        return PLUGIN_HANDLED;
}

public admin_switchteams(HLCommand,HLUserName,HLData)
{

	//switch teams for all those connected, except those with admin_immunity or spectators

	new User[MAX_NAME_LENGTH];
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new i;
	new maxplayers = maxplayercount();
	new SessionID;
	new Target[MAX_NAME_LENGTH];
	new Team;
	new WONID;
	new Text[MAX_TEXT_LENGTH];

	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	
	snprintf(Text, MAX_TEXT_LENGTH, "Admin: Changed your team.");
	say(Text);
	centersay(Text,10,255,0,0);

	for(i=1; i<=maxplayers; i++) {
		strinit(Target);
		if(playerinfo(i,Target,MAX_NAME_LENGTH,SessionID,WONID,Team)==1) {
			if(Team==1) {
				plugin_exec("admin_ct",Target);
			}else if(Team==2) {
				plugin_exec("admin_t",Target);
			}
		}
	}

	log_command(User, Command, Data);
	return PLUGIN_HANDLED;	
}

public HandleSay(HLCommand,HLData,HLUserName,UserIndex) {

	//handles the chat words that activate some functions

	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	strstripquotes(Data);
	if ((streq(Data, "matchtime")==1) || (streq(Data, "time")==1) || (streq(Data, "match time")==1)) {
		if (systemtime() < LastTime) {
			return PLUGIN_CONTINUE;
  		} else {
  			admin_matchtime();
			LastTime = systemtime();
			LastTime += 20;
		}
	}
	if (streq(Data, "ss")==1) {
		execclient(User,"+showscores;wait;wait;wait;");
		execclient(User,"snapshot;wait;wait;-showscores");
		messageex(User,"( [ADMIN] : Sreenshot of the current scores has been taken for you. )",print_chat);
	}
	return PLUGIN_CONTINUE;
}

public admin_matchtime() {

	//displays elapsed match time

	if (Status == 0) {
		say("[ Clan Match Timer Not Activated ]");
	} else {
		Request = 1;
		refreshtime();
	}
	
	return PLUGIN_HANDLED;
}

public countdown() {

	//10 second count down to match start
	
	new Text[MAX_TEXT_LENGTH];
	
	snprintf(Text, MAX_TEXT_LENGTH, "Match Starts at Round Reset in %i ", z);
	say(Text);
	z--;
	return PLUGIN_CONTINUE;	
}

public countfinal() {

	//10 second count down
	
	new Text[MAX_TEXT_LENGTH];
	
	snprintf(Text, MAX_TEXT_LENGTH, "Match Ends in %i ", z);
	say(Text);
	z--;
	return PLUGIN_CONTINUE;
}

public refreshtime()
{
	new Text[MAX_DATA_LENGTH];

	if (Counter != 1) {
		new Elapsedtemp; 
		new ElapsedMtemp;
		new ElapsedStemp;
	
		Elapsedtemp = systemtime();
		Elapsedtemp = (Elapsedtemp - Counter);
		ElapsedMtemp = (Elapsedtemp / 60);
		ElapsedStemp = (Elapsedtemp - (ElapsedMtemp * 60) );
		ElapsedM = ElapsedMtemp;
		ElapsedS = ElapsedStemp;

		if ((ElapsedStemp > 55) || (ElapsedStemp < 5) || (Request == 1)) {

			//when the timer comes to an even minute from timer start, print the following message

			snprintf(Text, MAX_TEXT_LENGTH, "[ Match time elapsed: %i minute(s) %i second(s) ]", ElapsedMtemp, ElapsedStemp);
			say(Text);
			Request = 0;
		}
		if ((ElapsedMtemp == (MatchTime-1)) && (ElapsedStemp >= 50)) {

			//if the timer has reached the last 10 seconds of match, start count down

			z=10;
			set_timer("countfinal", 1, 10);
		}
		if ((ElapsedMtemp >= MatchTime) && (Status == 1)) {

			//end timer when matchtime has been reached

			plugin_exec("admin_matchtimer","25");
		}
	}
	return PLUGIN_CONTINUE;
}

public logd_matchscore(HLCommand,HLData,HLUserName,UserIndex)
{
	//LogD needs to be installed for this part of the clanmatch plugin to function.
	//If LogD is not installed, the pluging will automatically ignore this addition.

	new Params[MAX_DATA_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new Team[MAX_DATA_LENGTH];
	new Event[MAX_DATA_LENGTH];	
	new Text[MAX_TEXT_LENGTH];

	LogDenabled = 1;

	convert_string(HLData,Params,MAX_DATA_LENGTH);
	strbreak(Params,Team,Data,MAX_DATA_LENGTH);
	strbreak(Data,Event,Data,MAX_DATA_LENGTH);
	strbreak(Data,CTScore,TScore,MAX_DATA_LENGTH);

	if (Report == 1) {
		snprintf(Text,MAX_TEXT_LENGTH,"%s^nThe score is now:^n%s^n%s",Event,CTScore,TScore);
		typesay(Text,10,0,255,0);
	}
	return PLUGIN_HANDLED;
}

public admin_scores(HLCommand,HLData,HLUserName) {
	
	//LogD needs to be installed for this part of the clanmatch plugin to function.
	//If LogD is not installed, the pluging will automatically ignore this addition.
	
	new User[MAX_NAME_LENGTH];
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
		
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);	
	
	if (strlen(Data) > 0) {
		Report = strtonum(Data);
		if (Report == 1) {
			selfmessage("[ Score Reporting has been activated. ]");
		}else if (Report == 0) {
			selfmessage("[ Score Reporting has been deactivated. ]");
		}else {
			Report = 0;
			selfmessage("[ Command not issued correctly, 1=on, 0=off ]");
		}
	}else {
		selfmessage("[ Command not issued correctly, 1=on, 0=off ]");
	}
        return PLUGIN_HANDLED;
}

public plugin_init()
{
	plugin_registerinfo("Admin Clanmatch Plugin","Commands for running clan match settings and timers.",STRING_VERSION);

	plugin_registercmd("admin_clanmatch","admin_clanmatch",ACCESS_CLANMATCH,"admin_clanmatch <ClanTag1> <ClanTag2> <Password> : Kick everyone without <ClanTag1> or <ClanTag2> and set a password on server.");
	plugin_registercmd("admin_matchtimer", "admin_matchtimer", ACCESS_TIMER, "admin_matchtimer <number> : Toggles the clanmatch timer (on/off).");
	plugin_registercmd("admin_switchteams", "admin_switchteams", ACCESS_CLANMATCH, "admin_switchteams: Switches everyone to opposite team. Except those with admin_immunity.");
	plugin_registercmd("admin_matchtime", "admin_matchtime", ACCESS_MATCHTIME, "admin_matchtime: Public Command displays timer time elapsed.");
	plugin_registercmd("admin_endmatch", "admin_endmatch", ACCESS_CLANMATCH, "admin_endmatch: Restores server to non clanmatch settings and stops the timer.");
	plugin_registercmd("say","HandleSay",ACCESS_ALL);
	plugin_registercmd("logd_matchscore", "logd_matchscore", ACCESS_CONSOLE, "");
	plugin_registercmd("admin_scores", "admin_scores", ACCESS_CLANMATCH, "admin_scores <#>: Toggles reporting of team scores after every round.");
	
	plugin_registerhelp("say",ACCESS_ALL,"say matchtime/time/match time :  Shows current match time if a match is active.");
	plugin_registerhelp("say",ACCESS_ALL,"say ss :  Takes a screenshot of the current scores.");

	exec( "logd_reg 61 admin_command logd_matchscore" );

	return PLUGIN_CONTINUE;
}