/* 
CWC-MENUE
by: Sir Drink a lot
Plugin to make your settings of CW-Creator.
!!!Use amv_enable_beta "menu1" in your adminmod.cfg!!!
*/

#include <core> 
#include <console> 
#include <string> 
#include <admin> 
#include <adminlib>
#define ACCESS_WAR 256

new String_Version[]="05.05.03";

#define OK	0
#define BAD	1

new File[MAX_TEXT_LENGTH]="addons/adminmod/config/cwcreator/settings.ini";
new ruledir[MAX_DATA_LENGTH]="addons/adminmod/config/cwcreator/rules/";

#define SETTINGS 9
/*Hier werden die Setting reingeladen-- zur Zeit 9 Stck*/
new Commands[SETTINGS][MAX_COMMAND_LENGTH]={{"admin_war_pass"},{"admin_war_tag"},{"admin_war_map1"},{"admin_war_map2"},{"admin_war_endmap"},{"admin_war_rules"},{"admin_war_count"},{"admin_war_demo"},{"admin_war_countrules"}};
new Settings[SETTINGS][MAX_NAME_LENGTH];
new SaySettings[SETTINGS][MAX_TEXT_LENGTH]={{"Password"},{"Clantag"},{"Map 1"},{"Map 2"},{"Endmap"},{"Regel.cfg"},{"Score-Counter (0/1)"},{"Demo (0/1)"},{"Count-Modus (attack/all)"}};

/*Arrays zur Auswertung, anhand des UserIndex des Admins werden hoffentlich Fehlauswahlen verhindert*/
new MenuID[MAX_PLAYERS];
new LastMenuID[MAX_PLAYERS];
new MessageMode[MAX_PLAYERS];
new SelectedMenuCommand[MAX_PLAYERS];
new SelectedSet[MAX_PLAYERS];
new SelectedSetLoop[MAX_PLAYERS]={1,1,...};
new settingsloaded=0;



public admin_war_menu(HLCommand,HLData,HLUserName,UserIndex){
	new User[MAX_NAME_LENGTH];
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	mainmenu(User,UserIndex);
	return PLUGIN_HANDLED;
}

mainmenu(User[],UserIndex){
	new Text[512];
	new keys;
	new on;
	get_vaultnumdata("admin_war_on",on);
	if(on){
		snprintf(Text,MAX_TEXT_LENGTH,"\wCW-Creator-MainMenu:^n^n\y1. CW-Einstellungen^n\r2. -- CW Modus aktiv --^n\y3. CW-Regel.cfg nachtraeglich aendern^n4. CW-Runde mit Vote starten^n5. CW-Runde ohne Vote neu starten^n6. CW beenden^n^n\r0. Ende");
		keys=573;
	}else{
		snprintf(Text,MAX_TEXT_LENGTH,"\wCW-Creator-MainMenu:^n^n\y1. CW-Einstellungen^n2. CW-Modus starten^n\r3. -- nur im CW-Modus --^n4. -- nur im CW-Modus --^n5. -- nur im CW-Modus --^n6. -- nur im CW-Modus --^n^n0. Ende");
		keys=515;
	}
	menu(User,Text,keys);
	MenuID[UserIndex]=1;
	return 0;
}

/*Settingsauswahl 8 ist Next, 9 ist Back, 0 ist Cancel*/
setmenu(User[],UserIndex){
	new Text[512];
	new Auswahl[MAX_TEXT_LENGTH];
	new l=0;
	new i;
	new a=1;
	new keys=0;
	new on;
	get_vaultnumdata("admin_war_on",on);
	snprintf(Text,MAX_TEXT_LENGTH,"\wCW-Creator-Settings:^n^n");
	for(i=SelectedSetLoop[UserIndex];i<=settingsloaded;i++){
		l++;
		if(l==6){
			if(settingsloaded>SelectedSetLoop[UserIndex]+5){
				strcat(Text,"\y^n8. -x",MAX_TEXT_LENGTH);
				keys+=128;
				break;
			}else{
				break;
			}
		}else{
			if(!on){
				snprintf(Auswahl,MAX_TEXT_LENGTH,"\y%i. %s: \w%s^n",l,SaySettings[i-1],Settings[i-1]);
				strcat(Text,Auswahl,MAX_TEXT_LENGTH);
				a+=a;
				keys=a-1;
			}else{
				snprintf(Auswahl,MAX_TEXT_LENGTH,"\y%i. %s: \r%s^n",l,SaySettings[i-1],Settings[i-1]);
				strcat(Text,Auswahl,MAX_TEXT_LENGTH);
			}
		}
	}
	if(SelectedSetLoop[UserIndex]>=5){
		strcat(Text,"\y^n9. x-",MAX_TEXT_LENGTH);
		keys+=256;
	}
	strcat(Text,"\r^n0. Ende",MAX_TEXT_LENGTH);
	keys+=512;
	menu(User,Text,keys);
	MenuID[UserIndex]=2;
	return 0;
}

show_text(User[],Text[],UserIndex,ID){
	new Headline[512]="\w[CW-CREATOR] Meldung:^n^n";
	new keys;
	strcat(Headline,Text,MAX_TEXT_LENGTH);
	if(ID){
		strcat(Headline,"^n^n0. OK",MAX_TEXT_LENGTH);
		keys=512;
	}else{
		keys=1024;
	}	
	menu(User,Headline,keys);
	MenuID[UserIndex]=3;
	return 0;
}

/*Auswertung der Menauswahl*/
public menuselect(HLCommand,HLData,HLUserName,UserIndex){
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
  	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	if(MenuID[UserIndex]!=0){
		SelectedMenuCommand[UserIndex]=strtonum(Data);
		if(MenuID[UserIndex]==1){
			switch(SelectedMenuCommand[UserIndex]){
				case 1: {
					setmenu(User,UserIndex);
				}
				case 2: {
					SelectedSet[UserIndex]=1;
					sethandling(User,UserIndex);
				}
				case 3: {
					SelectedSet[UserIndex]=5;
					sethandling(User,UserIndex);
				}
				case 4: {
					plugin_exec("admin_war_start",""); 
					reset_array(UserIndex);
					}
				case 5: {
					plugin_exec("admin_war_restart",""); 
					reset_array(UserIndex);
				}
				case 6: {
					plugin_exec("admin_war_end","");
					reset_array(UserIndex);
				}
				case 10: { 
					reset_array(UserIndex);
				}
			}
		}else if(MenuID[UserIndex]==2){
			if(SelectedMenuCommand[UserIndex]==8){
				SelectedSetLoop[UserIndex]=SelectedSetLoop[UserIndex]+5;
				setmenu(User,UserIndex);
			}else if(SelectedMenuCommand[UserIndex]==9){
				SelectedSetLoop[UserIndex]=SelectedSetLoop[UserIndex]-5;
				setmenu(User,UserIndex);
			}else if(SelectedMenuCommand[UserIndex]==10){
				reset_array(UserIndex);
				mainmenu(User,UserIndex);			
			}else{
				if(SelectedSetLoop[UserIndex]>=5){
					SelectedSet[UserIndex]=SelectedSetLoop[UserIndex]+SelectedMenuCommand[UserIndex]-2;
				}else{
					SelectedSet[UserIndex]=SelectedMenuCommand[UserIndex]-1;
				}
				sethandling(User,UserIndex);
			}
		}else if(MenuID[UserIndex]==3){
			if(SelectedMenuCommand[UserIndex]==10){
				/*Reset ohne den Loop des Users*/
				MessageMode[UserIndex]=0;
				SelectedMenuCommand[UserIndex]=0;
				SelectedSet[UserIndex]=0;
				if(LastMenuID[UserIndex]==1){
					mainmenu(User,UserIndex);
				}else if(LastMenuID[UserIndex]==2){
					setmenu(User,UserIndex);
				}
			}
		}
		return PLUGIN_HANDLED;
	}
	return PLUGIN_CONTINUE;
}

/*Wenn Map ausgewhlt, entsprechend zur Map wechseln, wenn genug Stimmen vorhanden sind*/
sethandling(User[],UserIndex){
	if(SelectedSet[UserIndex]<=5){
		new Text[MAX_TEXT_LENGTH];
		if(MenuID[UserIndex]==1 && SelectedSet[UserIndex]==1){
			snprintf(Text,MAX_TEXT_LENGTH,"Bitte gebe den Clantag des Gastes^nim Chat ein,^num den CW-Modus zu starten!");
		}else if(MenuID[UserIndex]==1 && SelectedSet[UserIndex]==5){
			snprintf(Text,MAX_TEXT_LENGTH,"Bitte gebe die Regel.cfg im Chat ein,^ndie neu geladen werden soll!");
		}else if(MenuID[UserIndex]==2){
			snprintf(Text,MAX_TEXT_LENGTH,"Bitte gebe den Wert fuer^n'%s' im Chat ein!",SaySettings[SelectedSet[UserIndex]]);
		}
		MessageMode[UserIndex]=1;
		LastMenuID[UserIndex]=MenuID[UserIndex];
		show_text(User,Text,UserIndex,OK);
	}else{
		if(SelectedSet[UserIndex]==6 || SelectedSet[UserIndex]==7){
			if(Settings[SelectedSet[UserIndex]][0]=='0'){
				strcpy(Settings[SelectedSet[UserIndex]],"1",MAX_NUMBER_LENGTH);
			}else{
				strcpy(Settings[SelectedSet[UserIndex]],"0",MAX_NUMBER_LENGTH);
			}
		}else{
			if(strcmp(Settings[SelectedSet[UserIndex]],"attack")==0){
				strcpy(Settings[SelectedSet[UserIndex]],"all",MAX_NAME_LENGTH);
			}else{
				strcpy(Settings[SelectedSet[UserIndex]],"attack",MAX_NAME_LENGTH);
			}
		}
		plugin_exec(Commands[SelectedSet[UserIndex]],Settings[SelectedSet[UserIndex]]);
		/*erneutes Laden nur fr Debug*/
		load_cw_settings();
		/*Reset ohne den Loop des Users*/
		MessageMode[UserIndex]=0;
		SelectedMenuCommand[UserIndex]=0;
		SelectedSet[UserIndex]=0;
		setmenu(User,UserIndex);
	}			
	return PLUGIN_HANDLED;
}

/*Reaktion auf die Chateingaben*/
public HandleSay(HLCommand,HLData,HLUserName,UserIndex) {
	new Data[MAX_DATA_LENGTH];
  	new UserName[MAX_NAME_LENGTH];
  	
  	convert_string(HLData,Data,MAX_DATA_LENGTH);
  	convert_string(HLUserName,UserName,MAX_NAME_LENGTH);

  	strstripquotes(Data);
  	
	if(MessageMode[UserIndex]==0){
	  	if (strcasestr(Data,"cwmenu")!=-1) {
	  		mainmenu(UserName,UserIndex);
			return PLUGIN_HANDLED;
		}
	}else if(MessageMode[UserIndex]==1){
		/*hier gilt 'cwmenu' als Abbruch der Chateingabe*/
		if(strcasestr(Data,"cwmenu")==-1){
			if(check_set(Commands[SelectedSet[UserIndex]],Data,UserName,UserIndex)==1){
				if(LastMenuID[UserIndex]==1 && SelectedSet[UserIndex]==5){
					strcpy(Settings[SelectedSet[UserIndex]],Data,MAX_TEXT_LENGTH);
					plugin_exec(Commands[SelectedSet[UserIndex]],Data);
				}else if(LastMenuID[UserIndex]==1 && SelectedSet[UserIndex]==1){
					/*den CW-Modus starten*/
					plugin_exec("admin_war_set",Data);
				}else if(LastMenuID[UserIndex]==2){
					strcpy(Settings[SelectedSet[UserIndex]],Data,MAX_TEXT_LENGTH);
					plugin_exec(Commands[SelectedSet[UserIndex]],Data);
				}
				/*erneutes Laden nur fr Debug*/
				load_cw_settings();
				/*Reset ohne den Loop des Users*/
				SelectedMenuCommand[UserIndex]=0;
				SelectedSet[UserIndex]=0;
				if(LastMenuID[UserIndex]==1){
					mainmenu(UserName,UserIndex);
				}else if(LastMenuID[UserIndex]==2){
					setmenu(UserName,UserIndex);
				}
			}
		}else{
			reset_array(UserIndex);
			mainmenu(UserName,UserIndex);
		}		
		MessageMode[UserIndex]=0;
		return PLUGIN_HANDLED;
	}
	return PLUGIN_CONTINUE;
}

check_set(Command[],Value[],UserName[],UserIndex){
	new Text[MAX_TEXT_LENGTH];
	new error;
	
	if(strlen(Value)!=0){
		if(strcmp(Command,"admin_war_pass")==0){
			if (strcmp(Value,"none")== 0) {
				snprintf(Text,MAX_TEXT_LENGTH,"\rFehler:^nPasswort nicht korrekt!");
		 		error=1;
			}
		}else if(strcmp(Command,"admin_war_tag")==0){
			if(strlen(Value) > 20) {
				snprintf(Text,MAX_TEXT_LENGTH,"\rFehler:^nDer ClanTag^n%s^nist zu lang!",Value);
				error=1;
			}
		}else if(strcmp(Command,"admin_war_map1")==0 || strcmp(Command,"admin_war_map2")==0 || strcmp(Command,"admin_war_endmap")==0){
			if(!valid_map(Value)) {
				snprintf(Text,MAX_TEXT_LENGTH,"\rFehler:^nMap %s^nexistiert nicht!",Value);
				error=1;
			}
		}else if(strcmp(Command,"admin_war_rules")==0){
			new rule[MAX_DATA_LENGTH];
			snprintf(rule,MAX_DATA_LENGTH,"%s%s",ruledir,Value);
			if(!fileexists(rule)) {
				snprintf(Text,MAX_TEXT_LENGTH,"\rFehler:^nRegeldatei^n%s^nexistiert nicht!",Value);
				error=1;
			}
		}
		if(error){
			show_text(UserName,Text,UserIndex,BAD);
			return 0;
		}else{
			return 1;
		}
	}else{
		snprintf(Text,MAX_TEXT_LENGTH,"\rFehler:^nKeinen Wert fuer^n'%s' im chat eingegeben!",SaySettings[SelectedSet[UserIndex]]);
		show_text(UserName,Text,UserIndex,BAD);
		return 0;
	}
	return 0;
}

/*Ldt die settings.ini Datei.*/
load_cw_settings(){
	new Data[MAX_DATA_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new j;
	settingsloaded=0;
	
	for(j=1; j <= SETTINGS; j++){
		readfile(File,Data,j,MAX_TEXT_LENGTH);
		strcpy(Settings[settingsloaded],Data,MAX_TEXT_LENGTH);
		settingsloaded++;
	}
	snprintf(Text,MAX_TEXT_LENGTH,"[CWCREATOR-MENU] %i Settings loaded successfully from %s",settingsloaded,File);
	log(Text);
	return PLUGIN_CONTINUE;
}

/*Setzt die Arrays wieder zurck*/
reset_array(UserIndex){
	MenuID[UserIndex]=0;
	LastMenuID[UserIndex]=0;
	MessageMode[UserIndex]=0;
	SelectedMenuCommand[UserIndex]=0;
	SelectedSet[UserIndex]=0;
	SelectedSetLoop[UserIndex]=1;
	return PLUGIN_CONTINUE;
}

public SetMenuData(HLCommand,HLData,HLUserName,UserIndex){
	new UserName[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	convert_string(HLUserName,UserName,MAX_NAME_LENGTH);
	if(MenuID[UserIndex]==1 || MenuID[UserIndex]==2 || MenuID[UserIndex]==3){
		reset_array(UserIndex);
		snprintf(Text,MAX_TEXT_LENGTH,"[CW-CREATOR-MENU] Menue wurde durch ein anderes Menue beendet!");
		messageex(UserName,Text,print_chat);
	}
	return PLUGIN_CONTINUE;
}

public plugin_init(){
	plugin_registerinfo("CWC-MENUE","Menue for settings of CW-Creator >v2.0",String_Version);
	plugin_registercmd("admin_war_menu","admin_war_menu",ACCESS_WAR,"admin_war_menu: Menuebedinung des CW-Creators.");
	plugin_registercmd("menuselect","menuselect",ACCESS_ALL);
	plugin_registercmd("say","HandleSay",ACCESS_ALL);
	plugin_registerhelp("say",ACCESS_WAR,"say cwmenu, um das CW-Creator Menue aufzurufen.");
	plugin_registercmd("radio1","SetMenuData",ACCESS_ALL);
	plugin_registercmd("radio2","SetMenuData",ACCESS_ALL);
	plugin_registercmd("radio3","SetMenuData",ACCESS_ALL);
	plugin_registercmd("buyequip","SetMenuData",ACCESS_ALL);
	plugin_registercmd("buy","SetMenuData",ACCESS_ALL);
	plugin_registercmd("chooseteam","SetMenuData",ACCESS_ALL);
	plugin_registercmd("showbriefing","SetMenuData",ACCESS_ALL);
	load_cw_settings();
	return PLUGIN_CONTINUE;
}
