/* [WING]Black Knight's CW-Creator Addon 13.07.2003 */

#pragma dynamic 8192

#include <core> 
#include <console> 
#include <string> 
#include <admin> 
#include <adminlib>
#define ACCESS_WAR 256
#define ACCESS_CONSOLE 131072
/* Bis auf weiteres DEMO nicht auf 1 stellen. Ist leider auf Grund eines HL-Bugs ein zahnloser Tiger */
#define DEMO 0

new STRING_VERSION[MAX_DATA_LENGTH] = "2.1";

new settings[MAX_DATA_LENGTH]="addons/adminmod/config/cwcreator/settings.ini";
new round=0;
new starts=0;
new count;
new demo=0;
new maxrounds=0;
new timerid=0;
new tag[MAX_DATA_LENGTH];
new opponent[MAX_DATA_LENGTH];
/* Pausen Detektions Variablen */
new paused=0;
new pausedsec=0;
new day;
/* Count Variablen */
new homeattack=0;
new countrules=0;
new hometeam;
new homecount=0;
new guestcount=0;
new filename[MAX_DATA_LENGTH];

/* Startfunktion, wird von plugin_cw_creator aufgerufen */
public cwc_addon_start(HLCommand,HLData,HLUserName,UserIndex){
	new sTime[7];
	new Text[MAX_TEXT_LENGTH];
	new sdummy[30];
	new smaptype[30];
	new smaxrounds[5];
	new sround[5];

	convert_string(HLData,sdummy,30);
	strsplit(sdummy," ",sround,5,smaxrounds,5);

	round=strtonum(sround);
	maxrounds=strtonum(smaxrounds);

	servertime(sTime,7,"%d.%m");

	/* Demostartfunktion */
	if(demo){
		/* Demo starten */
		snprintf(Text,MAX_TEXT_LENGTH,"record %s-vs-%s-%s-%i.dem",tag,opponent,sTime,round);
		repairfn(Text,Text);
		say("Demoaufnahme wurde automatisch gestartet!");
		execclient_all(Text);
		snprintf(Text,MAX_TEXT_LENGTH,"%s-vs-%s-%s-%i.dem",tag,opponent,sTime,round);
		repairfn(Text,Text);
		say(Text);
		/* Mapabschlusserkennung einleiten */
		if(starts==0){
			if(maxrounds>0){
				logd_registering();
			}
			else{
				/* Wird bei Neustart nicht durchgefhrt, berarbeiten! */
				new timelimit;
				timelimit=getvar("mp_timelimit")*60-10;
				if(timerid!=0){
					kill_timer(timerid);
				}
				timerid=set_timer("end_maptimer",timelimit,0);
				plugin_registercmd("pause","HandlePause",ACCESS_ALL);
				if(count){
					logd_registering();
				}
			}
		}
	}
	else{
		if(count==1 && starts==0){
			logd_registering();
		}
	}

	if(count){
		/* Spielstandsdatei anlegen */
		if(round==1){
			if(fileexists(filename)){
				deletefile(filename);
			}
			snprintf(Text,MAX_TEXT_LENGTH,"%s : %s am %s",tag,opponent,sTime);
			writefile(filename,Text,-1);
		}
		currentmap(Text,MAX_TEXT_LENGTH);
		if(starts==1 && (round==1 || round==3)){
			writefile(filename,Text,-1);
		}
		if(starts==1){
			writefile(filename," ",-1);
		}
		/* Teamerkennung */
		hometeam=which_team();
		/* charge only Regeln setzen */
		if(countrules){
			strsplit(Text,"_",smaptype,30,sdummy,30);
			if(strmatch(smaptype,"de",MAX_DATA_LENGTH)||strmatch(smaptype,"es",MAX_DATA_LENGTH)){
				if(hometeam==1){
					homeattack=1;
				}
			}
			else if(strmatch(smaptype,"cs",MAX_DATA_LENGTH)||strmatch(smaptype,"as",MAX_DATA_LENGTH)){
				if(hometeam==2){
					homeattack=1;
				}
			}
			else{
				/* Fr alle Volltrottel da drauen, Nicht-Standardmaps mit Charge only, nee iiiis klaaar */
				homeattack=2;
			}
		}
	}
	return PLUGIN_HANDLED;
}

get_score(){
	new i,lineno;
	new shomecount[30],sguestcount[30],dummy[30];
	new sresult[MAX_TEXT_LENGTH];

	if(round<=1){
		return PLUGIN_CONTINUE;
	}

	if(fileexists(filename)){
		for(i=2;i<=round;i++){
			lineno=3*i/2;
			readfile(filename,sresult,lineno,MAX_TEXT_LENGTH);
			strsplit(sresult,":",shomecount,30,sguestcount,30);
			strtrim(shomecount," ",2);
			strtrim(sguestcount," ",2);
			if(countrules){
				if(strchr(shomecount,' ')>=0){
					strsplit(shomecount," ",dummy,30,shomecount,30);
					homecount+=strtonum(shomecount);
				}
				else{
					strsplit(sguestcount," ",sguestcount,30,dummy,30);
					guestcount+=strtonum(sguestcount);
				}
			}
			else{
				homecount+=strtonum(shomecount);
				guestcount+=strtonum(sguestcount);
			}
		}
	}
	else{
		say("Datei nicht gefunden");
	}
	return PLUGIN_CONTINUE;
}

which_team(){
	new i;
	new maxplayers = maxplayercount();
	new Target[MAX_NAME_LENGTH];
	new SessionID;
	new WONID;
	new Team;

	for(i=1; i<=maxplayers; i++) {
		if(playerinfo(i,Target,MAX_NAME_LENGTH,SessionID,WONID,Team)==1) {
			if (Team < 3 && strstr(Target,tag)!=-1){
				return Team;
				break;
			}
		}
	}
	say("Klar doch, Funmap, bei der nur Attackerwins zaehlen...");
	return 2;
}

/* LogD-Aktivierung; erst jetzt, da im Normalmodus nicht bentigt */
logd_registering(){
	plugin_registercmd("logd_cwc_score","logd_cwc_score",ACCESS_CONSOLE,"");
	exec("logd_reg 61 admin_command logd_cwc_score");
	/* Verhindern eines nochmaligen Aufrufs der LogD */
	starts++;
	/* Score laden */
	get_score();
	return PLUGIN_CONTINUE;
}

/* Demo beenden */
demo_stop(){
	execclient_all("stop");
	say("Demoaufnahme wurde automatisch beendet!");
	return PLUGIN_CONTINUE;
}

/* Demostop fr Timelimit-Matches */
public end_maptimer(Timer,Repeat,HLUser){
	/* Aufzeichnung verlngern wegen Pause */
	timerid=0;
	if(pausedsec>0){
		timerid=set_timer("end_maptimer",pausedsec,0);
		pausedsec=0;
		return PLUGIN_CONTINUE;
	}
	/* Pause bei offiziellem Ende der Map, wer macht denn sowas? Was soll's...
	Lsung unschn, aber unumgnglich */
	if(paused>0){
		timerid=set_timer("end_maptimer",1,0);
		return PLUGIN_CONTINUE;
	}
	/* Offensichtlich keine weitere Pause, also Ende des Demos! (Timelimit)*/
	demo_stop();

	return PLUGIN_CONTINUE;
}

public logd_cwc_score(HLCommand,HLData,HLUserName,UserIndex){
	new Data[MAX_DATA_LENGTH];
	new sdummy[30];
	new sctscore[10];
	new stscore[10];
	new ctscore;
	new tscore;
	new homescore=0;
	new guestscore=0;

	/* Ergebnis auswerten */
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	strsplit(Data," ",sdummy,30,sdummy,30,sctscore,10,stscore,10);
	strsplit(sctscore,"#",sdummy,30,sctscore,10);
	strsplit(stscore,"#",sdummy,30,stscore,10);
	ctscore=strtonum(sctscore);
	tscore=strtonum(stscore);
	/* Demostop fr Maxrounds-Matches */
	if(ctscore+tscore==maxrounds && maxrounds>0 && demo==1){
		demo_stop();
	}

	if(count){
		if(countrules && homeattack!=2){
			if(homeattack==1){
				if(hometeam==2){
					homescore=ctscore;
				}
				else{
					homescore=tscore;
				}
			}
			else{
				if(hometeam==2){
					guestscore=tscore;
				}
				else{
					guestscore=ctscore;
				}
			}
		}
		else{
			if(hometeam==2){
				homescore=ctscore;
				guestscore=tscore;
			}
			else{
				homescore=tscore;
				guestscore=ctscore;
			}
		}
		new mrhome,mrguest;
		mrhome=homescore;
		mrguest=guestscore;
		homescore+=homecount;
		guestscore+=guestcount;

		new Text[MAX_TEXT_LENGTH];
		new Text2[MAX_TEXT_LENGTH];
		if(countrules && homeattack!=2){
			if(homeattack){
				snprintf(Text,MAX_TEXT_LENGTH,"(*) %d : %d",homescore,guestscore);
				snprintf(Text2,MAX_TEXT_LENGTH,"(*) %d : %d",mrhome,mrguest);
			}
			else{
				snprintf(Text,MAX_TEXT_LENGTH,"    %d : %d (*)",homescore,guestscore);
				snprintf(Text2,MAX_TEXT_LENGTH,"    %d : %d (*)",mrhome,mrguest);
			}
		}
		else{
			snprintf(Text,MAX_TEXT_LENGTH,"    %d : %d",homescore,guestscore);
			snprintf(Text2,MAX_TEXT_LENGTH,"    %d : %d",mrhome,mrguest);
		}
		writefile(filename,Text2,3*(round+1)/2);
		readfile(filename,Text2,1,MAX_TEXT_LENGTH);
		snprintf(Text,MAX_TEXT_LENGTH,"%s^n%s",Text2,Text);
		typesay(Text,3,127,127,255);
		if(maxrounds==0){
			execclient_all("timeleft");
		}
		else{
			snprintf(Text,MAX_TEXT_LENGTH,"%d rounds remaining.",maxrounds-ctscore-tscore);
			say(Text);
		}
	}
	if(paused>0 && demo==1){
		say("Pausenende nicht erkannt. Bitte Demo selber beenden -> Console: stop");
	}

	return PLUGIN_CONTINUE;
}

public cwc_addon_end(HLCommand,HLData,HLUserName,UserIndex){
	new Text[512]="";
	new i;
	new sizeoffile;
	new content[MAX_TEXT_LENGTH];
	new maxplayers = maxplayercount();
	new Target[MAX_NAME_LENGTH];
	new sround[MAX_DATA_LENGTH];

	convert_string(HLData,sround,MAX_DATA_LENGTH);
	round=strtonum(sround);
	get_score();
	if(fileexists(filename)){
		sizeoffile=filesize(filename);
		for(i=1;i<=sizeoffile;i++){
			readfile(filename,content,i,MAX_TEXT_LENGTH);
			strcat(Text,content,512);
			strcat(Text,"^n",512);
		}
		new Text2[MAX_NAME_LENGTH];
		snprintf(Text2,MAX_TEXT_LENGTH,"^nErgebnis: %d : %d",homecount,guestcount);
		writefile(filename,Text2,-1);
		strcat(Text,Text2,512);
		for(i=1; i<=maxplayers; i++) {
			if(playerinfo(i,Target,MAX_NAME_LENGTH)) {
 				if(check_user(Target)) {
 					menu(Target,Text,1024,60);
 				}
 			}
 		}

	}
	return PLUGIN_CONTINUE;
}

/* Pausen Detektion */
public HandlePause(HLCommand,HLData,HLUserName,UserIndex) {
	if(getvar("pausable")){
		new sTimeString[3];
		new Time;
		new newday;
		/* Tag auswerten, falls Pause ber 0 Uhr hinausgeht */
		servertime(sTimeString,3,"%d");
		newday=strtonum(sTimeString);
		/* Uhrzeit in Sekunden umrechnen */
		servertime(sTimeString,3,"%H");
		Time=strtonum(sTimeString)*3600;
		servertime(sTimeString,3,"%M");
		Time+=strtonum(sTimeString)*60;
		servertime(sTimeString,3,"%S");
		Time+=strtonum(sTimeString);
		/* Beim Beenden der Pause addieren der Pausenzeit zur Verlngerung des Timers */
		if(paused>0){
			if(newday!=day){
				pausedsec+=86400-paused+Time;
			}
			else {
				pausedsec+=Time-paused;
			}
			paused=0;
		}
		else {
			paused=Time;
		}
		day=newday;
	}

	return PLUGIN_CONTINUE;
}

repairfn(d[],s[]) {
	new i;
	new maxlen=strlen(s);

	for(i=0; i<=maxlen; i++){
		switch(s[i]){
			case '\','/','*','?','"','<','>','|':{
				d[i]='x';
			}
			default:{
				d[i]=s[i];
			}
		}
	}
	d[maxlen+1]=NULL_CHAR;
	return 1;
}

/************* INIT ********************/
public plugin_init() {
 	plugin_registerinfo("Clan War Creator Addon","Counting and demo recording for cwc",STRING_VERSION);
 	plugin_registercmd("cwc_addon_start","cwc_addon_start",ACCESS_WAR);
	plugin_registercmd("cwc_addon_end","cwc_addon_end",ACCESS_WAR);

	new on;
	get_vaultnumdata("admin_war_on",on);
	if(on) {
		/* Gobale Optionsvariablen setzen */
		new scount[MAX_DATA_LENGTH];
#if(DEMO)
		new sdemo[MAX_DATA_LENGTH];
#endif
		new scountrules[MAX_DATA_LENGTH];

		readfile(settings,scount,7,MAX_DATA_LENGTH);
#if(DEMO)
		readfile(settings,sdemo,8,MAX_DATA_LENGTH);
#endif
		readfile(settings,scountrules,9,MAX_DATA_LENGTH);
		count=strtonum(scount);
#if(DEMO)
		demo=strtonum(sdemo);
#endif
		if(strmatch(scountrules,"attack",MAX_DATA_LENGTH)){
			countrules=1;
		}

		readfile(settings,tag,2,MAX_DATA_LENGTH);
		readfile(settings,opponent,10,MAX_DATA_LENGTH);
		snprintf(filename,MAX_DATA_LENGTH,"%s-vs-%s.txt",tag,opponent);
		repairfn(filename,filename);
	}
 
 	return PLUGIN_CONTINUE; 
} 
