/******************************************************************************************
 *Plugin displays info on the player's screen while he is connecting to the server.      *
 * Original plugin was published by -[bluebird]- and I modify it a little, to properly    *
 *display info about number of the players on the server for player who is reconnecting.  *
 *Additional modifications:                                                               *
 *- Map timing and notification                                                           *
 *- announcement to all about new player who is joining the server                          *
 *- announcement to all about player leaving the game                                       *
 *- greetings only for player who just joined the server			          *
 *Greetings are based on -[Sharpsniper's]- plugin                                         *
 *Changes, modifications by j23  12.16.2001                                               *
 ******************************************************************************************/

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

new STRING_VERSION[MAX_DATA_LENGTH] = "1.0.0";

public newplayer[MAX_NAME_LENGTH];
public all;

addstr(strBegin[],strEnd[])
{
	new i=0;
	new Length = strlen(strEnd);
	new j;
	while(strBegin[i]!=0) i++;
	for(j=0;j<Length;j++)
		strBegin[i+j]=strEnd[j];
	/* Null-terminate the string. */
	strBegin[i+j] = NULL_CHAR;
}

public plugin_connect(HLUserName,HLIP,UserIndex)
{
	new strSeconds[MAX_NAME_LENGTH];
	new strNumber[MAX_NUMBER_LENGTH];
	new NextMap[MAX_NAME_LENGTH];
	nextmap(NextMap,MAX_NAME_LENGTH);
	new conmsg[MAX_TEXT_LENGTH];
	new host[MAX_TEXT_LENGTH];
	new CurrentMap[MAX_NAME_LENGTH];
	new Seconds = timeleft(0)/60;
	new total;
	new sName[MAX_NAME_LENGTH];
	new iUser;
	new iWONID;
	new iTeam;
	new maxplayers = maxplayercount();
	new terror;
	new counter;
		
	currentmap(CurrentMap,MAX_NAME_LENGTH);
	getstrvar("hostname",host,MAX_TEXT_LENGTH);
	convert_string(HLUserName,newplayer,MAX_NAME_LENGTH);
		
	/* number of the players on the server: terrorists, counterterrorists and total */

	for(new i = 1; i <=maxplayers; i++)
	{
	    if(playerinfo(i,sName,MAX_NAME_LENGTH,iUser,iWONID,iTeam)==1)
	    {
	        if(streq(newplayer,sName)!=1)  // check for reconnecting player and not counting him
	        {
	            total++;
	            if(iTeam==1)
	                terror++;
	            else
	                counter++;
	        }
	    }
	}

	/* screen cleanup */

	for(new i=1; i<=25; i++)
	    consgreet("");
		
	/* start of the greeting */
	conmsg = "";
	consgreet("================================================================");
	addstr(conmsg,"Welcome "); addstr(conmsg,newplayer); addstr(conmsg," to ");
	addstr(conmsg,host); consgreet(conmsg); conmsg = "";
	consgreet("================================================================");
	consgreet("");
	addstr(conmsg, "Playercount: "); numtostr(total, strNumber); addstr(conmsg, strNumber); addstr(conmsg, "/");
	numtostr(maxplayers, strNumber); addstr(conmsg, strNumber); consgreet(conmsg); conmsg = "";
	conmsg = "Terrorists: "; numtostr(terror, strNumber); addstr(conmsg, strNumber); consgreet(conmsg); conmsg = "";
	conmsg = "Counter-Terrorists: "; numtostr(counter, strNumber); addstr(conmsg, strNumber); consgreet(conmsg); conmsg = "";
	consgreet("");
	addstr(conmsg,"Current Map: "); addstr(conmsg,CurrentMap); consgreet(conmsg); conmsg = "";

	/* check if current map has timelimit */

	if(getvar("mp_timelimit")==0)
	{
		addstr(conmsg,"It is no time limit on this map");
		consgreet(conmsg);
	}
	else
		if(Seconds<0)
		{
			addstr(conmsg,"Map is about to change to the next one...");
			consgreet(conmsg);
		}
		else
		{
			numtostr(Seconds, strSeconds);
			addstr(conmsg,"Time Remaining On Map: "); addstr(conmsg,strSeconds); addstr(conmsg," minutes"); consgreet(conmsg);
		}
	conmsg = "";
	addstr(conmsg,"Nextmap: "); addstr(conmsg,NextMap); consgreet(conmsg); conmsg = "";

	/* easy to modify greetings inside conmsg.txt */

	consgreet("");
	consgreet("================================================================");
	consgreet("conmsg.txt"); consgreet("");
	consgreet("================================================================");
	consgreet("                now just wait to get connected...                ");
	consgreet("");
	consgreet("");

	/* announces to all about new player who is joining the server */

	all=0;
	set_timer("say_hi",15,1);
	return PLUGIN_CONTINUE;
}

public plugin_disconnect(HLUserName,UserIndex)
{
	new msg[MAX_TEXT_LENGTH];

	/* announces to all about player who is leaving the server */

	convert_string(HLUserName,newplayer,MAX_NAME_LENGTH);
	strcat(msg,newplayer,MAX_DATA_LENGTH);
	strcat(msg,"^nhas left the game.^n'till next time...",MAX_DATA_LENGTH);
	typesay(msg,7,12,125,12);
}

public say_hi()
{
	new msg[MAX_TEXT_LENGTH];
	
	if(all==0)

	/* announces to all about new player who is joining the server */

	{
		strcat(msg,newplayer,MAX_DATA_LENGTH);
		strcat(msg,"^njust connects to the server",MAX_DATA_LENGTH);
		all=1;
		typesay(msg,7,12,125,12);
		set_timer("say_hi",40,1);
	}
	else

	/* greeting only for player who just join the game */

	{
		strcat(msg,"Welcome^n",MAX_DATA_LENGTH);
		strcat(msg,newplayer,MAX_DATA_LENGTH);
		strcat(msg," on the SSP Clan Server^nHappy hunting!",MAX_DATA_LENGTH);
		messageex(newplayer,msg,print_tty);
	}

}
		
public plugin_init()
{
	plugin_registerinfo("Connect Message Plugin","Shows message on connect and greets the player.",STRING_VERSION);
	return PLUGIN_CONTINUE;
}


