/* This plugin contains commands to disable changing teams in Counter-Strike */

/* $Id: plugin_choosteam_CS.sma,v 1.0 2001/05/02 yensid Exp $ */

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_RESTRICT 8192

new STRING_VERSION[MAX_DATA_LENGTH] = "2.50.0";

new ChooseteamRestrict = 0;

public admin_chooseteam(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];

	convert_string(HLCommand,Command,MAX_NAME_LENGTH);
	convert_string(HLData,Data,MAX_NAME_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	if (ChooseteamRestrict == 0) {
		ChooseteamRestrict = 1;
		snprintf(Text, MAX_TEXT_LENGTH, "The admin has DISABLED team changing");
		centersay(Text,10,255,255,0);
	} else {
		ChooseteamRestrict = 0;
		snprintf(Text, MAX_TEXT_LENGTH, "The admin has ENABLED team changing");
		centersay(Text,10,255,255,0);
	}
	return PLUGIN_HANDLED;
}

public CheckMenu(HLCommand,HLData,HLUserName,UserIndex) {
	new User[MAX_NAME_LENGTH];

	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	if (ChooseteamRestrict==1) {
		messageex(User, "Changing teams is currently disabled.", print_center);
		return PLUGIN_HANDLED;
	}
	return PLUGIN_CONTINUE;
}
public plugin_init() {
	plugin_registerinfo("Team restriction plugin","Has the ability to enable and disable team changing.",STRING_VERSION);

	plugin_registercmd("admin_chooseteam","admin_chooseteam",ACCESS_RESTRICT,"admin_chooseteam: Turn ability to change team on or off.");
	plugin_registercmd("chooseteam","CheckMenu",ACCESS_ALL);
	
	return PLUGIN_CONTINUE;
}
