#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_WARN ACCESS_KICK
#define WARN_SLAP 2
#define WARN_BURY 4
#define WARN_SLAY 6
#define WARN_KICK 10

new STRING_VERSION[MAX_DATA_LENGTH] = "1.0";

public admin_warn(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new WarnTarget[MAX_DATA_LENGTH];
	new TargetName[MAX_NAME_LENGTH];
	new TargetIndex;
	new Text[MAX_TEXT_LENGTH];
	new Reason[MAX_TEXT_LENGTH];
	new WonIDSTR[MAX_DATA_LENGTH];
	new Temp[MAX_DATA_LENGTH];
	new FileSize;
	new Count;
	new Warnings;
	
 	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	/*It filters for a reason for my adminlog plugin*/
	strbreak(Data,WarnTarget,Reason, MAX_DATA_LENGTH);
	
	if (check_user(WarnTarget)==1) {
		get_username(WarnTarget,TargetName,MAX_NAME_LENGTH);
		say_command(User,Command,TargetName);
		if(check_immunity(TargetName)==1) {
			snprintf(Text, MAX_TEXT_LENGTH, "You can't issue a warning to %s, you silly bear.", TargetName);
			say(Text);
		} else {
			get_userindex(TargetName, TargetIndex);
			get_userAuthID(TargetName, WonIDSTR);
			writefile("warnings.ini", WonIDSTR);

			FileSize = filesize("warnings.ini");
			Warnings = 0;
			for(Count=1;Count<=FileSize;Count++) {
				readfile("warnings.ini",Temp,Count,MAX_NAME_LENGTH);
				if ( (strcasestr(Temp,WonIDSTR) != -1) ) {
					Warnings++;
				}
			}
			if ( ( Warnings <= WARN_SLAP ) ){
				snprintf(Text, MAX_TEXT_LENGTH, "WARNING #%d has been issued to %s.^n^nPunismet: Slap!",Warnings,TargetName);
				centersay(Text,10,10,250,10);
				slap(TargetName);
			} else if ( ( Warnings > WARN_SLAP ) && ( Warnings <= WARN_BURY ) ){
				snprintf(Text, MAX_TEXT_LENGTH, "WARNING #%d has been issued to %s.^n^nPunishment: Bury!",Warnings,TargetName);
				centersay(Text,10,250,250,10);
				plugin_exec("admin_bury",WonIDSTR);
			} else if ( ( Warnings > WARN_BURY ) && ( Warnings <= WARN_SLAY ) ){
				snprintf(Text, MAX_TEXT_LENGTH, "WARNING #%d has been issued to %s.^n^nPunishment: Slay!",Warnings,TargetName);
				centersay(Text,10,250,10,10);
				slay(TargetName);
			} else if ( ( Warnings > WARN_SLAY ) && ( Warnings <= WARN_KICK ) ){
				snprintf(Text, MAX_TEXT_LENGTH, "WARNING #%d has been issued to %s.^n^nPunishment: Kick!",Warnings,TargetName);
				centersay(Text,10,250,10,10);
				snprintf(Text, MAX_TEXT_LENGTH, "You have been kicked for warning #%d. After %d warnings you will be banned!",Warnings,WARN_KICK);
				message(TargetName, Text);
				kick(TargetName);
			} else if ( ( Warnings > WARN_KICK ) ){
				snprintf(Text, MAX_TEXT_LENGTH, "WARNING #%d has been issued to %s.^n^nPunishment: Ban!",Warnings,TargetName);
				centersay(Text,10,250,10,10);
				ban(TargetName,0,bBanByID);
			} 
		}
	}
	return PLUGIN_CONTINUE;
}

public plugin_init() {
	plugin_registerinfo("Admin Warn Plugin","Allows admins to warn and punish players.",STRING_VERSION);

	plugin_registercmd("admin_warn","admin_warn",ACCESS_WARN,"admin_warn <target>: Issues warnings sequectially with a punishment to get their attention.");
	return PLUGIN_CONTINUE;
	}