/*********************************************************
 *          Bugblatter Report Extension - V3.3           *
 *********************************************************
 *                                                       *
 * This plug-in is linux & win32 friendly.               *
 *                                                       *
 * Version history                                       *
 *                                                       *
 * Version 3.2:                                          *
 *                                                       *
 *  - Updated to compile on Admin Mod V2.50.56           *
 *                                                       *
 * Version 3.2:                                          *
 *                                                       *
 *  - Updated for language plugin version 3.3            *
 *                                                       *
 * Version 3.1:                                          *
 *                                                       *
 *  -  No Changes                                        *
 *                                                       *
 * Version 2.6:                                          *
 *                                                       *
 *  -  Added colour and timing settings for all          *
 *     messageex class on 2.51.xx alpha builds.          *
 *                                                       *
 * Version 2.5:                                          *
 *  -  Initial Version                                   *
 *                                                       *
 *                                                       *
 *********************************************************/

#pragma dynamic 4096
#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>
#include <plugin>

#include "settings"
#include "clientio"
#include "language"

new g_Version[] = "3.3";

#define DEFAULT_ENABLED 1
#define MIN_ENABLED 0
#define MAX_ENABLED 1

#define DEFAULT_REPORT 1
#define MIN_REPORT 0
#define MAX_REPORT 1

forward RegisterPlugin();
forward BBReportEnabled(HLCommand,HLData,HLUserName,UserIndex);
forward BBReportReset(HLCommand,HLData,HLUserName,UserIndex);
forward BBReportReport(HLCommand,HLData,HLUserName,UserIndex);
forward BBReportAddress(HLCommand,HLData,HLUserName,UserIndex);
forward BBReport(HLCommand,HLData,HLUserName,UserIndex);


new g_MSG_REPORT_TITLE[]="Bugblatter Email Report configuration:|Configuration du report par Email Bugblatter:|Einstellungen fur Bugblatters Email-Bericht:";
new g_MSG_RPT_ENABLED_ON[]=" - Reporting is currently enabled (bbreport_enabled)| - Le report est actuellement actif (bbreport_enabled)| - Bericht ist momentan aktiviert (bbreport_enabled)";
new g_MSG_RPT_ENABLED_OFF[]=" - Reporting is currently disabled (bbreport_enabled)| - Le report est actuellement desactive (bbreport_enabled)| - Bericht ist momentan deaktiviert (bbreport_enabled)";
new g_MSG_RPT_ADDRESS[]=" - Reports sent to address %1s (bbreport_address)| - Les reports sot envoyes a l'adresse %1s (bbreport_address)| - Bericht wird an %1s verschickt (bbreport_address)";
new g_DISABLED[]="Message reporting is currently disabled.||Mitteilungsbericht ist momentan deaktiviert.";
new g_REPORTED[]="Message reported to administrators.|Le message est rapporte aux administrateurs.|Mitteilung an Administratoren gemeldet.";


/* Configuration variables */
new g_Enabled=DEFAULT_ENABLED;                          /* Is this plugin enabled */
new g_Report=DEFAULT_REPORT;                            /* Should it report */
new g_Address[MAX_DATA_LENGTH];
/* State Varaibles */
new g_FileCount=0;

/*********************************************************/
/* Standard event handlers for adminmod                  */
/*********************************************************/

public plugin_init() {
  plugin_registerinfo("Bugblatter's Report plugin","Reports abuse/suggestions by email",g_Version);

  /* Check server is configured properly */
  new fOK = checkFileAccessRead();
  fOK = checkFileAccessWrite() && fOK;
  fOK = checkVaultOK() && fOK;
  if (fOK == 0) {
    return PLUGIN_CONTINUE;
  }

  /* No need to abort if this one fails */
  checkLanguage();
  readvaultnum("bbreport_enabled",g_Enabled,DEFAULT_ENABLED,MIN_ENABLED,MAX_ENABLED);
  get_vaultdata("bbreport_address",g_Address,MAX_DATA_LENGTH);
  RegisterPlugin();

  return PLUGIN_CONTINUE;
}


RegisterPlugin() {
  /* Register commands with adminmod */
  language_init();
  plugin_registercmd("email","BBReportEmail",ACCESS_ALL,
                     "email <message>: Email message to adminstrators.");
  plugin_registercmd("bbreport_enabled","BBReportEnabled",ACCESS_CONFIG,
                     "bbreport_enabled < ^"on^" | ^"off^" >: Enables / Disables report command.");
  plugin_registercmd("bbreport_report","BBReportReport",ACCESS_CONFIG,
                     "bbreport_report [ ^"on^" | ^"off^" ]: shows the report config, and enables/disable display after every command");
  plugin_registercmd("bbreport_reset","BBReportReset",ACCESS_CONFIG,
                     "bbreport_reset: resets all report configuraiton settings to the compiled defaults");
  plugin_registercmd("bbreport_address","BBReportAddress",ACCESS_CONFIG,
                     "bbreport_address <email address>: configures who to send reports to");

}


/*********************************************************/
/* Command handlers for admin commands                   */
/*********************************************************/


public BBReportEmail(HLCommand,HLData,HLUserName,UserIndex) {
  new Message[1000];
  safe_convert(HLData,Message,MAX_DATA_LENGTH);

  new User[MAX_NAME_LENGTH];
  safe_convert(HLUserName,User,MAX_DATA_LENGTH);

  if (g_Enabled==0) {
    language_say(UserIndex,g_DISABLED,print_type:print_console);
    return PLUGIN_HANDLED;
  }

  new File[MAX_DATA_LENGTH];

  servertime(File, MAX_DATA_LENGTH,"none");
  new i;
  new c= strlen(File);
  for(i=0;i<c;i++) {
    if (File[i] == ':' || File[i] == ' ') {
      File[i] = '_';
    }
  }

  snprintf(File,MAX_DATA_LENGTH,"mailpickup/%s%i.eml",File,g_FileCount);
  g_FileCount++;
  strstripquotes(Message);

  new Hostname[MAX_DATA_LENGTH];
  if (getstrvar("hostname",Hostname,MAX_DATA_LENGTH)!=1) {
    strcpy(Hostname,"Halflife server",MAX_DATA_LENGTH);
  }

  new Recipient[MAX_DATA_LENGTH];
  strcpy(Recipient,g_Address,MAX_DATA_LENGTH);
  if (strlen(Recipient) == 0)  {
    getstrvar("sv_contact",Recipient,MAX_DATA_LENGTH);
  }

  snprintf(Message,256,"From: %s <adminmod@halflife.server>^nTo: %s^nSubject: HLMsg - %s - %s^n",Hostname,Recipient,User,Message);

  writefile(File,Message);
  language_say(UserIndex,g_REPORTED,print_type:print_console);
  return PLUGIN_HANDLED;
}

public BBReportEnabled(HLCommand,HLData,HLUserName,UserIndex) {
  if (readHLonoff(HLData,g_Enabled,DEFAULT_ENABLED,MIN_ENABLED,MAX_ENABLED)) {
  writevaultnum("bbreport_enabled",g_Enabled);
  }
  return ShowConfig(0,UserIndex);
}

public BBReportReset(HLCommand,HLData,HLUserName,UserIndex) {
  g_Enabled=DEFAULT_ENABLED;
  writevaultnum("bbreport_report",g_Report);
  writevaultnum("bbreport_enabled",g_Enabled);
  return ShowConfig(0,UserIndex);
}


public BBReportReport(HLCommand,HLData,HLUserName,UserIndex) {
  if (readHLonoff(HLData,g_Report,DEFAULT_REPORT,MIN_REPORT,MAX_REPORT)) {
    writevaultnum("bbreport_report",g_Report);
    ShowConfig(0,UserIndex);
  }
  else {
    ShowConfig(1,UserIndex);
  }
  return PLUGIN_HANDLED;
}

public BBReportAddress(HLCommand,HLData,HLUserName,UserIndex) {
  safe_convert(HLData,g_Address,MAX_DATA_LENGTH);
  set_vaultdata("bbreport_address",g_Address);
  return ShowConfig(UserIndex,0);
}


ShowConfig(Force,UserIndex) {
  if ((Force==0) && (g_Report==0)) {
    return PLUGIN_HANDLED;
  }

  language_say(UserIndex,g_MSG_REPORT_TITLE,print_type:print_console);
  if (g_Enabled) {
    language_say(UserIndex,g_MSG_RPT_ENABLED_ON,print_type:print_console);
  }
  else {
    language_say(UserIndex,g_MSG_RPT_ENABLED_OFF,print_type:print_console);
  }
  language_sayf(UserIndex,g_MSG_RPT_ADDRESS,print_type:print_console,0,0,0,0,g_Address);

  return PLUGIN_HANDLED;
}
