/*********************************************************
 *            Bugblatter Config Switch - V3.3            *
 *********************************************************
 *                                                       *
 * This plug-in is linux & win32 friendly.               *
 *                                                       *
 * Version 3.3:                                          *
 *                                                       *
 *  - Removed warnings compiling on Admin Mod 2.50.56    *
 *                                                       *
 * Version 3.2:                                          *
 *                                                       *
 *  - Updated for language plugin version 3.3            *
 *                                                       *
 * Version 3.1:                                          *
 *  -  No changes                                        *
 *                                                       *
 * Version 2.6:                                          *
 *  -  Bugfix - was appending to server.cfg instead of   *
 *     overwriting                                       *
 *                                                       *
 * Version 2.5:                                          *
 *                                                       *
 *  -  Initial Version                                   *
 *                                                       *
 *********************************************************
 */

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>
#include <plugin>

#include "language.inc"
#include "settings.inc"
#include "clientio.inc"

new g_Version[] = "3.2";

new g_MSG_CONFIGCHANGE[]="Configuration change will take effect on the next map.|La changement de configuration prendra effet a la prochaine map.|Konfigurationsanderungen werden ab der nachsten Map verwendet.";
new g_MSG_FILENOTFOUND[]="File not found ^"%1s^"|Fichier non trouve ^"%1s^"|Datei nicht gefunden: ^"%1s^"";


public plugin_init() {

  plugin_registerinfo("Bugblatter's Config Switch Plugin","Switches the server between configurations",g_Version);

  /* Check server is configured properly */
  new fOK = checkFileAccessWrite();
  if (fOK == 0) {
    return PLUGIN_CONTINUE;
  }
  language_init();
  plugin_registercmd("bbcfg_set","BBCfgSet",ACCESS_CONFIG,"");
  return PLUGIN_CONTINUE;
}


public BBCfgSet(HLCommand,HLData,HLUserName,UserIndex) {
  new Data[MAX_DATA_LENGTH];
  new Cmd[MAX_DATA_LENGTH];
  safe_convert(HLData,Data,MAX_DATA_LENGTH);

  if (fileexists(Data)) {
    snprintf(Cmd,MAX_DATA_LENGTH,"exec ^"%s^"",Data);
    writefile("server.cfg",Cmd,1);
    language_say(UserIndex,g_MSG_CONFIGCHANGE,print_type:print_console);
  }
  else {
    language_sayf(UserIndex,g_MSG_FILENOTFOUND,print_type:print_console,0,0,0,0,Data);
  }
  return 0;
}

