/* Black Knight's AM Cron v1.1 (09.09.2003)

Contact: http://www.wing-clan.de, blackknight@wing-clan.de 

PS.: The Black Knight always triumphs... */

#pragma dynamic 8192

#include <core> 
#include <console> 
#include <string> 
#include <admin> 
#include <adminlib>

#include "cron_language(us)"

#define MAX_COMMANDS 50
#define TIMESTRING 10
#define PARAMETER 10
#define TIMECOLUMN 31

#define CHAR_INVALID -1
#define FALSE 0
#define NULL_CHAR 0
#define QUOTE_CHAR 34
#define TRUE 1

new STRING_VERSION[MAX_DATA_LENGTH] = "1.1";
new timearray[MAX_COMMANDS][TIMESTRING];
new cmdarray[MAX_COMMANDS][MAX_DATA_LENGTH];
new cvarcron[MAX_COMMANDS][2];
new filename[MAX_DATA_LENGTH]="schedule.ini";
new filename2[MAX_DATA_LENGTH]="tasks.cfg";
new crontimeleft=FALSE;

strbreak2(str[], first[], second[], maxlen, search[], number) {
	new i = 0;
	new NullPos = CHAR_INVALID;
	new Quote = FALSE;
	new SpacePos = CHAR_INVALID;
	new merk=0;

	if (maxlen == 0){
		maxlen = strlen(str);
	}
			
	for(i=0; i<maxlen; i++) {
		if (str[i] == QUOTE_CHAR) {
			if (Quote==FALSE) {
				Quote = TRUE;
			}
			else {
				Quote = FALSE;
			}
		}
		else if (str[i] == search[0] && Quote == FALSE) {
			merk++;
			if (merk==number) {
				SpacePos = i;
			}
		}
		else if (str[i] == NULL_CHAR) {
			NullPos = i;
			break;
		}	
	}
	
	if (SpacePos == CHAR_INVALID) {
		strcpy(first, str, maxlen);
		strinit(second);
	}
	else {
		if (NullPos == CHAR_INVALID) {
			NullPos = maxlen + 1;
		}
		for(i=0; i<SpacePos; i++) { 
			first[i] = str[i];
		}
		first[SpacePos] = NULL_CHAR;
		for(i=SpacePos+1; i<NullPos;i++) {
			second[i - SpacePos - 1] = str[i];
		}
		second[NullPos - SpacePos - 1] = NULL_CHAR;
	}
	return 1;
}

/* Splits string at a specific position */
strnsplit(str[],first[],second[],n) {
	new i;
	new maxlen=strlen(str);
	new m=n+1;

	for(i=0; i<n; i++){
		first[i]=str[i];
	}
	for(i=m;i<=maxlen;i++){ 
		second[i-m]=str[i];
	}
	return 1;
}

/* Splits string at a specific position */
strnsplit2(str[],first[],second[],n) {
	new i;
	new maxlen=strlen(str);
	new m=n+1;

	for(i=0; i<=n; i++){
		first[i]=str[i];
	}
	first[n+1]=NULL_CHAR;
	for(i=m;i<=maxlen;i++){ 
		second[i-m]=str[i];
	}
	second[maxlen+1]=NULL_CHAR;
	return 1;
}

/* Timestring auf gleiche Laenge formatieren */
format_timestring(timevar[5][], i) {
	new j;

	for(j=0;j<=3;j++){
		if (strlen(timevar[j])<=1) {
			if (timevar[j][0]=='*'){
				timearray[i][j+j]='*';
			}
			else {
				timearray[i][j+j]='0';
			}
			timearray[i][j+j+1]=timevar[j][0];
		}
		else {
			timearray[i][j+j]=timevar[j][0];
			timearray[i][j+j+1]=timevar[j][1];
		}
	}
	timearray[i][8]=timevar[4][0];
	return PLUGIN_CONTINUE;
}

cron_error(linestring[],line,actionstring[]){
	new string[MAX_DATA_LENGTH];

	/* snprintf(string,MAX_DATA_LENGTH,"plugin_bk_cron ERROR in line: %i %s",line,linestring); */
	snprintf(string,MAX_DATA_LENGTH,cron_err,line,linestring);
	log(string);
	log(actionstring);
	return PLUGIN_CONTINUE;
}

admin_cron_refresh(){
	new sizeoffile,i,j,k,l;
	new string[MAX_DATA_LENGTH];
	new timeaustausch[MAX_DATA_LENGTH];
	new cmdaustausch[MAX_DATA_LENGTH];
	new cvarcronmerk[2];
	new cmdmerk[MAX_DATA_LENGTH];
	new timevar[5][TIMECOLUMN];
	new merk[TIMECOLUMN];
	new anzahlkomma[5];
	new anzahlslash[5];
	new indexmerk=0;
	new fieldsize=1;
	new dontwrite=FALSE;
	new szaehler[3],snenner[3];
	new zaehler, nenner, teiler;
	new maxtime[4]={59,23,29,11};
	new tmparameter[MAX_TEXT_LENGTH];
	new tmparameter2[MAX_TEXT_LENGTH];
	new merktimearray[MAX_COMMANDS][TIMECOLUMN];
	new blowup;

	/* Empty arrays */
	for(i=0;i<MAX_COMMANDS;i++) {
		timearray[i][0]=NULL_CHAR;
		cmdarray[i][0]=NULL_CHAR;
		cvarcron[i][0]=NULL_CHAR;
	}
	
	/* snprintf(tmparameter,MAX_TEXT_LENGTH,"(Too many parameters >%i)",PARAMETER);
	snprintf(tmparameter2,MAX_TEXT_LENGTH,"Parameter No.%i and higher ignored!",PARAMETER+1); */
	snprintf(tmparameter,MAX_TEXT_LENGTH,cron_tmp,PARAMETER);
	snprintf(tmparameter2,MAX_TEXT_LENGTH,cron_tmp2,PARAMETER+1);

	if(fileexists(filename)==0){
		/* log("plugin_bk_cron found no schedule.ini."); */
		log(cron_nosched);
		return PLUGIN_CONTINUE;
	}
	sizeoffile=filesize(filename,lines);

	for(i=0; i<=sizeoffile-1; i++) {
		/* Schedule.ini auslesen */
		readfile(filename,string,i+1,MAX_DATA_LENGTH);
		if(strlen(string)==0){
			dontwrite=TRUE;
		}
		else{
			/* Timestring vom Commandstring trennen */
			strbreak2(string,timeaustausch,cmdaustausch,MAX_DATA_LENGTH," ",5);
			/* cvarcron-Variable abtrennen */
			strnsplit(cmdaustausch,cvarcronmerk,cmdmerk,1);
			/* Zeitsplit */
			strsplit(timeaustausch," ",timevar[0],TIMECOLUMN,timevar[1],TIMECOLUMN,timevar[2],TIMECOLUMN,timevar[3],TIMECOLUMN,timevar[4],TIMECOLUMN);

			/* Converts Slash to comma expression */
			for(j=0;j<=4;j++){
				anzahlkomma[j]=0;
				anzahlslash[j]=0;
				anzahlkomma[j]=strcount(timevar[j],',');
				anzahlslash[j]=strcount(timevar[j],'/');
				/* Check if slashs and commas exist in one column */
				if(anzahlkomma[j]>=1 && anzahlslash[j]>=1) {
					/* cron_error("(Slash and Komma in 1 column)",i+1,"Line ignored!"); */
					cron_error(cron_err_sak,i+1,cron_li);
					dontwrite=TRUE;
					break;
				}
				if(anzahlslash[j]>=1) {
					/* Check if slash exists in the weekdays column */
					if(j==4) {
						/* cron_error("(Slash on weekdays column)",i+1,"Line ignored!"); */
						cron_error(cron_err_sowc,i+1,cron_li);
						dontwrite=TRUE;
						break;
					}
					strsplit(timevar[j],"/",szaehler,3,snenner,3);
					zaehler=strtonum(szaehler);
					nenner=strtonum(snenner);
					if(nenner==0){
						/* cron_error("(Division by zero)",i+1,"Line ignored!"); */
						cron_error(cron_err_dbz,i+1,cron_li);
						dontwrite=TRUE;
						break;
					}
					teiler=zaehler/nenner;
					if(teiler<1){
						teiler=1;
					}
					zaehler=0;
					anzahlkomma[j]=0;
					strcpy(timevar[j],"0",TIMECOLUMN);
					for(k=0;k<=maxtime[j]+1;k++){
						zaehler+=teiler;
						numtostr(zaehler,szaehler);
						strcat(timevar[j],",",TIMECOLUMN);
						strcat(timevar[j],szaehler,TIMECOLUMN);
						anzahlkomma[j]+=1;
						if(zaehler+teiler>=maxtime[j]){
							break;
						}
					}
				}
				if(anzahlkomma[j]>=PARAMETER) {
					anzahlkomma[j]=PARAMETER-1;
					cron_error(tmparameter,i+1,tmparameter2);
				}
			}
		}
		if(dontwrite==FALSE){
			/* Check if this command blows up the array */
			blowup=1;
			for(j=0;j<=4;j++){
				blowup=blowup*(anzahlkomma[j]+1);
			}
			if(blowup+i+indexmerk>=MAX_COMMANDS-1){
				/* cron_error("(Exceeds max time commands)",i+1,"Actual line and remaining lines ignored!"); */
				cron_error(cron_err_emtc,i+1,cron_ali);
				return PLUGIN_HANDLED;
			}
			if(anzahlkomma[0]!=0 || anzahlkomma[1]!=0 || anzahlkomma[2]!=0 || anzahlkomma[3]!=0 || anzahlkomma[4]!=0){
				for(j=0;j<=4;j++){
					if(anzahlkomma[j]!=0){
						/* Copy information for permutation (enlarge field)*/
						for(k=fieldsize;k<=(anzahlkomma[j]+1)*fieldsize-1;k++){
							strcpy(merktimearray[k],merktimearray[k-fieldsize],TIMECOLUMN);
						}
						for(k=0;k<=anzahlkomma[j];k++){
							/* Write all permutative possibilities */
							strbreak2(timevar[j],merk,timevar[j],TIMECOLUMN,",",1);
							strcat(merk," ",TIMECOLUMN);
							for(l=k*fieldsize;l<=(k+1)*fieldsize-1;l++){
								strcat(merktimearray[l],merk,TIMECOLUMN);
							}
						}
						fieldsize=(anzahlkomma[j]+1)*fieldsize;
					}
					else{
						for(k=0;k<=fieldsize-1;k++){
							strcat(merktimearray[k],timevar[j],TIMECOLUMN);
							strcat(merktimearray[k]," ",TIMECOLUMN);
						}
					}
				}
				for(j=0;j<=fieldsize-1;j++){
					for(k=0;k<=4;k++){
						strbreak2(merktimearray[j],timevar[k],merktimearray[j],TIMECOLUMN," ",1);
					}
					format_timestring(timevar,i+indexmerk+j);
					strcpy(cvarcron[i+indexmerk+j],cvarcronmerk,2);
					strcpy(cmdarray[i+indexmerk+j],cmdmerk,MAX_DATA_LENGTH);
				}
				indexmerk+=fieldsize-1;
			}
			else {
				format_timestring(timevar,i+indexmerk);
				strcpy(cvarcron[i+indexmerk],cvarcronmerk,2);
				strcpy(cmdarray[i+indexmerk],cmdmerk,MAX_DATA_LENGTH);
			}
		}
		else{
			indexmerk=indexmerk-1;
		}
		dontwrite=FALSE;
		fieldsize=1;
	}
	/* log("[ADMIN] plugin_bk_cron initialized"); */
	log(cron_init);
	return PLUGIN_CONTINUE;
}

admin_cron_check(sTime[]){
	new nullpos;
	new i,j;
	new validate=TRUE;
	new string[MAX_DATA_LENGTH];
	new fcommand[MAX_DATA_LENGTH];
	new scommand[MAX_DATA_LENGTH];
	new sscommand[MAX_DATA_LENGTH];
	new first[MAX_DATA_LENGTH];
	new second[MAX_DATA_LENGTH];

	/* Array-Laenge ermitteln (Vermutlich Compilerbug) */
	for(i=0;i<MAX_COMMANDS;i++) {
		if(timearray[i][0]==NULL_CHAR) {
			nullpos=i;
			break;
		}
	}
	if(nullpos==0){
		return PLUGIN_CONTINUE;
	}
	/* Check-Funktion, ob Timestring aktuell/Tabelle gleich */
	for(i=0;i<nullpos;i++) {
		for(j=0;j<9;j++){
			if(timearray[i][j]!='*' && timearray[i][j]!=sTime[j]){
				validate=FALSE;
				break;
			}
		}
		if (validate==TRUE){
			/* Check if admin_command is the first command, uses plugin_exec then */
			if(cvarcron[i][0]=='1'){
				strbreak2(cmdarray[i],first,second,MAX_DATA_LENGTH," ",strcount(cmdarray[i],' '));
				if(streq(second,"delete")){
					edittasks(first,1);
				}
				else{
					strcpy(first,cmdarray[i],MAX_DATA_LENGTH);
					edittasks(first,0);
				}
			}
			else{
				strcpy(first,cmdarray[i],MAX_DATA_LENGTH);
			}
			strbreak2(first,fcommand,scommand,MAX_DATA_LENGTH," ",1);
			if(streq(fcommand,"admin_command")){
				strbreak2(scommand,fcommand,sscommand,MAX_DATA_LENGTH," ",1);
				plugin_exec(fcommand,sscommand);
			}
			else{
				exec(first,0);
			}
			strncpy(first,first,73,MAX_DATA_LENGTH);
			/* snprintf(string,MAX_DATA_LENGTH,"plugin_bk_cron executes: %s",first); */
			snprintf(string,MAX_DATA_LENGTH,cron_exe,first);
			log(string);
		}
		validate=TRUE;
	}
	return PLUGIN_CONTINUE;
}

edittasks(searchstring[],delete){
	new ebreak=1;
	new fcommand[MAX_DATA_LENGTH];
	new fcommand2[MAX_DATA_LENGTH];
	new scommand[MAX_DATA_LENGTH];
	new sizeoffile;
	new string[MAX_DATA_LENGTH];
	new i;
	new emptyspace=-1;

	strbreak2(searchstring,fcommand,scommand,MAX_DATA_LENGTH," ",ebreak);
	if(streq(fcommand,"admin_command")){
		ebreak=2;
		strbreak2(searchstring,fcommand,scommand,MAX_DATA_LENGTH," ",ebreak);
	}
	sizeoffile=filesize(filename2,lines);
	for(i=0; i<=sizeoffile-1; i++) {
		readfile(filename2,string,i+1,MAX_DATA_LENGTH);
		strbreak2(string,fcommand2,scommand,MAX_DATA_LENGTH," ",ebreak);
		if(streq(fcommand2,fcommand)){
			if(delete==1){
				writefile(filename2,"",i+1);
				return PLUGIN_CONTINUE;
			}
			else{
				writefile(filename2,searchstring,i+1);
				return PLUGIN_CONTINUE;
			}
		}
		if(strlen(fcommand2)==0 && emptyspace==-1){
			emptyspace=i+1;
		}
	}
	if(delete!=1){
		writefile(filename2,searchstring,emptyspace);
	}
	else{
		/* log("plugin_bk_cron did not found string to be deleted"); */
		log(cron_notfound);
	}
	return PLUGIN_CONTINUE;
}

/* Start regular timer */
public regular_timer(Timer,Repeat,HLUser,HLParam){

	set_timer("admin_cron_check2",60,99999);
	lag_check();

	set_timeleft();

	return PLUGIN_CONTINUE;
}

/* Reads Servertime and issues check */ 
public admin_cron_check2(Timer,Repeat,HLUser,HLParam){

	lag_check();

	set_timeleft();

	return PLUGIN_CONTINUE;
}

/* Lag check (max. 5 minutes) */
lag_check(){
	new sTime[TIMESTRING];
	new sTimeold[TIMESTRING];
	new sTimem[TIMESTRING];
	new sTimew[TIMESTRING];
	new lastcheck=0;
	new iTime;
	new lagcompensation;
	new i;
	new slastcheck[3];

	/* get_vaultnumdata("last_cron",lastcheck); */
	get_serverinfo("last_cron",slastcheck,3);
	lastcheck=strtonum(slastcheck);
	servertime(sTime,TIMESTRING,"%H%d%m%w");
	servertime(sTimem,TIMESTRING,"%M");
	iTime=strtonum(sTimem);
	if(iTime-lastcheck<0){
		lastcheck-=60;
		oldtimestring(sTime,sTimeold);
	}
	lagcompensation=iTime-lastcheck;
	if(lagcompensation>5){
		lagcompensation=5;
		/* log("plugin_bk_cron detected too much lag. Last 5 minutes going to be compensated."); */
		log(cron_comp);
	}
	if(lagcompensation>1){
		for(i=iTime-lagcompensation;i<=iTime;i++){
			if(i<0){
				snprintf(sTimew,TIMESTRING,"%i%s",i+60,sTimeold);
			}
			else if(i>=0 && i<=9){
				snprintf(sTimew,TIMESTRING,"0%i%s",i,sTime);
			}
			else{
				snprintf(sTimew,TIMESTRING,"%i%s",i,sTime);
			}
			admin_cron_check(sTimew);
		}
		/* log("plugin_bk_cron lag compensation done"); */
		log(cron_compdone);
	}
	else{
		strcat(sTimem,sTime,TIMESTRING);
		admin_cron_check(sTimem);
	}
	/* set_vaultnumdata("last_cron",iTime); */
	numtostr(iTime,sTime);
	set_serverinfo("last_cron",sTime);

	return PLUGIN_CONTINUE;
}

oldtimestring(sTime[],sTime2[]){
	new i;
	new Time[3];
	new iTime[5];
	new timemerk[3];

	for(i=0;i<=2;i++){
		Time[0]=sTime[i*2];
		Time[1]=sTime[i*2+1];
		iTime[i]=strtonum(Time);
	}
	Time[0]=sTime[6];
	Time[1]=NULL_CHAR;
	iTime[3]=strtonum(Time);
	iTime[0]=iTime[0]-1;
	if(iTime[0]<0){
		iTime[0]=23;
		iTime[1]=iTime[1]-1;
		iTime[3]=iTime[3]-1;
		if(iTime[1]<1){
			iTime[1]=31;
			iTime[2]=iTime[2]-1;
			if(iTime[2]<1){
				iTime[2]=12;
			}
		}
		if(iTime[3]<1){
			iTime[3]=7;
		}
	}
	for(i=0;i<=2;i++){
		if(iTime[i]<10){
			snprintf(timemerk,3,"0%i",iTime[i]);
		}
		else{
			numtostr(iTime[i],timemerk);
		}
		strcat(sTime2,timemerk,TIMESTRING);
	}
	numtostr(iTime[3],timemerk);
	strcat(sTime2,timemerk,TIMESTRING);

	return PLUGIN_CONTINUE;
}

public admin_cron_refresh2(HLCommand,HLData,HLUserName,UserIndex){
	admin_cron_refresh();
	return PLUGIN_HANDLED;
}

public admin_cron_fcheck(HLCommand,HLData,HLUserName,UserIndex){
	lag_check();
	return PLUGIN_HANDLED;
}

public admin_cron_list(HLCommand,HLData,HLUserName,UserIndex){
	new snumber[4];
	new inumber;
	new sizeoffile;
	new remaining;
	new Msg[MAX_TEXT_LENGTH];
	new string[MAX_DATA_LENGTH];
	new first[95];
	new second[MAX_DATA_LENGTH];
	new i;

	convert_string(HLData,snumber,4);
	inumber=strtonum(snumber);
	if(inumber==0){
		inumber=1;
	}

	sizeoffile=filesize(filename,lines);
	/* selfmessage("Nr.: Time and command string"); */
	selfmessage(cron_listtitle);
	if(sizeoffile<inumber || sizeoffile==0){
		/* selfmessage("No schedule tasks available"); */
		selfmessage(cron_listnotasks);
		return PLUGIN_HANDLED;
	}
	if(inumber+9>sizeoffile){
		remaining=sizeoffile;
	}
	else{
		remaining=inumber+9;
	}
	for(i=inumber; i<=remaining; i++) {
		readfile(filename,string,i,MAX_DATA_LENGTH);
		strnsplit2(string, first, second, 93);
		/* strncpy(string2,string,93,95); */
		snprintf(Msg,MAX_TEXT_LENGTH,"%i: %s",i,first);
		selfmessage(Msg);
		if(strlen(string)>93){
			strncpy(first,second,93,95);
			selfmessage(first);
		}
	}
	/* snprintf(Msg,MAX_TEXT_LENGTH,"Showing %i to %i of %i.",inumber,remaining,sizeoffile); */
	snprintf(Msg,MAX_TEXT_LENGTH,cron_listshow,inumber,remaining,sizeoffile);
	selfmessage(Msg);
	if(remaining<sizeoffile){
		/* snprintf(Msg,MAX_TEXT_LENGTH,"For more, type admin_cron_list %i",remaining+1); */
		snprintf(Msg,MAX_TEXT_LENGTH,cron_listmore,remaining+1);
		selfmessage(Msg);
	}

	return PLUGIN_HANDLED;
}

public admin_cron_del(HLCommand,HLData,HLUserName,UserIndex){
	new snumber[4];
	new inumber;
	new sizeoffile;

	convert_string(HLData,snumber,4);
	inumber=strtonum(snumber);

	sizeoffile=filesize(filename,lines);
	/* sizeoffile=realfilesize(filename);*/
	if(sizeoffile<1 || sizeoffile<inumber){
		/* selfmessage("Nothing to delete. Line number invalid!"); */
		selfmessage(cron_dellni);
		/* selfmessage("Usage: admin_cron_del <line number>"); */
		selfmessage(cron_deluse);
		return PLUGIN_HANDLED;
	}
	writefile(filename,"",inumber);
	/* selfmessage("Line deleted!"); */
	selfmessage(cron_del);
	admin_cron_refresh();

	return PLUGIN_HANDLED;
}

public admin_cron_add(HLCommand,HLData,HLUserName,UserIndex){
	new task[MAX_DATA_LENGTH];
	new sizeoffile;
	new i;
	new written=-1;
	new string[MAX_DATA_LENGTH];

	convert_string(HLData,task,MAX_DATA_LENGTH);

	if(strcount(task,' ')<6){
		/* selfmessage("Task not valid!"); */
		selfmessage(cron_tnv);
		/* selfmessage("Usage: admin_cron_add <min> <h> <d> <month> <weekday> <cvarcron> <command>"); */
		selfmessage(cron_adduse);
		return PLUGIN_HANDLED;
	}

	sizeoffile=filesize(filename,lines);
	/* sizeoffile=realfilesize(filename);*/
	for(i=1; i<=sizeoffile; i++) {
		readfile(filename,string,i,MAX_DATA_LENGTH);
		if(strlen(string)==0){
			written=i;
			break;
		}
	}
	if(sizeoffile<=MAX_COMMANDS){
		writefile(filename,task,written);
		/* selfmessage("Line added!"); */
		selfmessage(cron_add);
		admin_cron_refresh();
	}
	else{
		/* selfmessage("Too many tasks! Delete unneeded tasks first."); */
		selfmessage(cron_addtmt);
	}

	return PLUGIN_HANDLED;
}

public admin_cron_edit(HLCommand,HLData,HLUserName,UserIndex){
	new task[MAX_DATA_LENGTH];
	new cmdtask[MAX_DATA_LENGTH];
	new line[MAX_DATA_LENGTH];
	new iline;
	new sizeoffile;

	convert_string(HLData,task,MAX_DATA_LENGTH);

	if(strcount(task,' ')<7){
		/* selfmessage("Task not valid!"); */
		selfmessage(cron_tnv);
		/* selfmessage("Usage: admin_cron_edit <line> <min> <h> <d> <month> <weekday> <cvarcron> <command>"); */
		selfmessage(cron_edituse);
		return PLUGIN_HANDLED;
	}
	
	strbreak2(task,line,cmdtask,MAX_DATA_LENGTH," ",1);
	iline=strtonum(line);

	sizeoffile=filesize(filename,lines);

	if(sizeoffile>=iline){
		writefile(filename,cmdtask,iline);
		/* selfmessage("Line edited!"); */
		selfmessage(cron_edit);
		admin_cron_refresh();
	}
	else{
		/* selfmessage("No valid line given!"); */
		selfmessage(cron_nvlg);
		/* selfmessage("Usage: admin_cron_edit <line> <min> <h> <d> <month> <weekday> <cvarcron> <command>"); */
		selfmessage(cron_edituse);
	}

	return PLUGIN_HANDLED;
}

public admin_cron_fexe(HLCommand,HLData,HLUserName,UserIndex){
	new line[4];
	new iline;
	new sizeoffile;
	new string[MAX_DATA_LENGTH];
	new cmdaustausch[MAX_DATA_LENGTH];
	new timeaustausch[MAX_DATA_LENGTH];
	new fcommand[MAX_DATA_LENGTH];
	new scommand[MAX_DATA_LENGTH];
	new sscommand[MAX_DATA_LENGTH];

	convert_string(HLData,line,4);
	iline=strtonum(line);

	sizeoffile=filesize(filename,lines);
	if(sizeoffile<1 || sizeoffile<iline){
		/* selfmessage("No valid line given!"); */
		selfmessage(cron_nvlg);
		/* selfmessage("Usage: admin_cron_forceexe <line number>"); */
		selfmessage(cron_fexeuse);
		return PLUGIN_HANDLED;
	}

	readfile(filename,string,iline,MAX_DATA_LENGTH);
	strbreak2(string,timeaustausch,cmdaustausch,MAX_DATA_LENGTH," ",6);
	strbreak2(cmdaustausch,fcommand,scommand,MAX_DATA_LENGTH," ",1);
	if(streq(fcommand,"admin_command")){
		strbreak2(scommand,fcommand,sscommand,MAX_DATA_LENGTH," ",1);
		plugin_exec(fcommand,sscommand);
	}
	else{
		strcpy(scommand,cmdaustausch,MAX_DATA_LENGTH);
		exec(scommand,0);
	}
	/* snprintf(string,MAX_DATA_LENGTH,"plugin_bk_cron executes: %s",scommand); */
	snprintf(string,MAX_DATA_LENGTH,cron_exe,scommand);
	log(string);
	selfmessage(string);

	return PLUGIN_HANDLED;
}

set_timeleft(){

	if(crontimeleft==TRUE){
		new itimeleft;
		new stimeleft[MAX_DATA_LENGTH];
		itimeleft=timeleft(0);
		snprintf(stimeleft,MAX_DATA_LENGTH,"mp_timeleft %i",itimeleft);
		exec(stimeleft,0);
	}
	return PLUGIN_CONTINUE;
}

public admin_cron_tl(HLCommand,HLData,HLUserName,UserIndex){
	new option[2];
	new ioption;
	new Msg[MAX_TEXT_LENGTH];

	convert_string(HLData,option,2);
	ioption=strtonum(option);
	if(streq(option,"") || ioption<0 || ioption>1){
		/* selfmessage("Usage: admin_cron_timeleft <0/1>"); */
		selfmessage(cron_tluse);
		return PLUGIN_HANDLED;
	}
	else{
		set_vaultnumdata("cron_timeleft",ioption);
		/* snprintf(Msg,MAX_TEXT_LENGTH,"cron_timeleft set to %i",ioption); */
		snprintf(Msg,MAX_TEXT_LENGTH,cron_tl,ioption);
		crontimeleft=ioption;
		selfmessage(Msg);
		log(Msg);
	}

	return PLUGIN_HANDLED;
}

public plugin_init(){
	new write=getvar("file_access_write");
	new read=getvar("file_access_read");
	new vault[MAX_DATA_LENGTH];
	new ivault=1;

	getstrvar("admin_vault_file",vault,MAX_DATA_LENGTH);
	if(streq(vault,"0")){
		ivault=0;
	}
	if(write==1 && read==1 && ivault==1){
		/* plugin_registerinfo("Black Knights AM-Cron","Small Cronsystem for AM",STRING_VERSION);
		plugin_registercmd("admin_cron_refresh","admin_cron_refresh2",ACCESS_RCON,"Refreshes time table");
		plugin_registercmd("admin_cron_forcecheck","admin_cron_fcheck",ACCESS_RCON,"Forces cron check");
		plugin_registercmd("admin_cron_list","admin_cron_list",ACCESS_RCON,"Lists schedule.ini.");
		plugin_registercmd("admin_cron_del","admin_cron_del",ACCESS_RCON,"Deletes specific line in schedule.ini");
		plugin_registercmd("admin_cron_add","admin_cron_add",ACCESS_RCON,"Adds given line to schedule.ini");
		plugin_registercmd("admin_cron_edit","admin_cron_edit",ACCESS_RCON,"Edits specific line in schedule.ini");
		plugin_registercmd("admin_cron_forceexe","admin_cron_fexe",ACCESS_RCON,"Forces task execution without time check");
		plugin_registercmd("admin_cron_timeleft","admin_cron_tl",ACCESS_RCON,"Toggles setting of mp_timeleft"); */

		plugin_registerinfo("Black Knights AM-Cron",cron_info,STRING_VERSION);
		plugin_registercmd("admin_cron_refresh","admin_cron_refresh2",ACCESS_RCON,cron_inforf);
		plugin_registercmd("admin_cron_forcecheck","admin_cron_fcheck",ACCESS_RCON,cron_infofr);
		plugin_registercmd("admin_cron_list","admin_cron_list",ACCESS_RCON,cron_infolist);
		plugin_registercmd("admin_cron_del","admin_cron_del",ACCESS_RCON,cron_infodel);
		plugin_registercmd("admin_cron_add","admin_cron_add",ACCESS_RCON,cron_infoadd);
		plugin_registercmd("admin_cron_edit","admin_cron_edit",ACCESS_RCON,cron_infoedit);
		plugin_registercmd("admin_cron_forceexe","admin_cron_fexe",ACCESS_RCON,cron_infofexe);
		plugin_registercmd("admin_cron_timeleft","admin_cron_tl",ACCESS_RCON,cron_infotl);

		/* Pfadgenerierung */
		new pathname[MAX_DATA_LENGTH];
		getstrvar("amv_default_config_dir",pathname,MAX_DATA_LENGTH);
		snprintf(filename,MAX_DATA_LENGTH,"%s/cron/%s",pathname,filename);
		snprintf(filename2,MAX_DATA_LENGTH,"%s/cron/%s",pathname,filename2);

		admin_cron_refresh();

		new sTime[TIMESTRING];
		new iTime;

		servertime(sTime,TIMESTRING,"%S");
		iTime=strtonum(sTime);

		set_timer("regular_timer",61-iTime,0);

		get_vaultnumdata("cron_timeleft",crontimeleft);
		set_timeleft();

	}
	else{
		/* plugin_registerinfo("Black Knights AM-Cron","Disabled! Check your cvarcrons",STRING_VERSION); */
		plugin_registerinfo("Black Knights AM-Cron",cron_infodis,STRING_VERSION);
		/* log("Check file_access_read, file_access_write, admin_vault_file."); */
		log(cron_check);
	}

	return PLUGIN_CONTINUE; 
}