#include <core>
#include <string>
#include <admin>
#include <adminlib>

#define DEBUG 0
#define ACCESS_ENTRYSOUND 512
#define MAX_ENTRYS 40
#define FILENAME_LENGTH 60
#define TEXT_LENGTH 100
#define LINE_LENGTH (MAX_AUTHID_LENGTH+FILENAME_LENGTH+TEXT_LENGTH+5)
new CfgFile[]="usersounds.cfg";            //contains ':'-seperated list: wonid:path/to/soundfile.wav:Some cool text announcing the admin

new Timers[MAX_PLAYERS] = {0,...};
new STRING_VERSION[MAX_DATA_LENGTH] = "1.0";
new strAuthID[MAX_PLAYERS][MAX_AUTHID_LENGTH];
new Sounds[MAX_ENTRYS][20];
new Texts[MAX_ENTRYS][100];
new bPluginEnabled = 0;                    //will be enabled in plugin_init() 

public plugin_init()
{
	new i=0;

	plugin_registerinfo("Bib's entrysound-plugin","Announces admins with text and sound.",STRING_VERSION);
	plugin_registercmd("admin_entrysound","admin_entrysound",ACCESS_ENTRYSOUND,"admin_entrysound <1|0> : enables/disables sounds.");

	for (i=0;i<MAX_ENTRYS;i++)
	{
		strinit(Sounds[i]);
		strinit(Texts[i]);
	}
	parse_cfg();
	bPluginEnabled=1;

	return PLUGIN_CONTINUE;
}

public plugin_connect(HLUserName, HLIP, UserIndex)
{
	if (bPluginEnabled)
	{
		new username[MAX_NAME_LENGTH];

		convert_string(HLUserName,username,MAX_NAME_LENGTH);
		Timers[UserIndex]=set_timer("WonIdTimer",10,10);
	}

	return PLUGIN_CONTINUE;
}

public plugin_disconnect(HLUserName, UserIndex)
{
	if (Timers[UserIndex]>0 && UserIndex>0)
	{
		kill_timer(Timers[UserIndex]);
		Timers[UserIndex]=0;
	}

	return PLUGIN_CONTINUE;
}

announce(sAuthID[])
{
	new i=0;

	for (i=0; i<MAX_ENTRYS; i++)
	{
		if (streq(strAuthID[i],sAuthID))
		{
			if (Texts[i][0]!=0) centersay(Texts[i],20,255,10,10);
			if (Sounds[i][0]!=0) playsoundall(Sounds[i]);
			break;
		}
	}
	return PLUGIN_CONTINUE;
}

public WonIdTimer(Timer,Repeat,HLUser,HLParam)
{
		new sAuthID[MAX_AUTHID_LENGTH];
		new valid;
		new UserIndex=0;
		new username[MAX_NAME_LENGTH];

		convert_string(HLUser,username,MAX_NAME_LENGTH);
		valid=get_userAuthID(username,sAuthID,MAX_AUTHID_LENGTH);
		if (valid>0)
		{
			get_userindex(username,UserIndex);
			kill_timer(Timer);
			Timers[UserIndex]=0;
			announce(sAuthID);
		}
		return PLUGIN_HANDLED;
}

public admin_entrysound(HLCommand, HLData)
{
	if (check_auth(ACCESS_ENTRYSOUND))
	{
		new data[MAX_DATA_LENGTH];
		convert_string(HLData,data,MAX_DATA_LENGTH);
		strtrim(data," ",2);
		if (strncmp(data,"1",1)==0)
		{
			bPluginEnabled = 1;
			selfmessage("Bib Entrysound Plugin has been enabled!");
		}
		else if (strncmp(data,"0",1)==0)
		{
			bPluginEnabled = 0;
			selfmessage("Bib Entrysound Plugin has been disabled!");
		}
		else
		{
			selfmessage("admin_entrysound <1|0> : enables/disables sounds.");
		}
	}
	else
	{
		selfmessage("Access denied.");
	}
	return PLUGIN_HANDLED;
}

stock playsoundall(sound[])
{
	new maxplayers = maxplayercount();
	new Name[MAX_NAME_LENGTH];
	new i;

	for(i=1; i<=maxplayers; i++)
	{
		if (playerinfo(i, Name, MAX_NAME_LENGTH) == 1)
		{
			playsound(Name, sound);
		}
	}
}

parse_cfg()
{
	new i=0;
	new strFilename[FILENAME_LENGTH];
	new strText[TEXT_LENGTH];
	new strLine[LINE_LENGTH];
	new LineNo=0;
	new readerror=0;

	if (fileexists(CfgFile))
	{
		LineNo=filesize(CfgFile,lines);

		for (i=1;i<=MAX_ENTRYS && i<=LineNo;i++)
		{
			if (readfile(CfgFile,strLine,i,LINE_LENGTH)>0)
			{
				if ((strncmp(strLine, "#", 1) != 0) && (strncmp(strLine, "//", 2) != 0) && (strcount(strLine,'%') > 1))
				{
					strsep(strLine,"%",strAuthID[i-1],MAX_AUTHID_LENGTH,strFilename,FILENAME_LENGTH,strText,TEXT_LENGTH);
					strcpy(Sounds[i-1],strFilename,FILENAME_LENGTH);
					strcpy(Texts[i-1],strText,TEXT_LENGTH);
				}
			}
			else
			{
				readerror=1;
			}
		}
		if (readerror)
		{
			log("WARNING: Entrysound-Plugin: Readerror while reading Configfile");
		}
	}
	else
	{
		log("ERROR: Entrysound-Plugin: Configfile not found!");
	}
}