/* plugin_bailo_warn.sma
   This plugin allows you to warn people like on AIM by saying /warn <player>
   Each warning is a 5% increment.
   15%: (3)Slapping
   35%: (10)Slapping
   50%: Slay
   65%: Gag
   80%: 5 slays, one every 30 seconds
   100%: Kick
   A single player may warn another player every 20 seconds.  After 180 seconds
   10% of your total warn level is removed.  One player can only warn another 
   player 7 times, until the target player hits zero again.
   ---Thanks to Greentryst for that last idea---
   You can also say: /wlvl <user> to see their warning level, or /mlvl to see your level
   admin_warning 1/0 enables or disables warning.  admin_warningimmune disables/enables
   admin immunity from punishments, admin_punishments disables/enables warning punishments.
****************************************************************************
(C)1995-2002 The TCW Organization; David Anderson a.k.a. BAILOPAN
**************************http://www.tcwonline.org*************************/


#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_FUN 8192

new WarnLevels[MAX_PLAYERS];
new STRING_VERSION[MAX_DATA_LENGTH]="1.00";
new FlagPlayer[MAX_PLAYERS];
new CanWarn[MAX_PLAYERS] [MAX_PLAYERS];
new GagPlayer[MAX_PLAYERS];
new WarnLimit[MAX_PLAYERS] [MAX_PLAYERS];
new AllowPlayer[MAX_PLAYERS];
new AllowWarns=1;
new AllowImmune=0;
new AllowPunish=1;

public plugin_init() {
	plugin_registerinfo("Warn Plugin","Allows users to warn each other.",STRING_VERSION);
	
	plugin_registercmd("say", "HandleSay", ACCESS_ALL, "/warn <player>");
	plugin_registercmd("admin_warning", "admin_warning", ACCESS_FUN, "Enable/Disable Warning");
	plugin_registercmd("admin_warningimmune", "admin_warningimmune", ACCESS_FUN, "Enable/Disable Admin Punishment Immunities");
	plugin_registercmd("admin_punishments", "admin_punishments", ACCESS_FUN, "Enable/Disable Warning Punishments");

	return PLUGIN_CONTINUE;
}

public admin_warning(HLCommand, HLData, HLUserName, UserIndex)
{
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];

	convert_string(HLCommand, Command, MAX_COMMAND_LENGTH);
	convert_string(HLData, Data, MAX_DATA_LENGTH);
	convert_string(HLUserName, User, MAX_NAME_LENGTH);

	if (check_param(Data)==1) {
		selfmessage("Warning has been turned on!");
		AllowWarns=1;
	} 
	else {
		selfmessage("Warning has been turned off!");
		AllowWarns=0;
	}
	return PLUGIN_HANDLED;
}

public admin_warningimmune(HLCommand, HLData, HLUserName, UserIndex)
{
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];

	convert_string(HLCommand, Command, MAX_COMMAND_LENGTH);
	convert_string(HLData, Data, MAX_DATA_LENGTH);
	convert_string(HLUserName, User, MAX_NAME_LENGTH);

	if (check_param(Data)==1) {
		selfmessage("Warning Admin Immunity has been turned on!");
		AllowImmune=1;
	} 
	else {
		selfmessage("Warning Admin Immunity has been turned off!");
		AllowImmune=0;
	}
	return PLUGIN_HANDLED;
}

public admin_punishments(HLCommand, HLData, HLUserName, UserIndex)
{
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];

	convert_string(HLCommand, Command, MAX_COMMAND_LENGTH);
	convert_string(HLData, Data, MAX_DATA_LENGTH);
	convert_string(HLUserName, User, MAX_NAME_LENGTH);

	if (check_param(Data)==1) {
		selfmessage("Warning Punishments have been turned on!");
		AllowPunish=1;
	} 
	else {
		selfmessage("Warning Punishments have been turned off!");
		AllowPunish=0;
	}
	return PLUGIN_HANDLED;
}

PunishHim(iUser, nUser[])
{
	new Text[MAX_TEXT_LENGTH];
	new Continue=0;

	if (AllowPunish==1) { Continue=1; }
	if (check_immunity(nUser)==1) {
		if (AllowImmune==1) { Continue=1; }
		else { Continue=0; }
	}
	if (Continue==1)
	{
	if (WarnLevels[iUser]==15) {
		slap(nUser);
		slap(nUser);
		slap(nUser);
		snprintf(Text, MAX_TEXT_LENGTH, "*%s's warning level is at %i and has been slapped 3 times.*", nUser, WarnLevels[iUser]);
		say(Text);
	}
	if (WarnLevels[iUser]==35) {
		slap(nUser);
		slap(nUser);
		slap(nUser);
		slap(nUser);
		slap(nUser);
		slap(nUser);
		slap(nUser);
		slap(nUser);
		slap(nUser);
		slap(nUser);
		snprintf(Text, MAX_TEXT_LENGTH, "*%s's warning level is at %i and has been slapped 10 times.*", nUser, WarnLevels[iUser]);
		say(Text);
	}
	if (WarnLevels[iUser]==50) {
		slay(nUser);
		snprintf(Text, MAX_TEXT_LENGTH, "*%s's warning level is at %i and has been slain.*", nUser, WarnLevels[iUser]);
		say(Text);
	}
	if (WarnLevels[iUser]==65) {
		GagPlayer[iUser]=1;
		snprintf(Text, MAX_TEXT_LENGTH, "*%s's warning level is at %i and has been gagged.*", nUser, WarnLevels[iUser]);
		say(Text);
	}
	if (WarnLevels[iUser]==80) {
		set_timer("ControlSlay", 30, 5, nUser);
		snprintf(Text, MAX_TEXT_LENGTH, "*%s's warning level is at %i and will be slain every 30 seconds 3 times.*", nUser, WarnLevels[iUser]);
		say(Text);
	}
	if (WarnLevels[iUser]==100) {
		snprintf(Text, MAX_TEXT_LENGTH, "*%s's warning level is at %1 and will be kicked.*", nUser, WarnLevels[iUser]);
		messageex(nUser,"Your warning level reached 100 and you were kicked.",print_console);
		say(Text);
		kick(nUser);
	}
	}
}

public WarnCheck(Timer, Repeat, HLName, HLParam)
{
	new iUser[MAX_NUMBER_LENGTH];
	new idUser;
	new ddUser;

	convert_string(HLParam,iUser,MAX_NUMBER_LENGTH);
	idUser=strtonum(iUser);
	ddUser=FlagPlayer[idUser];
	if (CanWarn[ddUser] [idUser]==1) {
		CanWarn[ddUser] [idUser]=0;
	}
}

public ControlSlay(Timer, Repeat, HLName, HLParam)
{
	new Text[MAX_TEXT_LENGTH];
	new nUser[MAX_TEXT_LENGTH];

	convert_string(HLParam, nUser, MAX_TEXT_LENGTH);

	slay(nUser);

	snprintf(Text, MAX_TEXT_LENGTH, "debug");
	say(Text);
}


public AllowAgain(Timer, Repeat, HLName, HLParam)
{
	new iUser[MAX_NUMBER_LENGTH];
	new idUser;
	new ddUser;

	convert_string(HLParam,iUser,MAX_NUMBER_LENGTH);
	idUser=strtonum(iUser);
	ddUser=FlagPlayer[idUser];
	WarnLimit[ddUser] [idUser]=0;
}

public LowerWarn(Timer, Repeat, HLName, HLParam)
{
	new Text[MAX_TEXT_LENGTH];
	new iUser[MAX_NUMBER_LENGTH];
	new idUser;
	convert_string(HLParam, iUser, MAX_NUMBER_LENGTH);
	idUser=strtonum(iUser);
	if (WarnLevels[idUser]==65) {
		GagPlayer[idUser]=0;
		snprintf(Text, MAX_TEXT_LENGTH, "[You are no longer gagged from warning.]");
		messageex(iUser, Text, print_chat);
	}
	if (WarnLevels[idUser]!=0) {
		WarnLevels[idUser]-=10;
		if (WarnLevels[idUser]<0) { WarnLevels[idUser]=0; }
		snprintf(Text, MAX_TEXT_LENGTH, "[Your warning level has lowered to %i]", WarnLevels[idUser]);
		messageex(iUser, Text, print_chat);
	}
}

public HandleSay(HLCommand, HLData, HLUserName, UserIndex) 
{
	new Command[MAX_COMMAND_LENGTH];
	new Speech[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new Mesg[MAX_TEXT_LENGTH];
	new Targ[MAX_TEXT_LENGTH];
	new iUser;
	new UserStr[MAX_TEXT_LENGTH];
	new dUser;
	new dUserStr[MAX_TEXT_LENGTH];

	convert_string(HLCommand, Command, MAX_COMMAND_LENGTH);
	convert_string(HLData, Speech, MAX_DATA_LENGTH);
	convert_string(HLUserName, User, MAX_NAME_LENGTH);
	
	strstripquotes(Speech);
	get_userindex(User, dUser);
	if (AllowWarns==1) {
	if ( (strcasestr(Speech, "/wlvl ") != -1) )
	{
			strbreak(Speech, Targ, Mesg, MAX_TEXT_LENGTH);
			strbreak(Mesg, Targ, Mesg, MAX_TEXT_LENGTH);
			get_userindex(Targ, iUser);
			numtostr(iUser, UserStr);
			if (check_user(Targ)==1) {
			snprintf(Text, MAX_TEXT_LENGTH, "The current warning level of %s is %i", Targ, WarnLevels[iUser]);
			messageex(User, Text, print_chat);
			}
	}

	if ( (strcasestr(Speech, "/mlvl") != -1) ) {
		snprintf(Text, MAX_TEXT_LENGTH, "Your current warning level is %i", WarnLevels[dUser]);
		messageex(User, Text, print_chat);
	}

	if ( (strcasestr(Speech, "/warn ") != -1) ) 
	{
		strbreak(Speech, Targ, Mesg, MAX_TEXT_LENGTH);
		strbreak(Mesg, Targ, Mesg, MAX_TEXT_LENGTH);
		get_userindex(Targ, iUser);
		numtostr(iUser, UserStr);
		snprintf(dUserStr, MAX_TEXT_LENGTH, "%s", Targ);
		if (check_user(Targ)==1) 
		{
			if ((CanWarn[dUser] [iUser]==0) && (WarnLimit[dUser] [iUser]<=6)) {
				WarnLevels[iUser]+=5;
				CanWarn[dUser] [iUser]=1;
				WarnLimit[dUser] [iUser]+=1;
				FlagPlayer[iUser]=dUser;
				AllowPlayer[iUser]=dUser;
				set_timer("LowerWarn", 180, 1, UserStr);					
				set_timer("WarnCheck", 20, 1, UserStr);
				if (WarnLimit[dUser] [iUser]==7) {
					set_timer("AllowAgain", 1260, 1, UserStr);
				}
				PunishHim(iUser, dUserStr);
				snprintf(Text, MAX_TEXT_LENGTH, "[%s has warned %s to %i]", User, Targ, WarnLevels[iUser]);
				say(Text);
			} else {
				snprintf(Text, MAX_TEXT_LENGTH, "!! You cannot warn %s right now.", Targ);
				messageex(User, Text, print_chat);
			}	
			return PLUGIN_HANDLED;
		}
	}
	if (GagPlayer[dUser]==1) {
		snprintf(Text, MAX_TEXT_LENGTH, "!! You are currently gagged from being warned and cannot speak.");
		messageex(User, Text, print_chat);
		return PLUGIN_HANDLED;
	}
	}
	
	return PLUGIN_CONTINUE;
}

public plugin_disconnect(HLUserName, UserIndex) {
	if (UserIndex >= 1 && UserIndex <= MAX_PLAYERS) {
		WarnLevels[UserIndex]=0;
		//CanWarn[UserIndex]=1;
	}
	return PLUGIN_CONTINUE;
}